package io.dekorate.kubernetes.config;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AzureDiskVolumeFluent<A extends AzureDiskVolumeFluent<A>> extends BaseFluent<A>{
  public AzureDiskVolumeFluent() {
  }
  
  public AzureDiskVolumeFluent(AzureDiskVolume instance) {
    this.copyInstance(instance);
  }
  private String volumeName;
  private String diskName;
  private String diskURI;
  private String kind;
  private String cachingMode;
  private String fsType;
  private Boolean readOnly;
  
  protected void copyInstance(AzureDiskVolume instance) {
    instance = (instance != null ? instance : new AzureDiskVolume());
    if (instance != null) {
          this.withVolumeName(instance.getVolumeName());
          this.withDiskName(instance.getDiskName());
          this.withDiskURI(instance.getDiskURI());
          this.withKind(instance.getKind());
          this.withCachingMode(instance.getCachingMode());
          this.withFsType(instance.getFsType());
          this.withReadOnly(instance.getReadOnly());
        }
  }
  
  public String getVolumeName() {
    return this.volumeName;
  }
  
  public A withVolumeName(String volumeName) {
    this.volumeName = volumeName;
    return (A) this;
  }
  
  public boolean hasVolumeName() {
    return this.volumeName != null;
  }
  
  public String getDiskName() {
    return this.diskName;
  }
  
  public A withDiskName(String diskName) {
    this.diskName = diskName;
    return (A) this;
  }
  
  public boolean hasDiskName() {
    return this.diskName != null;
  }
  
  public String getDiskURI() {
    return this.diskURI;
  }
  
  public A withDiskURI(String diskURI) {
    this.diskURI = diskURI;
    return (A) this;
  }
  
  public boolean hasDiskURI() {
    return this.diskURI != null;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public String getCachingMode() {
    return this.cachingMode;
  }
  
  public A withCachingMode(String cachingMode) {
    this.cachingMode = cachingMode;
    return (A) this;
  }
  
  public boolean hasCachingMode() {
    return this.cachingMode != null;
  }
  
  public String getFsType() {
    return this.fsType;
  }
  
  public A withFsType(String fsType) {
    this.fsType = fsType;
    return (A) this;
  }
  
  public boolean hasFsType() {
    return this.fsType != null;
  }
  
  public Boolean getReadOnly() {
    return this.readOnly;
  }
  
  public A withReadOnly(Boolean readOnly) {
    this.readOnly = readOnly;
    return (A) this;
  }
  
  public boolean hasReadOnly() {
    return this.readOnly != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AzureDiskVolumeFluent that = (AzureDiskVolumeFluent) o;
    if (!java.util.Objects.equals(volumeName, that.volumeName)) return false;
    if (!java.util.Objects.equals(diskName, that.diskName)) return false;
    if (!java.util.Objects.equals(diskURI, that.diskURI)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(cachingMode, that.cachingMode)) return false;
    if (!java.util.Objects.equals(fsType, that.fsType)) return false;
    if (!java.util.Objects.equals(readOnly, that.readOnly)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(volumeName,  diskName,  diskURI,  kind,  cachingMode,  fsType,  readOnly,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (volumeName != null) { sb.append("volumeName:"); sb.append(volumeName + ","); }
    if (diskName != null) { sb.append("diskName:"); sb.append(diskName + ","); }
    if (diskURI != null) { sb.append("diskURI:"); sb.append(diskURI + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (cachingMode != null) { sb.append("cachingMode:"); sb.append(cachingMode + ","); }
    if (fsType != null) { sb.append("fsType:"); sb.append(fsType + ","); }
    if (readOnly != null) { sb.append("readOnly:"); sb.append(readOnly); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withReadOnly() {
    return withReadOnly(true);
  }
  

}