package io.dekorate.kubernetes.config;

import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class AzureFileVolume{
  public AzureFileVolume() {
  }
  
  public AzureFileVolume(String volumeName,String shareName,String secretName,Boolean readOnly) {
    this.volumeName = volumeName;
    this.shareName = shareName;
    this.secretName = secretName;
    this.readOnly = readOnly;
  }
  private String volumeName;
  private String shareName;
  private String secretName;
  private Boolean readOnly;
  
  
  /**
   * The volumeName name.
   * @return The volumeName name.
   */
  public String getVolumeName() {
    return this.volumeName;
  }
  
  public String getShareName() {
    return this.shareName;
  }
  
  public String getSecretName() {
    return this.secretName;
  }
  
  
  /**
   * Wether the volumeName is read only or not.
   * @return True if read only, False otherwise.
   */
  public Boolean getReadOnly() {
    return this.readOnly;
  }
  
  
  /**
   * Wether the volumeName is read only or not.
   * @return True if read only, False otherwise.
   */
  public boolean isReadOnly() {
    return this.readOnly != null &&  this.readOnly;
  }
  
  public static AzureFileVolumeBuilder newBuilder() {
    return new AzureFileVolumeBuilder();
  }
  
  public static AzureFileVolumeBuilder newBuilderFromDefaults() {
    return new AzureFileVolumeBuilder().withReadOnly(false);
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AzureFileVolume that = (AzureFileVolume) o;
    if (!java.util.Objects.equals(volumeName, that.volumeName)) return false;
    if (!java.util.Objects.equals(shareName, that.shareName)) return false;
    if (!java.util.Objects.equals(secretName, that.secretName)) return false;
    if (!java.util.Objects.equals(readOnly, that.readOnly)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(volumeName,  shareName,  secretName,  readOnly,  super.hashCode());
  }
  

}