package io.dekorate.kubernetes.config;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AzureFileVolumeFluent<A extends AzureFileVolumeFluent<A>> extends BaseFluent<A>{
  public AzureFileVolumeFluent() {
  }
  
  public AzureFileVolumeFluent(AzureFileVolume instance) {
    this.copyInstance(instance);
  }
  private String volumeName;
  private String shareName;
  private String secretName;
  private Boolean readOnly;
  
  protected void copyInstance(AzureFileVolume instance) {
    instance = (instance != null ? instance : new AzureFileVolume());
    if (instance != null) {
          this.withVolumeName(instance.getVolumeName());
          this.withShareName(instance.getShareName());
          this.withSecretName(instance.getSecretName());
          this.withReadOnly(instance.getReadOnly());
        }
  }
  
  public String getVolumeName() {
    return this.volumeName;
  }
  
  public A withVolumeName(String volumeName) {
    this.volumeName = volumeName;
    return (A) this;
  }
  
  public boolean hasVolumeName() {
    return this.volumeName != null;
  }
  
  public String getShareName() {
    return this.shareName;
  }
  
  public A withShareName(String shareName) {
    this.shareName = shareName;
    return (A) this;
  }
  
  public boolean hasShareName() {
    return this.shareName != null;
  }
  
  public String getSecretName() {
    return this.secretName;
  }
  
  public A withSecretName(String secretName) {
    this.secretName = secretName;
    return (A) this;
  }
  
  public boolean hasSecretName() {
    return this.secretName != null;
  }
  
  public Boolean getReadOnly() {
    return this.readOnly;
  }
  
  public A withReadOnly(Boolean readOnly) {
    this.readOnly = readOnly;
    return (A) this;
  }
  
  public boolean hasReadOnly() {
    return this.readOnly != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AzureFileVolumeFluent that = (AzureFileVolumeFluent) o;
    if (!java.util.Objects.equals(volumeName, that.volumeName)) return false;
    if (!java.util.Objects.equals(shareName, that.shareName)) return false;
    if (!java.util.Objects.equals(secretName, that.secretName)) return false;
    if (!java.util.Objects.equals(readOnly, that.readOnly)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(volumeName,  shareName,  secretName,  readOnly,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (volumeName != null) { sb.append("volumeName:"); sb.append(volumeName + ","); }
    if (shareName != null) { sb.append("shareName:"); sb.append(shareName + ","); }
    if (secretName != null) { sb.append("secretName:"); sb.append(secretName + ","); }
    if (readOnly != null) { sb.append("readOnly:"); sb.append(readOnly); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withReadOnly() {
    return withReadOnly(true);
  }
  

}