package io.dekorate.kubernetes.config;

import java.lang.String;
import io.dekorate.kubernetes.annotation.ServiceType;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import io.dekorate.project.Project;
import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class BaseConfig extends ApplicationConfiguration{
  public BaseConfig() {
  }
  
  public BaseConfig(Project project,Map<ConfigKey,Object> attributes,String partOf,String name,String version,String deploymentKind,Label[] labels,Annotation[] annotations,Env[] envVars,String workingDir,String[] command,String[] arguments,String serviceAccount,Port[] ports,ServiceType serviceType,PersistentVolumeClaimVolume[] pvcVolumes,SecretVolume[] secretVolumes,ConfigMapVolume[] configMapVolumes,EmptyDirVolume[] emptyDirVolumes,GitRepoVolume[] gitRepoVolumes,AwsElasticBlockStoreVolume[] awsElasticBlockStoreVolumes,AzureDiskVolume[] azureDiskVolumes,AzureFileVolume[] azureFileVolumes,Mount[] mounts,ImagePullPolicy imagePullPolicy,String[] imagePullSecrets,DeploymentStrategy deploymentStrategy,RollingUpdate rollingUpdate,HostAlias[] hostAliases,Probe livenessProbe,Probe readinessProbe,Probe startupProbe,ResourceRequirements requestResources,ResourceRequirements limitResources,Container[] sidecars,Boolean autoDeployEnabled,Job[] jobs,CronJob[] cronJobs) {
    super(project, attributes, partOf, name, version);
    this.deploymentKind = deploymentKind;
    this.labels = labels != null ? labels : new Label[0];
    this.annotations = annotations != null ? annotations : new Annotation[0];
    this.envVars = envVars != null ? envVars : new Env[0];
    this.workingDir = workingDir;
    this.command = command != null ? command : new String[0];
    this.arguments = arguments != null ? arguments : new String[0];
    this.serviceAccount = serviceAccount;
    this.ports = ports != null ? ports : new Port[0];
    this.serviceType = serviceType;
    this.pvcVolumes = pvcVolumes != null ? pvcVolumes : new PersistentVolumeClaimVolume[0];
    this.secretVolumes = secretVolumes != null ? secretVolumes : new SecretVolume[0];
    this.configMapVolumes = configMapVolumes != null ? configMapVolumes : new ConfigMapVolume[0];
    this.emptyDirVolumes = emptyDirVolumes != null ? emptyDirVolumes : new EmptyDirVolume[0];
    this.gitRepoVolumes = gitRepoVolumes != null ? gitRepoVolumes : new GitRepoVolume[0];
    this.awsElasticBlockStoreVolumes = awsElasticBlockStoreVolumes != null ? awsElasticBlockStoreVolumes : new AwsElasticBlockStoreVolume[0];
    this.azureDiskVolumes = azureDiskVolumes != null ? azureDiskVolumes : new AzureDiskVolume[0];
    this.azureFileVolumes = azureFileVolumes != null ? azureFileVolumes : new AzureFileVolume[0];
    this.mounts = mounts != null ? mounts : new Mount[0];
    this.imagePullPolicy = imagePullPolicy;
    this.imagePullSecrets = imagePullSecrets != null ? imagePullSecrets : new String[0];
    this.deploymentStrategy = deploymentStrategy;
    this.rollingUpdate = rollingUpdate;
    this.hostAliases = hostAliases != null ? hostAliases : new HostAlias[0];
    this.livenessProbe = livenessProbe;
    this.readinessProbe = readinessProbe;
    this.startupProbe = startupProbe;
    this.requestResources = requestResources;
    this.limitResources = limitResources;
    this.sidecars = sidecars != null ? sidecars : new Container[0];
    this.autoDeployEnabled = autoDeployEnabled;
    this.jobs = jobs != null ? jobs : new Job[0];
    this.cronJobs = cronJobs != null ? cronJobs : new CronJob[0];
  }
  private String deploymentKind;
  private Label[] labels = new Label[0];
  private Annotation[] annotations = new Annotation[0];
  private Env[] envVars = new Env[0];
  private String workingDir;
  private String[] command = new String[0];
  private String[] arguments = new String[0];
  private String serviceAccount;
  private Port[] ports = new Port[0];
  private ServiceType serviceType;
  private PersistentVolumeClaimVolume[] pvcVolumes = new PersistentVolumeClaimVolume[0];
  private SecretVolume[] secretVolumes = new SecretVolume[0];
  private ConfigMapVolume[] configMapVolumes = new ConfigMapVolume[0];
  private EmptyDirVolume[] emptyDirVolumes = new EmptyDirVolume[0];
  private GitRepoVolume[] gitRepoVolumes = new GitRepoVolume[0];
  private AwsElasticBlockStoreVolume[] awsElasticBlockStoreVolumes = new AwsElasticBlockStoreVolume[0];
  private AzureDiskVolume[] azureDiskVolumes = new AzureDiskVolume[0];
  private AzureFileVolume[] azureFileVolumes = new AzureFileVolume[0];
  private Mount[] mounts = new Mount[0];
  private ImagePullPolicy imagePullPolicy;
  private String[] imagePullSecrets = new String[0];
  private DeploymentStrategy deploymentStrategy;
  private RollingUpdate rollingUpdate;
  private HostAlias[] hostAliases = new HostAlias[0];
  private Probe livenessProbe;
  private Probe readinessProbe;
  private Probe startupProbe;
  private ResourceRequirements requestResources;
  private ResourceRequirements limitResources;
  private Container[] sidecars = new Container[0];
  private Boolean autoDeployEnabled;
  private Job[] jobs = new Job[0];
  private CronJob[] cronJobs = new CronJob[0];
  
  
  /**
   * The kind of the deployment resource to use.
   * @return The deployment kind resource.
   */
  public String getDeploymentKind() {
    return this.deploymentKind;
  }
  
  
  /**
   * Custom labels to add to all resources.
   * @return The labels.
   */
  public Label[] getLabels() {
    return this.labels;
  }
  
  
  /**
   * Custom annotations to add to all resources.
   * @return The annotations.
   */
  public Annotation[] getAnnotations() {
    return this.annotations;
  }
  
  
  /**
   * Environment variables to add to all containers.
   * @return The environment variables.
   */
  public Env[] getEnvVars() {
    return this.envVars;
  }
  
  
  /**
   * Working directory.
   * @return The working directory if specified, else empty string.
   */
  public String getWorkingDir() {
    return this.workingDir;
  }
  
  
  /**
   * The commands
   * @return The commands.
   */
  public String[] getCommand() {
    return this.command;
  }
  
  
  /**
   * The arguments
   * @return The arguments.
   */
  public String[] getArguments() {
    return this.arguments;
  }
  
  
  /**
   * The service account.
   * @return The service account or empty string if not specified.
   */
  public String getServiceAccount() {
    return this.serviceAccount;
  }
  
  
  /**
   * The application ports.
   */
  public Port[] getPorts() {
    return this.ports;
  }
  
  
  /**
   * The type of service that will be generated for the application.
   */
  public ServiceType getServiceType() {
    return this.serviceType;
  }
  
  public PersistentVolumeClaimVolume[] getPvcVolumes() {
    return this.pvcVolumes;
  }
  
  public SecretVolume[] getSecretVolumes() {
    return this.secretVolumes;
  }
  
  public ConfigMapVolume[] getConfigMapVolumes() {
    return this.configMapVolumes;
  }
  
  public EmptyDirVolume[] getEmptyDirVolumes() {
    return this.emptyDirVolumes;
  }
  
  public GitRepoVolume[] getGitRepoVolumes() {
    return this.gitRepoVolumes;
  }
  
  public AwsElasticBlockStoreVolume[] getAwsElasticBlockStoreVolumes() {
    return this.awsElasticBlockStoreVolumes;
  }
  
  public AzureDiskVolume[] getAzureDiskVolumes() {
    return this.azureDiskVolumes;
  }
  
  public AzureFileVolume[] getAzureFileVolumes() {
    return this.azureFileVolumes;
  }
  
  
  /**
   * Mounts to add to all containers.
   * @return The mounts.
   */
  public Mount[] getMounts() {
    return this.mounts;
  }
  
  
  /**
   * Image pull policy.
   * @return The image pull policy.
   */
  public ImagePullPolicy getImagePullPolicy() {
    return this.imagePullPolicy;
  }
  
  
  /**
   * The image pull secret
   */
  public String[] getImagePullSecrets() {
    return this.imagePullSecrets;
  }
  
  
  /**
   * Specifies the deployment strategy.
   */
  public DeploymentStrategy getDeploymentStrategy() {
    return this.deploymentStrategy;
  }
  
  
  /**
   * Specifies rolling update configuration.
   * The configuration is applied when DeploymentStrategy == Rolling update, or
   * when explicit configuration has been provided. In the later case RollingUpdate is assumed.
   */
  public RollingUpdate getRollingUpdate() {
    return this.rollingUpdate;
  }
  
  
  /**
   * Host aliases
   * @return The host aliases
   */
  public HostAlias[] getHostAliases() {
    return this.hostAliases;
  }
  
  
  /**
   * The liveness probe.
   * @return The probe.
   */
  public Probe getLivenessProbe() {
    return this.livenessProbe;
  }
  
  
  /**
   * The readiness probe.
   * @return The probe.
   */
  public Probe getReadinessProbe() {
    return this.readinessProbe;
  }
  
  
  /**
   * The startup probe.
   * @return The probe.
   */
  public Probe getStartupProbe() {
    return this.startupProbe;
  }
  
  
  /**
   * The resources that the application container requires.
   */
  public ResourceRequirements getRequestResources() {
    return this.requestResources;
  }
  
  
  /**
   * The resource limit for the application container.
   */
  public ResourceRequirements getLimitResources() {
    return this.limitResources;
  }
  
  
  /**
   * The sidecars.
   * @return the sidecar containers.
   */
  public Container[] getSidecars() {
    return this.sidecars;
  }
  
  
  /**
   * Flag to trigger the registration of the deploy hook. It's generally
   * preferable to use `-Ddekorate.deploy=true` instead of hardcoding this here.
   * @return True for automatic registration of the build hook.
   */
  public Boolean getAutoDeployEnabled() {
    return this.autoDeployEnabled;
  }
  
  
  /**
   * Flag to trigger the registration of the deploy hook. It's generally
   * preferable to use `-Ddekorate.deploy=true` instead of hardcoding this here.
   * @return True for automatic registration of the build hook.
   */
  public boolean isAutoDeployEnabled() {
    return this.autoDeployEnabled != null &&  this.autoDeployEnabled;
  }
  
  
  /**
   * The Kubernetes Jobs.
   * @return the jobs;
   */
  public Job[] getJobs() {
    return this.jobs;
  }
  
  
  /**
   * The Kubernetes CronJobs.
   * @return the cronJobs;
   */
  public CronJob[] getCronJobs() {
    return this.cronJobs;
  }
  
  public static BaseConfigBuilder newBaseConfigBuilder() {
    return new BaseConfigBuilder();
  }
  
  public static BaseConfigBuilder newBaseConfigBuilderFromDefaults() {
    return new BaseConfigBuilder().withDeploymentKind("Deployment").withServiceType(io.dekorate.kubernetes.annotation.ServiceType.ClusterIP).withImagePullPolicy(io.dekorate.kubernetes.annotation.ImagePullPolicy.IfNotPresent).withDeploymentStrategy(io.dekorate.kubernetes.config.DeploymentStrategy.None).withLivenessProbe(new Probe()).withReadinessProbe(new Probe()).withStartupProbe(new Probe()).withRequestResources(new ResourceRequirements()).withLimitResources(new ResourceRequirements()).withAutoDeployEnabled(false);
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BaseConfig that = (BaseConfig) o;
    if (!java.util.Objects.equals(deploymentKind, that.deploymentKind)) return false;
    if (!java.util.Objects.equals(labels, that.labels)) return false;
    if (!java.util.Objects.equals(annotations, that.annotations)) return false;
    if (!java.util.Objects.equals(envVars, that.envVars)) return false;
    if (!java.util.Objects.equals(workingDir, that.workingDir)) return false;
    if (!java.util.Objects.equals(command, that.command)) return false;
    if (!java.util.Objects.equals(arguments, that.arguments)) return false;
    if (!java.util.Objects.equals(serviceAccount, that.serviceAccount)) return false;
    if (!java.util.Objects.equals(ports, that.ports)) return false;
    if (!java.util.Objects.equals(serviceType, that.serviceType)) return false;
    if (!java.util.Objects.equals(pvcVolumes, that.pvcVolumes)) return false;
    if (!java.util.Objects.equals(secretVolumes, that.secretVolumes)) return false;
    if (!java.util.Objects.equals(configMapVolumes, that.configMapVolumes)) return false;
    if (!java.util.Objects.equals(emptyDirVolumes, that.emptyDirVolumes)) return false;
    if (!java.util.Objects.equals(gitRepoVolumes, that.gitRepoVolumes)) return false;
    if (!java.util.Objects.equals(awsElasticBlockStoreVolumes, that.awsElasticBlockStoreVolumes)) return false;
    if (!java.util.Objects.equals(azureDiskVolumes, that.azureDiskVolumes)) return false;
    if (!java.util.Objects.equals(azureFileVolumes, that.azureFileVolumes)) return false;
    if (!java.util.Objects.equals(mounts, that.mounts)) return false;
    if (!java.util.Objects.equals(imagePullPolicy, that.imagePullPolicy)) return false;
    if (!java.util.Objects.equals(imagePullSecrets, that.imagePullSecrets)) return false;
    if (!java.util.Objects.equals(deploymentStrategy, that.deploymentStrategy)) return false;
    if (!java.util.Objects.equals(rollingUpdate, that.rollingUpdate)) return false;
    if (!java.util.Objects.equals(hostAliases, that.hostAliases)) return false;
    if (!java.util.Objects.equals(livenessProbe, that.livenessProbe)) return false;
    if (!java.util.Objects.equals(readinessProbe, that.readinessProbe)) return false;
    if (!java.util.Objects.equals(startupProbe, that.startupProbe)) return false;
    if (!java.util.Objects.equals(requestResources, that.requestResources)) return false;
    if (!java.util.Objects.equals(limitResources, that.limitResources)) return false;
    if (!java.util.Objects.equals(sidecars, that.sidecars)) return false;
    if (!java.util.Objects.equals(autoDeployEnabled, that.autoDeployEnabled)) return false;
    if (!java.util.Objects.equals(jobs, that.jobs)) return false;
    if (!java.util.Objects.equals(cronJobs, that.cronJobs)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(deploymentKind,  labels,  annotations,  envVars,  workingDir,  command,  arguments,  serviceAccount,  ports,  serviceType,  pvcVolumes,  secretVolumes,  configMapVolumes,  emptyDirVolumes,  gitRepoVolumes,  awsElasticBlockStoreVolumes,  azureDiskVolumes,  azureFileVolumes,  mounts,  imagePullPolicy,  imagePullSecrets,  deploymentStrategy,  rollingUpdate,  hostAliases,  livenessProbe,  readinessProbe,  startupProbe,  requestResources,  limitResources,  sidecars,  autoDeployEnabled,  jobs,  cronJobs,  super.hashCode());
  }
  

}