package io.dekorate.kubernetes.config;

import java.util.ArrayList;
import java.lang.String;
import io.dekorate.kubernetes.annotation.ServiceType;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.function.Predicate;
import java.util.List;
import java.util.Collection;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;
import java.lang.Integer;
import io.dekorate.kubernetes.annotation.ImagePullPolicy;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class BaseConfigFluent<A extends BaseConfigFluent<A>> extends ApplicationConfigurationFluent<A>{
  public BaseConfigFluent() {
  }
  
  public BaseConfigFluent(BaseConfig instance) {
    this.copyInstance(instance);
  }
  private String deploymentKind;
  private ArrayList<LabelBuilder> labels = new ArrayList<LabelBuilder>();
  private ArrayList<AnnotationBuilder> annotations = new ArrayList<AnnotationBuilder>();
  private ArrayList<EnvBuilder> envVars = new ArrayList<EnvBuilder>();
  private String workingDir;
  private List<String> command = new ArrayList<String>();
  private List<String> arguments = new ArrayList<String>();
  private String serviceAccount;
  private ArrayList<PortBuilder> ports = new ArrayList<PortBuilder>();
  private ServiceType serviceType;
  private ArrayList<PersistentVolumeClaimVolumeBuilder> pvcVolumes = new ArrayList<PersistentVolumeClaimVolumeBuilder>();
  private ArrayList<SecretVolumeBuilder> secretVolumes = new ArrayList<SecretVolumeBuilder>();
  private ArrayList<ConfigMapVolumeBuilder> configMapVolumes = new ArrayList<ConfigMapVolumeBuilder>();
  private ArrayList<EmptyDirVolumeBuilder> emptyDirVolumes = new ArrayList<EmptyDirVolumeBuilder>();
  private ArrayList<GitRepoVolumeBuilder> gitRepoVolumes = new ArrayList<GitRepoVolumeBuilder>();
  private ArrayList<AwsElasticBlockStoreVolumeBuilder> awsElasticBlockStoreVolumes = new ArrayList<AwsElasticBlockStoreVolumeBuilder>();
  private ArrayList<AzureDiskVolumeBuilder> azureDiskVolumes = new ArrayList<AzureDiskVolumeBuilder>();
  private ArrayList<AzureFileVolumeBuilder> azureFileVolumes = new ArrayList<AzureFileVolumeBuilder>();
  private ArrayList<MountBuilder> mounts = new ArrayList<MountBuilder>();
  private ImagePullPolicy imagePullPolicy;
  private List<String> imagePullSecrets = new ArrayList<String>();
  private DeploymentStrategy deploymentStrategy;
  private RollingUpdateBuilder rollingUpdate;
  private ArrayList<HostAliasBuilder> hostAliases = new ArrayList<HostAliasBuilder>();
  private ProbeBuilder livenessProbe;
  private ProbeBuilder readinessProbe;
  private ProbeBuilder startupProbe;
  private ResourceRequirementsBuilder requestResources;
  private ResourceRequirementsBuilder limitResources;
  private ArrayList<ContainerBuilder> sidecars = new ArrayList<ContainerBuilder>();
  private Boolean autoDeployEnabled;
  private ArrayList<JobBuilder> jobs = new ArrayList<JobBuilder>();
  private ArrayList<CronJobBuilder> cronJobs = new ArrayList<CronJobBuilder>();
  
  protected void copyInstance(BaseConfig instance) {
    instance = (instance != null ? instance : new BaseConfig());
    if (instance != null) {
          this.withProject(instance.getProject());
          this.withAttributes(instance.getAttributes());
          this.withPartOf(instance.getPartOf());
          this.withName(instance.getName());
          this.withVersion(instance.getVersion());
          this.withDeploymentKind(instance.getDeploymentKind());
          this.withLabels(instance.getLabels());
          this.withAnnotations(instance.getAnnotations());
          this.withEnvVars(instance.getEnvVars());
          this.withWorkingDir(instance.getWorkingDir());
          this.withCommand(instance.getCommand());
          this.withArguments(instance.getArguments());
          this.withServiceAccount(instance.getServiceAccount());
          this.withPorts(instance.getPorts());
          this.withServiceType(instance.getServiceType());
          this.withPvcVolumes(instance.getPvcVolumes());
          this.withSecretVolumes(instance.getSecretVolumes());
          this.withConfigMapVolumes(instance.getConfigMapVolumes());
          this.withEmptyDirVolumes(instance.getEmptyDirVolumes());
          this.withGitRepoVolumes(instance.getGitRepoVolumes());
          this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes());
          this.withAzureDiskVolumes(instance.getAzureDiskVolumes());
          this.withAzureFileVolumes(instance.getAzureFileVolumes());
          this.withMounts(instance.getMounts());
          this.withImagePullPolicy(instance.getImagePullPolicy());
          this.withImagePullSecrets(instance.getImagePullSecrets());
          this.withDeploymentStrategy(instance.getDeploymentStrategy());
          this.withRollingUpdate(instance.getRollingUpdate());
          this.withHostAliases(instance.getHostAliases());
          this.withLivenessProbe(instance.getLivenessProbe());
          this.withReadinessProbe(instance.getReadinessProbe());
          this.withStartupProbe(instance.getStartupProbe());
          this.withRequestResources(instance.getRequestResources());
          this.withLimitResources(instance.getLimitResources());
          this.withSidecars(instance.getSidecars());
          this.withAutoDeployEnabled(instance.getAutoDeployEnabled());
          this.withJobs(instance.getJobs());
          this.withCronJobs(instance.getCronJobs());
        }
  }
  
  public String getDeploymentKind() {
    return this.deploymentKind;
  }
  
  public A withDeploymentKind(String deploymentKind) {
    this.deploymentKind = deploymentKind;
    return (A) this;
  }
  
  public boolean hasDeploymentKind() {
    return this.deploymentKind != null;
  }
  
  public A withLabels(io.dekorate.kubernetes.config.Label... labels) {
    if (this.labels != null) {
        this.labels.clear();
        _visitables.remove("labels");
    }
    if (labels != null) {
      for (Label item : labels) {
        this.addToLabels(item);
      }
    }
    return (A) this;
  }
  
  public Label[] buildLabels() {
    int size = labels != null ? labels.size() : 0;;
    Label[] result = new Label[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<Label,LabelBuilder> item : labels) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public Label buildLabel(int index) {
    return this.labels.get(index).build();
  }
  
  public Label buildFirstLabel() {
    return this.labels.get(0).build();
  }
  
  public Label buildLastLabel() {
    return this.labels.get(labels.size() - 1).build();
  }
  
  public Label buildMatchingLabel(Predicate<LabelBuilder> predicate) {
      for (LabelBuilder item : labels) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingLabel(Predicate<LabelBuilder> predicate) {
      for (LabelBuilder item : labels) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToLabels(int index,Label item) {
    if (this.labels == null) {this.labels = new ArrayList<LabelBuilder>();}
    LabelBuilder builder = new LabelBuilder(item);
    if (index < 0 || index >= labels.size()) { _visitables.get("labels").add(builder); labels.add(builder); } else { _visitables.get("labels").add(index, builder); labels.add(index, builder);}
    return (A)this;
  }
  
  public A setToLabels(int index,Label item) {
    if (this.labels == null) {this.labels = new ArrayList<LabelBuilder>();}
    LabelBuilder builder = new LabelBuilder(item);
    if (index < 0 || index >= labels.size()) { _visitables.get("labels").add(builder); labels.add(builder); } else { _visitables.get("labels").set(index, builder); labels.set(index, builder);}
    return (A)this;
  }
  
  public A addToLabels(io.dekorate.kubernetes.config.Label... items) {
    if (this.labels == null) {this.labels = new ArrayList<LabelBuilder>();}
    for (Label item : items) {LabelBuilder builder = new LabelBuilder(item);_visitables.get("labels").add(builder);this.labels.add(builder);} return (A)this;
  }
  
  public A addAllToLabels(Collection<Label> items) {
    if (this.labels == null) {this.labels = new ArrayList<LabelBuilder>();}
    for (Label item : items) {LabelBuilder builder = new LabelBuilder(item);_visitables.get("labels").add(builder);this.labels.add(builder);} return (A)this;
  }
  
  public A removeFromLabels(io.dekorate.kubernetes.config.Label... items) {
    if (this.labels == null) return (A)this;
    for (Label item : items) {LabelBuilder builder = new LabelBuilder(item);_visitables.get("labels").remove(builder); this.labels.remove(builder);} return (A)this;
  }
  
  public A removeAllFromLabels(Collection<Label> items) {
    if (this.labels == null) return (A)this;
    for (Label item : items) {LabelBuilder builder = new LabelBuilder(item);_visitables.get("labels").remove(builder); this.labels.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromLabels(Predicate<LabelBuilder> predicate) {
    if (labels == null) return (A) this;
    final Iterator<LabelBuilder> each = labels.iterator();
    final List visitables = _visitables.get("labels");
    while (each.hasNext()) {
      LabelBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasLabels() {
    return this.labels != null && !this.labels.isEmpty();
  }
  
  public A addNewLabel(String key,String value,String[] kinds) {
    return (A)addToLabels(new Label(key, value, kinds));
  }
  
  public LabelsNested<A> addNewLabel() {
    return new LabelsNested(-1, null);
  }
  
  public LabelsNested<A> addNewLabelLike(Label item) {
    return new LabelsNested(-1, item);
  }
  
  public LabelsNested<A> setNewLabelLike(int index,Label item) {
    return new LabelsNested(index, item);
  }
  
  public LabelsNested<A> editLabel(int index) {
    if (labels.size() <= index) throw new RuntimeException("Can't edit labels. Index exceeds size.");
    return setNewLabelLike(index, buildLabel(index));
  }
  
  public LabelsNested<A> editFirstLabel() {
    if (labels.size() == 0) throw new RuntimeException("Can't edit first labels. The list is empty.");
    return setNewLabelLike(0, buildLabel(0));
  }
  
  public LabelsNested<A> editLastLabel() {
    int index = labels.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last labels. The list is empty.");
    return setNewLabelLike(index, buildLabel(index));
  }
  
  public LabelsNested<A> editMatchingLabel(Predicate<LabelBuilder> predicate) {
    int index = -1;
    for (int i=0;i<labels.size();i++) { 
    if (predicate.test(labels.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching labels. No match found.");
    return setNewLabelLike(index, buildLabel(index));
  }
  
  public A withAnnotations(io.dekorate.kubernetes.config.Annotation... annotations) {
    if (this.annotations != null) {
        this.annotations.clear();
        _visitables.remove("annotations");
    }
    if (annotations != null) {
      for (Annotation item : annotations) {
        this.addToAnnotations(item);
      }
    }
    return (A) this;
  }
  
  public Annotation[] buildAnnotations() {
    int size = annotations != null ? annotations.size() : 0;;
    Annotation[] result = new Annotation[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<Annotation,AnnotationBuilder> item : annotations) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public Annotation buildAnnotation(int index) {
    return this.annotations.get(index).build();
  }
  
  public Annotation buildFirstAnnotation() {
    return this.annotations.get(0).build();
  }
  
  public Annotation buildLastAnnotation() {
    return this.annotations.get(annotations.size() - 1).build();
  }
  
  public Annotation buildMatchingAnnotation(Predicate<AnnotationBuilder> predicate) {
      for (AnnotationBuilder item : annotations) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAnnotation(Predicate<AnnotationBuilder> predicate) {
      for (AnnotationBuilder item : annotations) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToAnnotations(int index,Annotation item) {
    if (this.annotations == null) {this.annotations = new ArrayList<AnnotationBuilder>();}
    AnnotationBuilder builder = new AnnotationBuilder(item);
    if (index < 0 || index >= annotations.size()) { _visitables.get("annotations").add(builder); annotations.add(builder); } else { _visitables.get("annotations").add(index, builder); annotations.add(index, builder);}
    return (A)this;
  }
  
  public A setToAnnotations(int index,Annotation item) {
    if (this.annotations == null) {this.annotations = new ArrayList<AnnotationBuilder>();}
    AnnotationBuilder builder = new AnnotationBuilder(item);
    if (index < 0 || index >= annotations.size()) { _visitables.get("annotations").add(builder); annotations.add(builder); } else { _visitables.get("annotations").set(index, builder); annotations.set(index, builder);}
    return (A)this;
  }
  
  public A addToAnnotations(io.dekorate.kubernetes.config.Annotation... items) {
    if (this.annotations == null) {this.annotations = new ArrayList<AnnotationBuilder>();}
    for (Annotation item : items) {AnnotationBuilder builder = new AnnotationBuilder(item);_visitables.get("annotations").add(builder);this.annotations.add(builder);} return (A)this;
  }
  
  public A addAllToAnnotations(Collection<Annotation> items) {
    if (this.annotations == null) {this.annotations = new ArrayList<AnnotationBuilder>();}
    for (Annotation item : items) {AnnotationBuilder builder = new AnnotationBuilder(item);_visitables.get("annotations").add(builder);this.annotations.add(builder);} return (A)this;
  }
  
  public A removeFromAnnotations(io.dekorate.kubernetes.config.Annotation... items) {
    if (this.annotations == null) return (A)this;
    for (Annotation item : items) {AnnotationBuilder builder = new AnnotationBuilder(item);_visitables.get("annotations").remove(builder); this.annotations.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAnnotations(Collection<Annotation> items) {
    if (this.annotations == null) return (A)this;
    for (Annotation item : items) {AnnotationBuilder builder = new AnnotationBuilder(item);_visitables.get("annotations").remove(builder); this.annotations.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAnnotations(Predicate<AnnotationBuilder> predicate) {
    if (annotations == null) return (A) this;
    final Iterator<AnnotationBuilder> each = annotations.iterator();
    final List visitables = _visitables.get("annotations");
    while (each.hasNext()) {
      AnnotationBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasAnnotations() {
    return this.annotations != null && !this.annotations.isEmpty();
  }
  
  public A addNewAnnotation(String key,String value,String[] kinds) {
    return (A)addToAnnotations(new Annotation(key, value, kinds));
  }
  
  public AnnotationsNested<A> addNewAnnotation() {
    return new AnnotationsNested(-1, null);
  }
  
  public AnnotationsNested<A> addNewAnnotationLike(Annotation item) {
    return new AnnotationsNested(-1, item);
  }
  
  public AnnotationsNested<A> setNewAnnotationLike(int index,Annotation item) {
    return new AnnotationsNested(index, item);
  }
  
  public AnnotationsNested<A> editAnnotation(int index) {
    if (annotations.size() <= index) throw new RuntimeException("Can't edit annotations. Index exceeds size.");
    return setNewAnnotationLike(index, buildAnnotation(index));
  }
  
  public AnnotationsNested<A> editFirstAnnotation() {
    if (annotations.size() == 0) throw new RuntimeException("Can't edit first annotations. The list is empty.");
    return setNewAnnotationLike(0, buildAnnotation(0));
  }
  
  public AnnotationsNested<A> editLastAnnotation() {
    int index = annotations.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last annotations. The list is empty.");
    return setNewAnnotationLike(index, buildAnnotation(index));
  }
  
  public AnnotationsNested<A> editMatchingAnnotation(Predicate<AnnotationBuilder> predicate) {
    int index = -1;
    for (int i=0;i<annotations.size();i++) { 
    if (predicate.test(annotations.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching annotations. No match found.");
    return setNewAnnotationLike(index, buildAnnotation(index));
  }
  
  public A withEnvVars(io.dekorate.kubernetes.config.Env... envVars) {
    if (this.envVars != null) {
        this.envVars.clear();
        _visitables.remove("envVars");
    }
    if (envVars != null) {
      for (Env item : envVars) {
        this.addToEnvVars(item);
      }
    }
    return (A) this;
  }
  
  public Env[] buildEnvVars() {
    int size = envVars != null ? envVars.size() : 0;;
    Env[] result = new Env[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<Env,EnvBuilder> item : envVars) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public Env buildEnvVar(int index) {
    return this.envVars.get(index).build();
  }
  
  public Env buildFirstEnvVar() {
    return this.envVars.get(0).build();
  }
  
  public Env buildLastEnvVar() {
    return this.envVars.get(envVars.size() - 1).build();
  }
  
  public Env buildMatchingEnvVar(Predicate<EnvBuilder> predicate) {
      for (EnvBuilder item : envVars) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingEnvVar(Predicate<EnvBuilder> predicate) {
      for (EnvBuilder item : envVars) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToEnvVars(int index,Env item) {
    if (this.envVars == null) {this.envVars = new ArrayList<EnvBuilder>();}
    EnvBuilder builder = new EnvBuilder(item);
    if (index < 0 || index >= envVars.size()) { _visitables.get("envVars").add(builder); envVars.add(builder); } else { _visitables.get("envVars").add(index, builder); envVars.add(index, builder);}
    return (A)this;
  }
  
  public A setToEnvVars(int index,Env item) {
    if (this.envVars == null) {this.envVars = new ArrayList<EnvBuilder>();}
    EnvBuilder builder = new EnvBuilder(item);
    if (index < 0 || index >= envVars.size()) { _visitables.get("envVars").add(builder); envVars.add(builder); } else { _visitables.get("envVars").set(index, builder); envVars.set(index, builder);}
    return (A)this;
  }
  
  public A addToEnvVars(io.dekorate.kubernetes.config.Env... items) {
    if (this.envVars == null) {this.envVars = new ArrayList<EnvBuilder>();}
    for (Env item : items) {EnvBuilder builder = new EnvBuilder(item);_visitables.get("envVars").add(builder);this.envVars.add(builder);} return (A)this;
  }
  
  public A addAllToEnvVars(Collection<Env> items) {
    if (this.envVars == null) {this.envVars = new ArrayList<EnvBuilder>();}
    for (Env item : items) {EnvBuilder builder = new EnvBuilder(item);_visitables.get("envVars").add(builder);this.envVars.add(builder);} return (A)this;
  }
  
  public A removeFromEnvVars(io.dekorate.kubernetes.config.Env... items) {
    if (this.envVars == null) return (A)this;
    for (Env item : items) {EnvBuilder builder = new EnvBuilder(item);_visitables.get("envVars").remove(builder); this.envVars.remove(builder);} return (A)this;
  }
  
  public A removeAllFromEnvVars(Collection<Env> items) {
    if (this.envVars == null) return (A)this;
    for (Env item : items) {EnvBuilder builder = new EnvBuilder(item);_visitables.get("envVars").remove(builder); this.envVars.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromEnvVars(Predicate<EnvBuilder> predicate) {
    if (envVars == null) return (A) this;
    final Iterator<EnvBuilder> each = envVars.iterator();
    final List visitables = _visitables.get("envVars");
    while (each.hasNext()) {
      EnvBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasEnvVars() {
    return this.envVars != null && !this.envVars.isEmpty();
  }
  
  public EnvVarsNested<A> addNewEnvVar() {
    return new EnvVarsNested(-1, null);
  }
  
  public EnvVarsNested<A> addNewEnvVarLike(Env item) {
    return new EnvVarsNested(-1, item);
  }
  
  public EnvVarsNested<A> setNewEnvVarLike(int index,Env item) {
    return new EnvVarsNested(index, item);
  }
  
  public EnvVarsNested<A> editEnvVar(int index) {
    if (envVars.size() <= index) throw new RuntimeException("Can't edit envVars. Index exceeds size.");
    return setNewEnvVarLike(index, buildEnvVar(index));
  }
  
  public EnvVarsNested<A> editFirstEnvVar() {
    if (envVars.size() == 0) throw new RuntimeException("Can't edit first envVars. The list is empty.");
    return setNewEnvVarLike(0, buildEnvVar(0));
  }
  
  public EnvVarsNested<A> editLastEnvVar() {
    int index = envVars.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last envVars. The list is empty.");
    return setNewEnvVarLike(index, buildEnvVar(index));
  }
  
  public EnvVarsNested<A> editMatchingEnvVar(Predicate<EnvBuilder> predicate) {
    int index = -1;
    for (int i=0;i<envVars.size();i++) { 
    if (predicate.test(envVars.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching envVars. No match found.");
    return setNewEnvVarLike(index, buildEnvVar(index));
  }
  
  public String getWorkingDir() {
    return this.workingDir;
  }
  
  public A withWorkingDir(String workingDir) {
    this.workingDir = workingDir;
    return (A) this;
  }
  
  public boolean hasWorkingDir() {
    return this.workingDir != null;
  }
  
  public A withCommand(java.lang.String... command) {
    if (this.command != null) {
        this.command.clear();
        _visitables.remove("command");
    }
    if (command != null) {
      for (String item : command) {
        this.addToCommand(item);
      }
    }
    return (A) this;
  }
  
  public String[] getCommand() {
    int size = command != null ? command.size() : 0;;
    String[] result = new String[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (String item : command) {
      result[index++] = item;
    }
    return result;
  }
  
  public A addToCommand(int index,String item) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    this.command.add(index, item);
    return (A)this;
  }
  
  public A setToCommand(int index,String item) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    this.command.set(index, item); return (A)this;
  }
  
  public A addToCommand(java.lang.String... items) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    for (String item : items) {this.command.add(item);} return (A)this;
  }
  
  public A addAllToCommand(Collection<String> items) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    for (String item : items) {this.command.add(item);} return (A)this;
  }
  
  public A removeFromCommand(java.lang.String... items) {
    if (this.command == null) return (A)this;
    for (String item : items) { this.command.remove(item);} return (A)this;
  }
  
  public A removeAllFromCommand(Collection<String> items) {
    if (this.command == null) return (A)this;
    for (String item : items) { this.command.remove(item);} return (A)this;
  }
  
  public boolean hasCommand() {
    return this.command != null && !this.command.isEmpty();
  }
  
  public A withArguments(java.lang.String... arguments) {
    if (this.arguments != null) {
        this.arguments.clear();
        _visitables.remove("arguments");
    }
    if (arguments != null) {
      for (String item : arguments) {
        this.addToArguments(item);
      }
    }
    return (A) this;
  }
  
  public String[] getArguments() {
    int size = arguments != null ? arguments.size() : 0;;
    String[] result = new String[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (String item : arguments) {
      result[index++] = item;
    }
    return result;
  }
  
  public A addToArguments(int index,String item) {
    if (this.arguments == null) {this.arguments = new ArrayList<String>();}
    this.arguments.add(index, item);
    return (A)this;
  }
  
  public A setToArguments(int index,String item) {
    if (this.arguments == null) {this.arguments = new ArrayList<String>();}
    this.arguments.set(index, item); return (A)this;
  }
  
  public A addToArguments(java.lang.String... items) {
    if (this.arguments == null) {this.arguments = new ArrayList<String>();}
    for (String item : items) {this.arguments.add(item);} return (A)this;
  }
  
  public A addAllToArguments(Collection<String> items) {
    if (this.arguments == null) {this.arguments = new ArrayList<String>();}
    for (String item : items) {this.arguments.add(item);} return (A)this;
  }
  
  public A removeFromArguments(java.lang.String... items) {
    if (this.arguments == null) return (A)this;
    for (String item : items) { this.arguments.remove(item);} return (A)this;
  }
  
  public A removeAllFromArguments(Collection<String> items) {
    if (this.arguments == null) return (A)this;
    for (String item : items) { this.arguments.remove(item);} return (A)this;
  }
  
  public boolean hasArguments() {
    return this.arguments != null && !this.arguments.isEmpty();
  }
  
  public String getServiceAccount() {
    return this.serviceAccount;
  }
  
  public A withServiceAccount(String serviceAccount) {
    this.serviceAccount = serviceAccount;
    return (A) this;
  }
  
  public boolean hasServiceAccount() {
    return this.serviceAccount != null;
  }
  
  public A withPorts(io.dekorate.kubernetes.config.Port... ports) {
    if (this.ports != null) {
        this.ports.clear();
        _visitables.remove("ports");
    }
    if (ports != null) {
      for (Port item : ports) {
        this.addToPorts(item);
      }
    }
    return (A) this;
  }
  
  public Port[] buildPorts() {
    int size = ports != null ? ports.size() : 0;;
    Port[] result = new Port[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<Port,PortBuilder> item : ports) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public Port buildPort(int index) {
    return this.ports.get(index).build();
  }
  
  public Port buildFirstPort() {
    return this.ports.get(0).build();
  }
  
  public Port buildLastPort() {
    return this.ports.get(ports.size() - 1).build();
  }
  
  public Port buildMatchingPort(Predicate<PortBuilder> predicate) {
      for (PortBuilder item : ports) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingPort(Predicate<PortBuilder> predicate) {
      for (PortBuilder item : ports) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToPorts(int index,Port item) {
    if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
    PortBuilder builder = new PortBuilder(item);
    if (index < 0 || index >= ports.size()) { _visitables.get("ports").add(builder); ports.add(builder); } else { _visitables.get("ports").add(index, builder); ports.add(index, builder);}
    return (A)this;
  }
  
  public A setToPorts(int index,Port item) {
    if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
    PortBuilder builder = new PortBuilder(item);
    if (index < 0 || index >= ports.size()) { _visitables.get("ports").add(builder); ports.add(builder); } else { _visitables.get("ports").set(index, builder); ports.set(index, builder);}
    return (A)this;
  }
  
  public A addToPorts(io.dekorate.kubernetes.config.Port... items) {
    if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
    for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  
  public A addAllToPorts(Collection<Port> items) {
    if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
    for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  
  public A removeFromPorts(io.dekorate.kubernetes.config.Port... items) {
    if (this.ports == null) return (A)this;
    for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.get("ports").remove(builder); this.ports.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPorts(Collection<Port> items) {
    if (this.ports == null) return (A)this;
    for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.get("ports").remove(builder); this.ports.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPorts(Predicate<PortBuilder> predicate) {
    if (ports == null) return (A) this;
    final Iterator<PortBuilder> each = ports.iterator();
    final List visitables = _visitables.get("ports");
    while (each.hasNext()) {
      PortBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasPorts() {
    return this.ports != null && !this.ports.isEmpty();
  }
  
  public PortsNested<A> addNewPort() {
    return new PortsNested(-1, null);
  }
  
  public PortsNested<A> addNewPortLike(Port item) {
    return new PortsNested(-1, item);
  }
  
  public PortsNested<A> setNewPortLike(int index,Port item) {
    return new PortsNested(index, item);
  }
  
  public PortsNested<A> editPort(int index) {
    if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
    return setNewPortLike(index, buildPort(index));
  }
  
  public PortsNested<A> editFirstPort() {
    if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
    return setNewPortLike(0, buildPort(0));
  }
  
  public PortsNested<A> editLastPort() {
    int index = ports.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
    return setNewPortLike(index, buildPort(index));
  }
  
  public PortsNested<A> editMatchingPort(Predicate<PortBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ports.size();i++) { 
    if (predicate.test(ports.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
    return setNewPortLike(index, buildPort(index));
  }
  
  public ServiceType getServiceType() {
    return this.serviceType;
  }
  
  public A withServiceType(ServiceType serviceType) {
    this.serviceType = serviceType;
    return (A) this;
  }
  
  public boolean hasServiceType() {
    return this.serviceType != null;
  }
  
  public A withPvcVolumes(io.dekorate.kubernetes.config.PersistentVolumeClaimVolume... pvcVolumes) {
    if (this.pvcVolumes != null) {
        this.pvcVolumes.clear();
        _visitables.remove("pvcVolumes");
    }
    if (pvcVolumes != null) {
      for (PersistentVolumeClaimVolume item : pvcVolumes) {
        this.addToPvcVolumes(item);
      }
    }
    return (A) this;
  }
  
  public PersistentVolumeClaimVolume[] buildPvcVolumes() {
    int size = pvcVolumes != null ? pvcVolumes.size() : 0;;
    PersistentVolumeClaimVolume[] result = new PersistentVolumeClaimVolume[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<PersistentVolumeClaimVolume,PersistentVolumeClaimVolumeBuilder> item : pvcVolumes) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public PersistentVolumeClaimVolume buildPvcVolume(int index) {
    return this.pvcVolumes.get(index).build();
  }
  
  public PersistentVolumeClaimVolume buildFirstPvcVolume() {
    return this.pvcVolumes.get(0).build();
  }
  
  public PersistentVolumeClaimVolume buildLastPvcVolume() {
    return this.pvcVolumes.get(pvcVolumes.size() - 1).build();
  }
  
  public PersistentVolumeClaimVolume buildMatchingPvcVolume(Predicate<PersistentVolumeClaimVolumeBuilder> predicate) {
      for (PersistentVolumeClaimVolumeBuilder item : pvcVolumes) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingPvcVolume(Predicate<PersistentVolumeClaimVolumeBuilder> predicate) {
      for (PersistentVolumeClaimVolumeBuilder item : pvcVolumes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToPvcVolumes(int index,PersistentVolumeClaimVolume item) {
    if (this.pvcVolumes == null) {this.pvcVolumes = new ArrayList<PersistentVolumeClaimVolumeBuilder>();}
    PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
    if (index < 0 || index >= pvcVolumes.size()) { _visitables.get("pvcVolumes").add(builder); pvcVolumes.add(builder); } else { _visitables.get("pvcVolumes").add(index, builder); pvcVolumes.add(index, builder);}
    return (A)this;
  }
  
  public A setToPvcVolumes(int index,PersistentVolumeClaimVolume item) {
    if (this.pvcVolumes == null) {this.pvcVolumes = new ArrayList<PersistentVolumeClaimVolumeBuilder>();}
    PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
    if (index < 0 || index >= pvcVolumes.size()) { _visitables.get("pvcVolumes").add(builder); pvcVolumes.add(builder); } else { _visitables.get("pvcVolumes").set(index, builder); pvcVolumes.set(index, builder);}
    return (A)this;
  }
  
  public A addToPvcVolumes(io.dekorate.kubernetes.config.PersistentVolumeClaimVolume... items) {
    if (this.pvcVolumes == null) {this.pvcVolumes = new ArrayList<PersistentVolumeClaimVolumeBuilder>();}
    for (PersistentVolumeClaimVolume item : items) {PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);_visitables.get("pvcVolumes").add(builder);this.pvcVolumes.add(builder);} return (A)this;
  }
  
  public A addAllToPvcVolumes(Collection<PersistentVolumeClaimVolume> items) {
    if (this.pvcVolumes == null) {this.pvcVolumes = new ArrayList<PersistentVolumeClaimVolumeBuilder>();}
    for (PersistentVolumeClaimVolume item : items) {PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);_visitables.get("pvcVolumes").add(builder);this.pvcVolumes.add(builder);} return (A)this;
  }
  
  public A removeFromPvcVolumes(io.dekorate.kubernetes.config.PersistentVolumeClaimVolume... items) {
    if (this.pvcVolumes == null) return (A)this;
    for (PersistentVolumeClaimVolume item : items) {PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);_visitables.get("pvcVolumes").remove(builder); this.pvcVolumes.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPvcVolumes(Collection<PersistentVolumeClaimVolume> items) {
    if (this.pvcVolumes == null) return (A)this;
    for (PersistentVolumeClaimVolume item : items) {PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);_visitables.get("pvcVolumes").remove(builder); this.pvcVolumes.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPvcVolumes(Predicate<PersistentVolumeClaimVolumeBuilder> predicate) {
    if (pvcVolumes == null) return (A) this;
    final Iterator<PersistentVolumeClaimVolumeBuilder> each = pvcVolumes.iterator();
    final List visitables = _visitables.get("pvcVolumes");
    while (each.hasNext()) {
      PersistentVolumeClaimVolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasPvcVolumes() {
    return this.pvcVolumes != null && !this.pvcVolumes.isEmpty();
  }
  
  public A addNewPvcVolume(String volumeName,String claimName,Boolean readOnly) {
    return (A)addToPvcVolumes(new PersistentVolumeClaimVolume(volumeName, claimName, readOnly));
  }
  
  public PvcVolumesNested<A> addNewPvcVolume() {
    return new PvcVolumesNested(-1, null);
  }
  
  public PvcVolumesNested<A> addNewPvcVolumeLike(PersistentVolumeClaimVolume item) {
    return new PvcVolumesNested(-1, item);
  }
  
  public PvcVolumesNested<A> setNewPvcVolumeLike(int index,PersistentVolumeClaimVolume item) {
    return new PvcVolumesNested(index, item);
  }
  
  public PvcVolumesNested<A> editPvcVolume(int index) {
    if (pvcVolumes.size() <= index) throw new RuntimeException("Can't edit pvcVolumes. Index exceeds size.");
    return setNewPvcVolumeLike(index, buildPvcVolume(index));
  }
  
  public PvcVolumesNested<A> editFirstPvcVolume() {
    if (pvcVolumes.size() == 0) throw new RuntimeException("Can't edit first pvcVolumes. The list is empty.");
    return setNewPvcVolumeLike(0, buildPvcVolume(0));
  }
  
  public PvcVolumesNested<A> editLastPvcVolume() {
    int index = pvcVolumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last pvcVolumes. The list is empty.");
    return setNewPvcVolumeLike(index, buildPvcVolume(index));
  }
  
  public PvcVolumesNested<A> editMatchingPvcVolume(Predicate<PersistentVolumeClaimVolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<pvcVolumes.size();i++) { 
    if (predicate.test(pvcVolumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching pvcVolumes. No match found.");
    return setNewPvcVolumeLike(index, buildPvcVolume(index));
  }
  
  public A withSecretVolumes(io.dekorate.kubernetes.config.SecretVolume... secretVolumes) {
    if (this.secretVolumes != null) {
        this.secretVolumes.clear();
        _visitables.remove("secretVolumes");
    }
    if (secretVolumes != null) {
      for (SecretVolume item : secretVolumes) {
        this.addToSecretVolumes(item);
      }
    }
    return (A) this;
  }
  
  public SecretVolume[] buildSecretVolumes() {
    int size = secretVolumes != null ? secretVolumes.size() : 0;;
    SecretVolume[] result = new SecretVolume[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<SecretVolume,SecretVolumeBuilder> item : secretVolumes) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public SecretVolume buildSecretVolume(int index) {
    return this.secretVolumes.get(index).build();
  }
  
  public SecretVolume buildFirstSecretVolume() {
    return this.secretVolumes.get(0).build();
  }
  
  public SecretVolume buildLastSecretVolume() {
    return this.secretVolumes.get(secretVolumes.size() - 1).build();
  }
  
  public SecretVolume buildMatchingSecretVolume(Predicate<SecretVolumeBuilder> predicate) {
      for (SecretVolumeBuilder item : secretVolumes) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingSecretVolume(Predicate<SecretVolumeBuilder> predicate) {
      for (SecretVolumeBuilder item : secretVolumes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToSecretVolumes(int index,SecretVolume item) {
    if (this.secretVolumes == null) {this.secretVolumes = new ArrayList<SecretVolumeBuilder>();}
    SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
    if (index < 0 || index >= secretVolumes.size()) { _visitables.get("secretVolumes").add(builder); secretVolumes.add(builder); } else { _visitables.get("secretVolumes").add(index, builder); secretVolumes.add(index, builder);}
    return (A)this;
  }
  
  public A setToSecretVolumes(int index,SecretVolume item) {
    if (this.secretVolumes == null) {this.secretVolumes = new ArrayList<SecretVolumeBuilder>();}
    SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
    if (index < 0 || index >= secretVolumes.size()) { _visitables.get("secretVolumes").add(builder); secretVolumes.add(builder); } else { _visitables.get("secretVolumes").set(index, builder); secretVolumes.set(index, builder);}
    return (A)this;
  }
  
  public A addToSecretVolumes(io.dekorate.kubernetes.config.SecretVolume... items) {
    if (this.secretVolumes == null) {this.secretVolumes = new ArrayList<SecretVolumeBuilder>();}
    for (SecretVolume item : items) {SecretVolumeBuilder builder = new SecretVolumeBuilder(item);_visitables.get("secretVolumes").add(builder);this.secretVolumes.add(builder);} return (A)this;
  }
  
  public A addAllToSecretVolumes(Collection<SecretVolume> items) {
    if (this.secretVolumes == null) {this.secretVolumes = new ArrayList<SecretVolumeBuilder>();}
    for (SecretVolume item : items) {SecretVolumeBuilder builder = new SecretVolumeBuilder(item);_visitables.get("secretVolumes").add(builder);this.secretVolumes.add(builder);} return (A)this;
  }
  
  public A removeFromSecretVolumes(io.dekorate.kubernetes.config.SecretVolume... items) {
    if (this.secretVolumes == null) return (A)this;
    for (SecretVolume item : items) {SecretVolumeBuilder builder = new SecretVolumeBuilder(item);_visitables.get("secretVolumes").remove(builder); this.secretVolumes.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSecretVolumes(Collection<SecretVolume> items) {
    if (this.secretVolumes == null) return (A)this;
    for (SecretVolume item : items) {SecretVolumeBuilder builder = new SecretVolumeBuilder(item);_visitables.get("secretVolumes").remove(builder); this.secretVolumes.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSecretVolumes(Predicate<SecretVolumeBuilder> predicate) {
    if (secretVolumes == null) return (A) this;
    final Iterator<SecretVolumeBuilder> each = secretVolumes.iterator();
    final List visitables = _visitables.get("secretVolumes");
    while (each.hasNext()) {
      SecretVolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasSecretVolumes() {
    return this.secretVolumes != null && !this.secretVolumes.isEmpty();
  }
  
  public SecretVolumesNested<A> addNewSecretVolume() {
    return new SecretVolumesNested(-1, null);
  }
  
  public SecretVolumesNested<A> addNewSecretVolumeLike(SecretVolume item) {
    return new SecretVolumesNested(-1, item);
  }
  
  public SecretVolumesNested<A> setNewSecretVolumeLike(int index,SecretVolume item) {
    return new SecretVolumesNested(index, item);
  }
  
  public SecretVolumesNested<A> editSecretVolume(int index) {
    if (secretVolumes.size() <= index) throw new RuntimeException("Can't edit secretVolumes. Index exceeds size.");
    return setNewSecretVolumeLike(index, buildSecretVolume(index));
  }
  
  public SecretVolumesNested<A> editFirstSecretVolume() {
    if (secretVolumes.size() == 0) throw new RuntimeException("Can't edit first secretVolumes. The list is empty.");
    return setNewSecretVolumeLike(0, buildSecretVolume(0));
  }
  
  public SecretVolumesNested<A> editLastSecretVolume() {
    int index = secretVolumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last secretVolumes. The list is empty.");
    return setNewSecretVolumeLike(index, buildSecretVolume(index));
  }
  
  public SecretVolumesNested<A> editMatchingSecretVolume(Predicate<SecretVolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<secretVolumes.size();i++) { 
    if (predicate.test(secretVolumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching secretVolumes. No match found.");
    return setNewSecretVolumeLike(index, buildSecretVolume(index));
  }
  
  public A withConfigMapVolumes(io.dekorate.kubernetes.config.ConfigMapVolume... configMapVolumes) {
    if (this.configMapVolumes != null) {
        this.configMapVolumes.clear();
        _visitables.remove("configMapVolumes");
    }
    if (configMapVolumes != null) {
      for (ConfigMapVolume item : configMapVolumes) {
        this.addToConfigMapVolumes(item);
      }
    }
    return (A) this;
  }
  
  public ConfigMapVolume[] buildConfigMapVolumes() {
    int size = configMapVolumes != null ? configMapVolumes.size() : 0;;
    ConfigMapVolume[] result = new ConfigMapVolume[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<ConfigMapVolume,ConfigMapVolumeBuilder> item : configMapVolumes) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public ConfigMapVolume buildConfigMapVolume(int index) {
    return this.configMapVolumes.get(index).build();
  }
  
  public ConfigMapVolume buildFirstConfigMapVolume() {
    return this.configMapVolumes.get(0).build();
  }
  
  public ConfigMapVolume buildLastConfigMapVolume() {
    return this.configMapVolumes.get(configMapVolumes.size() - 1).build();
  }
  
  public ConfigMapVolume buildMatchingConfigMapVolume(Predicate<ConfigMapVolumeBuilder> predicate) {
      for (ConfigMapVolumeBuilder item : configMapVolumes) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingConfigMapVolume(Predicate<ConfigMapVolumeBuilder> predicate) {
      for (ConfigMapVolumeBuilder item : configMapVolumes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToConfigMapVolumes(int index,ConfigMapVolume item) {
    if (this.configMapVolumes == null) {this.configMapVolumes = new ArrayList<ConfigMapVolumeBuilder>();}
    ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
    if (index < 0 || index >= configMapVolumes.size()) { _visitables.get("configMapVolumes").add(builder); configMapVolumes.add(builder); } else { _visitables.get("configMapVolumes").add(index, builder); configMapVolumes.add(index, builder);}
    return (A)this;
  }
  
  public A setToConfigMapVolumes(int index,ConfigMapVolume item) {
    if (this.configMapVolumes == null) {this.configMapVolumes = new ArrayList<ConfigMapVolumeBuilder>();}
    ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
    if (index < 0 || index >= configMapVolumes.size()) { _visitables.get("configMapVolumes").add(builder); configMapVolumes.add(builder); } else { _visitables.get("configMapVolumes").set(index, builder); configMapVolumes.set(index, builder);}
    return (A)this;
  }
  
  public A addToConfigMapVolumes(io.dekorate.kubernetes.config.ConfigMapVolume... items) {
    if (this.configMapVolumes == null) {this.configMapVolumes = new ArrayList<ConfigMapVolumeBuilder>();}
    for (ConfigMapVolume item : items) {ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);_visitables.get("configMapVolumes").add(builder);this.configMapVolumes.add(builder);} return (A)this;
  }
  
  public A addAllToConfigMapVolumes(Collection<ConfigMapVolume> items) {
    if (this.configMapVolumes == null) {this.configMapVolumes = new ArrayList<ConfigMapVolumeBuilder>();}
    for (ConfigMapVolume item : items) {ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);_visitables.get("configMapVolumes").add(builder);this.configMapVolumes.add(builder);} return (A)this;
  }
  
  public A removeFromConfigMapVolumes(io.dekorate.kubernetes.config.ConfigMapVolume... items) {
    if (this.configMapVolumes == null) return (A)this;
    for (ConfigMapVolume item : items) {ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);_visitables.get("configMapVolumes").remove(builder); this.configMapVolumes.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConfigMapVolumes(Collection<ConfigMapVolume> items) {
    if (this.configMapVolumes == null) return (A)this;
    for (ConfigMapVolume item : items) {ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);_visitables.get("configMapVolumes").remove(builder); this.configMapVolumes.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConfigMapVolumes(Predicate<ConfigMapVolumeBuilder> predicate) {
    if (configMapVolumes == null) return (A) this;
    final Iterator<ConfigMapVolumeBuilder> each = configMapVolumes.iterator();
    final List visitables = _visitables.get("configMapVolumes");
    while (each.hasNext()) {
      ConfigMapVolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasConfigMapVolumes() {
    return this.configMapVolumes != null && !this.configMapVolumes.isEmpty();
  }
  
  public ConfigMapVolumesNested<A> addNewConfigMapVolume() {
    return new ConfigMapVolumesNested(-1, null);
  }
  
  public ConfigMapVolumesNested<A> addNewConfigMapVolumeLike(ConfigMapVolume item) {
    return new ConfigMapVolumesNested(-1, item);
  }
  
  public ConfigMapVolumesNested<A> setNewConfigMapVolumeLike(int index,ConfigMapVolume item) {
    return new ConfigMapVolumesNested(index, item);
  }
  
  public ConfigMapVolumesNested<A> editConfigMapVolume(int index) {
    if (configMapVolumes.size() <= index) throw new RuntimeException("Can't edit configMapVolumes. Index exceeds size.");
    return setNewConfigMapVolumeLike(index, buildConfigMapVolume(index));
  }
  
  public ConfigMapVolumesNested<A> editFirstConfigMapVolume() {
    if (configMapVolumes.size() == 0) throw new RuntimeException("Can't edit first configMapVolumes. The list is empty.");
    return setNewConfigMapVolumeLike(0, buildConfigMapVolume(0));
  }
  
  public ConfigMapVolumesNested<A> editLastConfigMapVolume() {
    int index = configMapVolumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last configMapVolumes. The list is empty.");
    return setNewConfigMapVolumeLike(index, buildConfigMapVolume(index));
  }
  
  public ConfigMapVolumesNested<A> editMatchingConfigMapVolume(Predicate<ConfigMapVolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<configMapVolumes.size();i++) { 
    if (predicate.test(configMapVolumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching configMapVolumes. No match found.");
    return setNewConfigMapVolumeLike(index, buildConfigMapVolume(index));
  }
  
  public A withEmptyDirVolumes(io.dekorate.kubernetes.config.EmptyDirVolume... emptyDirVolumes) {
    if (this.emptyDirVolumes != null) {
        this.emptyDirVolumes.clear();
        _visitables.remove("emptyDirVolumes");
    }
    if (emptyDirVolumes != null) {
      for (EmptyDirVolume item : emptyDirVolumes) {
        this.addToEmptyDirVolumes(item);
      }
    }
    return (A) this;
  }
  
  public EmptyDirVolume[] buildEmptyDirVolumes() {
    int size = emptyDirVolumes != null ? emptyDirVolumes.size() : 0;;
    EmptyDirVolume[] result = new EmptyDirVolume[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<EmptyDirVolume,EmptyDirVolumeBuilder> item : emptyDirVolumes) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public EmptyDirVolume buildEmptyDirVolume(int index) {
    return this.emptyDirVolumes.get(index).build();
  }
  
  public EmptyDirVolume buildFirstEmptyDirVolume() {
    return this.emptyDirVolumes.get(0).build();
  }
  
  public EmptyDirVolume buildLastEmptyDirVolume() {
    return this.emptyDirVolumes.get(emptyDirVolumes.size() - 1).build();
  }
  
  public EmptyDirVolume buildMatchingEmptyDirVolume(Predicate<EmptyDirVolumeBuilder> predicate) {
      for (EmptyDirVolumeBuilder item : emptyDirVolumes) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingEmptyDirVolume(Predicate<EmptyDirVolumeBuilder> predicate) {
      for (EmptyDirVolumeBuilder item : emptyDirVolumes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToEmptyDirVolumes(int index,EmptyDirVolume item) {
    if (this.emptyDirVolumes == null) {this.emptyDirVolumes = new ArrayList<EmptyDirVolumeBuilder>();}
    EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
    if (index < 0 || index >= emptyDirVolumes.size()) { _visitables.get("emptyDirVolumes").add(builder); emptyDirVolumes.add(builder); } else { _visitables.get("emptyDirVolumes").add(index, builder); emptyDirVolumes.add(index, builder);}
    return (A)this;
  }
  
  public A setToEmptyDirVolumes(int index,EmptyDirVolume item) {
    if (this.emptyDirVolumes == null) {this.emptyDirVolumes = new ArrayList<EmptyDirVolumeBuilder>();}
    EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
    if (index < 0 || index >= emptyDirVolumes.size()) { _visitables.get("emptyDirVolumes").add(builder); emptyDirVolumes.add(builder); } else { _visitables.get("emptyDirVolumes").set(index, builder); emptyDirVolumes.set(index, builder);}
    return (A)this;
  }
  
  public A addToEmptyDirVolumes(io.dekorate.kubernetes.config.EmptyDirVolume... items) {
    if (this.emptyDirVolumes == null) {this.emptyDirVolumes = new ArrayList<EmptyDirVolumeBuilder>();}
    for (EmptyDirVolume item : items) {EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);_visitables.get("emptyDirVolumes").add(builder);this.emptyDirVolumes.add(builder);} return (A)this;
  }
  
  public A addAllToEmptyDirVolumes(Collection<EmptyDirVolume> items) {
    if (this.emptyDirVolumes == null) {this.emptyDirVolumes = new ArrayList<EmptyDirVolumeBuilder>();}
    for (EmptyDirVolume item : items) {EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);_visitables.get("emptyDirVolumes").add(builder);this.emptyDirVolumes.add(builder);} return (A)this;
  }
  
  public A removeFromEmptyDirVolumes(io.dekorate.kubernetes.config.EmptyDirVolume... items) {
    if (this.emptyDirVolumes == null) return (A)this;
    for (EmptyDirVolume item : items) {EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);_visitables.get("emptyDirVolumes").remove(builder); this.emptyDirVolumes.remove(builder);} return (A)this;
  }
  
  public A removeAllFromEmptyDirVolumes(Collection<EmptyDirVolume> items) {
    if (this.emptyDirVolumes == null) return (A)this;
    for (EmptyDirVolume item : items) {EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);_visitables.get("emptyDirVolumes").remove(builder); this.emptyDirVolumes.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromEmptyDirVolumes(Predicate<EmptyDirVolumeBuilder> predicate) {
    if (emptyDirVolumes == null) return (A) this;
    final Iterator<EmptyDirVolumeBuilder> each = emptyDirVolumes.iterator();
    final List visitables = _visitables.get("emptyDirVolumes");
    while (each.hasNext()) {
      EmptyDirVolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasEmptyDirVolumes() {
    return this.emptyDirVolumes != null && !this.emptyDirVolumes.isEmpty();
  }
  
  public A addNewEmptyDirVolume(String volumeName) {
    return (A)addToEmptyDirVolumes(new EmptyDirVolume(volumeName));
  }
  
  public EmptyDirVolumesNested<A> addNewEmptyDirVolume() {
    return new EmptyDirVolumesNested(-1, null);
  }
  
  public EmptyDirVolumesNested<A> addNewEmptyDirVolumeLike(EmptyDirVolume item) {
    return new EmptyDirVolumesNested(-1, item);
  }
  
  public EmptyDirVolumesNested<A> setNewEmptyDirVolumeLike(int index,EmptyDirVolume item) {
    return new EmptyDirVolumesNested(index, item);
  }
  
  public EmptyDirVolumesNested<A> editEmptyDirVolume(int index) {
    if (emptyDirVolumes.size() <= index) throw new RuntimeException("Can't edit emptyDirVolumes. Index exceeds size.");
    return setNewEmptyDirVolumeLike(index, buildEmptyDirVolume(index));
  }
  
  public EmptyDirVolumesNested<A> editFirstEmptyDirVolume() {
    if (emptyDirVolumes.size() == 0) throw new RuntimeException("Can't edit first emptyDirVolumes. The list is empty.");
    return setNewEmptyDirVolumeLike(0, buildEmptyDirVolume(0));
  }
  
  public EmptyDirVolumesNested<A> editLastEmptyDirVolume() {
    int index = emptyDirVolumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last emptyDirVolumes. The list is empty.");
    return setNewEmptyDirVolumeLike(index, buildEmptyDirVolume(index));
  }
  
  public EmptyDirVolumesNested<A> editMatchingEmptyDirVolume(Predicate<EmptyDirVolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<emptyDirVolumes.size();i++) { 
    if (predicate.test(emptyDirVolumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching emptyDirVolumes. No match found.");
    return setNewEmptyDirVolumeLike(index, buildEmptyDirVolume(index));
  }
  
  public A withGitRepoVolumes(io.dekorate.kubernetes.config.GitRepoVolume... gitRepoVolumes) {
    if (this.gitRepoVolumes != null) {
        this.gitRepoVolumes.clear();
        _visitables.remove("gitRepoVolumes");
    }
    if (gitRepoVolumes != null) {
      for (GitRepoVolume item : gitRepoVolumes) {
        this.addToGitRepoVolumes(item);
      }
    }
    return (A) this;
  }
  
  public GitRepoVolume[] buildGitRepoVolumes() {
    int size = gitRepoVolumes != null ? gitRepoVolumes.size() : 0;;
    GitRepoVolume[] result = new GitRepoVolume[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<GitRepoVolume,GitRepoVolumeBuilder> item : gitRepoVolumes) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public GitRepoVolume buildGitRepoVolume(int index) {
    return this.gitRepoVolumes.get(index).build();
  }
  
  public GitRepoVolume buildFirstGitRepoVolume() {
    return this.gitRepoVolumes.get(0).build();
  }
  
  public GitRepoVolume buildLastGitRepoVolume() {
    return this.gitRepoVolumes.get(gitRepoVolumes.size() - 1).build();
  }
  
  public GitRepoVolume buildMatchingGitRepoVolume(Predicate<GitRepoVolumeBuilder> predicate) {
      for (GitRepoVolumeBuilder item : gitRepoVolumes) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingGitRepoVolume(Predicate<GitRepoVolumeBuilder> predicate) {
      for (GitRepoVolumeBuilder item : gitRepoVolumes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToGitRepoVolumes(int index,GitRepoVolume item) {
    if (this.gitRepoVolumes == null) {this.gitRepoVolumes = new ArrayList<GitRepoVolumeBuilder>();}
    GitRepoVolumeBuilder builder = new GitRepoVolumeBuilder(item);
    if (index < 0 || index >= gitRepoVolumes.size()) { _visitables.get("gitRepoVolumes").add(builder); gitRepoVolumes.add(builder); } else { _visitables.get("gitRepoVolumes").add(index, builder); gitRepoVolumes.add(index, builder);}
    return (A)this;
  }
  
  public A setToGitRepoVolumes(int index,GitRepoVolume item) {
    if (this.gitRepoVolumes == null) {this.gitRepoVolumes = new ArrayList<GitRepoVolumeBuilder>();}
    GitRepoVolumeBuilder builder = new GitRepoVolumeBuilder(item);
    if (index < 0 || index >= gitRepoVolumes.size()) { _visitables.get("gitRepoVolumes").add(builder); gitRepoVolumes.add(builder); } else { _visitables.get("gitRepoVolumes").set(index, builder); gitRepoVolumes.set(index, builder);}
    return (A)this;
  }
  
  public A addToGitRepoVolumes(io.dekorate.kubernetes.config.GitRepoVolume... items) {
    if (this.gitRepoVolumes == null) {this.gitRepoVolumes = new ArrayList<GitRepoVolumeBuilder>();}
    for (GitRepoVolume item : items) {GitRepoVolumeBuilder builder = new GitRepoVolumeBuilder(item);_visitables.get("gitRepoVolumes").add(builder);this.gitRepoVolumes.add(builder);} return (A)this;
  }
  
  public A addAllToGitRepoVolumes(Collection<GitRepoVolume> items) {
    if (this.gitRepoVolumes == null) {this.gitRepoVolumes = new ArrayList<GitRepoVolumeBuilder>();}
    for (GitRepoVolume item : items) {GitRepoVolumeBuilder builder = new GitRepoVolumeBuilder(item);_visitables.get("gitRepoVolumes").add(builder);this.gitRepoVolumes.add(builder);} return (A)this;
  }
  
  public A removeFromGitRepoVolumes(io.dekorate.kubernetes.config.GitRepoVolume... items) {
    if (this.gitRepoVolumes == null) return (A)this;
    for (GitRepoVolume item : items) {GitRepoVolumeBuilder builder = new GitRepoVolumeBuilder(item);_visitables.get("gitRepoVolumes").remove(builder); this.gitRepoVolumes.remove(builder);} return (A)this;
  }
  
  public A removeAllFromGitRepoVolumes(Collection<GitRepoVolume> items) {
    if (this.gitRepoVolumes == null) return (A)this;
    for (GitRepoVolume item : items) {GitRepoVolumeBuilder builder = new GitRepoVolumeBuilder(item);_visitables.get("gitRepoVolumes").remove(builder); this.gitRepoVolumes.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromGitRepoVolumes(Predicate<GitRepoVolumeBuilder> predicate) {
    if (gitRepoVolumes == null) return (A) this;
    final Iterator<GitRepoVolumeBuilder> each = gitRepoVolumes.iterator();
    final List visitables = _visitables.get("gitRepoVolumes");
    while (each.hasNext()) {
      GitRepoVolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasGitRepoVolumes() {
    return this.gitRepoVolumes != null && !this.gitRepoVolumes.isEmpty();
  }
  
  public A addNewGitRepoVolume(String volumeName,String repository,String directory,String revision) {
    return (A)addToGitRepoVolumes(new GitRepoVolume(volumeName, repository, directory, revision));
  }
  
  public GitRepoVolumesNested<A> addNewGitRepoVolume() {
    return new GitRepoVolumesNested(-1, null);
  }
  
  public GitRepoVolumesNested<A> addNewGitRepoVolumeLike(GitRepoVolume item) {
    return new GitRepoVolumesNested(-1, item);
  }
  
  public GitRepoVolumesNested<A> setNewGitRepoVolumeLike(int index,GitRepoVolume item) {
    return new GitRepoVolumesNested(index, item);
  }
  
  public GitRepoVolumesNested<A> editGitRepoVolume(int index) {
    if (gitRepoVolumes.size() <= index) throw new RuntimeException("Can't edit gitRepoVolumes. Index exceeds size.");
    return setNewGitRepoVolumeLike(index, buildGitRepoVolume(index));
  }
  
  public GitRepoVolumesNested<A> editFirstGitRepoVolume() {
    if (gitRepoVolumes.size() == 0) throw new RuntimeException("Can't edit first gitRepoVolumes. The list is empty.");
    return setNewGitRepoVolumeLike(0, buildGitRepoVolume(0));
  }
  
  public GitRepoVolumesNested<A> editLastGitRepoVolume() {
    int index = gitRepoVolumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last gitRepoVolumes. The list is empty.");
    return setNewGitRepoVolumeLike(index, buildGitRepoVolume(index));
  }
  
  public GitRepoVolumesNested<A> editMatchingGitRepoVolume(Predicate<GitRepoVolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<gitRepoVolumes.size();i++) { 
    if (predicate.test(gitRepoVolumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching gitRepoVolumes. No match found.");
    return setNewGitRepoVolumeLike(index, buildGitRepoVolume(index));
  }
  
  public A withAwsElasticBlockStoreVolumes(io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume... awsElasticBlockStoreVolumes) {
    if (this.awsElasticBlockStoreVolumes != null) {
        this.awsElasticBlockStoreVolumes.clear();
        _visitables.remove("awsElasticBlockStoreVolumes");
    }
    if (awsElasticBlockStoreVolumes != null) {
      for (AwsElasticBlockStoreVolume item : awsElasticBlockStoreVolumes) {
        this.addToAwsElasticBlockStoreVolumes(item);
      }
    }
    return (A) this;
  }
  
  public AwsElasticBlockStoreVolume[] buildAwsElasticBlockStoreVolumes() {
    int size = awsElasticBlockStoreVolumes != null ? awsElasticBlockStoreVolumes.size() : 0;;
    AwsElasticBlockStoreVolume[] result = new AwsElasticBlockStoreVolume[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<AwsElasticBlockStoreVolume,AwsElasticBlockStoreVolumeBuilder> item : awsElasticBlockStoreVolumes) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public AwsElasticBlockStoreVolume buildAwsElasticBlockStoreVolume(int index) {
    return this.awsElasticBlockStoreVolumes.get(index).build();
  }
  
  public AwsElasticBlockStoreVolume buildFirstAwsElasticBlockStoreVolume() {
    return this.awsElasticBlockStoreVolumes.get(0).build();
  }
  
  public AwsElasticBlockStoreVolume buildLastAwsElasticBlockStoreVolume() {
    return this.awsElasticBlockStoreVolumes.get(awsElasticBlockStoreVolumes.size() - 1).build();
  }
  
  public AwsElasticBlockStoreVolume buildMatchingAwsElasticBlockStoreVolume(Predicate<AwsElasticBlockStoreVolumeBuilder> predicate) {
      for (AwsElasticBlockStoreVolumeBuilder item : awsElasticBlockStoreVolumes) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAwsElasticBlockStoreVolume(Predicate<AwsElasticBlockStoreVolumeBuilder> predicate) {
      for (AwsElasticBlockStoreVolumeBuilder item : awsElasticBlockStoreVolumes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToAwsElasticBlockStoreVolumes(int index,AwsElasticBlockStoreVolume item) {
    if (this.awsElasticBlockStoreVolumes == null) {this.awsElasticBlockStoreVolumes = new ArrayList<AwsElasticBlockStoreVolumeBuilder>();}
    AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
    if (index < 0 || index >= awsElasticBlockStoreVolumes.size()) { _visitables.get("awsElasticBlockStoreVolumes").add(builder); awsElasticBlockStoreVolumes.add(builder); } else { _visitables.get("awsElasticBlockStoreVolumes").add(index, builder); awsElasticBlockStoreVolumes.add(index, builder);}
    return (A)this;
  }
  
  public A setToAwsElasticBlockStoreVolumes(int index,AwsElasticBlockStoreVolume item) {
    if (this.awsElasticBlockStoreVolumes == null) {this.awsElasticBlockStoreVolumes = new ArrayList<AwsElasticBlockStoreVolumeBuilder>();}
    AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
    if (index < 0 || index >= awsElasticBlockStoreVolumes.size()) { _visitables.get("awsElasticBlockStoreVolumes").add(builder); awsElasticBlockStoreVolumes.add(builder); } else { _visitables.get("awsElasticBlockStoreVolumes").set(index, builder); awsElasticBlockStoreVolumes.set(index, builder);}
    return (A)this;
  }
  
  public A addToAwsElasticBlockStoreVolumes(io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume... items) {
    if (this.awsElasticBlockStoreVolumes == null) {this.awsElasticBlockStoreVolumes = new ArrayList<AwsElasticBlockStoreVolumeBuilder>();}
    for (AwsElasticBlockStoreVolume item : items) {AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);_visitables.get("awsElasticBlockStoreVolumes").add(builder);this.awsElasticBlockStoreVolumes.add(builder);} return (A)this;
  }
  
  public A addAllToAwsElasticBlockStoreVolumes(Collection<AwsElasticBlockStoreVolume> items) {
    if (this.awsElasticBlockStoreVolumes == null) {this.awsElasticBlockStoreVolumes = new ArrayList<AwsElasticBlockStoreVolumeBuilder>();}
    for (AwsElasticBlockStoreVolume item : items) {AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);_visitables.get("awsElasticBlockStoreVolumes").add(builder);this.awsElasticBlockStoreVolumes.add(builder);} return (A)this;
  }
  
  public A removeFromAwsElasticBlockStoreVolumes(io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume... items) {
    if (this.awsElasticBlockStoreVolumes == null) return (A)this;
    for (AwsElasticBlockStoreVolume item : items) {AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);_visitables.get("awsElasticBlockStoreVolumes").remove(builder); this.awsElasticBlockStoreVolumes.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAwsElasticBlockStoreVolumes(Collection<AwsElasticBlockStoreVolume> items) {
    if (this.awsElasticBlockStoreVolumes == null) return (A)this;
    for (AwsElasticBlockStoreVolume item : items) {AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);_visitables.get("awsElasticBlockStoreVolumes").remove(builder); this.awsElasticBlockStoreVolumes.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAwsElasticBlockStoreVolumes(Predicate<AwsElasticBlockStoreVolumeBuilder> predicate) {
    if (awsElasticBlockStoreVolumes == null) return (A) this;
    final Iterator<AwsElasticBlockStoreVolumeBuilder> each = awsElasticBlockStoreVolumes.iterator();
    final List visitables = _visitables.get("awsElasticBlockStoreVolumes");
    while (each.hasNext()) {
      AwsElasticBlockStoreVolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasAwsElasticBlockStoreVolumes() {
    return this.awsElasticBlockStoreVolumes != null && !this.awsElasticBlockStoreVolumes.isEmpty();
  }
  
  public A addNewAwsElasticBlockStoreVolume(String volumeName,String volumeId,Integer partition,String fsType,Boolean readOnly) {
    return (A)addToAwsElasticBlockStoreVolumes(new AwsElasticBlockStoreVolume(volumeName, volumeId, partition, fsType, readOnly));
  }
  
  public AwsElasticBlockStoreVolumesNested<A> addNewAwsElasticBlockStoreVolume() {
    return new AwsElasticBlockStoreVolumesNested(-1, null);
  }
  
  public AwsElasticBlockStoreVolumesNested<A> addNewAwsElasticBlockStoreVolumeLike(AwsElasticBlockStoreVolume item) {
    return new AwsElasticBlockStoreVolumesNested(-1, item);
  }
  
  public AwsElasticBlockStoreVolumesNested<A> setNewAwsElasticBlockStoreVolumeLike(int index,AwsElasticBlockStoreVolume item) {
    return new AwsElasticBlockStoreVolumesNested(index, item);
  }
  
  public AwsElasticBlockStoreVolumesNested<A> editAwsElasticBlockStoreVolume(int index) {
    if (awsElasticBlockStoreVolumes.size() <= index) throw new RuntimeException("Can't edit awsElasticBlockStoreVolumes. Index exceeds size.");
    return setNewAwsElasticBlockStoreVolumeLike(index, buildAwsElasticBlockStoreVolume(index));
  }
  
  public AwsElasticBlockStoreVolumesNested<A> editFirstAwsElasticBlockStoreVolume() {
    if (awsElasticBlockStoreVolumes.size() == 0) throw new RuntimeException("Can't edit first awsElasticBlockStoreVolumes. The list is empty.");
    return setNewAwsElasticBlockStoreVolumeLike(0, buildAwsElasticBlockStoreVolume(0));
  }
  
  public AwsElasticBlockStoreVolumesNested<A> editLastAwsElasticBlockStoreVolume() {
    int index = awsElasticBlockStoreVolumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last awsElasticBlockStoreVolumes. The list is empty.");
    return setNewAwsElasticBlockStoreVolumeLike(index, buildAwsElasticBlockStoreVolume(index));
  }
  
  public AwsElasticBlockStoreVolumesNested<A> editMatchingAwsElasticBlockStoreVolume(Predicate<AwsElasticBlockStoreVolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<awsElasticBlockStoreVolumes.size();i++) { 
    if (predicate.test(awsElasticBlockStoreVolumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching awsElasticBlockStoreVolumes. No match found.");
    return setNewAwsElasticBlockStoreVolumeLike(index, buildAwsElasticBlockStoreVolume(index));
  }
  
  public A withAzureDiskVolumes(io.dekorate.kubernetes.config.AzureDiskVolume... azureDiskVolumes) {
    if (this.azureDiskVolumes != null) {
        this.azureDiskVolumes.clear();
        _visitables.remove("azureDiskVolumes");
    }
    if (azureDiskVolumes != null) {
      for (AzureDiskVolume item : azureDiskVolumes) {
        this.addToAzureDiskVolumes(item);
      }
    }
    return (A) this;
  }
  
  public AzureDiskVolume[] buildAzureDiskVolumes() {
    int size = azureDiskVolumes != null ? azureDiskVolumes.size() : 0;;
    AzureDiskVolume[] result = new AzureDiskVolume[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<AzureDiskVolume,AzureDiskVolumeBuilder> item : azureDiskVolumes) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public AzureDiskVolume buildAzureDiskVolume(int index) {
    return this.azureDiskVolumes.get(index).build();
  }
  
  public AzureDiskVolume buildFirstAzureDiskVolume() {
    return this.azureDiskVolumes.get(0).build();
  }
  
  public AzureDiskVolume buildLastAzureDiskVolume() {
    return this.azureDiskVolumes.get(azureDiskVolumes.size() - 1).build();
  }
  
  public AzureDiskVolume buildMatchingAzureDiskVolume(Predicate<AzureDiskVolumeBuilder> predicate) {
      for (AzureDiskVolumeBuilder item : azureDiskVolumes) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAzureDiskVolume(Predicate<AzureDiskVolumeBuilder> predicate) {
      for (AzureDiskVolumeBuilder item : azureDiskVolumes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToAzureDiskVolumes(int index,AzureDiskVolume item) {
    if (this.azureDiskVolumes == null) {this.azureDiskVolumes = new ArrayList<AzureDiskVolumeBuilder>();}
    AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
    if (index < 0 || index >= azureDiskVolumes.size()) { _visitables.get("azureDiskVolumes").add(builder); azureDiskVolumes.add(builder); } else { _visitables.get("azureDiskVolumes").add(index, builder); azureDiskVolumes.add(index, builder);}
    return (A)this;
  }
  
  public A setToAzureDiskVolumes(int index,AzureDiskVolume item) {
    if (this.azureDiskVolumes == null) {this.azureDiskVolumes = new ArrayList<AzureDiskVolumeBuilder>();}
    AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
    if (index < 0 || index >= azureDiskVolumes.size()) { _visitables.get("azureDiskVolumes").add(builder); azureDiskVolumes.add(builder); } else { _visitables.get("azureDiskVolumes").set(index, builder); azureDiskVolumes.set(index, builder);}
    return (A)this;
  }
  
  public A addToAzureDiskVolumes(io.dekorate.kubernetes.config.AzureDiskVolume... items) {
    if (this.azureDiskVolumes == null) {this.azureDiskVolumes = new ArrayList<AzureDiskVolumeBuilder>();}
    for (AzureDiskVolume item : items) {AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);_visitables.get("azureDiskVolumes").add(builder);this.azureDiskVolumes.add(builder);} return (A)this;
  }
  
  public A addAllToAzureDiskVolumes(Collection<AzureDiskVolume> items) {
    if (this.azureDiskVolumes == null) {this.azureDiskVolumes = new ArrayList<AzureDiskVolumeBuilder>();}
    for (AzureDiskVolume item : items) {AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);_visitables.get("azureDiskVolumes").add(builder);this.azureDiskVolumes.add(builder);} return (A)this;
  }
  
  public A removeFromAzureDiskVolumes(io.dekorate.kubernetes.config.AzureDiskVolume... items) {
    if (this.azureDiskVolumes == null) return (A)this;
    for (AzureDiskVolume item : items) {AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);_visitables.get("azureDiskVolumes").remove(builder); this.azureDiskVolumes.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAzureDiskVolumes(Collection<AzureDiskVolume> items) {
    if (this.azureDiskVolumes == null) return (A)this;
    for (AzureDiskVolume item : items) {AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);_visitables.get("azureDiskVolumes").remove(builder); this.azureDiskVolumes.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAzureDiskVolumes(Predicate<AzureDiskVolumeBuilder> predicate) {
    if (azureDiskVolumes == null) return (A) this;
    final Iterator<AzureDiskVolumeBuilder> each = azureDiskVolumes.iterator();
    final List visitables = _visitables.get("azureDiskVolumes");
    while (each.hasNext()) {
      AzureDiskVolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasAzureDiskVolumes() {
    return this.azureDiskVolumes != null && !this.azureDiskVolumes.isEmpty();
  }
  
  public AzureDiskVolumesNested<A> addNewAzureDiskVolume() {
    return new AzureDiskVolumesNested(-1, null);
  }
  
  public AzureDiskVolumesNested<A> addNewAzureDiskVolumeLike(AzureDiskVolume item) {
    return new AzureDiskVolumesNested(-1, item);
  }
  
  public AzureDiskVolumesNested<A> setNewAzureDiskVolumeLike(int index,AzureDiskVolume item) {
    return new AzureDiskVolumesNested(index, item);
  }
  
  public AzureDiskVolumesNested<A> editAzureDiskVolume(int index) {
    if (azureDiskVolumes.size() <= index) throw new RuntimeException("Can't edit azureDiskVolumes. Index exceeds size.");
    return setNewAzureDiskVolumeLike(index, buildAzureDiskVolume(index));
  }
  
  public AzureDiskVolumesNested<A> editFirstAzureDiskVolume() {
    if (azureDiskVolumes.size() == 0) throw new RuntimeException("Can't edit first azureDiskVolumes. The list is empty.");
    return setNewAzureDiskVolumeLike(0, buildAzureDiskVolume(0));
  }
  
  public AzureDiskVolumesNested<A> editLastAzureDiskVolume() {
    int index = azureDiskVolumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last azureDiskVolumes. The list is empty.");
    return setNewAzureDiskVolumeLike(index, buildAzureDiskVolume(index));
  }
  
  public AzureDiskVolumesNested<A> editMatchingAzureDiskVolume(Predicate<AzureDiskVolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<azureDiskVolumes.size();i++) { 
    if (predicate.test(azureDiskVolumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching azureDiskVolumes. No match found.");
    return setNewAzureDiskVolumeLike(index, buildAzureDiskVolume(index));
  }
  
  public A withAzureFileVolumes(io.dekorate.kubernetes.config.AzureFileVolume... azureFileVolumes) {
    if (this.azureFileVolumes != null) {
        this.azureFileVolumes.clear();
        _visitables.remove("azureFileVolumes");
    }
    if (azureFileVolumes != null) {
      for (AzureFileVolume item : azureFileVolumes) {
        this.addToAzureFileVolumes(item);
      }
    }
    return (A) this;
  }
  
  public AzureFileVolume[] buildAzureFileVolumes() {
    int size = azureFileVolumes != null ? azureFileVolumes.size() : 0;;
    AzureFileVolume[] result = new AzureFileVolume[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<AzureFileVolume,AzureFileVolumeBuilder> item : azureFileVolumes) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public AzureFileVolume buildAzureFileVolume(int index) {
    return this.azureFileVolumes.get(index).build();
  }
  
  public AzureFileVolume buildFirstAzureFileVolume() {
    return this.azureFileVolumes.get(0).build();
  }
  
  public AzureFileVolume buildLastAzureFileVolume() {
    return this.azureFileVolumes.get(azureFileVolumes.size() - 1).build();
  }
  
  public AzureFileVolume buildMatchingAzureFileVolume(Predicate<AzureFileVolumeBuilder> predicate) {
      for (AzureFileVolumeBuilder item : azureFileVolumes) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAzureFileVolume(Predicate<AzureFileVolumeBuilder> predicate) {
      for (AzureFileVolumeBuilder item : azureFileVolumes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToAzureFileVolumes(int index,AzureFileVolume item) {
    if (this.azureFileVolumes == null) {this.azureFileVolumes = new ArrayList<AzureFileVolumeBuilder>();}
    AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
    if (index < 0 || index >= azureFileVolumes.size()) { _visitables.get("azureFileVolumes").add(builder); azureFileVolumes.add(builder); } else { _visitables.get("azureFileVolumes").add(index, builder); azureFileVolumes.add(index, builder);}
    return (A)this;
  }
  
  public A setToAzureFileVolumes(int index,AzureFileVolume item) {
    if (this.azureFileVolumes == null) {this.azureFileVolumes = new ArrayList<AzureFileVolumeBuilder>();}
    AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
    if (index < 0 || index >= azureFileVolumes.size()) { _visitables.get("azureFileVolumes").add(builder); azureFileVolumes.add(builder); } else { _visitables.get("azureFileVolumes").set(index, builder); azureFileVolumes.set(index, builder);}
    return (A)this;
  }
  
  public A addToAzureFileVolumes(io.dekorate.kubernetes.config.AzureFileVolume... items) {
    if (this.azureFileVolumes == null) {this.azureFileVolumes = new ArrayList<AzureFileVolumeBuilder>();}
    for (AzureFileVolume item : items) {AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);_visitables.get("azureFileVolumes").add(builder);this.azureFileVolumes.add(builder);} return (A)this;
  }
  
  public A addAllToAzureFileVolumes(Collection<AzureFileVolume> items) {
    if (this.azureFileVolumes == null) {this.azureFileVolumes = new ArrayList<AzureFileVolumeBuilder>();}
    for (AzureFileVolume item : items) {AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);_visitables.get("azureFileVolumes").add(builder);this.azureFileVolumes.add(builder);} return (A)this;
  }
  
  public A removeFromAzureFileVolumes(io.dekorate.kubernetes.config.AzureFileVolume... items) {
    if (this.azureFileVolumes == null) return (A)this;
    for (AzureFileVolume item : items) {AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);_visitables.get("azureFileVolumes").remove(builder); this.azureFileVolumes.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAzureFileVolumes(Collection<AzureFileVolume> items) {
    if (this.azureFileVolumes == null) return (A)this;
    for (AzureFileVolume item : items) {AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);_visitables.get("azureFileVolumes").remove(builder); this.azureFileVolumes.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAzureFileVolumes(Predicate<AzureFileVolumeBuilder> predicate) {
    if (azureFileVolumes == null) return (A) this;
    final Iterator<AzureFileVolumeBuilder> each = azureFileVolumes.iterator();
    final List visitables = _visitables.get("azureFileVolumes");
    while (each.hasNext()) {
      AzureFileVolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasAzureFileVolumes() {
    return this.azureFileVolumes != null && !this.azureFileVolumes.isEmpty();
  }
  
  public A addNewAzureFileVolume(String volumeName,String shareName,String secretName,Boolean readOnly) {
    return (A)addToAzureFileVolumes(new AzureFileVolume(volumeName, shareName, secretName, readOnly));
  }
  
  public AzureFileVolumesNested<A> addNewAzureFileVolume() {
    return new AzureFileVolumesNested(-1, null);
  }
  
  public AzureFileVolumesNested<A> addNewAzureFileVolumeLike(AzureFileVolume item) {
    return new AzureFileVolumesNested(-1, item);
  }
  
  public AzureFileVolumesNested<A> setNewAzureFileVolumeLike(int index,AzureFileVolume item) {
    return new AzureFileVolumesNested(index, item);
  }
  
  public AzureFileVolumesNested<A> editAzureFileVolume(int index) {
    if (azureFileVolumes.size() <= index) throw new RuntimeException("Can't edit azureFileVolumes. Index exceeds size.");
    return setNewAzureFileVolumeLike(index, buildAzureFileVolume(index));
  }
  
  public AzureFileVolumesNested<A> editFirstAzureFileVolume() {
    if (azureFileVolumes.size() == 0) throw new RuntimeException("Can't edit first azureFileVolumes. The list is empty.");
    return setNewAzureFileVolumeLike(0, buildAzureFileVolume(0));
  }
  
  public AzureFileVolumesNested<A> editLastAzureFileVolume() {
    int index = azureFileVolumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last azureFileVolumes. The list is empty.");
    return setNewAzureFileVolumeLike(index, buildAzureFileVolume(index));
  }
  
  public AzureFileVolumesNested<A> editMatchingAzureFileVolume(Predicate<AzureFileVolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<azureFileVolumes.size();i++) { 
    if (predicate.test(azureFileVolumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching azureFileVolumes. No match found.");
    return setNewAzureFileVolumeLike(index, buildAzureFileVolume(index));
  }
  
  public A withMounts(io.dekorate.kubernetes.config.Mount... mounts) {
    if (this.mounts != null) {
        this.mounts.clear();
        _visitables.remove("mounts");
    }
    if (mounts != null) {
      for (Mount item : mounts) {
        this.addToMounts(item);
      }
    }
    return (A) this;
  }
  
  public Mount[] buildMounts() {
    int size = mounts != null ? mounts.size() : 0;;
    Mount[] result = new Mount[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<Mount,MountBuilder> item : mounts) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public Mount buildMount(int index) {
    return this.mounts.get(index).build();
  }
  
  public Mount buildFirstMount() {
    return this.mounts.get(0).build();
  }
  
  public Mount buildLastMount() {
    return this.mounts.get(mounts.size() - 1).build();
  }
  
  public Mount buildMatchingMount(Predicate<MountBuilder> predicate) {
      for (MountBuilder item : mounts) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingMount(Predicate<MountBuilder> predicate) {
      for (MountBuilder item : mounts) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToMounts(int index,Mount item) {
    if (this.mounts == null) {this.mounts = new ArrayList<MountBuilder>();}
    MountBuilder builder = new MountBuilder(item);
    if (index < 0 || index >= mounts.size()) { _visitables.get("mounts").add(builder); mounts.add(builder); } else { _visitables.get("mounts").add(index, builder); mounts.add(index, builder);}
    return (A)this;
  }
  
  public A setToMounts(int index,Mount item) {
    if (this.mounts == null) {this.mounts = new ArrayList<MountBuilder>();}
    MountBuilder builder = new MountBuilder(item);
    if (index < 0 || index >= mounts.size()) { _visitables.get("mounts").add(builder); mounts.add(builder); } else { _visitables.get("mounts").set(index, builder); mounts.set(index, builder);}
    return (A)this;
  }
  
  public A addToMounts(io.dekorate.kubernetes.config.Mount... items) {
    if (this.mounts == null) {this.mounts = new ArrayList<MountBuilder>();}
    for (Mount item : items) {MountBuilder builder = new MountBuilder(item);_visitables.get("mounts").add(builder);this.mounts.add(builder);} return (A)this;
  }
  
  public A addAllToMounts(Collection<Mount> items) {
    if (this.mounts == null) {this.mounts = new ArrayList<MountBuilder>();}
    for (Mount item : items) {MountBuilder builder = new MountBuilder(item);_visitables.get("mounts").add(builder);this.mounts.add(builder);} return (A)this;
  }
  
  public A removeFromMounts(io.dekorate.kubernetes.config.Mount... items) {
    if (this.mounts == null) return (A)this;
    for (Mount item : items) {MountBuilder builder = new MountBuilder(item);_visitables.get("mounts").remove(builder); this.mounts.remove(builder);} return (A)this;
  }
  
  public A removeAllFromMounts(Collection<Mount> items) {
    if (this.mounts == null) return (A)this;
    for (Mount item : items) {MountBuilder builder = new MountBuilder(item);_visitables.get("mounts").remove(builder); this.mounts.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromMounts(Predicate<MountBuilder> predicate) {
    if (mounts == null) return (A) this;
    final Iterator<MountBuilder> each = mounts.iterator();
    final List visitables = _visitables.get("mounts");
    while (each.hasNext()) {
      MountBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasMounts() {
    return this.mounts != null && !this.mounts.isEmpty();
  }
  
  public A addNewMount(String name,String path,String subPath,Boolean readOnly) {
    return (A)addToMounts(new Mount(name, path, subPath, readOnly));
  }
  
  public MountsNested<A> addNewMount() {
    return new MountsNested(-1, null);
  }
  
  public MountsNested<A> addNewMountLike(Mount item) {
    return new MountsNested(-1, item);
  }
  
  public MountsNested<A> setNewMountLike(int index,Mount item) {
    return new MountsNested(index, item);
  }
  
  public MountsNested<A> editMount(int index) {
    if (mounts.size() <= index) throw new RuntimeException("Can't edit mounts. Index exceeds size.");
    return setNewMountLike(index, buildMount(index));
  }
  
  public MountsNested<A> editFirstMount() {
    if (mounts.size() == 0) throw new RuntimeException("Can't edit first mounts. The list is empty.");
    return setNewMountLike(0, buildMount(0));
  }
  
  public MountsNested<A> editLastMount() {
    int index = mounts.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last mounts. The list is empty.");
    return setNewMountLike(index, buildMount(index));
  }
  
  public MountsNested<A> editMatchingMount(Predicate<MountBuilder> predicate) {
    int index = -1;
    for (int i=0;i<mounts.size();i++) { 
    if (predicate.test(mounts.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching mounts. No match found.");
    return setNewMountLike(index, buildMount(index));
  }
  
  public ImagePullPolicy getImagePullPolicy() {
    return this.imagePullPolicy;
  }
  
  public A withImagePullPolicy(ImagePullPolicy imagePullPolicy) {
    this.imagePullPolicy = imagePullPolicy;
    return (A) this;
  }
  
  public boolean hasImagePullPolicy() {
    return this.imagePullPolicy != null;
  }
  
  public A withImagePullSecrets(java.lang.String... imagePullSecrets) {
    if (this.imagePullSecrets != null) {
        this.imagePullSecrets.clear();
        _visitables.remove("imagePullSecrets");
    }
    if (imagePullSecrets != null) {
      for (String item : imagePullSecrets) {
        this.addToImagePullSecrets(item);
      }
    }
    return (A) this;
  }
  
  public String[] getImagePullSecrets() {
    int size = imagePullSecrets != null ? imagePullSecrets.size() : 0;;
    String[] result = new String[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (String item : imagePullSecrets) {
      result[index++] = item;
    }
    return result;
  }
  
  public A addToImagePullSecrets(int index,String item) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<String>();}
    this.imagePullSecrets.add(index, item);
    return (A)this;
  }
  
  public A setToImagePullSecrets(int index,String item) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<String>();}
    this.imagePullSecrets.set(index, item); return (A)this;
  }
  
  public A addToImagePullSecrets(java.lang.String... items) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<String>();}
    for (String item : items) {this.imagePullSecrets.add(item);} return (A)this;
  }
  
  public A addAllToImagePullSecrets(Collection<String> items) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<String>();}
    for (String item : items) {this.imagePullSecrets.add(item);} return (A)this;
  }
  
  public A removeFromImagePullSecrets(java.lang.String... items) {
    if (this.imagePullSecrets == null) return (A)this;
    for (String item : items) { this.imagePullSecrets.remove(item);} return (A)this;
  }
  
  public A removeAllFromImagePullSecrets(Collection<String> items) {
    if (this.imagePullSecrets == null) return (A)this;
    for (String item : items) { this.imagePullSecrets.remove(item);} return (A)this;
  }
  
  public boolean hasImagePullSecrets() {
    return this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty();
  }
  
  public DeploymentStrategy getDeploymentStrategy() {
    return this.deploymentStrategy;
  }
  
  public A withDeploymentStrategy(DeploymentStrategy deploymentStrategy) {
    this.deploymentStrategy = deploymentStrategy;
    return (A) this;
  }
  
  public boolean hasDeploymentStrategy() {
    return this.deploymentStrategy != null;
  }
  
  public RollingUpdate buildRollingUpdate() {
    return this.rollingUpdate != null ? this.rollingUpdate.build() : null;
  }
  
  public A withRollingUpdate(RollingUpdate rollingUpdate) {
    this._visitables.remove("rollingUpdate");
    if (rollingUpdate != null) {
        this.rollingUpdate = new RollingUpdateBuilder(rollingUpdate);
        this._visitables.get("rollingUpdate").add(this.rollingUpdate);
    } else {
        this.rollingUpdate = null;
        this._visitables.get("rollingUpdate").remove(this.rollingUpdate);
    }
    return (A) this;
  }
  
  public boolean hasRollingUpdate() {
    return this.rollingUpdate != null;
  }
  
  public A withNewRollingUpdate(String maxUnavailable,String maxSurge) {
    return (A)withRollingUpdate(new RollingUpdate(maxUnavailable, maxSurge));
  }
  
  public RollingUpdateNested<A> withNewRollingUpdate() {
    return new RollingUpdateNested(null);
  }
  
  public RollingUpdateNested<A> withNewRollingUpdateLike(RollingUpdate item) {
    return new RollingUpdateNested(item);
  }
  
  public RollingUpdateNested<A> editRollingUpdate() {
    return withNewRollingUpdateLike(java.util.Optional.ofNullable(buildRollingUpdate()).orElse(null));
  }
  
  public RollingUpdateNested<A> editOrNewRollingUpdate() {
    return withNewRollingUpdateLike(java.util.Optional.ofNullable(buildRollingUpdate()).orElse(new RollingUpdateBuilder().build()));
  }
  
  public RollingUpdateNested<A> editOrNewRollingUpdateLike(RollingUpdate item) {
    return withNewRollingUpdateLike(java.util.Optional.ofNullable(buildRollingUpdate()).orElse(item));
  }
  
  public A withHostAliases(io.dekorate.kubernetes.config.HostAlias... hostAliases) {
    if (this.hostAliases != null) {
        this.hostAliases.clear();
        _visitables.remove("hostAliases");
    }
    if (hostAliases != null) {
      for (HostAlias item : hostAliases) {
        this.addToHostAliases(item);
      }
    }
    return (A) this;
  }
  
  public HostAlias[] buildHostAliases() {
    int size = hostAliases != null ? hostAliases.size() : 0;;
    HostAlias[] result = new HostAlias[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<HostAlias,HostAliasBuilder> item : hostAliases) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public HostAlias buildHostAlias(int index) {
    return this.hostAliases.get(index).build();
  }
  
  public HostAlias buildFirstHostAlias() {
    return this.hostAliases.get(0).build();
  }
  
  public HostAlias buildLastHostAlias() {
    return this.hostAliases.get(hostAliases.size() - 1).build();
  }
  
  public HostAlias buildMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
      for (HostAliasBuilder item : hostAliases) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
      for (HostAliasBuilder item : hostAliases) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToHostAliases(int index,HostAlias item) {
    if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAliasBuilder>();}
    HostAliasBuilder builder = new HostAliasBuilder(item);
    if (index < 0 || index >= hostAliases.size()) { _visitables.get("hostAliases").add(builder); hostAliases.add(builder); } else { _visitables.get("hostAliases").add(index, builder); hostAliases.add(index, builder);}
    return (A)this;
  }
  
  public A setToHostAliases(int index,HostAlias item) {
    if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAliasBuilder>();}
    HostAliasBuilder builder = new HostAliasBuilder(item);
    if (index < 0 || index >= hostAliases.size()) { _visitables.get("hostAliases").add(builder); hostAliases.add(builder); } else { _visitables.get("hostAliases").set(index, builder); hostAliases.set(index, builder);}
    return (A)this;
  }
  
  public A addToHostAliases(io.dekorate.kubernetes.config.HostAlias... items) {
    if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAliasBuilder>();}
    for (HostAlias item : items) {HostAliasBuilder builder = new HostAliasBuilder(item);_visitables.get("hostAliases").add(builder);this.hostAliases.add(builder);} return (A)this;
  }
  
  public A addAllToHostAliases(Collection<HostAlias> items) {
    if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAliasBuilder>();}
    for (HostAlias item : items) {HostAliasBuilder builder = new HostAliasBuilder(item);_visitables.get("hostAliases").add(builder);this.hostAliases.add(builder);} return (A)this;
  }
  
  public A removeFromHostAliases(io.dekorate.kubernetes.config.HostAlias... items) {
    if (this.hostAliases == null) return (A)this;
    for (HostAlias item : items) {HostAliasBuilder builder = new HostAliasBuilder(item);_visitables.get("hostAliases").remove(builder); this.hostAliases.remove(builder);} return (A)this;
  }
  
  public A removeAllFromHostAliases(Collection<HostAlias> items) {
    if (this.hostAliases == null) return (A)this;
    for (HostAlias item : items) {HostAliasBuilder builder = new HostAliasBuilder(item);_visitables.get("hostAliases").remove(builder); this.hostAliases.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromHostAliases(Predicate<HostAliasBuilder> predicate) {
    if (hostAliases == null) return (A) this;
    final Iterator<HostAliasBuilder> each = hostAliases.iterator();
    final List visitables = _visitables.get("hostAliases");
    while (each.hasNext()) {
      HostAliasBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasHostAliases() {
    return this.hostAliases != null && !this.hostAliases.isEmpty();
  }
  
  public A addNewHostAlias(String ip,String hostnames) {
    return (A)addToHostAliases(new HostAlias(ip, hostnames));
  }
  
  public HostAliasesNested<A> addNewHostAlias() {
    return new HostAliasesNested(-1, null);
  }
  
  public HostAliasesNested<A> addNewHostAliasLike(HostAlias item) {
    return new HostAliasesNested(-1, item);
  }
  
  public HostAliasesNested<A> setNewHostAliasLike(int index,HostAlias item) {
    return new HostAliasesNested(index, item);
  }
  
  public HostAliasesNested<A> editHostAlias(int index) {
    if (hostAliases.size() <= index) throw new RuntimeException("Can't edit hostAliases. Index exceeds size.");
    return setNewHostAliasLike(index, buildHostAlias(index));
  }
  
  public HostAliasesNested<A> editFirstHostAlias() {
    if (hostAliases.size() == 0) throw new RuntimeException("Can't edit first hostAliases. The list is empty.");
    return setNewHostAliasLike(0, buildHostAlias(0));
  }
  
  public HostAliasesNested<A> editLastHostAlias() {
    int index = hostAliases.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last hostAliases. The list is empty.");
    return setNewHostAliasLike(index, buildHostAlias(index));
  }
  
  public HostAliasesNested<A> editMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
    int index = -1;
    for (int i=0;i<hostAliases.size();i++) { 
    if (predicate.test(hostAliases.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching hostAliases. No match found.");
    return setNewHostAliasLike(index, buildHostAlias(index));
  }
  
  public Probe buildLivenessProbe() {
    return this.livenessProbe != null ? this.livenessProbe.build() : null;
  }
  
  public A withLivenessProbe(Probe livenessProbe) {
    this._visitables.remove("livenessProbe");
    if (livenessProbe != null) {
        this.livenessProbe = new ProbeBuilder(livenessProbe);
        this._visitables.get("livenessProbe").add(this.livenessProbe);
    } else {
        this.livenessProbe = null;
        this._visitables.get("livenessProbe").remove(this.livenessProbe);
    }
    return (A) this;
  }
  
  public boolean hasLivenessProbe() {
    return this.livenessProbe != null;
  }
  
  public LivenessProbeNested<A> withNewLivenessProbe() {
    return new LivenessProbeNested(null);
  }
  
  public LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
    return new LivenessProbeNested(item);
  }
  
  public LivenessProbeNested<A> editLivenessProbe() {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(null));
  }
  
  public LivenessProbeNested<A> editOrNewLivenessProbe() {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(new ProbeBuilder().build()));
  }
  
  public LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(item));
  }
  
  public Probe buildReadinessProbe() {
    return this.readinessProbe != null ? this.readinessProbe.build() : null;
  }
  
  public A withReadinessProbe(Probe readinessProbe) {
    this._visitables.remove("readinessProbe");
    if (readinessProbe != null) {
        this.readinessProbe = new ProbeBuilder(readinessProbe);
        this._visitables.get("readinessProbe").add(this.readinessProbe);
    } else {
        this.readinessProbe = null;
        this._visitables.get("readinessProbe").remove(this.readinessProbe);
    }
    return (A) this;
  }
  
  public boolean hasReadinessProbe() {
    return this.readinessProbe != null;
  }
  
  public ReadinessProbeNested<A> withNewReadinessProbe() {
    return new ReadinessProbeNested(null);
  }
  
  public ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
    return new ReadinessProbeNested(item);
  }
  
  public ReadinessProbeNested<A> editReadinessProbe() {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(null));
  }
  
  public ReadinessProbeNested<A> editOrNewReadinessProbe() {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(new ProbeBuilder().build()));
  }
  
  public ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(item));
  }
  
  public Probe buildStartupProbe() {
    return this.startupProbe != null ? this.startupProbe.build() : null;
  }
  
  public A withStartupProbe(Probe startupProbe) {
    this._visitables.remove("startupProbe");
    if (startupProbe != null) {
        this.startupProbe = new ProbeBuilder(startupProbe);
        this._visitables.get("startupProbe").add(this.startupProbe);
    } else {
        this.startupProbe = null;
        this._visitables.get("startupProbe").remove(this.startupProbe);
    }
    return (A) this;
  }
  
  public boolean hasStartupProbe() {
    return this.startupProbe != null;
  }
  
  public StartupProbeNested<A> withNewStartupProbe() {
    return new StartupProbeNested(null);
  }
  
  public StartupProbeNested<A> withNewStartupProbeLike(Probe item) {
    return new StartupProbeNested(item);
  }
  
  public StartupProbeNested<A> editStartupProbe() {
    return withNewStartupProbeLike(java.util.Optional.ofNullable(buildStartupProbe()).orElse(null));
  }
  
  public StartupProbeNested<A> editOrNewStartupProbe() {
    return withNewStartupProbeLike(java.util.Optional.ofNullable(buildStartupProbe()).orElse(new ProbeBuilder().build()));
  }
  
  public StartupProbeNested<A> editOrNewStartupProbeLike(Probe item) {
    return withNewStartupProbeLike(java.util.Optional.ofNullable(buildStartupProbe()).orElse(item));
  }
  
  public ResourceRequirements buildRequestResources() {
    return this.requestResources != null ? this.requestResources.build() : null;
  }
  
  public A withRequestResources(ResourceRequirements requestResources) {
    this._visitables.remove("requestResources");
    if (requestResources != null) {
        this.requestResources = new ResourceRequirementsBuilder(requestResources);
        this._visitables.get("requestResources").add(this.requestResources);
    } else {
        this.requestResources = null;
        this._visitables.get("requestResources").remove(this.requestResources);
    }
    return (A) this;
  }
  
  public boolean hasRequestResources() {
    return this.requestResources != null;
  }
  
  public A withNewRequestResources(String memory,String cpu) {
    return (A)withRequestResources(new ResourceRequirements(memory, cpu));
  }
  
  public RequestResourcesNested<A> withNewRequestResources() {
    return new RequestResourcesNested(null);
  }
  
  public RequestResourcesNested<A> withNewRequestResourcesLike(ResourceRequirements item) {
    return new RequestResourcesNested(item);
  }
  
  public RequestResourcesNested<A> editRequestResources() {
    return withNewRequestResourcesLike(java.util.Optional.ofNullable(buildRequestResources()).orElse(null));
  }
  
  public RequestResourcesNested<A> editOrNewRequestResources() {
    return withNewRequestResourcesLike(java.util.Optional.ofNullable(buildRequestResources()).orElse(new ResourceRequirementsBuilder().build()));
  }
  
  public RequestResourcesNested<A> editOrNewRequestResourcesLike(ResourceRequirements item) {
    return withNewRequestResourcesLike(java.util.Optional.ofNullable(buildRequestResources()).orElse(item));
  }
  
  public ResourceRequirements buildLimitResources() {
    return this.limitResources != null ? this.limitResources.build() : null;
  }
  
  public A withLimitResources(ResourceRequirements limitResources) {
    this._visitables.remove("limitResources");
    if (limitResources != null) {
        this.limitResources = new ResourceRequirementsBuilder(limitResources);
        this._visitables.get("limitResources").add(this.limitResources);
    } else {
        this.limitResources = null;
        this._visitables.get("limitResources").remove(this.limitResources);
    }
    return (A) this;
  }
  
  public boolean hasLimitResources() {
    return this.limitResources != null;
  }
  
  public A withNewLimitResources(String memory,String cpu) {
    return (A)withLimitResources(new ResourceRequirements(memory, cpu));
  }
  
  public LimitResourcesNested<A> withNewLimitResources() {
    return new LimitResourcesNested(null);
  }
  
  public LimitResourcesNested<A> withNewLimitResourcesLike(ResourceRequirements item) {
    return new LimitResourcesNested(item);
  }
  
  public LimitResourcesNested<A> editLimitResources() {
    return withNewLimitResourcesLike(java.util.Optional.ofNullable(buildLimitResources()).orElse(null));
  }
  
  public LimitResourcesNested<A> editOrNewLimitResources() {
    return withNewLimitResourcesLike(java.util.Optional.ofNullable(buildLimitResources()).orElse(new ResourceRequirementsBuilder().build()));
  }
  
  public LimitResourcesNested<A> editOrNewLimitResourcesLike(ResourceRequirements item) {
    return withNewLimitResourcesLike(java.util.Optional.ofNullable(buildLimitResources()).orElse(item));
  }
  
  public A withSidecars(io.dekorate.kubernetes.config.Container... sidecars) {
    if (this.sidecars != null) {
        this.sidecars.clear();
        _visitables.remove("sidecars");
    }
    if (sidecars != null) {
      for (Container item : sidecars) {
        this.addToSidecars(item);
      }
    }
    return (A) this;
  }
  
  public Container[] buildSidecars() {
    int size = sidecars != null ? sidecars.size() : 0;;
    Container[] result = new Container[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<Container,ContainerBuilder> item : sidecars) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public Container buildSidecar(int index) {
    return this.sidecars.get(index).build();
  }
  
  public Container buildFirstSidecar() {
    return this.sidecars.get(0).build();
  }
  
  public Container buildLastSidecar() {
    return this.sidecars.get(sidecars.size() - 1).build();
  }
  
  public Container buildMatchingSidecar(Predicate<ContainerBuilder> predicate) {
      for (ContainerBuilder item : sidecars) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingSidecar(Predicate<ContainerBuilder> predicate) {
      for (ContainerBuilder item : sidecars) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToSidecars(int index,Container item) {
    if (this.sidecars == null) {this.sidecars = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= sidecars.size()) { _visitables.get("sidecars").add(builder); sidecars.add(builder); } else { _visitables.get("sidecars").add(index, builder); sidecars.add(index, builder);}
    return (A)this;
  }
  
  public A setToSidecars(int index,Container item) {
    if (this.sidecars == null) {this.sidecars = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= sidecars.size()) { _visitables.get("sidecars").add(builder); sidecars.add(builder); } else { _visitables.get("sidecars").set(index, builder); sidecars.set(index, builder);}
    return (A)this;
  }
  
  public A addToSidecars(io.dekorate.kubernetes.config.Container... items) {
    if (this.sidecars == null) {this.sidecars = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("sidecars").add(builder);this.sidecars.add(builder);} return (A)this;
  }
  
  public A addAllToSidecars(Collection<Container> items) {
    if (this.sidecars == null) {this.sidecars = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("sidecars").add(builder);this.sidecars.add(builder);} return (A)this;
  }
  
  public A removeFromSidecars(io.dekorate.kubernetes.config.Container... items) {
    if (this.sidecars == null) return (A)this;
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("sidecars").remove(builder); this.sidecars.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSidecars(Collection<Container> items) {
    if (this.sidecars == null) return (A)this;
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("sidecars").remove(builder); this.sidecars.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSidecars(Predicate<ContainerBuilder> predicate) {
    if (sidecars == null) return (A) this;
    final Iterator<ContainerBuilder> each = sidecars.iterator();
    final List visitables = _visitables.get("sidecars");
    while (each.hasNext()) {
      ContainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasSidecars() {
    return this.sidecars != null && !this.sidecars.isEmpty();
  }
  
  public SidecarsNested<A> addNewSidecar() {
    return new SidecarsNested(-1, null);
  }
  
  public SidecarsNested<A> addNewSidecarLike(Container item) {
    return new SidecarsNested(-1, item);
  }
  
  public SidecarsNested<A> setNewSidecarLike(int index,Container item) {
    return new SidecarsNested(index, item);
  }
  
  public SidecarsNested<A> editSidecar(int index) {
    if (sidecars.size() <= index) throw new RuntimeException("Can't edit sidecars. Index exceeds size.");
    return setNewSidecarLike(index, buildSidecar(index));
  }
  
  public SidecarsNested<A> editFirstSidecar() {
    if (sidecars.size() == 0) throw new RuntimeException("Can't edit first sidecars. The list is empty.");
    return setNewSidecarLike(0, buildSidecar(0));
  }
  
  public SidecarsNested<A> editLastSidecar() {
    int index = sidecars.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last sidecars. The list is empty.");
    return setNewSidecarLike(index, buildSidecar(index));
  }
  
  public SidecarsNested<A> editMatchingSidecar(Predicate<ContainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<sidecars.size();i++) { 
    if (predicate.test(sidecars.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching sidecars. No match found.");
    return setNewSidecarLike(index, buildSidecar(index));
  }
  
  public Boolean getAutoDeployEnabled() {
    return this.autoDeployEnabled;
  }
  
  public A withAutoDeployEnabled(Boolean autoDeployEnabled) {
    this.autoDeployEnabled = autoDeployEnabled;
    return (A) this;
  }
  
  public boolean hasAutoDeployEnabled() {
    return this.autoDeployEnabled != null;
  }
  
  public A withJobs(io.dekorate.kubernetes.config.Job... jobs) {
    if (this.jobs != null) {
        this.jobs.clear();
        _visitables.remove("jobs");
    }
    if (jobs != null) {
      for (Job item : jobs) {
        this.addToJobs(item);
      }
    }
    return (A) this;
  }
  
  public Job[] buildJobs() {
    int size = jobs != null ? jobs.size() : 0;;
    Job[] result = new Job[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<Job,JobBuilder> item : jobs) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public Job buildJob(int index) {
    return this.jobs.get(index).build();
  }
  
  public Job buildFirstJob() {
    return this.jobs.get(0).build();
  }
  
  public Job buildLastJob() {
    return this.jobs.get(jobs.size() - 1).build();
  }
  
  public Job buildMatchingJob(Predicate<JobBuilder> predicate) {
      for (JobBuilder item : jobs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingJob(Predicate<JobBuilder> predicate) {
      for (JobBuilder item : jobs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToJobs(int index,Job item) {
    if (this.jobs == null) {this.jobs = new ArrayList<JobBuilder>();}
    JobBuilder builder = new JobBuilder(item);
    if (index < 0 || index >= jobs.size()) { _visitables.get("jobs").add(builder); jobs.add(builder); } else { _visitables.get("jobs").add(index, builder); jobs.add(index, builder);}
    return (A)this;
  }
  
  public A setToJobs(int index,Job item) {
    if (this.jobs == null) {this.jobs = new ArrayList<JobBuilder>();}
    JobBuilder builder = new JobBuilder(item);
    if (index < 0 || index >= jobs.size()) { _visitables.get("jobs").add(builder); jobs.add(builder); } else { _visitables.get("jobs").set(index, builder); jobs.set(index, builder);}
    return (A)this;
  }
  
  public A addToJobs(io.dekorate.kubernetes.config.Job... items) {
    if (this.jobs == null) {this.jobs = new ArrayList<JobBuilder>();}
    for (Job item : items) {JobBuilder builder = new JobBuilder(item);_visitables.get("jobs").add(builder);this.jobs.add(builder);} return (A)this;
  }
  
  public A addAllToJobs(Collection<Job> items) {
    if (this.jobs == null) {this.jobs = new ArrayList<JobBuilder>();}
    for (Job item : items) {JobBuilder builder = new JobBuilder(item);_visitables.get("jobs").add(builder);this.jobs.add(builder);} return (A)this;
  }
  
  public A removeFromJobs(io.dekorate.kubernetes.config.Job... items) {
    if (this.jobs == null) return (A)this;
    for (Job item : items) {JobBuilder builder = new JobBuilder(item);_visitables.get("jobs").remove(builder); this.jobs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromJobs(Collection<Job> items) {
    if (this.jobs == null) return (A)this;
    for (Job item : items) {JobBuilder builder = new JobBuilder(item);_visitables.get("jobs").remove(builder); this.jobs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromJobs(Predicate<JobBuilder> predicate) {
    if (jobs == null) return (A) this;
    final Iterator<JobBuilder> each = jobs.iterator();
    final List visitables = _visitables.get("jobs");
    while (each.hasNext()) {
      JobBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasJobs() {
    return this.jobs != null && !this.jobs.isEmpty();
  }
  
  public JobsNested<A> addNewJob() {
    return new JobsNested(-1, null);
  }
  
  public JobsNested<A> addNewJobLike(Job item) {
    return new JobsNested(-1, item);
  }
  
  public JobsNested<A> setNewJobLike(int index,Job item) {
    return new JobsNested(index, item);
  }
  
  public JobsNested<A> editJob(int index) {
    if (jobs.size() <= index) throw new RuntimeException("Can't edit jobs. Index exceeds size.");
    return setNewJobLike(index, buildJob(index));
  }
  
  public JobsNested<A> editFirstJob() {
    if (jobs.size() == 0) throw new RuntimeException("Can't edit first jobs. The list is empty.");
    return setNewJobLike(0, buildJob(0));
  }
  
  public JobsNested<A> editLastJob() {
    int index = jobs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last jobs. The list is empty.");
    return setNewJobLike(index, buildJob(index));
  }
  
  public JobsNested<A> editMatchingJob(Predicate<JobBuilder> predicate) {
    int index = -1;
    for (int i=0;i<jobs.size();i++) { 
    if (predicate.test(jobs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching jobs. No match found.");
    return setNewJobLike(index, buildJob(index));
  }
  
  public A withCronJobs(io.dekorate.kubernetes.config.CronJob... cronJobs) {
    if (this.cronJobs != null) {
        this.cronJobs.clear();
        _visitables.remove("cronJobs");
    }
    if (cronJobs != null) {
      for (CronJob item : cronJobs) {
        this.addToCronJobs(item);
      }
    }
    return (A) this;
  }
  
  public CronJob[] buildCronJobs() {
    int size = cronJobs != null ? cronJobs.size() : 0;;
    CronJob[] result = new CronJob[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<CronJob,CronJobBuilder> item : cronJobs) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public CronJob buildCronJob(int index) {
    return this.cronJobs.get(index).build();
  }
  
  public CronJob buildFirstCronJob() {
    return this.cronJobs.get(0).build();
  }
  
  public CronJob buildLastCronJob() {
    return this.cronJobs.get(cronJobs.size() - 1).build();
  }
  
  public CronJob buildMatchingCronJob(Predicate<CronJobBuilder> predicate) {
      for (CronJobBuilder item : cronJobs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCronJob(Predicate<CronJobBuilder> predicate) {
      for (CronJobBuilder item : cronJobs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToCronJobs(int index,CronJob item) {
    if (this.cronJobs == null) {this.cronJobs = new ArrayList<CronJobBuilder>();}
    CronJobBuilder builder = new CronJobBuilder(item);
    if (index < 0 || index >= cronJobs.size()) { _visitables.get("cronJobs").add(builder); cronJobs.add(builder); } else { _visitables.get("cronJobs").add(index, builder); cronJobs.add(index, builder);}
    return (A)this;
  }
  
  public A setToCronJobs(int index,CronJob item) {
    if (this.cronJobs == null) {this.cronJobs = new ArrayList<CronJobBuilder>();}
    CronJobBuilder builder = new CronJobBuilder(item);
    if (index < 0 || index >= cronJobs.size()) { _visitables.get("cronJobs").add(builder); cronJobs.add(builder); } else { _visitables.get("cronJobs").set(index, builder); cronJobs.set(index, builder);}
    return (A)this;
  }
  
  public A addToCronJobs(io.dekorate.kubernetes.config.CronJob... items) {
    if (this.cronJobs == null) {this.cronJobs = new ArrayList<CronJobBuilder>();}
    for (CronJob item : items) {CronJobBuilder builder = new CronJobBuilder(item);_visitables.get("cronJobs").add(builder);this.cronJobs.add(builder);} return (A)this;
  }
  
  public A addAllToCronJobs(Collection<CronJob> items) {
    if (this.cronJobs == null) {this.cronJobs = new ArrayList<CronJobBuilder>();}
    for (CronJob item : items) {CronJobBuilder builder = new CronJobBuilder(item);_visitables.get("cronJobs").add(builder);this.cronJobs.add(builder);} return (A)this;
  }
  
  public A removeFromCronJobs(io.dekorate.kubernetes.config.CronJob... items) {
    if (this.cronJobs == null) return (A)this;
    for (CronJob item : items) {CronJobBuilder builder = new CronJobBuilder(item);_visitables.get("cronJobs").remove(builder); this.cronJobs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromCronJobs(Collection<CronJob> items) {
    if (this.cronJobs == null) return (A)this;
    for (CronJob item : items) {CronJobBuilder builder = new CronJobBuilder(item);_visitables.get("cronJobs").remove(builder); this.cronJobs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromCronJobs(Predicate<CronJobBuilder> predicate) {
    if (cronJobs == null) return (A) this;
    final Iterator<CronJobBuilder> each = cronJobs.iterator();
    final List visitables = _visitables.get("cronJobs");
    while (each.hasNext()) {
      CronJobBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasCronJobs() {
    return this.cronJobs != null && !this.cronJobs.isEmpty();
  }
  
  public CronJobsNested<A> addNewCronJob() {
    return new CronJobsNested(-1, null);
  }
  
  public CronJobsNested<A> addNewCronJobLike(CronJob item) {
    return new CronJobsNested(-1, item);
  }
  
  public CronJobsNested<A> setNewCronJobLike(int index,CronJob item) {
    return new CronJobsNested(index, item);
  }
  
  public CronJobsNested<A> editCronJob(int index) {
    if (cronJobs.size() <= index) throw new RuntimeException("Can't edit cronJobs. Index exceeds size.");
    return setNewCronJobLike(index, buildCronJob(index));
  }
  
  public CronJobsNested<A> editFirstCronJob() {
    if (cronJobs.size() == 0) throw new RuntimeException("Can't edit first cronJobs. The list is empty.");
    return setNewCronJobLike(0, buildCronJob(0));
  }
  
  public CronJobsNested<A> editLastCronJob() {
    int index = cronJobs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last cronJobs. The list is empty.");
    return setNewCronJobLike(index, buildCronJob(index));
  }
  
  public CronJobsNested<A> editMatchingCronJob(Predicate<CronJobBuilder> predicate) {
    int index = -1;
    for (int i=0;i<cronJobs.size();i++) { 
    if (predicate.test(cronJobs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching cronJobs. No match found.");
    return setNewCronJobLike(index, buildCronJob(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BaseConfigFluent that = (BaseConfigFluent) o;
    if (!java.util.Objects.equals(deploymentKind, that.deploymentKind)) return false;
    if (!java.util.Objects.equals(labels, that.labels)) return false;
    if (!java.util.Objects.equals(annotations, that.annotations)) return false;
    if (!java.util.Objects.equals(envVars, that.envVars)) return false;
    if (!java.util.Objects.equals(workingDir, that.workingDir)) return false;
    if (!java.util.Objects.equals(command, that.command)) return false;
    if (!java.util.Objects.equals(arguments, that.arguments)) return false;
    if (!java.util.Objects.equals(serviceAccount, that.serviceAccount)) return false;
    if (!java.util.Objects.equals(ports, that.ports)) return false;
    if (!java.util.Objects.equals(serviceType, that.serviceType)) return false;
    if (!java.util.Objects.equals(pvcVolumes, that.pvcVolumes)) return false;
    if (!java.util.Objects.equals(secretVolumes, that.secretVolumes)) return false;
    if (!java.util.Objects.equals(configMapVolumes, that.configMapVolumes)) return false;
    if (!java.util.Objects.equals(emptyDirVolumes, that.emptyDirVolumes)) return false;
    if (!java.util.Objects.equals(gitRepoVolumes, that.gitRepoVolumes)) return false;
    if (!java.util.Objects.equals(awsElasticBlockStoreVolumes, that.awsElasticBlockStoreVolumes)) return false;
    if (!java.util.Objects.equals(azureDiskVolumes, that.azureDiskVolumes)) return false;
    if (!java.util.Objects.equals(azureFileVolumes, that.azureFileVolumes)) return false;
    if (!java.util.Objects.equals(mounts, that.mounts)) return false;
    if (!java.util.Objects.equals(imagePullPolicy, that.imagePullPolicy)) return false;
    if (!java.util.Objects.equals(imagePullSecrets, that.imagePullSecrets)) return false;
    if (!java.util.Objects.equals(deploymentStrategy, that.deploymentStrategy)) return false;
    if (!java.util.Objects.equals(rollingUpdate, that.rollingUpdate)) return false;
    if (!java.util.Objects.equals(hostAliases, that.hostAliases)) return false;
    if (!java.util.Objects.equals(livenessProbe, that.livenessProbe)) return false;
    if (!java.util.Objects.equals(readinessProbe, that.readinessProbe)) return false;
    if (!java.util.Objects.equals(startupProbe, that.startupProbe)) return false;
    if (!java.util.Objects.equals(requestResources, that.requestResources)) return false;
    if (!java.util.Objects.equals(limitResources, that.limitResources)) return false;
    if (!java.util.Objects.equals(sidecars, that.sidecars)) return false;
    if (!java.util.Objects.equals(autoDeployEnabled, that.autoDeployEnabled)) return false;
    if (!java.util.Objects.equals(jobs, that.jobs)) return false;
    if (!java.util.Objects.equals(cronJobs, that.cronJobs)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(deploymentKind,  labels,  annotations,  envVars,  workingDir,  command,  arguments,  serviceAccount,  ports,  serviceType,  pvcVolumes,  secretVolumes,  configMapVolumes,  emptyDirVolumes,  gitRepoVolumes,  awsElasticBlockStoreVolumes,  azureDiskVolumes,  azureFileVolumes,  mounts,  imagePullPolicy,  imagePullSecrets,  deploymentStrategy,  rollingUpdate,  hostAliases,  livenessProbe,  readinessProbe,  startupProbe,  requestResources,  limitResources,  sidecars,  autoDeployEnabled,  jobs,  cronJobs,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (deploymentKind != null) { sb.append("deploymentKind:"); sb.append(deploymentKind + ","); }
    if (labels != null && !labels.isEmpty()) { sb.append("labels:"); sb.append(labels + ","); }
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (envVars != null && !envVars.isEmpty()) { sb.append("envVars:"); sb.append(envVars + ","); }
    if (workingDir != null) { sb.append("workingDir:"); sb.append(workingDir + ","); }
    if (command != null && !command.isEmpty()) { sb.append("command:"); sb.append(command + ","); }
    if (arguments != null && !arguments.isEmpty()) { sb.append("arguments:"); sb.append(arguments + ","); }
    if (serviceAccount != null) { sb.append("serviceAccount:"); sb.append(serviceAccount + ","); }
    if (ports != null && !ports.isEmpty()) { sb.append("ports:"); sb.append(ports + ","); }
    if (serviceType != null) { sb.append("serviceType:"); sb.append(serviceType + ","); }
    if (pvcVolumes != null && !pvcVolumes.isEmpty()) { sb.append("pvcVolumes:"); sb.append(pvcVolumes + ","); }
    if (secretVolumes != null && !secretVolumes.isEmpty()) { sb.append("secretVolumes:"); sb.append(secretVolumes + ","); }
    if (configMapVolumes != null && !configMapVolumes.isEmpty()) { sb.append("configMapVolumes:"); sb.append(configMapVolumes + ","); }
    if (emptyDirVolumes != null && !emptyDirVolumes.isEmpty()) { sb.append("emptyDirVolumes:"); sb.append(emptyDirVolumes + ","); }
    if (gitRepoVolumes != null && !gitRepoVolumes.isEmpty()) { sb.append("gitRepoVolumes:"); sb.append(gitRepoVolumes + ","); }
    if (awsElasticBlockStoreVolumes != null && !awsElasticBlockStoreVolumes.isEmpty()) { sb.append("awsElasticBlockStoreVolumes:"); sb.append(awsElasticBlockStoreVolumes + ","); }
    if (azureDiskVolumes != null && !azureDiskVolumes.isEmpty()) { sb.append("azureDiskVolumes:"); sb.append(azureDiskVolumes + ","); }
    if (azureFileVolumes != null && !azureFileVolumes.isEmpty()) { sb.append("azureFileVolumes:"); sb.append(azureFileVolumes + ","); }
    if (mounts != null && !mounts.isEmpty()) { sb.append("mounts:"); sb.append(mounts + ","); }
    if (imagePullPolicy != null) { sb.append("imagePullPolicy:"); sb.append(imagePullPolicy + ","); }
    if (imagePullSecrets != null && !imagePullSecrets.isEmpty()) { sb.append("imagePullSecrets:"); sb.append(imagePullSecrets + ","); }
    if (deploymentStrategy != null) { sb.append("deploymentStrategy:"); sb.append(deploymentStrategy + ","); }
    if (rollingUpdate != null) { sb.append("rollingUpdate:"); sb.append(rollingUpdate + ","); }
    if (hostAliases != null && !hostAliases.isEmpty()) { sb.append("hostAliases:"); sb.append(hostAliases + ","); }
    if (livenessProbe != null) { sb.append("livenessProbe:"); sb.append(livenessProbe + ","); }
    if (readinessProbe != null) { sb.append("readinessProbe:"); sb.append(readinessProbe + ","); }
    if (startupProbe != null) { sb.append("startupProbe:"); sb.append(startupProbe + ","); }
    if (requestResources != null) { sb.append("requestResources:"); sb.append(requestResources + ","); }
    if (limitResources != null) { sb.append("limitResources:"); sb.append(limitResources + ","); }
    if (sidecars != null && !sidecars.isEmpty()) { sb.append("sidecars:"); sb.append(sidecars + ","); }
    if (autoDeployEnabled != null) { sb.append("autoDeployEnabled:"); sb.append(autoDeployEnabled + ","); }
    if (jobs != null && !jobs.isEmpty()) { sb.append("jobs:"); sb.append(jobs + ","); }
    if (cronJobs != null && !cronJobs.isEmpty()) { sb.append("cronJobs:"); sb.append(cronJobs); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withAutoDeployEnabled() {
    return withAutoDeployEnabled(true);
  }
  public class LabelsNested<N> extends LabelFluent<LabelsNested<N>> implements Nested<N>{
    LabelsNested(int index,Label item) {
      this.index = index;
      this.builder = new LabelBuilder(this, item);
    }
    LabelBuilder builder;
    int index;
    
    public N and() {
      return (N) BaseConfigFluent.this.setToLabels(index,builder.build());
    }
    
    public N endLabel() {
      return and();
    }
    
  
  }
  public class AnnotationsNested<N> extends AnnotationFluent<AnnotationsNested<N>> implements Nested<N>{
    AnnotationsNested(int index,Annotation item) {
      this.index = index;
      this.builder = new AnnotationBuilder(this, item);
    }
    AnnotationBuilder builder;
    int index;
    
    public N and() {
      return (N) BaseConfigFluent.this.setToAnnotations(index,builder.build());
    }
    
    public N endAnnotation() {
      return and();
    }
    
  
  }
  public class EnvVarsNested<N> extends EnvFluent<EnvVarsNested<N>> implements Nested<N>{
    EnvVarsNested(int index,Env item) {
      this.index = index;
      this.builder = new EnvBuilder(this, item);
    }
    EnvBuilder builder;
    int index;
    
    public N and() {
      return (N) BaseConfigFluent.this.setToEnvVars(index,builder.build());
    }
    
    public N endEnvVar() {
      return and();
    }
    
  
  }
  public class PortsNested<N> extends PortFluent<PortsNested<N>> implements Nested<N>{
    PortsNested(int index,Port item) {
      this.index = index;
      this.builder = new PortBuilder(this, item);
    }
    PortBuilder builder;
    int index;
    
    public N and() {
      return (N) BaseConfigFluent.this.setToPorts(index,builder.build());
    }
    
    public N endPort() {
      return and();
    }
    
  
  }
  public class PvcVolumesNested<N> extends PersistentVolumeClaimVolumeFluent<PvcVolumesNested<N>> implements Nested<N>{
    PvcVolumesNested(int index,PersistentVolumeClaimVolume item) {
      this.index = index;
      this.builder = new PersistentVolumeClaimVolumeBuilder(this, item);
    }
    PersistentVolumeClaimVolumeBuilder builder;
    int index;
    
    public N and() {
      return (N) BaseConfigFluent.this.setToPvcVolumes(index,builder.build());
    }
    
    public N endPvcVolume() {
      return and();
    }
    
  
  }
  public class SecretVolumesNested<N> extends SecretVolumeFluent<SecretVolumesNested<N>> implements Nested<N>{
    SecretVolumesNested(int index,SecretVolume item) {
      this.index = index;
      this.builder = new SecretVolumeBuilder(this, item);
    }
    SecretVolumeBuilder builder;
    int index;
    
    public N and() {
      return (N) BaseConfigFluent.this.setToSecretVolumes(index,builder.build());
    }
    
    public N endSecretVolume() {
      return and();
    }
    
  
  }
  public class ConfigMapVolumesNested<N> extends ConfigMapVolumeFluent<ConfigMapVolumesNested<N>> implements Nested<N>{
    ConfigMapVolumesNested(int index,ConfigMapVolume item) {
      this.index = index;
      this.builder = new ConfigMapVolumeBuilder(this, item);
    }
    ConfigMapVolumeBuilder builder;
    int index;
    
    public N and() {
      return (N) BaseConfigFluent.this.setToConfigMapVolumes(index,builder.build());
    }
    
    public N endConfigMapVolume() {
      return and();
    }
    
  
  }
  public class EmptyDirVolumesNested<N> extends EmptyDirVolumeFluent<EmptyDirVolumesNested<N>> implements Nested<N>{
    EmptyDirVolumesNested(int index,EmptyDirVolume item) {
      this.index = index;
      this.builder = new EmptyDirVolumeBuilder(this, item);
    }
    EmptyDirVolumeBuilder builder;
    int index;
    
    public N and() {
      return (N) BaseConfigFluent.this.setToEmptyDirVolumes(index,builder.build());
    }
    
    public N endEmptyDirVolume() {
      return and();
    }
    
  
  }
  public class GitRepoVolumesNested<N> extends GitRepoVolumeFluent<GitRepoVolumesNested<N>> implements Nested<N>{
    GitRepoVolumesNested(int index,GitRepoVolume item) {
      this.index = index;
      this.builder = new GitRepoVolumeBuilder(this, item);
    }
    GitRepoVolumeBuilder builder;
    int index;
    
    public N and() {
      return (N) BaseConfigFluent.this.setToGitRepoVolumes(index,builder.build());
    }
    
    public N endGitRepoVolume() {
      return and();
    }
    
  
  }
  public class AwsElasticBlockStoreVolumesNested<N> extends AwsElasticBlockStoreVolumeFluent<AwsElasticBlockStoreVolumesNested<N>> implements Nested<N>{
    AwsElasticBlockStoreVolumesNested(int index,AwsElasticBlockStoreVolume item) {
      this.index = index;
      this.builder = new AwsElasticBlockStoreVolumeBuilder(this, item);
    }
    AwsElasticBlockStoreVolumeBuilder builder;
    int index;
    
    public N and() {
      return (N) BaseConfigFluent.this.setToAwsElasticBlockStoreVolumes(index,builder.build());
    }
    
    public N endAwsElasticBlockStoreVolume() {
      return and();
    }
    
  
  }
  public class AzureDiskVolumesNested<N> extends AzureDiskVolumeFluent<AzureDiskVolumesNested<N>> implements Nested<N>{
    AzureDiskVolumesNested(int index,AzureDiskVolume item) {
      this.index = index;
      this.builder = new AzureDiskVolumeBuilder(this, item);
    }
    AzureDiskVolumeBuilder builder;
    int index;
    
    public N and() {
      return (N) BaseConfigFluent.this.setToAzureDiskVolumes(index,builder.build());
    }
    
    public N endAzureDiskVolume() {
      return and();
    }
    
  
  }
  public class AzureFileVolumesNested<N> extends AzureFileVolumeFluent<AzureFileVolumesNested<N>> implements Nested<N>{
    AzureFileVolumesNested(int index,AzureFileVolume item) {
      this.index = index;
      this.builder = new AzureFileVolumeBuilder(this, item);
    }
    AzureFileVolumeBuilder builder;
    int index;
    
    public N and() {
      return (N) BaseConfigFluent.this.setToAzureFileVolumes(index,builder.build());
    }
    
    public N endAzureFileVolume() {
      return and();
    }
    
  
  }
  public class MountsNested<N> extends MountFluent<MountsNested<N>> implements Nested<N>{
    MountsNested(int index,Mount item) {
      this.index = index;
      this.builder = new MountBuilder(this, item);
    }
    MountBuilder builder;
    int index;
    
    public N and() {
      return (N) BaseConfigFluent.this.setToMounts(index,builder.build());
    }
    
    public N endMount() {
      return and();
    }
    
  
  }
  public class RollingUpdateNested<N> extends RollingUpdateFluent<RollingUpdateNested<N>> implements Nested<N>{
    RollingUpdateNested(RollingUpdate item) {
      this.builder = new RollingUpdateBuilder(this, item);
    }
    RollingUpdateBuilder builder;
    
    public N and() {
      return (N) BaseConfigFluent.this.withRollingUpdate(builder.build());
    }
    
    public N endRollingUpdate() {
      return and();
    }
    
  
  }
  public class HostAliasesNested<N> extends HostAliasFluent<HostAliasesNested<N>> implements Nested<N>{
    HostAliasesNested(int index,HostAlias item) {
      this.index = index;
      this.builder = new HostAliasBuilder(this, item);
    }
    HostAliasBuilder builder;
    int index;
    
    public N and() {
      return (N) BaseConfigFluent.this.setToHostAliases(index,builder.build());
    }
    
    public N endHostAlias() {
      return and();
    }
    
  
  }
  public class LivenessProbeNested<N> extends ProbeFluent<LivenessProbeNested<N>> implements Nested<N>{
    LivenessProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    
    public N and() {
      return (N) BaseConfigFluent.this.withLivenessProbe(builder.build());
    }
    
    public N endLivenessProbe() {
      return and();
    }
    
  
  }
  public class ReadinessProbeNested<N> extends ProbeFluent<ReadinessProbeNested<N>> implements Nested<N>{
    ReadinessProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    
    public N and() {
      return (N) BaseConfigFluent.this.withReadinessProbe(builder.build());
    }
    
    public N endReadinessProbe() {
      return and();
    }
    
  
  }
  public class StartupProbeNested<N> extends ProbeFluent<StartupProbeNested<N>> implements Nested<N>{
    StartupProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    
    public N and() {
      return (N) BaseConfigFluent.this.withStartupProbe(builder.build());
    }
    
    public N endStartupProbe() {
      return and();
    }
    
  
  }
  public class RequestResourcesNested<N> extends ResourceRequirementsFluent<RequestResourcesNested<N>> implements Nested<N>{
    RequestResourcesNested(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsBuilder builder;
    
    public N and() {
      return (N) BaseConfigFluent.this.withRequestResources(builder.build());
    }
    
    public N endRequestResources() {
      return and();
    }
    
  
  }
  public class LimitResourcesNested<N> extends ResourceRequirementsFluent<LimitResourcesNested<N>> implements Nested<N>{
    LimitResourcesNested(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsBuilder builder;
    
    public N and() {
      return (N) BaseConfigFluent.this.withLimitResources(builder.build());
    }
    
    public N endLimitResources() {
      return and();
    }
    
  
  }
  public class SidecarsNested<N> extends ContainerFluent<SidecarsNested<N>> implements Nested<N>{
    SidecarsNested(int index,Container item) {
      this.index = index;
      this.builder = new ContainerBuilder(this, item);
    }
    ContainerBuilder builder;
    int index;
    
    public N and() {
      return (N) BaseConfigFluent.this.setToSidecars(index,builder.build());
    }
    
    public N endSidecar() {
      return and();
    }
    
  
  }
  public class JobsNested<N> extends JobFluent<JobsNested<N>> implements Nested<N>{
    JobsNested(int index,Job item) {
      this.index = index;
      this.builder = new JobBuilder(this, item);
    }
    JobBuilder builder;
    int index;
    
    public N and() {
      return (N) BaseConfigFluent.this.setToJobs(index,builder.build());
    }
    
    public N endJob() {
      return and();
    }
    
  
  }
  public class CronJobsNested<N> extends CronJobFluent<CronJobsNested<N>> implements Nested<N>{
    CronJobsNested(int index,CronJob item) {
      this.index = index;
      this.builder = new CronJobBuilder(this, item);
    }
    CronJobBuilder builder;
    int index;
    
    public N and() {
      return (N) BaseConfigFluent.this.setToCronJobs(index,builder.build());
    }
    
    public N endCronJob() {
      return and();
    }
    
  
  }

}