package io.dekorate.kubernetes.config;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class ConfigMapVolume{
  public ConfigMapVolume() {
  }
  
  public ConfigMapVolume(String volumeName,String configMapName,Integer defaultMode,Boolean optional,Item[] items) {
    this.volumeName = volumeName;
    this.configMapName = configMapName;
    this.defaultMode = defaultMode;
    this.optional = optional;
    this.items = items != null ? items : new Item[0];
  }
  private String volumeName;
  private String configMapName;
  private Integer defaultMode;
  private Boolean optional;
  private Item[] items = new Item[0];
  
  
  /**
   * The volumeName name.
   * @return The volumeName name.
   */
  public String getVolumeName() {
    return this.volumeName;
  }
  
  
  /**
   * The name of the config map to mount.
   * @return The name.
   */
  public String getConfigMapName() {
    return this.configMapName;
  }
  
  
  /**
   * Default mode.
   * @return The default mode.
   */
  public Integer getDefaultMode() {
    return this.defaultMode;
  }
  
  
  /**
   * Optional
   * @return True if optional, False otherwise.
   */
  public Boolean getOptional() {
    return this.optional;
  }
  
  
  /**
   * Optional
   * @return True if optional, False otherwise.
   */
  public boolean isOptional() {
    return this.optional != null &&  this.optional;
  }
  
  
  /**
   * Optional
   * @return list of files to be mounted.
   */
  public Item[] getItems() {
    return this.items;
  }
  
  public static ConfigMapVolumeBuilder newBuilder() {
    return new ConfigMapVolumeBuilder();
  }
  
  public static ConfigMapVolumeBuilder newBuilderFromDefaults() {
    return new ConfigMapVolumeBuilder().withDefaultMode(384).withOptional(false);
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConfigMapVolume that = (ConfigMapVolume) o;
    if (!java.util.Objects.equals(volumeName, that.volumeName)) return false;
    if (!java.util.Objects.equals(configMapName, that.configMapName)) return false;
    if (!java.util.Objects.equals(defaultMode, that.defaultMode)) return false;
    if (!java.util.Objects.equals(optional, that.optional)) return false;
    if (!java.util.Objects.equals(items, that.items)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(volumeName,  configMapName,  defaultMode,  optional,  items,  super.hashCode());
  }
  

}