package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import java.lang.Object;
import java.lang.String;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class Container{
  public Container() {
  }
  
  public Container(String image,String name,Env[] envVars,String workingDir,String[] command,String[] arguments,Port[] ports,Mount[] mounts,ImagePullPolicy imagePullPolicy,Probe livenessProbe,Probe readinessProbe,Probe startupProbe,ResourceRequirements requestResources,ResourceRequirements limitResources) {
    this.image = image;
    this.name = name;
    this.envVars = envVars != null ? envVars : new Env[0];
    this.workingDir = workingDir;
    this.command = command != null ? command : new String[0];
    this.arguments = arguments != null ? arguments : new String[0];
    this.ports = ports != null ? ports : new Port[0];
    this.mounts = mounts != null ? mounts : new Mount[0];
    this.imagePullPolicy = imagePullPolicy;
    this.livenessProbe = livenessProbe;
    this.readinessProbe = readinessProbe;
    this.startupProbe = startupProbe;
    this.requestResources = requestResources;
    this.limitResources = limitResources;
  }
  private String image;
  private String name;
  private Env[] envVars = new Env[0];
  private String workingDir;
  private String[] command = new String[0];
  private String[] arguments = new String[0];
  private Port[] ports = new Port[0];
  private Mount[] mounts = new Mount[0];
  private ImagePullPolicy imagePullPolicy;
  private Probe livenessProbe;
  private Probe readinessProbe;
  private Probe startupProbe;
  private ResourceRequirements requestResources;
  private ResourceRequirements limitResources;
  
  
  /**
   * The container image.
   * @return The container image.
   */
  public String getImage() {
    return this.image;
  }
  
  
  /**
   * The container name.
   * @return The container name, or the name part of the image, if no name has been specified.
   */
  public String getName() {
    return this.name;
  }
  
  
  /**
   * Environment variables to add to all containers.
   * @return The environment variables.
   */
  public Env[] getEnvVars() {
    return this.envVars;
  }
  
  
  /**
   * Working directory.
   * @return The working directory if specified, else empty string.
   */
  public String getWorkingDir() {
    return this.workingDir;
  }
  
  
  /**
   * The commands
   * @return The commands.
   */
  public String[] getCommand() {
    return this.command;
  }
  
  
  /**
   * The arguments
   * @return The arguments.
   */
  public String[] getArguments() {
    return this.arguments;
  }
  
  
  /**
   * The application ports.
   */
  public Port[] getPorts() {
    return this.ports;
  }
  
  
  /**
   * Mounts to add to all containers.
   * @return The mounts.
   */
  public Mount[] getMounts() {
    return this.mounts;
  }
  
  
  /**
   * Image pull policy.
   * @return The image pull policy.
   */
  public ImagePullPolicy getImagePullPolicy() {
    return this.imagePullPolicy;
  }
  
  
  /**
   * The liveness probe.
   * @return The probe.
   */
  public Probe getLivenessProbe() {
    return this.livenessProbe;
  }
  
  
  /**
   * The readiness probe.
   * @return The probe.
   */
  public Probe getReadinessProbe() {
    return this.readinessProbe;
  }
  
  
  /**
   * The startup probe.
   * @return The probe.
   */
  public Probe getStartupProbe() {
    return this.startupProbe;
  }
  
  
  /**
   * The resources that the application container requires.
   */
  public ResourceRequirements getRequestResources() {
    return this.requestResources;
  }
  
  
  /**
   * The resource limit for the application container.
   */
  public ResourceRequirements getLimitResources() {
    return this.limitResources;
  }
  
  public static ContainerBuilder newBuilder() {
    return new ContainerBuilder();
  }
  
  public static ContainerBuilder newBuilderFromDefaults() {
    return new ContainerBuilder().withImagePullPolicy(io.dekorate.kubernetes.annotation.ImagePullPolicy.IfNotPresent).withLivenessProbe(new Probe()).withReadinessProbe(new Probe()).withStartupProbe(new Probe()).withRequestResources(new ResourceRequirements()).withLimitResources(new ResourceRequirements());
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    Container that = (Container) o;
    if (!java.util.Objects.equals(image, that.image)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(envVars, that.envVars)) return false;
    if (!java.util.Objects.equals(workingDir, that.workingDir)) return false;
    if (!java.util.Objects.equals(command, that.command)) return false;
    if (!java.util.Objects.equals(arguments, that.arguments)) return false;
    if (!java.util.Objects.equals(ports, that.ports)) return false;
    if (!java.util.Objects.equals(mounts, that.mounts)) return false;
    if (!java.util.Objects.equals(imagePullPolicy, that.imagePullPolicy)) return false;
    if (!java.util.Objects.equals(livenessProbe, that.livenessProbe)) return false;
    if (!java.util.Objects.equals(readinessProbe, that.readinessProbe)) return false;
    if (!java.util.Objects.equals(startupProbe, that.startupProbe)) return false;
    if (!java.util.Objects.equals(requestResources, that.requestResources)) return false;
    if (!java.util.Objects.equals(limitResources, that.limitResources)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(image,  name,  envVars,  workingDir,  command,  arguments,  ports,  mounts,  imagePullPolicy,  livenessProbe,  readinessProbe,  startupProbe,  requestResources,  limitResources,  super.hashCode());
  }
  

}