package io.dekorate.kubernetes.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import java.util.Collection;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ContainerFluent<A extends ContainerFluent<A>> extends BaseFluent<A>{
  public ContainerFluent() {
  }
  
  public ContainerFluent(Container instance) {
    this.copyInstance(instance);
  }
  private String image;
  private String name;
  private ArrayList<EnvBuilder> envVars = new ArrayList<EnvBuilder>();
  private String workingDir;
  private List<String> command = new ArrayList<String>();
  private List<String> arguments = new ArrayList<String>();
  private ArrayList<PortBuilder> ports = new ArrayList<PortBuilder>();
  private ArrayList<MountBuilder> mounts = new ArrayList<MountBuilder>();
  private ImagePullPolicy imagePullPolicy;
  private ProbeBuilder livenessProbe;
  private ProbeBuilder readinessProbe;
  private ProbeBuilder startupProbe;
  private ResourceRequirementsBuilder requestResources;
  private ResourceRequirementsBuilder limitResources;
  
  protected void copyInstance(Container instance) {
    instance = (instance != null ? instance : new Container());
    if (instance != null) {
          this.withImage(instance.getImage());
          this.withName(instance.getName());
          this.withEnvVars(instance.getEnvVars());
          this.withWorkingDir(instance.getWorkingDir());
          this.withCommand(instance.getCommand());
          this.withArguments(instance.getArguments());
          this.withPorts(instance.getPorts());
          this.withMounts(instance.getMounts());
          this.withImagePullPolicy(instance.getImagePullPolicy());
          this.withLivenessProbe(instance.getLivenessProbe());
          this.withReadinessProbe(instance.getReadinessProbe());
          this.withStartupProbe(instance.getStartupProbe());
          this.withRequestResources(instance.getRequestResources());
          this.withLimitResources(instance.getLimitResources());
        }
  }
  
  public String getImage() {
    return this.image;
  }
  
  public A withImage(String image) {
    this.image = image;
    return (A) this;
  }
  
  public boolean hasImage() {
    return this.image != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public A withEnvVars(io.dekorate.kubernetes.config.Env... envVars) {
    if (this.envVars != null) {
        this.envVars.clear();
        _visitables.remove("envVars");
    }
    if (envVars != null) {
      for (Env item : envVars) {
        this.addToEnvVars(item);
      }
    }
    return (A) this;
  }
  
  public Env[] buildEnvVars() {
    int size = envVars != null ? envVars.size() : 0;;
    Env[] result = new Env[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<Env,EnvBuilder> item : envVars) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public Env buildEnvVar(int index) {
    return this.envVars.get(index).build();
  }
  
  public Env buildFirstEnvVar() {
    return this.envVars.get(0).build();
  }
  
  public Env buildLastEnvVar() {
    return this.envVars.get(envVars.size() - 1).build();
  }
  
  public Env buildMatchingEnvVar(Predicate<EnvBuilder> predicate) {
      for (EnvBuilder item : envVars) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingEnvVar(Predicate<EnvBuilder> predicate) {
      for (EnvBuilder item : envVars) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToEnvVars(int index,Env item) {
    if (this.envVars == null) {this.envVars = new ArrayList<EnvBuilder>();}
    EnvBuilder builder = new EnvBuilder(item);
    if (index < 0 || index >= envVars.size()) { _visitables.get("envVars").add(builder); envVars.add(builder); } else { _visitables.get("envVars").add(index, builder); envVars.add(index, builder);}
    return (A)this;
  }
  
  public A setToEnvVars(int index,Env item) {
    if (this.envVars == null) {this.envVars = new ArrayList<EnvBuilder>();}
    EnvBuilder builder = new EnvBuilder(item);
    if (index < 0 || index >= envVars.size()) { _visitables.get("envVars").add(builder); envVars.add(builder); } else { _visitables.get("envVars").set(index, builder); envVars.set(index, builder);}
    return (A)this;
  }
  
  public A addToEnvVars(io.dekorate.kubernetes.config.Env... items) {
    if (this.envVars == null) {this.envVars = new ArrayList<EnvBuilder>();}
    for (Env item : items) {EnvBuilder builder = new EnvBuilder(item);_visitables.get("envVars").add(builder);this.envVars.add(builder);} return (A)this;
  }
  
  public A addAllToEnvVars(Collection<Env> items) {
    if (this.envVars == null) {this.envVars = new ArrayList<EnvBuilder>();}
    for (Env item : items) {EnvBuilder builder = new EnvBuilder(item);_visitables.get("envVars").add(builder);this.envVars.add(builder);} return (A)this;
  }
  
  public A removeFromEnvVars(io.dekorate.kubernetes.config.Env... items) {
    if (this.envVars == null) return (A)this;
    for (Env item : items) {EnvBuilder builder = new EnvBuilder(item);_visitables.get("envVars").remove(builder); this.envVars.remove(builder);} return (A)this;
  }
  
  public A removeAllFromEnvVars(Collection<Env> items) {
    if (this.envVars == null) return (A)this;
    for (Env item : items) {EnvBuilder builder = new EnvBuilder(item);_visitables.get("envVars").remove(builder); this.envVars.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromEnvVars(Predicate<EnvBuilder> predicate) {
    if (envVars == null) return (A) this;
    final Iterator<EnvBuilder> each = envVars.iterator();
    final List visitables = _visitables.get("envVars");
    while (each.hasNext()) {
      EnvBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasEnvVars() {
    return this.envVars != null && !this.envVars.isEmpty();
  }
  
  public EnvVarsNested<A> addNewEnvVar() {
    return new EnvVarsNested(-1, null);
  }
  
  public EnvVarsNested<A> addNewEnvVarLike(Env item) {
    return new EnvVarsNested(-1, item);
  }
  
  public EnvVarsNested<A> setNewEnvVarLike(int index,Env item) {
    return new EnvVarsNested(index, item);
  }
  
  public EnvVarsNested<A> editEnvVar(int index) {
    if (envVars.size() <= index) throw new RuntimeException("Can't edit envVars. Index exceeds size.");
    return setNewEnvVarLike(index, buildEnvVar(index));
  }
  
  public EnvVarsNested<A> editFirstEnvVar() {
    if (envVars.size() == 0) throw new RuntimeException("Can't edit first envVars. The list is empty.");
    return setNewEnvVarLike(0, buildEnvVar(0));
  }
  
  public EnvVarsNested<A> editLastEnvVar() {
    int index = envVars.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last envVars. The list is empty.");
    return setNewEnvVarLike(index, buildEnvVar(index));
  }
  
  public EnvVarsNested<A> editMatchingEnvVar(Predicate<EnvBuilder> predicate) {
    int index = -1;
    for (int i=0;i<envVars.size();i++) { 
    if (predicate.test(envVars.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching envVars. No match found.");
    return setNewEnvVarLike(index, buildEnvVar(index));
  }
  
  public String getWorkingDir() {
    return this.workingDir;
  }
  
  public A withWorkingDir(String workingDir) {
    this.workingDir = workingDir;
    return (A) this;
  }
  
  public boolean hasWorkingDir() {
    return this.workingDir != null;
  }
  
  public A withCommand(java.lang.String... command) {
    if (this.command != null) {
        this.command.clear();
        _visitables.remove("command");
    }
    if (command != null) {
      for (String item : command) {
        this.addToCommand(item);
      }
    }
    return (A) this;
  }
  
  public String[] getCommand() {
    int size = command != null ? command.size() : 0;;
    String[] result = new String[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (String item : command) {
      result[index++] = item;
    }
    return result;
  }
  
  public A addToCommand(int index,String item) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    this.command.add(index, item);
    return (A)this;
  }
  
  public A setToCommand(int index,String item) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    this.command.set(index, item); return (A)this;
  }
  
  public A addToCommand(java.lang.String... items) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    for (String item : items) {this.command.add(item);} return (A)this;
  }
  
  public A addAllToCommand(Collection<String> items) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    for (String item : items) {this.command.add(item);} return (A)this;
  }
  
  public A removeFromCommand(java.lang.String... items) {
    if (this.command == null) return (A)this;
    for (String item : items) { this.command.remove(item);} return (A)this;
  }
  
  public A removeAllFromCommand(Collection<String> items) {
    if (this.command == null) return (A)this;
    for (String item : items) { this.command.remove(item);} return (A)this;
  }
  
  public boolean hasCommand() {
    return this.command != null && !this.command.isEmpty();
  }
  
  public A withArguments(java.lang.String... arguments) {
    if (this.arguments != null) {
        this.arguments.clear();
        _visitables.remove("arguments");
    }
    if (arguments != null) {
      for (String item : arguments) {
        this.addToArguments(item);
      }
    }
    return (A) this;
  }
  
  public String[] getArguments() {
    int size = arguments != null ? arguments.size() : 0;;
    String[] result = new String[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (String item : arguments) {
      result[index++] = item;
    }
    return result;
  }
  
  public A addToArguments(int index,String item) {
    if (this.arguments == null) {this.arguments = new ArrayList<String>();}
    this.arguments.add(index, item);
    return (A)this;
  }
  
  public A setToArguments(int index,String item) {
    if (this.arguments == null) {this.arguments = new ArrayList<String>();}
    this.arguments.set(index, item); return (A)this;
  }
  
  public A addToArguments(java.lang.String... items) {
    if (this.arguments == null) {this.arguments = new ArrayList<String>();}
    for (String item : items) {this.arguments.add(item);} return (A)this;
  }
  
  public A addAllToArguments(Collection<String> items) {
    if (this.arguments == null) {this.arguments = new ArrayList<String>();}
    for (String item : items) {this.arguments.add(item);} return (A)this;
  }
  
  public A removeFromArguments(java.lang.String... items) {
    if (this.arguments == null) return (A)this;
    for (String item : items) { this.arguments.remove(item);} return (A)this;
  }
  
  public A removeAllFromArguments(Collection<String> items) {
    if (this.arguments == null) return (A)this;
    for (String item : items) { this.arguments.remove(item);} return (A)this;
  }
  
  public boolean hasArguments() {
    return this.arguments != null && !this.arguments.isEmpty();
  }
  
  public A withPorts(io.dekorate.kubernetes.config.Port... ports) {
    if (this.ports != null) {
        this.ports.clear();
        _visitables.remove("ports");
    }
    if (ports != null) {
      for (Port item : ports) {
        this.addToPorts(item);
      }
    }
    return (A) this;
  }
  
  public Port[] buildPorts() {
    int size = ports != null ? ports.size() : 0;;
    Port[] result = new Port[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<Port,PortBuilder> item : ports) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public Port buildPort(int index) {
    return this.ports.get(index).build();
  }
  
  public Port buildFirstPort() {
    return this.ports.get(0).build();
  }
  
  public Port buildLastPort() {
    return this.ports.get(ports.size() - 1).build();
  }
  
  public Port buildMatchingPort(Predicate<PortBuilder> predicate) {
      for (PortBuilder item : ports) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingPort(Predicate<PortBuilder> predicate) {
      for (PortBuilder item : ports) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToPorts(int index,Port item) {
    if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
    PortBuilder builder = new PortBuilder(item);
    if (index < 0 || index >= ports.size()) { _visitables.get("ports").add(builder); ports.add(builder); } else { _visitables.get("ports").add(index, builder); ports.add(index, builder);}
    return (A)this;
  }
  
  public A setToPorts(int index,Port item) {
    if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
    PortBuilder builder = new PortBuilder(item);
    if (index < 0 || index >= ports.size()) { _visitables.get("ports").add(builder); ports.add(builder); } else { _visitables.get("ports").set(index, builder); ports.set(index, builder);}
    return (A)this;
  }
  
  public A addToPorts(io.dekorate.kubernetes.config.Port... items) {
    if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
    for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  
  public A addAllToPorts(Collection<Port> items) {
    if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
    for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  
  public A removeFromPorts(io.dekorate.kubernetes.config.Port... items) {
    if (this.ports == null) return (A)this;
    for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.get("ports").remove(builder); this.ports.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPorts(Collection<Port> items) {
    if (this.ports == null) return (A)this;
    for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.get("ports").remove(builder); this.ports.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPorts(Predicate<PortBuilder> predicate) {
    if (ports == null) return (A) this;
    final Iterator<PortBuilder> each = ports.iterator();
    final List visitables = _visitables.get("ports");
    while (each.hasNext()) {
      PortBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasPorts() {
    return this.ports != null && !this.ports.isEmpty();
  }
  
  public PortsNested<A> addNewPort() {
    return new PortsNested(-1, null);
  }
  
  public PortsNested<A> addNewPortLike(Port item) {
    return new PortsNested(-1, item);
  }
  
  public PortsNested<A> setNewPortLike(int index,Port item) {
    return new PortsNested(index, item);
  }
  
  public PortsNested<A> editPort(int index) {
    if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
    return setNewPortLike(index, buildPort(index));
  }
  
  public PortsNested<A> editFirstPort() {
    if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
    return setNewPortLike(0, buildPort(0));
  }
  
  public PortsNested<A> editLastPort() {
    int index = ports.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
    return setNewPortLike(index, buildPort(index));
  }
  
  public PortsNested<A> editMatchingPort(Predicate<PortBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ports.size();i++) { 
    if (predicate.test(ports.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
    return setNewPortLike(index, buildPort(index));
  }
  
  public A withMounts(io.dekorate.kubernetes.config.Mount... mounts) {
    if (this.mounts != null) {
        this.mounts.clear();
        _visitables.remove("mounts");
    }
    if (mounts != null) {
      for (Mount item : mounts) {
        this.addToMounts(item);
      }
    }
    return (A) this;
  }
  
  public Mount[] buildMounts() {
    int size = mounts != null ? mounts.size() : 0;;
    Mount[] result = new Mount[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<Mount,MountBuilder> item : mounts) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public Mount buildMount(int index) {
    return this.mounts.get(index).build();
  }
  
  public Mount buildFirstMount() {
    return this.mounts.get(0).build();
  }
  
  public Mount buildLastMount() {
    return this.mounts.get(mounts.size() - 1).build();
  }
  
  public Mount buildMatchingMount(Predicate<MountBuilder> predicate) {
      for (MountBuilder item : mounts) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingMount(Predicate<MountBuilder> predicate) {
      for (MountBuilder item : mounts) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToMounts(int index,Mount item) {
    if (this.mounts == null) {this.mounts = new ArrayList<MountBuilder>();}
    MountBuilder builder = new MountBuilder(item);
    if (index < 0 || index >= mounts.size()) { _visitables.get("mounts").add(builder); mounts.add(builder); } else { _visitables.get("mounts").add(index, builder); mounts.add(index, builder);}
    return (A)this;
  }
  
  public A setToMounts(int index,Mount item) {
    if (this.mounts == null) {this.mounts = new ArrayList<MountBuilder>();}
    MountBuilder builder = new MountBuilder(item);
    if (index < 0 || index >= mounts.size()) { _visitables.get("mounts").add(builder); mounts.add(builder); } else { _visitables.get("mounts").set(index, builder); mounts.set(index, builder);}
    return (A)this;
  }
  
  public A addToMounts(io.dekorate.kubernetes.config.Mount... items) {
    if (this.mounts == null) {this.mounts = new ArrayList<MountBuilder>();}
    for (Mount item : items) {MountBuilder builder = new MountBuilder(item);_visitables.get("mounts").add(builder);this.mounts.add(builder);} return (A)this;
  }
  
  public A addAllToMounts(Collection<Mount> items) {
    if (this.mounts == null) {this.mounts = new ArrayList<MountBuilder>();}
    for (Mount item : items) {MountBuilder builder = new MountBuilder(item);_visitables.get("mounts").add(builder);this.mounts.add(builder);} return (A)this;
  }
  
  public A removeFromMounts(io.dekorate.kubernetes.config.Mount... items) {
    if (this.mounts == null) return (A)this;
    for (Mount item : items) {MountBuilder builder = new MountBuilder(item);_visitables.get("mounts").remove(builder); this.mounts.remove(builder);} return (A)this;
  }
  
  public A removeAllFromMounts(Collection<Mount> items) {
    if (this.mounts == null) return (A)this;
    for (Mount item : items) {MountBuilder builder = new MountBuilder(item);_visitables.get("mounts").remove(builder); this.mounts.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromMounts(Predicate<MountBuilder> predicate) {
    if (mounts == null) return (A) this;
    final Iterator<MountBuilder> each = mounts.iterator();
    final List visitables = _visitables.get("mounts");
    while (each.hasNext()) {
      MountBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasMounts() {
    return this.mounts != null && !this.mounts.isEmpty();
  }
  
  public A addNewMount(String name,String path,String subPath,Boolean readOnly) {
    return (A)addToMounts(new Mount(name, path, subPath, readOnly));
  }
  
  public MountsNested<A> addNewMount() {
    return new MountsNested(-1, null);
  }
  
  public MountsNested<A> addNewMountLike(Mount item) {
    return new MountsNested(-1, item);
  }
  
  public MountsNested<A> setNewMountLike(int index,Mount item) {
    return new MountsNested(index, item);
  }
  
  public MountsNested<A> editMount(int index) {
    if (mounts.size() <= index) throw new RuntimeException("Can't edit mounts. Index exceeds size.");
    return setNewMountLike(index, buildMount(index));
  }
  
  public MountsNested<A> editFirstMount() {
    if (mounts.size() == 0) throw new RuntimeException("Can't edit first mounts. The list is empty.");
    return setNewMountLike(0, buildMount(0));
  }
  
  public MountsNested<A> editLastMount() {
    int index = mounts.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last mounts. The list is empty.");
    return setNewMountLike(index, buildMount(index));
  }
  
  public MountsNested<A> editMatchingMount(Predicate<MountBuilder> predicate) {
    int index = -1;
    for (int i=0;i<mounts.size();i++) { 
    if (predicate.test(mounts.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching mounts. No match found.");
    return setNewMountLike(index, buildMount(index));
  }
  
  public ImagePullPolicy getImagePullPolicy() {
    return this.imagePullPolicy;
  }
  
  public A withImagePullPolicy(ImagePullPolicy imagePullPolicy) {
    this.imagePullPolicy = imagePullPolicy;
    return (A) this;
  }
  
  public boolean hasImagePullPolicy() {
    return this.imagePullPolicy != null;
  }
  
  public Probe buildLivenessProbe() {
    return this.livenessProbe != null ? this.livenessProbe.build() : null;
  }
  
  public A withLivenessProbe(Probe livenessProbe) {
    this._visitables.remove("livenessProbe");
    if (livenessProbe != null) {
        this.livenessProbe = new ProbeBuilder(livenessProbe);
        this._visitables.get("livenessProbe").add(this.livenessProbe);
    } else {
        this.livenessProbe = null;
        this._visitables.get("livenessProbe").remove(this.livenessProbe);
    }
    return (A) this;
  }
  
  public boolean hasLivenessProbe() {
    return this.livenessProbe != null;
  }
  
  public LivenessProbeNested<A> withNewLivenessProbe() {
    return new LivenessProbeNested(null);
  }
  
  public LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
    return new LivenessProbeNested(item);
  }
  
  public LivenessProbeNested<A> editLivenessProbe() {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(null));
  }
  
  public LivenessProbeNested<A> editOrNewLivenessProbe() {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(new ProbeBuilder().build()));
  }
  
  public LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
    return withNewLivenessProbeLike(java.util.Optional.ofNullable(buildLivenessProbe()).orElse(item));
  }
  
  public Probe buildReadinessProbe() {
    return this.readinessProbe != null ? this.readinessProbe.build() : null;
  }
  
  public A withReadinessProbe(Probe readinessProbe) {
    this._visitables.remove("readinessProbe");
    if (readinessProbe != null) {
        this.readinessProbe = new ProbeBuilder(readinessProbe);
        this._visitables.get("readinessProbe").add(this.readinessProbe);
    } else {
        this.readinessProbe = null;
        this._visitables.get("readinessProbe").remove(this.readinessProbe);
    }
    return (A) this;
  }
  
  public boolean hasReadinessProbe() {
    return this.readinessProbe != null;
  }
  
  public ReadinessProbeNested<A> withNewReadinessProbe() {
    return new ReadinessProbeNested(null);
  }
  
  public ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
    return new ReadinessProbeNested(item);
  }
  
  public ReadinessProbeNested<A> editReadinessProbe() {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(null));
  }
  
  public ReadinessProbeNested<A> editOrNewReadinessProbe() {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(new ProbeBuilder().build()));
  }
  
  public ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
    return withNewReadinessProbeLike(java.util.Optional.ofNullable(buildReadinessProbe()).orElse(item));
  }
  
  public Probe buildStartupProbe() {
    return this.startupProbe != null ? this.startupProbe.build() : null;
  }
  
  public A withStartupProbe(Probe startupProbe) {
    this._visitables.remove("startupProbe");
    if (startupProbe != null) {
        this.startupProbe = new ProbeBuilder(startupProbe);
        this._visitables.get("startupProbe").add(this.startupProbe);
    } else {
        this.startupProbe = null;
        this._visitables.get("startupProbe").remove(this.startupProbe);
    }
    return (A) this;
  }
  
  public boolean hasStartupProbe() {
    return this.startupProbe != null;
  }
  
  public StartupProbeNested<A> withNewStartupProbe() {
    return new StartupProbeNested(null);
  }
  
  public StartupProbeNested<A> withNewStartupProbeLike(Probe item) {
    return new StartupProbeNested(item);
  }
  
  public StartupProbeNested<A> editStartupProbe() {
    return withNewStartupProbeLike(java.util.Optional.ofNullable(buildStartupProbe()).orElse(null));
  }
  
  public StartupProbeNested<A> editOrNewStartupProbe() {
    return withNewStartupProbeLike(java.util.Optional.ofNullable(buildStartupProbe()).orElse(new ProbeBuilder().build()));
  }
  
  public StartupProbeNested<A> editOrNewStartupProbeLike(Probe item) {
    return withNewStartupProbeLike(java.util.Optional.ofNullable(buildStartupProbe()).orElse(item));
  }
  
  public ResourceRequirements buildRequestResources() {
    return this.requestResources != null ? this.requestResources.build() : null;
  }
  
  public A withRequestResources(ResourceRequirements requestResources) {
    this._visitables.remove("requestResources");
    if (requestResources != null) {
        this.requestResources = new ResourceRequirementsBuilder(requestResources);
        this._visitables.get("requestResources").add(this.requestResources);
    } else {
        this.requestResources = null;
        this._visitables.get("requestResources").remove(this.requestResources);
    }
    return (A) this;
  }
  
  public boolean hasRequestResources() {
    return this.requestResources != null;
  }
  
  public A withNewRequestResources(String memory,String cpu) {
    return (A)withRequestResources(new ResourceRequirements(memory, cpu));
  }
  
  public RequestResourcesNested<A> withNewRequestResources() {
    return new RequestResourcesNested(null);
  }
  
  public RequestResourcesNested<A> withNewRequestResourcesLike(ResourceRequirements item) {
    return new RequestResourcesNested(item);
  }
  
  public RequestResourcesNested<A> editRequestResources() {
    return withNewRequestResourcesLike(java.util.Optional.ofNullable(buildRequestResources()).orElse(null));
  }
  
  public RequestResourcesNested<A> editOrNewRequestResources() {
    return withNewRequestResourcesLike(java.util.Optional.ofNullable(buildRequestResources()).orElse(new ResourceRequirementsBuilder().build()));
  }
  
  public RequestResourcesNested<A> editOrNewRequestResourcesLike(ResourceRequirements item) {
    return withNewRequestResourcesLike(java.util.Optional.ofNullable(buildRequestResources()).orElse(item));
  }
  
  public ResourceRequirements buildLimitResources() {
    return this.limitResources != null ? this.limitResources.build() : null;
  }
  
  public A withLimitResources(ResourceRequirements limitResources) {
    this._visitables.remove("limitResources");
    if (limitResources != null) {
        this.limitResources = new ResourceRequirementsBuilder(limitResources);
        this._visitables.get("limitResources").add(this.limitResources);
    } else {
        this.limitResources = null;
        this._visitables.get("limitResources").remove(this.limitResources);
    }
    return (A) this;
  }
  
  public boolean hasLimitResources() {
    return this.limitResources != null;
  }
  
  public A withNewLimitResources(String memory,String cpu) {
    return (A)withLimitResources(new ResourceRequirements(memory, cpu));
  }
  
  public LimitResourcesNested<A> withNewLimitResources() {
    return new LimitResourcesNested(null);
  }
  
  public LimitResourcesNested<A> withNewLimitResourcesLike(ResourceRequirements item) {
    return new LimitResourcesNested(item);
  }
  
  public LimitResourcesNested<A> editLimitResources() {
    return withNewLimitResourcesLike(java.util.Optional.ofNullable(buildLimitResources()).orElse(null));
  }
  
  public LimitResourcesNested<A> editOrNewLimitResources() {
    return withNewLimitResourcesLike(java.util.Optional.ofNullable(buildLimitResources()).orElse(new ResourceRequirementsBuilder().build()));
  }
  
  public LimitResourcesNested<A> editOrNewLimitResourcesLike(ResourceRequirements item) {
    return withNewLimitResourcesLike(java.util.Optional.ofNullable(buildLimitResources()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ContainerFluent that = (ContainerFluent) o;
    if (!java.util.Objects.equals(image, that.image)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(envVars, that.envVars)) return false;
    if (!java.util.Objects.equals(workingDir, that.workingDir)) return false;
    if (!java.util.Objects.equals(command, that.command)) return false;
    if (!java.util.Objects.equals(arguments, that.arguments)) return false;
    if (!java.util.Objects.equals(ports, that.ports)) return false;
    if (!java.util.Objects.equals(mounts, that.mounts)) return false;
    if (!java.util.Objects.equals(imagePullPolicy, that.imagePullPolicy)) return false;
    if (!java.util.Objects.equals(livenessProbe, that.livenessProbe)) return false;
    if (!java.util.Objects.equals(readinessProbe, that.readinessProbe)) return false;
    if (!java.util.Objects.equals(startupProbe, that.startupProbe)) return false;
    if (!java.util.Objects.equals(requestResources, that.requestResources)) return false;
    if (!java.util.Objects.equals(limitResources, that.limitResources)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(image,  name,  envVars,  workingDir,  command,  arguments,  ports,  mounts,  imagePullPolicy,  livenessProbe,  readinessProbe,  startupProbe,  requestResources,  limitResources,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (envVars != null && !envVars.isEmpty()) { sb.append("envVars:"); sb.append(envVars + ","); }
    if (workingDir != null) { sb.append("workingDir:"); sb.append(workingDir + ","); }
    if (command != null && !command.isEmpty()) { sb.append("command:"); sb.append(command + ","); }
    if (arguments != null && !arguments.isEmpty()) { sb.append("arguments:"); sb.append(arguments + ","); }
    if (ports != null && !ports.isEmpty()) { sb.append("ports:"); sb.append(ports + ","); }
    if (mounts != null && !mounts.isEmpty()) { sb.append("mounts:"); sb.append(mounts + ","); }
    if (imagePullPolicy != null) { sb.append("imagePullPolicy:"); sb.append(imagePullPolicy + ","); }
    if (livenessProbe != null) { sb.append("livenessProbe:"); sb.append(livenessProbe + ","); }
    if (readinessProbe != null) { sb.append("readinessProbe:"); sb.append(readinessProbe + ","); }
    if (startupProbe != null) { sb.append("startupProbe:"); sb.append(startupProbe + ","); }
    if (requestResources != null) { sb.append("requestResources:"); sb.append(requestResources + ","); }
    if (limitResources != null) { sb.append("limitResources:"); sb.append(limitResources); }
    sb.append("}");
    return sb.toString();
  }
  public class EnvVarsNested<N> extends EnvFluent<EnvVarsNested<N>> implements Nested<N>{
    EnvVarsNested(int index,Env item) {
      this.index = index;
      this.builder = new EnvBuilder(this, item);
    }
    EnvBuilder builder;
    int index;
    
    public N and() {
      return (N) ContainerFluent.this.setToEnvVars(index,builder.build());
    }
    
    public N endEnvVar() {
      return and();
    }
    
  
  }
  public class PortsNested<N> extends PortFluent<PortsNested<N>> implements Nested<N>{
    PortsNested(int index,Port item) {
      this.index = index;
      this.builder = new PortBuilder(this, item);
    }
    PortBuilder builder;
    int index;
    
    public N and() {
      return (N) ContainerFluent.this.setToPorts(index,builder.build());
    }
    
    public N endPort() {
      return and();
    }
    
  
  }
  public class MountsNested<N> extends MountFluent<MountsNested<N>> implements Nested<N>{
    MountsNested(int index,Mount item) {
      this.index = index;
      this.builder = new MountBuilder(this, item);
    }
    MountBuilder builder;
    int index;
    
    public N and() {
      return (N) ContainerFluent.this.setToMounts(index,builder.build());
    }
    
    public N endMount() {
      return and();
    }
    
  
  }
  public class LivenessProbeNested<N> extends ProbeFluent<LivenessProbeNested<N>> implements Nested<N>{
    LivenessProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    
    public N and() {
      return (N) ContainerFluent.this.withLivenessProbe(builder.build());
    }
    
    public N endLivenessProbe() {
      return and();
    }
    
  
  }
  public class ReadinessProbeNested<N> extends ProbeFluent<ReadinessProbeNested<N>> implements Nested<N>{
    ReadinessProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    
    public N and() {
      return (N) ContainerFluent.this.withReadinessProbe(builder.build());
    }
    
    public N endReadinessProbe() {
      return and();
    }
    
  
  }
  public class StartupProbeNested<N> extends ProbeFluent<StartupProbeNested<N>> implements Nested<N>{
    StartupProbeNested(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ProbeBuilder builder;
    
    public N and() {
      return (N) ContainerFluent.this.withStartupProbe(builder.build());
    }
    
    public N endStartupProbe() {
      return and();
    }
    
  
  }
  public class RequestResourcesNested<N> extends ResourceRequirementsFluent<RequestResourcesNested<N>> implements Nested<N>{
    RequestResourcesNested(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsBuilder builder;
    
    public N and() {
      return (N) ContainerFluent.this.withRequestResources(builder.build());
    }
    
    public N endRequestResources() {
      return and();
    }
    
  
  }
  public class LimitResourcesNested<N> extends ResourceRequirementsFluent<LimitResourcesNested<N>> implements Nested<N>{
    LimitResourcesNested(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsBuilder builder;
    
    public N and() {
      return (N) ContainerFluent.this.withLimitResources(builder.build());
    }
    
    public N endLimitResources() {
      return and();
    }
    
  
  }

}