package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.annotation.JobCompletionMode;
import java.lang.String;
import java.lang.Integer;
import io.dekorate.kubernetes.annotation.CronJobConcurrencyPolicy;
import java.lang.Long;
import java.lang.Object;
import io.dekorate.kubernetes.annotation.JobRestartPolicy;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class CronJob{
  public CronJob() {
  }
  
  public CronJob(String name,String schedule,CronJobConcurrencyPolicy concurrencyPolicy,Long startingDeadlineSeconds,Integer failedJobsHistoryLimit,Integer successfulJobsHistoryLimit,Integer parallelism,Integer completions,JobCompletionMode completionMode,Integer backoffLimit,Long activeDeadlineSeconds,Integer ttlSecondsAfterFinished,Boolean suspend,JobRestartPolicy restartPolicy,PersistentVolumeClaimVolume[] pvcVolumes,SecretVolume[] secretVolumes,ConfigMapVolume[] configMapVolumes,EmptyDirVolume[] emptyDirVolumes,AwsElasticBlockStoreVolume[] awsElasticBlockStoreVolumes,AzureDiskVolume[] azureDiskVolumes,AzureFileVolume[] azureFileVolumes,Container[] containers) {
    this.name = name;
    this.schedule = schedule;
    this.concurrencyPolicy = concurrencyPolicy;
    this.startingDeadlineSeconds = startingDeadlineSeconds;
    this.failedJobsHistoryLimit = failedJobsHistoryLimit;
    this.successfulJobsHistoryLimit = successfulJobsHistoryLimit;
    this.parallelism = parallelism;
    this.completions = completions;
    this.completionMode = completionMode;
    this.backoffLimit = backoffLimit;
    this.activeDeadlineSeconds = activeDeadlineSeconds;
    this.ttlSecondsAfterFinished = ttlSecondsAfterFinished;
    this.suspend = suspend;
    this.restartPolicy = restartPolicy;
    this.pvcVolumes = pvcVolumes != null ? pvcVolumes : new PersistentVolumeClaimVolume[0];
    this.secretVolumes = secretVolumes != null ? secretVolumes : new SecretVolume[0];
    this.configMapVolumes = configMapVolumes != null ? configMapVolumes : new ConfigMapVolume[0];
    this.emptyDirVolumes = emptyDirVolumes != null ? emptyDirVolumes : new EmptyDirVolume[0];
    this.awsElasticBlockStoreVolumes = awsElasticBlockStoreVolumes != null ? awsElasticBlockStoreVolumes : new AwsElasticBlockStoreVolume[0];
    this.azureDiskVolumes = azureDiskVolumes != null ? azureDiskVolumes : new AzureDiskVolume[0];
    this.azureFileVolumes = azureFileVolumes != null ? azureFileVolumes : new AzureFileVolume[0];
    this.containers = containers != null ? containers : new Container[0];
  }
  private String name;
  private String schedule;
  private CronJobConcurrencyPolicy concurrencyPolicy;
  private Long startingDeadlineSeconds;
  private Integer failedJobsHistoryLimit;
  private Integer successfulJobsHistoryLimit;
  private Integer parallelism;
  private Integer completions;
  private JobCompletionMode completionMode;
  private Integer backoffLimit;
  private Long activeDeadlineSeconds;
  private Integer ttlSecondsAfterFinished;
  private Boolean suspend;
  private JobRestartPolicy restartPolicy;
  private PersistentVolumeClaimVolume[] pvcVolumes = new PersistentVolumeClaimVolume[0];
  private SecretVolume[] secretVolumes = new SecretVolume[0];
  private ConfigMapVolume[] configMapVolumes = new ConfigMapVolume[0];
  private EmptyDirVolume[] emptyDirVolumes = new EmptyDirVolume[0];
  private AwsElasticBlockStoreVolume[] awsElasticBlockStoreVolumes = new AwsElasticBlockStoreVolume[0];
  private AzureDiskVolume[] azureDiskVolumes = new AzureDiskVolume[0];
  private AzureFileVolume[] azureFileVolumes = new AzureFileVolume[0];
  private Container[] containers;
  
  
  /**
   * The cron job name.
   * @return The cron job name.
   */
  public String getName() {
    return this.name;
  }
  
  
  /**
   * The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.
   * @return The schedule cron expression.
   */
  public String getSchedule() {
    return this.schedule;
  }
  
  
  /**
   * ConcurrencyPolicy describes how the job will be handled.
   * @return the concurrency policy mode.
   */
  public CronJobConcurrencyPolicy getConcurrencyPolicy() {
    return this.concurrencyPolicy;
  }
  
  
  /**
   * Deadline in seconds for starting the job if it misses scheduled time for any reason.
   * Missed jobs executions will be counted as failed ones.
   * @return the starting deadline seconds attribute.
   */
  public Long getStartingDeadlineSeconds() {
    return this.startingDeadlineSeconds;
  }
  
  
  /**
   * The number of failed finished jobs to retain. The default value is 1.
   * @return the failed jobs history limit attribute.
   */
  public Integer getFailedJobsHistoryLimit() {
    return this.failedJobsHistoryLimit;
  }
  
  
  /**
   * The number of successful finished jobs to retain. The default value is 3.
   * @return the successful jobs history limit attribute.
   */
  public Integer getSuccessfulJobsHistoryLimit() {
    return this.successfulJobsHistoryLimit;
  }
  
  
  /**
   * Specifies the maximum desired number of pods the job should run at any given time.
   * @return The desired number of pods.
   */
  public Integer getParallelism() {
    return this.parallelism;
  }
  
  
  /**
   * Specifies the desired number of successfully finished pods the job should be run with.
   * @return The desired number of successfully finished pods.
   */
  public Integer getCompletions() {
    return this.completions;
  }
  
  
  /**
   * CompletionMode specifies how Pod completions are tracked.
   * @return the completion mode.
   */
  public JobCompletionMode getCompletionMode() {
    return this.completionMode;
  }
  
  
  /**
   * Specifies the number of retries before marking this job failed.
   * @return The back-off limit.
   */
  public Integer getBackoffLimit() {
    return this.backoffLimit;
  }
  
  
  /**
   * Specifies the duration in seconds relative to the startTime that the job may be continuously active before the system
   * tries to terminate it; value must be positive integer.
   * @return the active deadline seconds.
   */
  public Long getActiveDeadlineSeconds() {
    return this.activeDeadlineSeconds;
  }
  
  
  /**
   * Limits the lifetime of a Job that has finished execution (either Complete or Failed). If this
   * field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted.
   * @return the time to live seconds after finished.
   */
  public Integer getTtlSecondsAfterFinished() {
    return this.ttlSecondsAfterFinished;
  }
  
  
  /**
   * Suspend specifies whether the Job controller should create Pods or not.
   * @return the suspend job attribute.
   */
  public Boolean getSuspend() {
    return this.suspend;
  }
  
  
  /**
   * Suspend specifies whether the Job controller should create Pods or not.
   * @return the suspend job attribute.
   */
  public boolean isSuspend() {
    return this.suspend != null &&  this.suspend;
  }
  
  
  /**
   * Restart policy when the job container fails.
   * @return the restart policy.
   */
  public JobRestartPolicy getRestartPolicy() {
    return this.restartPolicy;
  }
  
  
  /**
   * PersistentVolumeClaim volumes to add to all containers.
   */
  public PersistentVolumeClaimVolume[] getPvcVolumes() {
    return this.pvcVolumes;
  }
  
  
  /**
   * Secret volumes to add to all containers.
   */
  public SecretVolume[] getSecretVolumes() {
    return this.secretVolumes;
  }
  
  
  /**
   * The ConfigMap volumes to add to all containers.
   */
  public ConfigMapVolume[] getConfigMapVolumes() {
    return this.configMapVolumes;
  }
  
  
  /**
   * The EmptyDir volumes to add to all containers.
   */
  public EmptyDirVolume[] getEmptyDirVolumes() {
    return this.emptyDirVolumes;
  }
  
  
  /**
   * Aws elastic block store volumes to add to all containers
   */
  public AwsElasticBlockStoreVolume[] getAwsElasticBlockStoreVolumes() {
    return this.awsElasticBlockStoreVolumes;
  }
  
  
  /**
   * Azure disk volumes to add
   */
  public AzureDiskVolume[] getAzureDiskVolumes() {
    return this.azureDiskVolumes;
  }
  
  
  /**
   * Azure file volumes to add
   */
  public AzureFileVolume[] getAzureFileVolumes() {
    return this.azureFileVolumes;
  }
  
  
  /**
   * The containers to be run within the Job execution.
   * @return the list of containers.
   */
  public Container[] getContainers() {
    return this.containers;
  }
  
  public static CronJobBuilder newBuilder() {
    return new CronJobBuilder();
  }
  
  public static CronJobBuilder newBuilderFromDefaults() {
    return new CronJobBuilder().withConcurrencyPolicy(io.dekorate.kubernetes.annotation.CronJobConcurrencyPolicy.Allow).withStartingDeadlineSeconds(-1L).withFailedJobsHistoryLimit(1).withSuccessfulJobsHistoryLimit(3).withParallelism(-1).withCompletions(-1).withCompletionMode(io.dekorate.kubernetes.annotation.JobCompletionMode.NonIndexed).withBackoffLimit(-1).withActiveDeadlineSeconds(-1L).withTtlSecondsAfterFinished(-1).withSuspend(false).withRestartPolicy(io.dekorate.kubernetes.annotation.JobRestartPolicy.OnFailure);
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CronJob that = (CronJob) o;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(schedule, that.schedule)) return false;
    if (!java.util.Objects.equals(concurrencyPolicy, that.concurrencyPolicy)) return false;
    if (!java.util.Objects.equals(startingDeadlineSeconds, that.startingDeadlineSeconds)) return false;
    if (!java.util.Objects.equals(failedJobsHistoryLimit, that.failedJobsHistoryLimit)) return false;
    if (!java.util.Objects.equals(successfulJobsHistoryLimit, that.successfulJobsHistoryLimit)) return false;
    if (!java.util.Objects.equals(parallelism, that.parallelism)) return false;
    if (!java.util.Objects.equals(completions, that.completions)) return false;
    if (!java.util.Objects.equals(completionMode, that.completionMode)) return false;
    if (!java.util.Objects.equals(backoffLimit, that.backoffLimit)) return false;
    if (!java.util.Objects.equals(activeDeadlineSeconds, that.activeDeadlineSeconds)) return false;
    if (!java.util.Objects.equals(ttlSecondsAfterFinished, that.ttlSecondsAfterFinished)) return false;
    if (!java.util.Objects.equals(suspend, that.suspend)) return false;
    if (!java.util.Objects.equals(restartPolicy, that.restartPolicy)) return false;
    if (!java.util.Objects.equals(pvcVolumes, that.pvcVolumes)) return false;
    if (!java.util.Objects.equals(secretVolumes, that.secretVolumes)) return false;
    if (!java.util.Objects.equals(configMapVolumes, that.configMapVolumes)) return false;
    if (!java.util.Objects.equals(emptyDirVolumes, that.emptyDirVolumes)) return false;
    if (!java.util.Objects.equals(awsElasticBlockStoreVolumes, that.awsElasticBlockStoreVolumes)) return false;
    if (!java.util.Objects.equals(azureDiskVolumes, that.azureDiskVolumes)) return false;
    if (!java.util.Objects.equals(azureFileVolumes, that.azureFileVolumes)) return false;
    if (!java.util.Objects.equals(containers, that.containers)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(name,  schedule,  concurrencyPolicy,  startingDeadlineSeconds,  failedJobsHistoryLimit,  successfulJobsHistoryLimit,  parallelism,  completions,  completionMode,  backoffLimit,  activeDeadlineSeconds,  ttlSecondsAfterFinished,  suspend,  restartPolicy,  pvcVolumes,  secretVolumes,  configMapVolumes,  emptyDirVolumes,  awsElasticBlockStoreVolumes,  azureDiskVolumes,  azureFileVolumes,  containers,  super.hashCode());
  }
  

}