package io.dekorate.kubernetes.config;

import java.lang.Object;
import java.lang.String;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class Env{
  public Env() {
  }
  
  public Env(String name,String value,String secret,String configmap,String field,String resourceField,String prefix) {
    this.name = name;
    this.value = value;
    this.secret = secret;
    this.configmap = configmap;
    this.field = field;
    this.resourceField = resourceField;
    this.prefix = prefix;
  }
  private String name;
  private String value;
  private String secret;
  private String configmap;
  private String field;
  private String resourceField;
  private String prefix;
  
  
  /**
   * The name of the environment variable.
   * @return the name.
   */
  public String getName() {
    return this.name;
  }
  
  
  /**
   * The value of the environment variable. When no other fields are used (just
   * name/value), this value will be assigned to the environment variable. If used
   * with other fields, like secret, configmap, or field, it will indicate the key
   * from with the value should be drawn.
   * @return The value of the variable, or the property/key from which the value
   * will be pulled (in case of secret, configmap or field).
   */
  public String getValue() {
    return this.value;
  }
  
  public String getSecret() {
    return this.secret;
  }
  
  public String getConfigmap() {
    return this.configmap;
  }
  
  public String getField() {
    return this.field;
  }
  
  public String getResourceField() {
    return this.resourceField;
  }
  
  public String getPrefix() {
    return this.prefix;
  }
  
  public static EnvBuilder newBuilder() {
    return new EnvBuilder();
  }
  
  public static EnvBuilder newBuilderFromDefaults() {
    return new EnvBuilder();
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    Env that = (Env) o;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(value, that.value)) return false;
    if (!java.util.Objects.equals(secret, that.secret)) return false;
    if (!java.util.Objects.equals(configmap, that.configmap)) return false;
    if (!java.util.Objects.equals(field, that.field)) return false;
    if (!java.util.Objects.equals(resourceField, that.resourceField)) return false;
    if (!java.util.Objects.equals(prefix, that.prefix)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(name,  value,  secret,  configmap,  field,  resourceField,  prefix,  super.hashCode());
  }
  

}