package io.dekorate.kubernetes.config;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class EnvFluent<A extends EnvFluent<A>> extends BaseFluent<A>{
  public EnvFluent() {
  }
  
  public EnvFluent(Env instance) {
    this.copyInstance(instance);
  }
  private String name;
  private String value;
  private String secret;
  private String configmap;
  private String field;
  private String resourceField;
  private String prefix;
  
  protected void copyInstance(Env instance) {
    instance = (instance != null ? instance : new Env());
    if (instance != null) {
          this.withName(instance.getName());
          this.withValue(instance.getValue());
          this.withSecret(instance.getSecret());
          this.withConfigmap(instance.getConfigmap());
          this.withField(instance.getField());
          this.withResourceField(instance.getResourceField());
          this.withPrefix(instance.getPrefix());
        }
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public String getValue() {
    return this.value;
  }
  
  public A withValue(String value) {
    this.value = value;
    return (A) this;
  }
  
  public boolean hasValue() {
    return this.value != null;
  }
  
  public String getSecret() {
    return this.secret;
  }
  
  public A withSecret(String secret) {
    this.secret = secret;
    return (A) this;
  }
  
  public boolean hasSecret() {
    return this.secret != null;
  }
  
  public String getConfigmap() {
    return this.configmap;
  }
  
  public A withConfigmap(String configmap) {
    this.configmap = configmap;
    return (A) this;
  }
  
  public boolean hasConfigmap() {
    return this.configmap != null;
  }
  
  public String getField() {
    return this.field;
  }
  
  public A withField(String field) {
    this.field = field;
    return (A) this;
  }
  
  public boolean hasField() {
    return this.field != null;
  }
  
  public String getResourceField() {
    return this.resourceField;
  }
  
  public A withResourceField(String resourceField) {
    this.resourceField = resourceField;
    return (A) this;
  }
  
  public boolean hasResourceField() {
    return this.resourceField != null;
  }
  
  public String getPrefix() {
    return this.prefix;
  }
  
  public A withPrefix(String prefix) {
    this.prefix = prefix;
    return (A) this;
  }
  
  public boolean hasPrefix() {
    return this.prefix != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EnvFluent that = (EnvFluent) o;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(value, that.value)) return false;
    if (!java.util.Objects.equals(secret, that.secret)) return false;
    if (!java.util.Objects.equals(configmap, that.configmap)) return false;
    if (!java.util.Objects.equals(field, that.field)) return false;
    if (!java.util.Objects.equals(resourceField, that.resourceField)) return false;
    if (!java.util.Objects.equals(prefix, that.prefix)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(name,  value,  secret,  configmap,  field,  resourceField,  prefix,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (value != null) { sb.append("value:"); sb.append(value + ","); }
    if (secret != null) { sb.append("secret:"); sb.append(secret + ","); }
    if (configmap != null) { sb.append("configmap:"); sb.append(configmap + ","); }
    if (field != null) { sb.append("field:"); sb.append(field + ","); }
    if (resourceField != null) { sb.append("resourceField:"); sb.append(resourceField + ","); }
    if (prefix != null) { sb.append("prefix:"); sb.append(prefix); }
    sb.append("}");
    return sb.toString();
  }
  

}