package io.dekorate.kubernetes.config;

import java.lang.Object;
import java.lang.String;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class GitRepoVolume{
  public GitRepoVolume() {
  }
  
  public GitRepoVolume(String volumeName,String repository,String directory,String revision) {
    this.volumeName = volumeName;
    this.repository = repository;
    this.directory = directory;
    this.revision = revision;
  }
  private String volumeName;
  private String repository;
  private String directory;
  private String revision;
  
  
  /**
   * The volumeName name.
   * @return The volumeName name.
   */
  public String getVolumeName() {
    return this.volumeName;
  }
  
  
  /**
   * Git repoistory URL.
   * @return The url of the repository.
   */
  public String getRepository() {
    return this.repository;
  }
  
  
  /**
   * The directory of the repository to mount.
   * @return The relative path to the directory.
   */
  public String getDirectory() {
    return this.directory;
  }
  
  
  /**
   * The commit hash to use.
   * @return The hash, or empty if the head of the repo (default).
   */
  public String getRevision() {
    return this.revision;
  }
  
  public static GitRepoVolumeBuilder newBuilder() {
    return new GitRepoVolumeBuilder();
  }
  
  public static GitRepoVolumeBuilder newBuilderFromDefaults() {
    return new GitRepoVolumeBuilder();
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GitRepoVolume that = (GitRepoVolume) o;
    if (!java.util.Objects.equals(volumeName, that.volumeName)) return false;
    if (!java.util.Objects.equals(repository, that.repository)) return false;
    if (!java.util.Objects.equals(directory, that.directory)) return false;
    if (!java.util.Objects.equals(revision, that.revision)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(volumeName,  repository,  directory,  revision,  super.hashCode());
  }
  

}