package io.dekorate.kubernetes.config;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HostAliasFluent<A extends HostAliasFluent<A>> extends BaseFluent<A>{
  public HostAliasFluent() {
  }
  
  public HostAliasFluent(HostAlias instance) {
    this.copyInstance(instance);
  }
  private String ip;
  private String hostnames;
  
  protected void copyInstance(HostAlias instance) {
    instance = (instance != null ? instance : new HostAlias());
    if (instance != null) {
          this.withIp(instance.getIp());
          this.withHostnames(instance.getHostnames());
        }
  }
  
  public String getIp() {
    return this.ip;
  }
  
  public A withIp(String ip) {
    this.ip = ip;
    return (A) this;
  }
  
  public boolean hasIp() {
    return this.ip != null;
  }
  
  public String getHostnames() {
    return this.hostnames;
  }
  
  public A withHostnames(String hostnames) {
    this.hostnames = hostnames;
    return (A) this;
  }
  
  public boolean hasHostnames() {
    return this.hostnames != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HostAliasFluent that = (HostAliasFluent) o;
    if (!java.util.Objects.equals(ip, that.ip)) return false;
    if (!java.util.Objects.equals(hostnames, that.hostnames)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(ip,  hostnames,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ip != null) { sb.append("ip:"); sb.append(ip + ","); }
    if (hostnames != null) { sb.append("hostnames:"); sb.append(hostnames); }
    sb.append("}");
    return sb.toString();
  }
  

}