package io.dekorate.kubernetes.config;

import java.lang.SuppressWarnings;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ImageConfigurationFluent<A extends ImageConfigurationFluent<A>> extends ApplicationConfigurationFluent<A>{
  public ImageConfigurationFluent() {
  }
  
  public ImageConfigurationFluent(ImageConfiguration instance) {
    this.copyInstance(instance);
  }
  private Boolean enabled;
  private String registry;
  private String group;
  private String name;
  private String version;
  private String image;
  private String dockerFile;
  private Boolean autoBuildEnabled;
  private Boolean autoPushEnabled;
  private Boolean autoLoadEnabled;
  
  protected void copyInstance(ImageConfiguration instance) {
    instance = (instance != null ? instance : new ImageConfiguration());
    if (instance != null) {
          this.withProject(instance.getProject());
          this.withAttributes(instance.getAttributes());
          this.withEnabled(instance.getEnabled());
          this.withRegistry(instance.getRegistry());
          this.withGroup(instance.getGroup());
          this.withName(instance.getName());
          this.withVersion(instance.getVersion());
          this.withImage(instance.getImage());
          this.withDockerFile(instance.getDockerFile());
          this.withAutoBuildEnabled(instance.getAutoBuildEnabled());
          this.withAutoPushEnabled(instance.getAutoPushEnabled());
          this.withAutoLoadEnabled(instance.isAutoLoadEnabled());
          this.withPartOf(instance.getPartOf());
        }
  }
  
  public Boolean getEnabled() {
    return this.enabled;
  }
  
  public A withEnabled(Boolean enabled) {
    this.enabled = enabled;
    return (A) this;
  }
  
  public boolean hasEnabled() {
    return this.enabled != null;
  }
  
  public String getRegistry() {
    return this.registry;
  }
  
  public A withRegistry(String registry) {
    this.registry = registry;
    return (A) this;
  }
  
  public boolean hasRegistry() {
    return this.registry != null;
  }
  
  public String getGroup() {
    return this.group;
  }
  
  public A withGroup(String group) {
    this.group = group;
    return (A) this;
  }
  
  public boolean hasGroup() {
    return this.group != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public A withVersion(String version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public String getImage() {
    return this.image;
  }
  
  public A withImage(String image) {
    this.image = image;
    return (A) this;
  }
  
  public boolean hasImage() {
    return this.image != null;
  }
  
  public String getDockerFile() {
    return this.dockerFile;
  }
  
  public A withDockerFile(String dockerFile) {
    this.dockerFile = dockerFile;
    return (A) this;
  }
  
  public boolean hasDockerFile() {
    return this.dockerFile != null;
  }
  
  public Boolean getAutoBuildEnabled() {
    return this.autoBuildEnabled;
  }
  
  public A withAutoBuildEnabled(Boolean autoBuildEnabled) {
    this.autoBuildEnabled = autoBuildEnabled;
    return (A) this;
  }
  
  public boolean hasAutoBuildEnabled() {
    return this.autoBuildEnabled != null;
  }
  
  public Boolean getAutoPushEnabled() {
    return this.autoPushEnabled;
  }
  
  public A withAutoPushEnabled(Boolean autoPushEnabled) {
    this.autoPushEnabled = autoPushEnabled;
    return (A) this;
  }
  
  public boolean hasAutoPushEnabled() {
    return this.autoPushEnabled != null;
  }
  
  public Boolean getAutoLoadEnabled() {
    return this.autoLoadEnabled;
  }
  
  public A withAutoLoadEnabled(Boolean autoLoadEnabled) {
    this.autoLoadEnabled = autoLoadEnabled;
    return (A) this;
  }
  
  public boolean hasAutoLoadEnabled() {
    return this.autoLoadEnabled != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageConfigurationFluent that = (ImageConfigurationFluent) o;
    if (!java.util.Objects.equals(enabled, that.enabled)) return false;
    if (!java.util.Objects.equals(registry, that.registry)) return false;
    if (!java.util.Objects.equals(group, that.group)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(image, that.image)) return false;
    if (!java.util.Objects.equals(dockerFile, that.dockerFile)) return false;
    if (!java.util.Objects.equals(autoBuildEnabled, that.autoBuildEnabled)) return false;
    if (!java.util.Objects.equals(autoPushEnabled, that.autoPushEnabled)) return false;
    if (!java.util.Objects.equals(autoLoadEnabled, that.autoLoadEnabled)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(enabled,  registry,  group,  name,  version,  image,  dockerFile,  autoBuildEnabled,  autoPushEnabled,  autoLoadEnabled,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (enabled != null) { sb.append("enabled:"); sb.append(enabled + ","); }
    if (registry != null) { sb.append("registry:"); sb.append(registry + ","); }
    if (group != null) { sb.append("group:"); sb.append(group + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (dockerFile != null) { sb.append("dockerFile:"); sb.append(dockerFile + ","); }
    if (autoBuildEnabled != null) { sb.append("autoBuildEnabled:"); sb.append(autoBuildEnabled + ","); }
    if (autoPushEnabled != null) { sb.append("autoPushEnabled:"); sb.append(autoPushEnabled + ","); }
    if (autoLoadEnabled != null) { sb.append("autoLoadEnabled:"); sb.append(autoLoadEnabled); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withEnabled() {
    return withEnabled(true);
  }
  
  public A withAutoBuildEnabled() {
    return withAutoBuildEnabled(true);
  }
  
  public A withAutoPushEnabled() {
    return withAutoPushEnabled(true);
  }
  
  public A withAutoLoadEnabled() {
    return withAutoLoadEnabled(true);
  }
  

}