package io.dekorate.kubernetes.config;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(builderPackage = "io.fabric8.kubernetes.api.builder")
public class Item{
  public Item() {
  }
  
  public Item(String key,String path,Integer mode) {
    this.key = key;
    this.path = path;
    this.mode = mode;
  }
  private String key;
  private String path;
  private Integer mode;
  
  
  /**
   * The key name within the data section (in Secrets and ConfigMaps).
   * @return The key.
   */
  public String getKey() {
    return this.key;
  }
  
  
  /**
   * The path where the file will be mounted.
   * @return The path.
   */
  public String getPath() {
    return this.path;
  }
  
  
  /**
   * It must be a value between 0000 and 0777. If not specified, the volume defaultMode will be used.
   * @return The file mode.
   */
  public Integer getMode() {
    return this.mode;
  }
  
  public static ItemBuilder newBuilder() {
    return new ItemBuilder();
  }
  
  public static ItemBuilder newBuilderFromDefaults() {
    return new ItemBuilder().withMode(-1);
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    Item that = (Item) o;
    if (!java.util.Objects.equals(key, that.key)) return false;
    if (!java.util.Objects.equals(path, that.path)) return false;
    if (!java.util.Objects.equals(mode, that.mode)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(key,  path,  mode,  super.hashCode());
  }
  

}