package io.dekorate.kubernetes.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import io.dekorate.kubernetes.annotation.JobRestartPolicy;
import java.lang.Boolean;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;
import io.dekorate.kubernetes.annotation.JobCompletionMode;
import java.lang.Integer;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class JobFluent<A extends JobFluent<A>> extends BaseFluent<A>{
  public JobFluent() {
  }
  
  public JobFluent(Job instance) {
    this.copyInstance(instance);
  }
  private String name;
  private Integer parallelism;
  private Integer completions;
  private JobCompletionMode completionMode;
  private Integer backoffLimit;
  private Long activeDeadlineSeconds;
  private Integer ttlSecondsAfterFinished;
  private Boolean suspend;
  private JobRestartPolicy restartPolicy;
  private ArrayList<PersistentVolumeClaimVolumeBuilder> pvcVolumes = new ArrayList<PersistentVolumeClaimVolumeBuilder>();
  private ArrayList<SecretVolumeBuilder> secretVolumes = new ArrayList<SecretVolumeBuilder>();
  private ArrayList<ConfigMapVolumeBuilder> configMapVolumes = new ArrayList<ConfigMapVolumeBuilder>();
  private ArrayList<EmptyDirVolumeBuilder> emptyDirVolumes = new ArrayList<EmptyDirVolumeBuilder>();
  private ArrayList<AwsElasticBlockStoreVolumeBuilder> awsElasticBlockStoreVolumes = new ArrayList<AwsElasticBlockStoreVolumeBuilder>();
  private ArrayList<AzureDiskVolumeBuilder> azureDiskVolumes = new ArrayList<AzureDiskVolumeBuilder>();
  private ArrayList<AzureFileVolumeBuilder> azureFileVolumes = new ArrayList<AzureFileVolumeBuilder>();
  private ArrayList<ContainerBuilder> containers = new ArrayList<ContainerBuilder>();
  
  protected void copyInstance(Job instance) {
    instance = (instance != null ? instance : new Job());
    if (instance != null) {
          this.withName(instance.getName());
          this.withParallelism(instance.getParallelism());
          this.withCompletions(instance.getCompletions());
          this.withCompletionMode(instance.getCompletionMode());
          this.withBackoffLimit(instance.getBackoffLimit());
          this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
          this.withTtlSecondsAfterFinished(instance.getTtlSecondsAfterFinished());
          this.withSuspend(instance.getSuspend());
          this.withRestartPolicy(instance.getRestartPolicy());
          this.withPvcVolumes(instance.getPvcVolumes());
          this.withSecretVolumes(instance.getSecretVolumes());
          this.withConfigMapVolumes(instance.getConfigMapVolumes());
          this.withEmptyDirVolumes(instance.getEmptyDirVolumes());
          this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes());
          this.withAzureDiskVolumes(instance.getAzureDiskVolumes());
          this.withAzureFileVolumes(instance.getAzureFileVolumes());
          this.withContainers(instance.getContainers());
        }
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public Integer getParallelism() {
    return this.parallelism;
  }
  
  public A withParallelism(Integer parallelism) {
    this.parallelism = parallelism;
    return (A) this;
  }
  
  public boolean hasParallelism() {
    return this.parallelism != null;
  }
  
  public Integer getCompletions() {
    return this.completions;
  }
  
  public A withCompletions(Integer completions) {
    this.completions = completions;
    return (A) this;
  }
  
  public boolean hasCompletions() {
    return this.completions != null;
  }
  
  public JobCompletionMode getCompletionMode() {
    return this.completionMode;
  }
  
  public A withCompletionMode(JobCompletionMode completionMode) {
    this.completionMode = completionMode;
    return (A) this;
  }
  
  public boolean hasCompletionMode() {
    return this.completionMode != null;
  }
  
  public Integer getBackoffLimit() {
    return this.backoffLimit;
  }
  
  public A withBackoffLimit(Integer backoffLimit) {
    this.backoffLimit = backoffLimit;
    return (A) this;
  }
  
  public boolean hasBackoffLimit() {
    return this.backoffLimit != null;
  }
  
  public Long getActiveDeadlineSeconds() {
    return this.activeDeadlineSeconds;
  }
  
  public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
    this.activeDeadlineSeconds = activeDeadlineSeconds;
    return (A) this;
  }
  
  public boolean hasActiveDeadlineSeconds() {
    return this.activeDeadlineSeconds != null;
  }
  
  public Integer getTtlSecondsAfterFinished() {
    return this.ttlSecondsAfterFinished;
  }
  
  public A withTtlSecondsAfterFinished(Integer ttlSecondsAfterFinished) {
    this.ttlSecondsAfterFinished = ttlSecondsAfterFinished;
    return (A) this;
  }
  
  public boolean hasTtlSecondsAfterFinished() {
    return this.ttlSecondsAfterFinished != null;
  }
  
  public Boolean getSuspend() {
    return this.suspend;
  }
  
  public A withSuspend(Boolean suspend) {
    this.suspend = suspend;
    return (A) this;
  }
  
  public boolean hasSuspend() {
    return this.suspend != null;
  }
  
  public JobRestartPolicy getRestartPolicy() {
    return this.restartPolicy;
  }
  
  public A withRestartPolicy(JobRestartPolicy restartPolicy) {
    this.restartPolicy = restartPolicy;
    return (A) this;
  }
  
  public boolean hasRestartPolicy() {
    return this.restartPolicy != null;
  }
  
  public A withPvcVolumes(io.dekorate.kubernetes.config.PersistentVolumeClaimVolume... pvcVolumes) {
    if (this.pvcVolumes != null) {
        this.pvcVolumes.clear();
        _visitables.remove("pvcVolumes");
    }
    if (pvcVolumes != null) {
      for (PersistentVolumeClaimVolume item : pvcVolumes) {
        this.addToPvcVolumes(item);
      }
    }
    return (A) this;
  }
  
  public PersistentVolumeClaimVolume[] buildPvcVolumes() {
    int size = pvcVolumes != null ? pvcVolumes.size() : 0;;
    PersistentVolumeClaimVolume[] result = new PersistentVolumeClaimVolume[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<PersistentVolumeClaimVolume,PersistentVolumeClaimVolumeBuilder> item : pvcVolumes) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public PersistentVolumeClaimVolume buildPvcVolume(int index) {
    return this.pvcVolumes.get(index).build();
  }
  
  public PersistentVolumeClaimVolume buildFirstPvcVolume() {
    return this.pvcVolumes.get(0).build();
  }
  
  public PersistentVolumeClaimVolume buildLastPvcVolume() {
    return this.pvcVolumes.get(pvcVolumes.size() - 1).build();
  }
  
  public PersistentVolumeClaimVolume buildMatchingPvcVolume(Predicate<PersistentVolumeClaimVolumeBuilder> predicate) {
      for (PersistentVolumeClaimVolumeBuilder item : pvcVolumes) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingPvcVolume(Predicate<PersistentVolumeClaimVolumeBuilder> predicate) {
      for (PersistentVolumeClaimVolumeBuilder item : pvcVolumes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToPvcVolumes(int index,PersistentVolumeClaimVolume item) {
    if (this.pvcVolumes == null) {this.pvcVolumes = new ArrayList<PersistentVolumeClaimVolumeBuilder>();}
    PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
    if (index < 0 || index >= pvcVolumes.size()) { _visitables.get("pvcVolumes").add(builder); pvcVolumes.add(builder); } else { _visitables.get("pvcVolumes").add(index, builder); pvcVolumes.add(index, builder);}
    return (A)this;
  }
  
  public A setToPvcVolumes(int index,PersistentVolumeClaimVolume item) {
    if (this.pvcVolumes == null) {this.pvcVolumes = new ArrayList<PersistentVolumeClaimVolumeBuilder>();}
    PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
    if (index < 0 || index >= pvcVolumes.size()) { _visitables.get("pvcVolumes").add(builder); pvcVolumes.add(builder); } else { _visitables.get("pvcVolumes").set(index, builder); pvcVolumes.set(index, builder);}
    return (A)this;
  }
  
  public A addToPvcVolumes(io.dekorate.kubernetes.config.PersistentVolumeClaimVolume... items) {
    if (this.pvcVolumes == null) {this.pvcVolumes = new ArrayList<PersistentVolumeClaimVolumeBuilder>();}
    for (PersistentVolumeClaimVolume item : items) {PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);_visitables.get("pvcVolumes").add(builder);this.pvcVolumes.add(builder);} return (A)this;
  }
  
  public A addAllToPvcVolumes(Collection<PersistentVolumeClaimVolume> items) {
    if (this.pvcVolumes == null) {this.pvcVolumes = new ArrayList<PersistentVolumeClaimVolumeBuilder>();}
    for (PersistentVolumeClaimVolume item : items) {PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);_visitables.get("pvcVolumes").add(builder);this.pvcVolumes.add(builder);} return (A)this;
  }
  
  public A removeFromPvcVolumes(io.dekorate.kubernetes.config.PersistentVolumeClaimVolume... items) {
    if (this.pvcVolumes == null) return (A)this;
    for (PersistentVolumeClaimVolume item : items) {PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);_visitables.get("pvcVolumes").remove(builder); this.pvcVolumes.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPvcVolumes(Collection<PersistentVolumeClaimVolume> items) {
    if (this.pvcVolumes == null) return (A)this;
    for (PersistentVolumeClaimVolume item : items) {PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);_visitables.get("pvcVolumes").remove(builder); this.pvcVolumes.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPvcVolumes(Predicate<PersistentVolumeClaimVolumeBuilder> predicate) {
    if (pvcVolumes == null) return (A) this;
    final Iterator<PersistentVolumeClaimVolumeBuilder> each = pvcVolumes.iterator();
    final List visitables = _visitables.get("pvcVolumes");
    while (each.hasNext()) {
      PersistentVolumeClaimVolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasPvcVolumes() {
    return this.pvcVolumes != null && !this.pvcVolumes.isEmpty();
  }
  
  public A addNewPvcVolume(String volumeName,String claimName,Boolean readOnly) {
    return (A)addToPvcVolumes(new PersistentVolumeClaimVolume(volumeName, claimName, readOnly));
  }
  
  public PvcVolumesNested<A> addNewPvcVolume() {
    return new PvcVolumesNested(-1, null);
  }
  
  public PvcVolumesNested<A> addNewPvcVolumeLike(PersistentVolumeClaimVolume item) {
    return new PvcVolumesNested(-1, item);
  }
  
  public PvcVolumesNested<A> setNewPvcVolumeLike(int index,PersistentVolumeClaimVolume item) {
    return new PvcVolumesNested(index, item);
  }
  
  public PvcVolumesNested<A> editPvcVolume(int index) {
    if (pvcVolumes.size() <= index) throw new RuntimeException("Can't edit pvcVolumes. Index exceeds size.");
    return setNewPvcVolumeLike(index, buildPvcVolume(index));
  }
  
  public PvcVolumesNested<A> editFirstPvcVolume() {
    if (pvcVolumes.size() == 0) throw new RuntimeException("Can't edit first pvcVolumes. The list is empty.");
    return setNewPvcVolumeLike(0, buildPvcVolume(0));
  }
  
  public PvcVolumesNested<A> editLastPvcVolume() {
    int index = pvcVolumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last pvcVolumes. The list is empty.");
    return setNewPvcVolumeLike(index, buildPvcVolume(index));
  }
  
  public PvcVolumesNested<A> editMatchingPvcVolume(Predicate<PersistentVolumeClaimVolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<pvcVolumes.size();i++) { 
    if (predicate.test(pvcVolumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching pvcVolumes. No match found.");
    return setNewPvcVolumeLike(index, buildPvcVolume(index));
  }
  
  public A withSecretVolumes(io.dekorate.kubernetes.config.SecretVolume... secretVolumes) {
    if (this.secretVolumes != null) {
        this.secretVolumes.clear();
        _visitables.remove("secretVolumes");
    }
    if (secretVolumes != null) {
      for (SecretVolume item : secretVolumes) {
        this.addToSecretVolumes(item);
      }
    }
    return (A) this;
  }
  
  public SecretVolume[] buildSecretVolumes() {
    int size = secretVolumes != null ? secretVolumes.size() : 0;;
    SecretVolume[] result = new SecretVolume[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<SecretVolume,SecretVolumeBuilder> item : secretVolumes) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public SecretVolume buildSecretVolume(int index) {
    return this.secretVolumes.get(index).build();
  }
  
  public SecretVolume buildFirstSecretVolume() {
    return this.secretVolumes.get(0).build();
  }
  
  public SecretVolume buildLastSecretVolume() {
    return this.secretVolumes.get(secretVolumes.size() - 1).build();
  }
  
  public SecretVolume buildMatchingSecretVolume(Predicate<SecretVolumeBuilder> predicate) {
      for (SecretVolumeBuilder item : secretVolumes) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingSecretVolume(Predicate<SecretVolumeBuilder> predicate) {
      for (SecretVolumeBuilder item : secretVolumes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToSecretVolumes(int index,SecretVolume item) {
    if (this.secretVolumes == null) {this.secretVolumes = new ArrayList<SecretVolumeBuilder>();}
    SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
    if (index < 0 || index >= secretVolumes.size()) { _visitables.get("secretVolumes").add(builder); secretVolumes.add(builder); } else { _visitables.get("secretVolumes").add(index, builder); secretVolumes.add(index, builder);}
    return (A)this;
  }
  
  public A setToSecretVolumes(int index,SecretVolume item) {
    if (this.secretVolumes == null) {this.secretVolumes = new ArrayList<SecretVolumeBuilder>();}
    SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
    if (index < 0 || index >= secretVolumes.size()) { _visitables.get("secretVolumes").add(builder); secretVolumes.add(builder); } else { _visitables.get("secretVolumes").set(index, builder); secretVolumes.set(index, builder);}
    return (A)this;
  }
  
  public A addToSecretVolumes(io.dekorate.kubernetes.config.SecretVolume... items) {
    if (this.secretVolumes == null) {this.secretVolumes = new ArrayList<SecretVolumeBuilder>();}
    for (SecretVolume item : items) {SecretVolumeBuilder builder = new SecretVolumeBuilder(item);_visitables.get("secretVolumes").add(builder);this.secretVolumes.add(builder);} return (A)this;
  }
  
  public A addAllToSecretVolumes(Collection<SecretVolume> items) {
    if (this.secretVolumes == null) {this.secretVolumes = new ArrayList<SecretVolumeBuilder>();}
    for (SecretVolume item : items) {SecretVolumeBuilder builder = new SecretVolumeBuilder(item);_visitables.get("secretVolumes").add(builder);this.secretVolumes.add(builder);} return (A)this;
  }
  
  public A removeFromSecretVolumes(io.dekorate.kubernetes.config.SecretVolume... items) {
    if (this.secretVolumes == null) return (A)this;
    for (SecretVolume item : items) {SecretVolumeBuilder builder = new SecretVolumeBuilder(item);_visitables.get("secretVolumes").remove(builder); this.secretVolumes.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSecretVolumes(Collection<SecretVolume> items) {
    if (this.secretVolumes == null) return (A)this;
    for (SecretVolume item : items) {SecretVolumeBuilder builder = new SecretVolumeBuilder(item);_visitables.get("secretVolumes").remove(builder); this.secretVolumes.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSecretVolumes(Predicate<SecretVolumeBuilder> predicate) {
    if (secretVolumes == null) return (A) this;
    final Iterator<SecretVolumeBuilder> each = secretVolumes.iterator();
    final List visitables = _visitables.get("secretVolumes");
    while (each.hasNext()) {
      SecretVolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasSecretVolumes() {
    return this.secretVolumes != null && !this.secretVolumes.isEmpty();
  }
  
  public SecretVolumesNested<A> addNewSecretVolume() {
    return new SecretVolumesNested(-1, null);
  }
  
  public SecretVolumesNested<A> addNewSecretVolumeLike(SecretVolume item) {
    return new SecretVolumesNested(-1, item);
  }
  
  public SecretVolumesNested<A> setNewSecretVolumeLike(int index,SecretVolume item) {
    return new SecretVolumesNested(index, item);
  }
  
  public SecretVolumesNested<A> editSecretVolume(int index) {
    if (secretVolumes.size() <= index) throw new RuntimeException("Can't edit secretVolumes. Index exceeds size.");
    return setNewSecretVolumeLike(index, buildSecretVolume(index));
  }
  
  public SecretVolumesNested<A> editFirstSecretVolume() {
    if (secretVolumes.size() == 0) throw new RuntimeException("Can't edit first secretVolumes. The list is empty.");
    return setNewSecretVolumeLike(0, buildSecretVolume(0));
  }
  
  public SecretVolumesNested<A> editLastSecretVolume() {
    int index = secretVolumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last secretVolumes. The list is empty.");
    return setNewSecretVolumeLike(index, buildSecretVolume(index));
  }
  
  public SecretVolumesNested<A> editMatchingSecretVolume(Predicate<SecretVolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<secretVolumes.size();i++) { 
    if (predicate.test(secretVolumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching secretVolumes. No match found.");
    return setNewSecretVolumeLike(index, buildSecretVolume(index));
  }
  
  public A withConfigMapVolumes(io.dekorate.kubernetes.config.ConfigMapVolume... configMapVolumes) {
    if (this.configMapVolumes != null) {
        this.configMapVolumes.clear();
        _visitables.remove("configMapVolumes");
    }
    if (configMapVolumes != null) {
      for (ConfigMapVolume item : configMapVolumes) {
        this.addToConfigMapVolumes(item);
      }
    }
    return (A) this;
  }
  
  public ConfigMapVolume[] buildConfigMapVolumes() {
    int size = configMapVolumes != null ? configMapVolumes.size() : 0;;
    ConfigMapVolume[] result = new ConfigMapVolume[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<ConfigMapVolume,ConfigMapVolumeBuilder> item : configMapVolumes) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public ConfigMapVolume buildConfigMapVolume(int index) {
    return this.configMapVolumes.get(index).build();
  }
  
  public ConfigMapVolume buildFirstConfigMapVolume() {
    return this.configMapVolumes.get(0).build();
  }
  
  public ConfigMapVolume buildLastConfigMapVolume() {
    return this.configMapVolumes.get(configMapVolumes.size() - 1).build();
  }
  
  public ConfigMapVolume buildMatchingConfigMapVolume(Predicate<ConfigMapVolumeBuilder> predicate) {
      for (ConfigMapVolumeBuilder item : configMapVolumes) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingConfigMapVolume(Predicate<ConfigMapVolumeBuilder> predicate) {
      for (ConfigMapVolumeBuilder item : configMapVolumes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToConfigMapVolumes(int index,ConfigMapVolume item) {
    if (this.configMapVolumes == null) {this.configMapVolumes = new ArrayList<ConfigMapVolumeBuilder>();}
    ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
    if (index < 0 || index >= configMapVolumes.size()) { _visitables.get("configMapVolumes").add(builder); configMapVolumes.add(builder); } else { _visitables.get("configMapVolumes").add(index, builder); configMapVolumes.add(index, builder);}
    return (A)this;
  }
  
  public A setToConfigMapVolumes(int index,ConfigMapVolume item) {
    if (this.configMapVolumes == null) {this.configMapVolumes = new ArrayList<ConfigMapVolumeBuilder>();}
    ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
    if (index < 0 || index >= configMapVolumes.size()) { _visitables.get("configMapVolumes").add(builder); configMapVolumes.add(builder); } else { _visitables.get("configMapVolumes").set(index, builder); configMapVolumes.set(index, builder);}
    return (A)this;
  }
  
  public A addToConfigMapVolumes(io.dekorate.kubernetes.config.ConfigMapVolume... items) {
    if (this.configMapVolumes == null) {this.configMapVolumes = new ArrayList<ConfigMapVolumeBuilder>();}
    for (ConfigMapVolume item : items) {ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);_visitables.get("configMapVolumes").add(builder);this.configMapVolumes.add(builder);} return (A)this;
  }
  
  public A addAllToConfigMapVolumes(Collection<ConfigMapVolume> items) {
    if (this.configMapVolumes == null) {this.configMapVolumes = new ArrayList<ConfigMapVolumeBuilder>();}
    for (ConfigMapVolume item : items) {ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);_visitables.get("configMapVolumes").add(builder);this.configMapVolumes.add(builder);} return (A)this;
  }
  
  public A removeFromConfigMapVolumes(io.dekorate.kubernetes.config.ConfigMapVolume... items) {
    if (this.configMapVolumes == null) return (A)this;
    for (ConfigMapVolume item : items) {ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);_visitables.get("configMapVolumes").remove(builder); this.configMapVolumes.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConfigMapVolumes(Collection<ConfigMapVolume> items) {
    if (this.configMapVolumes == null) return (A)this;
    for (ConfigMapVolume item : items) {ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);_visitables.get("configMapVolumes").remove(builder); this.configMapVolumes.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConfigMapVolumes(Predicate<ConfigMapVolumeBuilder> predicate) {
    if (configMapVolumes == null) return (A) this;
    final Iterator<ConfigMapVolumeBuilder> each = configMapVolumes.iterator();
    final List visitables = _visitables.get("configMapVolumes");
    while (each.hasNext()) {
      ConfigMapVolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasConfigMapVolumes() {
    return this.configMapVolumes != null && !this.configMapVolumes.isEmpty();
  }
  
  public ConfigMapVolumesNested<A> addNewConfigMapVolume() {
    return new ConfigMapVolumesNested(-1, null);
  }
  
  public ConfigMapVolumesNested<A> addNewConfigMapVolumeLike(ConfigMapVolume item) {
    return new ConfigMapVolumesNested(-1, item);
  }
  
  public ConfigMapVolumesNested<A> setNewConfigMapVolumeLike(int index,ConfigMapVolume item) {
    return new ConfigMapVolumesNested(index, item);
  }
  
  public ConfigMapVolumesNested<A> editConfigMapVolume(int index) {
    if (configMapVolumes.size() <= index) throw new RuntimeException("Can't edit configMapVolumes. Index exceeds size.");
    return setNewConfigMapVolumeLike(index, buildConfigMapVolume(index));
  }
  
  public ConfigMapVolumesNested<A> editFirstConfigMapVolume() {
    if (configMapVolumes.size() == 0) throw new RuntimeException("Can't edit first configMapVolumes. The list is empty.");
    return setNewConfigMapVolumeLike(0, buildConfigMapVolume(0));
  }
  
  public ConfigMapVolumesNested<A> editLastConfigMapVolume() {
    int index = configMapVolumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last configMapVolumes. The list is empty.");
    return setNewConfigMapVolumeLike(index, buildConfigMapVolume(index));
  }
  
  public ConfigMapVolumesNested<A> editMatchingConfigMapVolume(Predicate<ConfigMapVolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<configMapVolumes.size();i++) { 
    if (predicate.test(configMapVolumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching configMapVolumes. No match found.");
    return setNewConfigMapVolumeLike(index, buildConfigMapVolume(index));
  }
  
  public A withEmptyDirVolumes(io.dekorate.kubernetes.config.EmptyDirVolume... emptyDirVolumes) {
    if (this.emptyDirVolumes != null) {
        this.emptyDirVolumes.clear();
        _visitables.remove("emptyDirVolumes");
    }
    if (emptyDirVolumes != null) {
      for (EmptyDirVolume item : emptyDirVolumes) {
        this.addToEmptyDirVolumes(item);
      }
    }
    return (A) this;
  }
  
  public EmptyDirVolume[] buildEmptyDirVolumes() {
    int size = emptyDirVolumes != null ? emptyDirVolumes.size() : 0;;
    EmptyDirVolume[] result = new EmptyDirVolume[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<EmptyDirVolume,EmptyDirVolumeBuilder> item : emptyDirVolumes) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public EmptyDirVolume buildEmptyDirVolume(int index) {
    return this.emptyDirVolumes.get(index).build();
  }
  
  public EmptyDirVolume buildFirstEmptyDirVolume() {
    return this.emptyDirVolumes.get(0).build();
  }
  
  public EmptyDirVolume buildLastEmptyDirVolume() {
    return this.emptyDirVolumes.get(emptyDirVolumes.size() - 1).build();
  }
  
  public EmptyDirVolume buildMatchingEmptyDirVolume(Predicate<EmptyDirVolumeBuilder> predicate) {
      for (EmptyDirVolumeBuilder item : emptyDirVolumes) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingEmptyDirVolume(Predicate<EmptyDirVolumeBuilder> predicate) {
      for (EmptyDirVolumeBuilder item : emptyDirVolumes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToEmptyDirVolumes(int index,EmptyDirVolume item) {
    if (this.emptyDirVolumes == null) {this.emptyDirVolumes = new ArrayList<EmptyDirVolumeBuilder>();}
    EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
    if (index < 0 || index >= emptyDirVolumes.size()) { _visitables.get("emptyDirVolumes").add(builder); emptyDirVolumes.add(builder); } else { _visitables.get("emptyDirVolumes").add(index, builder); emptyDirVolumes.add(index, builder);}
    return (A)this;
  }
  
  public A setToEmptyDirVolumes(int index,EmptyDirVolume item) {
    if (this.emptyDirVolumes == null) {this.emptyDirVolumes = new ArrayList<EmptyDirVolumeBuilder>();}
    EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
    if (index < 0 || index >= emptyDirVolumes.size()) { _visitables.get("emptyDirVolumes").add(builder); emptyDirVolumes.add(builder); } else { _visitables.get("emptyDirVolumes").set(index, builder); emptyDirVolumes.set(index, builder);}
    return (A)this;
  }
  
  public A addToEmptyDirVolumes(io.dekorate.kubernetes.config.EmptyDirVolume... items) {
    if (this.emptyDirVolumes == null) {this.emptyDirVolumes = new ArrayList<EmptyDirVolumeBuilder>();}
    for (EmptyDirVolume item : items) {EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);_visitables.get("emptyDirVolumes").add(builder);this.emptyDirVolumes.add(builder);} return (A)this;
  }
  
  public A addAllToEmptyDirVolumes(Collection<EmptyDirVolume> items) {
    if (this.emptyDirVolumes == null) {this.emptyDirVolumes = new ArrayList<EmptyDirVolumeBuilder>();}
    for (EmptyDirVolume item : items) {EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);_visitables.get("emptyDirVolumes").add(builder);this.emptyDirVolumes.add(builder);} return (A)this;
  }
  
  public A removeFromEmptyDirVolumes(io.dekorate.kubernetes.config.EmptyDirVolume... items) {
    if (this.emptyDirVolumes == null) return (A)this;
    for (EmptyDirVolume item : items) {EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);_visitables.get("emptyDirVolumes").remove(builder); this.emptyDirVolumes.remove(builder);} return (A)this;
  }
  
  public A removeAllFromEmptyDirVolumes(Collection<EmptyDirVolume> items) {
    if (this.emptyDirVolumes == null) return (A)this;
    for (EmptyDirVolume item : items) {EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);_visitables.get("emptyDirVolumes").remove(builder); this.emptyDirVolumes.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromEmptyDirVolumes(Predicate<EmptyDirVolumeBuilder> predicate) {
    if (emptyDirVolumes == null) return (A) this;
    final Iterator<EmptyDirVolumeBuilder> each = emptyDirVolumes.iterator();
    final List visitables = _visitables.get("emptyDirVolumes");
    while (each.hasNext()) {
      EmptyDirVolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasEmptyDirVolumes() {
    return this.emptyDirVolumes != null && !this.emptyDirVolumes.isEmpty();
  }
  
  public A addNewEmptyDirVolume(String volumeName) {
    return (A)addToEmptyDirVolumes(new EmptyDirVolume(volumeName));
  }
  
  public EmptyDirVolumesNested<A> addNewEmptyDirVolume() {
    return new EmptyDirVolumesNested(-1, null);
  }
  
  public EmptyDirVolumesNested<A> addNewEmptyDirVolumeLike(EmptyDirVolume item) {
    return new EmptyDirVolumesNested(-1, item);
  }
  
  public EmptyDirVolumesNested<A> setNewEmptyDirVolumeLike(int index,EmptyDirVolume item) {
    return new EmptyDirVolumesNested(index, item);
  }
  
  public EmptyDirVolumesNested<A> editEmptyDirVolume(int index) {
    if (emptyDirVolumes.size() <= index) throw new RuntimeException("Can't edit emptyDirVolumes. Index exceeds size.");
    return setNewEmptyDirVolumeLike(index, buildEmptyDirVolume(index));
  }
  
  public EmptyDirVolumesNested<A> editFirstEmptyDirVolume() {
    if (emptyDirVolumes.size() == 0) throw new RuntimeException("Can't edit first emptyDirVolumes. The list is empty.");
    return setNewEmptyDirVolumeLike(0, buildEmptyDirVolume(0));
  }
  
  public EmptyDirVolumesNested<A> editLastEmptyDirVolume() {
    int index = emptyDirVolumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last emptyDirVolumes. The list is empty.");
    return setNewEmptyDirVolumeLike(index, buildEmptyDirVolume(index));
  }
  
  public EmptyDirVolumesNested<A> editMatchingEmptyDirVolume(Predicate<EmptyDirVolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<emptyDirVolumes.size();i++) { 
    if (predicate.test(emptyDirVolumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching emptyDirVolumes. No match found.");
    return setNewEmptyDirVolumeLike(index, buildEmptyDirVolume(index));
  }
  
  public A withAwsElasticBlockStoreVolumes(io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume... awsElasticBlockStoreVolumes) {
    if (this.awsElasticBlockStoreVolumes != null) {
        this.awsElasticBlockStoreVolumes.clear();
        _visitables.remove("awsElasticBlockStoreVolumes");
    }
    if (awsElasticBlockStoreVolumes != null) {
      for (AwsElasticBlockStoreVolume item : awsElasticBlockStoreVolumes) {
        this.addToAwsElasticBlockStoreVolumes(item);
      }
    }
    return (A) this;
  }
  
  public AwsElasticBlockStoreVolume[] buildAwsElasticBlockStoreVolumes() {
    int size = awsElasticBlockStoreVolumes != null ? awsElasticBlockStoreVolumes.size() : 0;;
    AwsElasticBlockStoreVolume[] result = new AwsElasticBlockStoreVolume[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<AwsElasticBlockStoreVolume,AwsElasticBlockStoreVolumeBuilder> item : awsElasticBlockStoreVolumes) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public AwsElasticBlockStoreVolume buildAwsElasticBlockStoreVolume(int index) {
    return this.awsElasticBlockStoreVolumes.get(index).build();
  }
  
  public AwsElasticBlockStoreVolume buildFirstAwsElasticBlockStoreVolume() {
    return this.awsElasticBlockStoreVolumes.get(0).build();
  }
  
  public AwsElasticBlockStoreVolume buildLastAwsElasticBlockStoreVolume() {
    return this.awsElasticBlockStoreVolumes.get(awsElasticBlockStoreVolumes.size() - 1).build();
  }
  
  public AwsElasticBlockStoreVolume buildMatchingAwsElasticBlockStoreVolume(Predicate<AwsElasticBlockStoreVolumeBuilder> predicate) {
      for (AwsElasticBlockStoreVolumeBuilder item : awsElasticBlockStoreVolumes) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAwsElasticBlockStoreVolume(Predicate<AwsElasticBlockStoreVolumeBuilder> predicate) {
      for (AwsElasticBlockStoreVolumeBuilder item : awsElasticBlockStoreVolumes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToAwsElasticBlockStoreVolumes(int index,AwsElasticBlockStoreVolume item) {
    if (this.awsElasticBlockStoreVolumes == null) {this.awsElasticBlockStoreVolumes = new ArrayList<AwsElasticBlockStoreVolumeBuilder>();}
    AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
    if (index < 0 || index >= awsElasticBlockStoreVolumes.size()) { _visitables.get("awsElasticBlockStoreVolumes").add(builder); awsElasticBlockStoreVolumes.add(builder); } else { _visitables.get("awsElasticBlockStoreVolumes").add(index, builder); awsElasticBlockStoreVolumes.add(index, builder);}
    return (A)this;
  }
  
  public A setToAwsElasticBlockStoreVolumes(int index,AwsElasticBlockStoreVolume item) {
    if (this.awsElasticBlockStoreVolumes == null) {this.awsElasticBlockStoreVolumes = new ArrayList<AwsElasticBlockStoreVolumeBuilder>();}
    AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
    if (index < 0 || index >= awsElasticBlockStoreVolumes.size()) { _visitables.get("awsElasticBlockStoreVolumes").add(builder); awsElasticBlockStoreVolumes.add(builder); } else { _visitables.get("awsElasticBlockStoreVolumes").set(index, builder); awsElasticBlockStoreVolumes.set(index, builder);}
    return (A)this;
  }
  
  public A addToAwsElasticBlockStoreVolumes(io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume... items) {
    if (this.awsElasticBlockStoreVolumes == null) {this.awsElasticBlockStoreVolumes = new ArrayList<AwsElasticBlockStoreVolumeBuilder>();}
    for (AwsElasticBlockStoreVolume item : items) {AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);_visitables.get("awsElasticBlockStoreVolumes").add(builder);this.awsElasticBlockStoreVolumes.add(builder);} return (A)this;
  }
  
  public A addAllToAwsElasticBlockStoreVolumes(Collection<AwsElasticBlockStoreVolume> items) {
    if (this.awsElasticBlockStoreVolumes == null) {this.awsElasticBlockStoreVolumes = new ArrayList<AwsElasticBlockStoreVolumeBuilder>();}
    for (AwsElasticBlockStoreVolume item : items) {AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);_visitables.get("awsElasticBlockStoreVolumes").add(builder);this.awsElasticBlockStoreVolumes.add(builder);} return (A)this;
  }
  
  public A removeFromAwsElasticBlockStoreVolumes(io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume... items) {
    if (this.awsElasticBlockStoreVolumes == null) return (A)this;
    for (AwsElasticBlockStoreVolume item : items) {AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);_visitables.get("awsElasticBlockStoreVolumes").remove(builder); this.awsElasticBlockStoreVolumes.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAwsElasticBlockStoreVolumes(Collection<AwsElasticBlockStoreVolume> items) {
    if (this.awsElasticBlockStoreVolumes == null) return (A)this;
    for (AwsElasticBlockStoreVolume item : items) {AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);_visitables.get("awsElasticBlockStoreVolumes").remove(builder); this.awsElasticBlockStoreVolumes.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAwsElasticBlockStoreVolumes(Predicate<AwsElasticBlockStoreVolumeBuilder> predicate) {
    if (awsElasticBlockStoreVolumes == null) return (A) this;
    final Iterator<AwsElasticBlockStoreVolumeBuilder> each = awsElasticBlockStoreVolumes.iterator();
    final List visitables = _visitables.get("awsElasticBlockStoreVolumes");
    while (each.hasNext()) {
      AwsElasticBlockStoreVolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasAwsElasticBlockStoreVolumes() {
    return this.awsElasticBlockStoreVolumes != null && !this.awsElasticBlockStoreVolumes.isEmpty();
  }
  
  public A addNewAwsElasticBlockStoreVolume(String volumeName,String volumeId,Integer partition,String fsType,Boolean readOnly) {
    return (A)addToAwsElasticBlockStoreVolumes(new AwsElasticBlockStoreVolume(volumeName, volumeId, partition, fsType, readOnly));
  }
  
  public AwsElasticBlockStoreVolumesNested<A> addNewAwsElasticBlockStoreVolume() {
    return new AwsElasticBlockStoreVolumesNested(-1, null);
  }
  
  public AwsElasticBlockStoreVolumesNested<A> addNewAwsElasticBlockStoreVolumeLike(AwsElasticBlockStoreVolume item) {
    return new AwsElasticBlockStoreVolumesNested(-1, item);
  }
  
  public AwsElasticBlockStoreVolumesNested<A> setNewAwsElasticBlockStoreVolumeLike(int index,AwsElasticBlockStoreVolume item) {
    return new AwsElasticBlockStoreVolumesNested(index, item);
  }
  
  public AwsElasticBlockStoreVolumesNested<A> editAwsElasticBlockStoreVolume(int index) {
    if (awsElasticBlockStoreVolumes.size() <= index) throw new RuntimeException("Can't edit awsElasticBlockStoreVolumes. Index exceeds size.");
    return setNewAwsElasticBlockStoreVolumeLike(index, buildAwsElasticBlockStoreVolume(index));
  }
  
  public AwsElasticBlockStoreVolumesNested<A> editFirstAwsElasticBlockStoreVolume() {
    if (awsElasticBlockStoreVolumes.size() == 0) throw new RuntimeException("Can't edit first awsElasticBlockStoreVolumes. The list is empty.");
    return setNewAwsElasticBlockStoreVolumeLike(0, buildAwsElasticBlockStoreVolume(0));
  }
  
  public AwsElasticBlockStoreVolumesNested<A> editLastAwsElasticBlockStoreVolume() {
    int index = awsElasticBlockStoreVolumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last awsElasticBlockStoreVolumes. The list is empty.");
    return setNewAwsElasticBlockStoreVolumeLike(index, buildAwsElasticBlockStoreVolume(index));
  }
  
  public AwsElasticBlockStoreVolumesNested<A> editMatchingAwsElasticBlockStoreVolume(Predicate<AwsElasticBlockStoreVolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<awsElasticBlockStoreVolumes.size();i++) { 
    if (predicate.test(awsElasticBlockStoreVolumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching awsElasticBlockStoreVolumes. No match found.");
    return setNewAwsElasticBlockStoreVolumeLike(index, buildAwsElasticBlockStoreVolume(index));
  }
  
  public A withAzureDiskVolumes(io.dekorate.kubernetes.config.AzureDiskVolume... azureDiskVolumes) {
    if (this.azureDiskVolumes != null) {
        this.azureDiskVolumes.clear();
        _visitables.remove("azureDiskVolumes");
    }
    if (azureDiskVolumes != null) {
      for (AzureDiskVolume item : azureDiskVolumes) {
        this.addToAzureDiskVolumes(item);
      }
    }
    return (A) this;
  }
  
  public AzureDiskVolume[] buildAzureDiskVolumes() {
    int size = azureDiskVolumes != null ? azureDiskVolumes.size() : 0;;
    AzureDiskVolume[] result = new AzureDiskVolume[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<AzureDiskVolume,AzureDiskVolumeBuilder> item : azureDiskVolumes) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public AzureDiskVolume buildAzureDiskVolume(int index) {
    return this.azureDiskVolumes.get(index).build();
  }
  
  public AzureDiskVolume buildFirstAzureDiskVolume() {
    return this.azureDiskVolumes.get(0).build();
  }
  
  public AzureDiskVolume buildLastAzureDiskVolume() {
    return this.azureDiskVolumes.get(azureDiskVolumes.size() - 1).build();
  }
  
  public AzureDiskVolume buildMatchingAzureDiskVolume(Predicate<AzureDiskVolumeBuilder> predicate) {
      for (AzureDiskVolumeBuilder item : azureDiskVolumes) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAzureDiskVolume(Predicate<AzureDiskVolumeBuilder> predicate) {
      for (AzureDiskVolumeBuilder item : azureDiskVolumes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToAzureDiskVolumes(int index,AzureDiskVolume item) {
    if (this.azureDiskVolumes == null) {this.azureDiskVolumes = new ArrayList<AzureDiskVolumeBuilder>();}
    AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
    if (index < 0 || index >= azureDiskVolumes.size()) { _visitables.get("azureDiskVolumes").add(builder); azureDiskVolumes.add(builder); } else { _visitables.get("azureDiskVolumes").add(index, builder); azureDiskVolumes.add(index, builder);}
    return (A)this;
  }
  
  public A setToAzureDiskVolumes(int index,AzureDiskVolume item) {
    if (this.azureDiskVolumes == null) {this.azureDiskVolumes = new ArrayList<AzureDiskVolumeBuilder>();}
    AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
    if (index < 0 || index >= azureDiskVolumes.size()) { _visitables.get("azureDiskVolumes").add(builder); azureDiskVolumes.add(builder); } else { _visitables.get("azureDiskVolumes").set(index, builder); azureDiskVolumes.set(index, builder);}
    return (A)this;
  }
  
  public A addToAzureDiskVolumes(io.dekorate.kubernetes.config.AzureDiskVolume... items) {
    if (this.azureDiskVolumes == null) {this.azureDiskVolumes = new ArrayList<AzureDiskVolumeBuilder>();}
    for (AzureDiskVolume item : items) {AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);_visitables.get("azureDiskVolumes").add(builder);this.azureDiskVolumes.add(builder);} return (A)this;
  }
  
  public A addAllToAzureDiskVolumes(Collection<AzureDiskVolume> items) {
    if (this.azureDiskVolumes == null) {this.azureDiskVolumes = new ArrayList<AzureDiskVolumeBuilder>();}
    for (AzureDiskVolume item : items) {AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);_visitables.get("azureDiskVolumes").add(builder);this.azureDiskVolumes.add(builder);} return (A)this;
  }
  
  public A removeFromAzureDiskVolumes(io.dekorate.kubernetes.config.AzureDiskVolume... items) {
    if (this.azureDiskVolumes == null) return (A)this;
    for (AzureDiskVolume item : items) {AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);_visitables.get("azureDiskVolumes").remove(builder); this.azureDiskVolumes.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAzureDiskVolumes(Collection<AzureDiskVolume> items) {
    if (this.azureDiskVolumes == null) return (A)this;
    for (AzureDiskVolume item : items) {AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);_visitables.get("azureDiskVolumes").remove(builder); this.azureDiskVolumes.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAzureDiskVolumes(Predicate<AzureDiskVolumeBuilder> predicate) {
    if (azureDiskVolumes == null) return (A) this;
    final Iterator<AzureDiskVolumeBuilder> each = azureDiskVolumes.iterator();
    final List visitables = _visitables.get("azureDiskVolumes");
    while (each.hasNext()) {
      AzureDiskVolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasAzureDiskVolumes() {
    return this.azureDiskVolumes != null && !this.azureDiskVolumes.isEmpty();
  }
  
  public AzureDiskVolumesNested<A> addNewAzureDiskVolume() {
    return new AzureDiskVolumesNested(-1, null);
  }
  
  public AzureDiskVolumesNested<A> addNewAzureDiskVolumeLike(AzureDiskVolume item) {
    return new AzureDiskVolumesNested(-1, item);
  }
  
  public AzureDiskVolumesNested<A> setNewAzureDiskVolumeLike(int index,AzureDiskVolume item) {
    return new AzureDiskVolumesNested(index, item);
  }
  
  public AzureDiskVolumesNested<A> editAzureDiskVolume(int index) {
    if (azureDiskVolumes.size() <= index) throw new RuntimeException("Can't edit azureDiskVolumes. Index exceeds size.");
    return setNewAzureDiskVolumeLike(index, buildAzureDiskVolume(index));
  }
  
  public AzureDiskVolumesNested<A> editFirstAzureDiskVolume() {
    if (azureDiskVolumes.size() == 0) throw new RuntimeException("Can't edit first azureDiskVolumes. The list is empty.");
    return setNewAzureDiskVolumeLike(0, buildAzureDiskVolume(0));
  }
  
  public AzureDiskVolumesNested<A> editLastAzureDiskVolume() {
    int index = azureDiskVolumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last azureDiskVolumes. The list is empty.");
    return setNewAzureDiskVolumeLike(index, buildAzureDiskVolume(index));
  }
  
  public AzureDiskVolumesNested<A> editMatchingAzureDiskVolume(Predicate<AzureDiskVolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<azureDiskVolumes.size();i++) { 
    if (predicate.test(azureDiskVolumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching azureDiskVolumes. No match found.");
    return setNewAzureDiskVolumeLike(index, buildAzureDiskVolume(index));
  }
  
  public A withAzureFileVolumes(io.dekorate.kubernetes.config.AzureFileVolume... azureFileVolumes) {
    if (this.azureFileVolumes != null) {
        this.azureFileVolumes.clear();
        _visitables.remove("azureFileVolumes");
    }
    if (azureFileVolumes != null) {
      for (AzureFileVolume item : azureFileVolumes) {
        this.addToAzureFileVolumes(item);
      }
    }
    return (A) this;
  }
  
  public AzureFileVolume[] buildAzureFileVolumes() {
    int size = azureFileVolumes != null ? azureFileVolumes.size() : 0;;
    AzureFileVolume[] result = new AzureFileVolume[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<AzureFileVolume,AzureFileVolumeBuilder> item : azureFileVolumes) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public AzureFileVolume buildAzureFileVolume(int index) {
    return this.azureFileVolumes.get(index).build();
  }
  
  public AzureFileVolume buildFirstAzureFileVolume() {
    return this.azureFileVolumes.get(0).build();
  }
  
  public AzureFileVolume buildLastAzureFileVolume() {
    return this.azureFileVolumes.get(azureFileVolumes.size() - 1).build();
  }
  
  public AzureFileVolume buildMatchingAzureFileVolume(Predicate<AzureFileVolumeBuilder> predicate) {
      for (AzureFileVolumeBuilder item : azureFileVolumes) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAzureFileVolume(Predicate<AzureFileVolumeBuilder> predicate) {
      for (AzureFileVolumeBuilder item : azureFileVolumes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToAzureFileVolumes(int index,AzureFileVolume item) {
    if (this.azureFileVolumes == null) {this.azureFileVolumes = new ArrayList<AzureFileVolumeBuilder>();}
    AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
    if (index < 0 || index >= azureFileVolumes.size()) { _visitables.get("azureFileVolumes").add(builder); azureFileVolumes.add(builder); } else { _visitables.get("azureFileVolumes").add(index, builder); azureFileVolumes.add(index, builder);}
    return (A)this;
  }
  
  public A setToAzureFileVolumes(int index,AzureFileVolume item) {
    if (this.azureFileVolumes == null) {this.azureFileVolumes = new ArrayList<AzureFileVolumeBuilder>();}
    AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
    if (index < 0 || index >= azureFileVolumes.size()) { _visitables.get("azureFileVolumes").add(builder); azureFileVolumes.add(builder); } else { _visitables.get("azureFileVolumes").set(index, builder); azureFileVolumes.set(index, builder);}
    return (A)this;
  }
  
  public A addToAzureFileVolumes(io.dekorate.kubernetes.config.AzureFileVolume... items) {
    if (this.azureFileVolumes == null) {this.azureFileVolumes = new ArrayList<AzureFileVolumeBuilder>();}
    for (AzureFileVolume item : items) {AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);_visitables.get("azureFileVolumes").add(builder);this.azureFileVolumes.add(builder);} return (A)this;
  }
  
  public A addAllToAzureFileVolumes(Collection<AzureFileVolume> items) {
    if (this.azureFileVolumes == null) {this.azureFileVolumes = new ArrayList<AzureFileVolumeBuilder>();}
    for (AzureFileVolume item : items) {AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);_visitables.get("azureFileVolumes").add(builder);this.azureFileVolumes.add(builder);} return (A)this;
  }
  
  public A removeFromAzureFileVolumes(io.dekorate.kubernetes.config.AzureFileVolume... items) {
    if (this.azureFileVolumes == null) return (A)this;
    for (AzureFileVolume item : items) {AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);_visitables.get("azureFileVolumes").remove(builder); this.azureFileVolumes.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAzureFileVolumes(Collection<AzureFileVolume> items) {
    if (this.azureFileVolumes == null) return (A)this;
    for (AzureFileVolume item : items) {AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);_visitables.get("azureFileVolumes").remove(builder); this.azureFileVolumes.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAzureFileVolumes(Predicate<AzureFileVolumeBuilder> predicate) {
    if (azureFileVolumes == null) return (A) this;
    final Iterator<AzureFileVolumeBuilder> each = azureFileVolumes.iterator();
    final List visitables = _visitables.get("azureFileVolumes");
    while (each.hasNext()) {
      AzureFileVolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasAzureFileVolumes() {
    return this.azureFileVolumes != null && !this.azureFileVolumes.isEmpty();
  }
  
  public A addNewAzureFileVolume(String volumeName,String shareName,String secretName,Boolean readOnly) {
    return (A)addToAzureFileVolumes(new AzureFileVolume(volumeName, shareName, secretName, readOnly));
  }
  
  public AzureFileVolumesNested<A> addNewAzureFileVolume() {
    return new AzureFileVolumesNested(-1, null);
  }
  
  public AzureFileVolumesNested<A> addNewAzureFileVolumeLike(AzureFileVolume item) {
    return new AzureFileVolumesNested(-1, item);
  }
  
  public AzureFileVolumesNested<A> setNewAzureFileVolumeLike(int index,AzureFileVolume item) {
    return new AzureFileVolumesNested(index, item);
  }
  
  public AzureFileVolumesNested<A> editAzureFileVolume(int index) {
    if (azureFileVolumes.size() <= index) throw new RuntimeException("Can't edit azureFileVolumes. Index exceeds size.");
    return setNewAzureFileVolumeLike(index, buildAzureFileVolume(index));
  }
  
  public AzureFileVolumesNested<A> editFirstAzureFileVolume() {
    if (azureFileVolumes.size() == 0) throw new RuntimeException("Can't edit first azureFileVolumes. The list is empty.");
    return setNewAzureFileVolumeLike(0, buildAzureFileVolume(0));
  }
  
  public AzureFileVolumesNested<A> editLastAzureFileVolume() {
    int index = azureFileVolumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last azureFileVolumes. The list is empty.");
    return setNewAzureFileVolumeLike(index, buildAzureFileVolume(index));
  }
  
  public AzureFileVolumesNested<A> editMatchingAzureFileVolume(Predicate<AzureFileVolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<azureFileVolumes.size();i++) { 
    if (predicate.test(azureFileVolumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching azureFileVolumes. No match found.");
    return setNewAzureFileVolumeLike(index, buildAzureFileVolume(index));
  }
  
  public A withContainers(io.dekorate.kubernetes.config.Container... containers) {
    if (this.containers != null) {
        this.containers.clear();
        _visitables.remove("containers");
    }
    if (containers != null) {
      for (Container item : containers) {
        this.addToContainers(item);
      }
    }
    return (A) this;
  }
  
  public Container[] buildContainers() {
    int size = containers != null ? containers.size() : 0;;
    Container[] result = new Container[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<Container,ContainerBuilder> item : containers) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public Container buildContainer(int index) {
    return this.containers.get(index).build();
  }
  
  public Container buildFirstContainer() {
    return this.containers.get(0).build();
  }
  
  public Container buildLastContainer() {
    return this.containers.get(containers.size() - 1).build();
  }
  
  public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate) {
      for (ContainerBuilder item : containers) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate) {
      for (ContainerBuilder item : containers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToContainers(int index,Container item) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= containers.size()) { _visitables.get("containers").add(builder); containers.add(builder); } else { _visitables.get("containers").add(index, builder); containers.add(index, builder);}
    return (A)this;
  }
  
  public A setToContainers(int index,Container item) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= containers.size()) { _visitables.get("containers").add(builder); containers.add(builder); } else { _visitables.get("containers").set(index, builder); containers.set(index, builder);}
    return (A)this;
  }
  
  public A addToContainers(io.dekorate.kubernetes.config.Container... items) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
  }
  
  public A addAllToContainers(Collection<Container> items) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
  }
  
  public A removeFromContainers(io.dekorate.kubernetes.config.Container... items) {
    if (this.containers == null) return (A)this;
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").remove(builder); this.containers.remove(builder);} return (A)this;
  }
  
  public A removeAllFromContainers(Collection<Container> items) {
    if (this.containers == null) return (A)this;
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").remove(builder); this.containers.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate) {
    if (containers == null) return (A) this;
    final Iterator<ContainerBuilder> each = containers.iterator();
    final List visitables = _visitables.get("containers");
    while (each.hasNext()) {
      ContainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasContainers() {
    return this.containers != null && !this.containers.isEmpty();
  }
  
  public ContainersNested<A> addNewContainer() {
    return new ContainersNested(-1, null);
  }
  
  public ContainersNested<A> addNewContainerLike(Container item) {
    return new ContainersNested(-1, item);
  }
  
  public ContainersNested<A> setNewContainerLike(int index,Container item) {
    return new ContainersNested(index, item);
  }
  
  public ContainersNested<A> editContainer(int index) {
    if (containers.size() <= index) throw new RuntimeException("Can't edit containers. Index exceeds size.");
    return setNewContainerLike(index, buildContainer(index));
  }
  
  public ContainersNested<A> editFirstContainer() {
    if (containers.size() == 0) throw new RuntimeException("Can't edit first containers. The list is empty.");
    return setNewContainerLike(0, buildContainer(0));
  }
  
  public ContainersNested<A> editLastContainer() {
    int index = containers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last containers. The list is empty.");
    return setNewContainerLike(index, buildContainer(index));
  }
  
  public ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<containers.size();i++) { 
    if (predicate.test(containers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching containers. No match found.");
    return setNewContainerLike(index, buildContainer(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JobFluent that = (JobFluent) o;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(parallelism, that.parallelism)) return false;
    if (!java.util.Objects.equals(completions, that.completions)) return false;
    if (!java.util.Objects.equals(completionMode, that.completionMode)) return false;
    if (!java.util.Objects.equals(backoffLimit, that.backoffLimit)) return false;
    if (!java.util.Objects.equals(activeDeadlineSeconds, that.activeDeadlineSeconds)) return false;
    if (!java.util.Objects.equals(ttlSecondsAfterFinished, that.ttlSecondsAfterFinished)) return false;
    if (!java.util.Objects.equals(suspend, that.suspend)) return false;
    if (!java.util.Objects.equals(restartPolicy, that.restartPolicy)) return false;
    if (!java.util.Objects.equals(pvcVolumes, that.pvcVolumes)) return false;
    if (!java.util.Objects.equals(secretVolumes, that.secretVolumes)) return false;
    if (!java.util.Objects.equals(configMapVolumes, that.configMapVolumes)) return false;
    if (!java.util.Objects.equals(emptyDirVolumes, that.emptyDirVolumes)) return false;
    if (!java.util.Objects.equals(awsElasticBlockStoreVolumes, that.awsElasticBlockStoreVolumes)) return false;
    if (!java.util.Objects.equals(azureDiskVolumes, that.azureDiskVolumes)) return false;
    if (!java.util.Objects.equals(azureFileVolumes, that.azureFileVolumes)) return false;
    if (!java.util.Objects.equals(containers, that.containers)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(name,  parallelism,  completions,  completionMode,  backoffLimit,  activeDeadlineSeconds,  ttlSecondsAfterFinished,  suspend,  restartPolicy,  pvcVolumes,  secretVolumes,  configMapVolumes,  emptyDirVolumes,  awsElasticBlockStoreVolumes,  azureDiskVolumes,  azureFileVolumes,  containers,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (parallelism != null) { sb.append("parallelism:"); sb.append(parallelism + ","); }
    if (completions != null) { sb.append("completions:"); sb.append(completions + ","); }
    if (completionMode != null) { sb.append("completionMode:"); sb.append(completionMode + ","); }
    if (backoffLimit != null) { sb.append("backoffLimit:"); sb.append(backoffLimit + ","); }
    if (activeDeadlineSeconds != null) { sb.append("activeDeadlineSeconds:"); sb.append(activeDeadlineSeconds + ","); }
    if (ttlSecondsAfterFinished != null) { sb.append("ttlSecondsAfterFinished:"); sb.append(ttlSecondsAfterFinished + ","); }
    if (suspend != null) { sb.append("suspend:"); sb.append(suspend + ","); }
    if (restartPolicy != null) { sb.append("restartPolicy:"); sb.append(restartPolicy + ","); }
    if (pvcVolumes != null && !pvcVolumes.isEmpty()) { sb.append("pvcVolumes:"); sb.append(pvcVolumes + ","); }
    if (secretVolumes != null && !secretVolumes.isEmpty()) { sb.append("secretVolumes:"); sb.append(secretVolumes + ","); }
    if (configMapVolumes != null && !configMapVolumes.isEmpty()) { sb.append("configMapVolumes:"); sb.append(configMapVolumes + ","); }
    if (emptyDirVolumes != null && !emptyDirVolumes.isEmpty()) { sb.append("emptyDirVolumes:"); sb.append(emptyDirVolumes + ","); }
    if (awsElasticBlockStoreVolumes != null && !awsElasticBlockStoreVolumes.isEmpty()) { sb.append("awsElasticBlockStoreVolumes:"); sb.append(awsElasticBlockStoreVolumes + ","); }
    if (azureDiskVolumes != null && !azureDiskVolumes.isEmpty()) { sb.append("azureDiskVolumes:"); sb.append(azureDiskVolumes + ","); }
    if (azureFileVolumes != null && !azureFileVolumes.isEmpty()) { sb.append("azureFileVolumes:"); sb.append(azureFileVolumes + ","); }
    if (containers != null && !containers.isEmpty()) { sb.append("containers:"); sb.append(containers); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withSuspend() {
    return withSuspend(true);
  }
  public class PvcVolumesNested<N> extends PersistentVolumeClaimVolumeFluent<PvcVolumesNested<N>> implements Nested<N>{
    PvcVolumesNested(int index,PersistentVolumeClaimVolume item) {
      this.index = index;
      this.builder = new PersistentVolumeClaimVolumeBuilder(this, item);
    }
    PersistentVolumeClaimVolumeBuilder builder;
    int index;
    
    public N and() {
      return (N) JobFluent.this.setToPvcVolumes(index,builder.build());
    }
    
    public N endPvcVolume() {
      return and();
    }
    
  
  }
  public class SecretVolumesNested<N> extends SecretVolumeFluent<SecretVolumesNested<N>> implements Nested<N>{
    SecretVolumesNested(int index,SecretVolume item) {
      this.index = index;
      this.builder = new SecretVolumeBuilder(this, item);
    }
    SecretVolumeBuilder builder;
    int index;
    
    public N and() {
      return (N) JobFluent.this.setToSecretVolumes(index,builder.build());
    }
    
    public N endSecretVolume() {
      return and();
    }
    
  
  }
  public class ConfigMapVolumesNested<N> extends ConfigMapVolumeFluent<ConfigMapVolumesNested<N>> implements Nested<N>{
    ConfigMapVolumesNested(int index,ConfigMapVolume item) {
      this.index = index;
      this.builder = new ConfigMapVolumeBuilder(this, item);
    }
    ConfigMapVolumeBuilder builder;
    int index;
    
    public N and() {
      return (N) JobFluent.this.setToConfigMapVolumes(index,builder.build());
    }
    
    public N endConfigMapVolume() {
      return and();
    }
    
  
  }
  public class EmptyDirVolumesNested<N> extends EmptyDirVolumeFluent<EmptyDirVolumesNested<N>> implements Nested<N>{
    EmptyDirVolumesNested(int index,EmptyDirVolume item) {
      this.index = index;
      this.builder = new EmptyDirVolumeBuilder(this, item);
    }
    EmptyDirVolumeBuilder builder;
    int index;
    
    public N and() {
      return (N) JobFluent.this.setToEmptyDirVolumes(index,builder.build());
    }
    
    public N endEmptyDirVolume() {
      return and();
    }
    
  
  }
  public class AwsElasticBlockStoreVolumesNested<N> extends AwsElasticBlockStoreVolumeFluent<AwsElasticBlockStoreVolumesNested<N>> implements Nested<N>{
    AwsElasticBlockStoreVolumesNested(int index,AwsElasticBlockStoreVolume item) {
      this.index = index;
      this.builder = new AwsElasticBlockStoreVolumeBuilder(this, item);
    }
    AwsElasticBlockStoreVolumeBuilder builder;
    int index;
    
    public N and() {
      return (N) JobFluent.this.setToAwsElasticBlockStoreVolumes(index,builder.build());
    }
    
    public N endAwsElasticBlockStoreVolume() {
      return and();
    }
    
  
  }
  public class AzureDiskVolumesNested<N> extends AzureDiskVolumeFluent<AzureDiskVolumesNested<N>> implements Nested<N>{
    AzureDiskVolumesNested(int index,AzureDiskVolume item) {
      this.index = index;
      this.builder = new AzureDiskVolumeBuilder(this, item);
    }
    AzureDiskVolumeBuilder builder;
    int index;
    
    public N and() {
      return (N) JobFluent.this.setToAzureDiskVolumes(index,builder.build());
    }
    
    public N endAzureDiskVolume() {
      return and();
    }
    
  
  }
  public class AzureFileVolumesNested<N> extends AzureFileVolumeFluent<AzureFileVolumesNested<N>> implements Nested<N>{
    AzureFileVolumesNested(int index,AzureFileVolume item) {
      this.index = index;
      this.builder = new AzureFileVolumeBuilder(this, item);
    }
    AzureFileVolumeBuilder builder;
    int index;
    
    public N and() {
      return (N) JobFluent.this.setToAzureFileVolumes(index,builder.build());
    }
    
    public N endAzureFileVolume() {
      return and();
    }
    
  
  }
  public class ContainersNested<N> extends ContainerFluent<ContainersNested<N>> implements Nested<N>{
    ContainersNested(int index,Container item) {
      this.index = index;
      this.builder = new ContainerBuilder(this, item);
    }
    ContainerBuilder builder;
    int index;
    
    public N and() {
      return (N) JobFluent.this.setToContainers(index,builder.build());
    }
    
    public N endContainer() {
      return and();
    }
    
  
  }

}