package io.dekorate.kubernetes.config;

import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class Mount{
  public Mount() {
  }
  
  public Mount(String name,String path,String subPath,Boolean readOnly) {
    this.name = name;
    this.path = path;
    this.subPath = subPath;
    this.readOnly = readOnly;
  }
  private String name;
  private String path;
  private String subPath;
  private Boolean readOnly;
  
  
  /**
   * The name of the volumeName to mount.
   * @return The name.
   */
  public String getName() {
    return this.name;
  }
  
  
  /**
   * The path to mount.
   * @return The path.
   */
  public String getPath() {
    return this.path;
  }
  
  
  /**
   * Path within the volumeName from which the container's volumeName should be mounted.
   * @return The subPath.
   */
  public String getSubPath() {
    return this.subPath;
  }
  
  
  /**
   * ReadOnly
   * @return True if mount is readonly, False otherwise.
   */
  public Boolean getReadOnly() {
    return this.readOnly;
  }
  
  
  /**
   * ReadOnly
   * @return True if mount is readonly, False otherwise.
   */
  public boolean isReadOnly() {
    return this.readOnly != null &&  this.readOnly;
  }
  
  public static MountBuilder newBuilder() {
    return new MountBuilder();
  }
  
  public static MountBuilder newBuilderFromDefaults() {
    return new MountBuilder().withReadOnly(false);
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    Mount that = (Mount) o;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(path, that.path)) return false;
    if (!java.util.Objects.equals(subPath, that.subPath)) return false;
    if (!java.util.Objects.equals(readOnly, that.readOnly)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(name,  path,  subPath,  readOnly,  super.hashCode());
  }
  

}