package io.dekorate.kubernetes.config;

import io.dekorate.project.Project;
import java.lang.Object;
import io.dekorate.kubernetes.annotation.AccessMode;
import java.lang.String;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(builderPackage = "io.fabric8.kubernetes.api.builder")
public class PersistentVolumeClaimConfig extends ApplicationConfiguration{
  public PersistentVolumeClaimConfig() {
  }
  
  public PersistentVolumeClaimConfig(Project project,Map<ConfigKey,Object> attributes,String partOf,String name,String version,int size,String unit,String storageClass,AccessMode accessMode,Label[] matchLabels) {
    super(project, attributes, partOf, name, version);
    this.size = size;
    this.unit = unit;
    this.storageClass = storageClass;
    this.accessMode = accessMode;
    this.matchLabels = matchLabels != null ? matchLabels : new Label[0];
  }
  private int size;
  private String unit;
  private String storageClass;
  private AccessMode accessMode;
  private Label[] matchLabels = new Label[0];
  
  public int getSize() {
    return this.size;
  }
  
  public String getUnit() {
    return this.unit;
  }
  
  public String getStorageClass() {
    return this.storageClass;
  }
  
  public AccessMode getAccessMode() {
    return this.accessMode;
  }
  
  public Label[] getMatchLabels() {
    return this.matchLabels;
  }
  
  public static PersistentVolumeClaimConfigBuilder newPersistentVolumeClaimConfigBuilder() {
    return new PersistentVolumeClaimConfigBuilder();
  }
  
  public static PersistentVolumeClaimConfigBuilder newPersistentVolumeClaimConfigBuilderFromDefaults() {
    return new PersistentVolumeClaimConfigBuilder().withSize(1).withUnit("Gi").withStorageClass("standard").withAccessMode(io.dekorate.kubernetes.annotation.AccessMode.ReadWriteOnce);
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PersistentVolumeClaimConfig that = (PersistentVolumeClaimConfig) o;
    if (size != that.size) return false;
    if (!java.util.Objects.equals(unit, that.unit)) return false;
    if (!java.util.Objects.equals(storageClass, that.storageClass)) return false;
    if (!java.util.Objects.equals(accessMode, that.accessMode)) return false;
    if (!java.util.Objects.equals(matchLabels, that.matchLabels)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(size,  unit,  storageClass,  accessMode,  matchLabels,  super.hashCode());
  }
  

}