package io.dekorate.kubernetes.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import io.dekorate.kubernetes.annotation.AccessMode;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PersistentVolumeClaimConfigFluent<A extends PersistentVolumeClaimConfigFluent<A>> extends ApplicationConfigurationFluent<A>{
  public PersistentVolumeClaimConfigFluent() {
  }
  
  public PersistentVolumeClaimConfigFluent(PersistentVolumeClaimConfig instance) {
    this.copyInstance(instance);
  }
  private int size;
  private String unit;
  private String storageClass;
  private AccessMode accessMode;
  private ArrayList<LabelBuilder> matchLabels = new ArrayList<LabelBuilder>();
  
  protected void copyInstance(PersistentVolumeClaimConfig instance) {
    instance = (instance != null ? instance : new PersistentVolumeClaimConfig());
    if (instance != null) {
          this.withProject(instance.getProject());
          this.withAttributes(instance.getAttributes());
          this.withPartOf(instance.getPartOf());
          this.withName(instance.getName());
          this.withVersion(instance.getVersion());
          this.withSize(instance.getSize());
          this.withUnit(instance.getUnit());
          this.withStorageClass(instance.getStorageClass());
          this.withAccessMode(instance.getAccessMode());
          this.withMatchLabels(instance.getMatchLabels());
        }
  }
  
  public int getSize() {
    return this.size;
  }
  
  public A withSize(int size) {
    this.size = size;
    return (A) this;
  }
  
  public boolean hasSize() {
    return true;
  }
  
  public String getUnit() {
    return this.unit;
  }
  
  public A withUnit(String unit) {
    this.unit = unit;
    return (A) this;
  }
  
  public boolean hasUnit() {
    return this.unit != null;
  }
  
  public String getStorageClass() {
    return this.storageClass;
  }
  
  public A withStorageClass(String storageClass) {
    this.storageClass = storageClass;
    return (A) this;
  }
  
  public boolean hasStorageClass() {
    return this.storageClass != null;
  }
  
  public AccessMode getAccessMode() {
    return this.accessMode;
  }
  
  public A withAccessMode(AccessMode accessMode) {
    this.accessMode = accessMode;
    return (A) this;
  }
  
  public boolean hasAccessMode() {
    return this.accessMode != null;
  }
  
  public A withMatchLabels(io.dekorate.kubernetes.config.Label... matchLabels) {
    if (this.matchLabels != null) {
        this.matchLabels.clear();
        _visitables.remove("matchLabels");
    }
    if (matchLabels != null) {
      for (Label item : matchLabels) {
        this.addToMatchLabels(item);
      }
    }
    return (A) this;
  }
  
  public Label[] buildMatchLabels() {
    int size = matchLabels != null ? matchLabels.size() : 0;;
    Label[] result = new Label[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<Label,LabelBuilder> item : matchLabels) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public Label buildMatchLabel(int index) {
    return this.matchLabels.get(index).build();
  }
  
  public Label buildFirstMatchLabel() {
    return this.matchLabels.get(0).build();
  }
  
  public Label buildLastMatchLabel() {
    return this.matchLabels.get(matchLabels.size() - 1).build();
  }
  
  public Label buildMatchingMatchLabel(Predicate<LabelBuilder> predicate) {
      for (LabelBuilder item : matchLabels) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingMatchLabel(Predicate<LabelBuilder> predicate) {
      for (LabelBuilder item : matchLabels) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToMatchLabels(int index,Label item) {
    if (this.matchLabels == null) {this.matchLabels = new ArrayList<LabelBuilder>();}
    LabelBuilder builder = new LabelBuilder(item);
    if (index < 0 || index >= matchLabels.size()) { _visitables.get("matchLabels").add(builder); matchLabels.add(builder); } else { _visitables.get("matchLabels").add(index, builder); matchLabels.add(index, builder);}
    return (A)this;
  }
  
  public A setToMatchLabels(int index,Label item) {
    if (this.matchLabels == null) {this.matchLabels = new ArrayList<LabelBuilder>();}
    LabelBuilder builder = new LabelBuilder(item);
    if (index < 0 || index >= matchLabels.size()) { _visitables.get("matchLabels").add(builder); matchLabels.add(builder); } else { _visitables.get("matchLabels").set(index, builder); matchLabels.set(index, builder);}
    return (A)this;
  }
  
  public A addToMatchLabels(io.dekorate.kubernetes.config.Label... items) {
    if (this.matchLabels == null) {this.matchLabels = new ArrayList<LabelBuilder>();}
    for (Label item : items) {LabelBuilder builder = new LabelBuilder(item);_visitables.get("matchLabels").add(builder);this.matchLabels.add(builder);} return (A)this;
  }
  
  public A addAllToMatchLabels(Collection<Label> items) {
    if (this.matchLabels == null) {this.matchLabels = new ArrayList<LabelBuilder>();}
    for (Label item : items) {LabelBuilder builder = new LabelBuilder(item);_visitables.get("matchLabels").add(builder);this.matchLabels.add(builder);} return (A)this;
  }
  
  public A removeFromMatchLabels(io.dekorate.kubernetes.config.Label... items) {
    if (this.matchLabels == null) return (A)this;
    for (Label item : items) {LabelBuilder builder = new LabelBuilder(item);_visitables.get("matchLabels").remove(builder); this.matchLabels.remove(builder);} return (A)this;
  }
  
  public A removeAllFromMatchLabels(Collection<Label> items) {
    if (this.matchLabels == null) return (A)this;
    for (Label item : items) {LabelBuilder builder = new LabelBuilder(item);_visitables.get("matchLabels").remove(builder); this.matchLabels.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromMatchLabels(Predicate<LabelBuilder> predicate) {
    if (matchLabels == null) return (A) this;
    final Iterator<LabelBuilder> each = matchLabels.iterator();
    final List visitables = _visitables.get("matchLabels");
    while (each.hasNext()) {
      LabelBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasMatchLabels() {
    return this.matchLabels != null && !this.matchLabels.isEmpty();
  }
  
  public A addNewMatchLabel(String key,String value,String[] kinds) {
    return (A)addToMatchLabels(new Label(key, value, kinds));
  }
  
  public MatchLabelsNested<A> addNewMatchLabel() {
    return new MatchLabelsNested(-1, null);
  }
  
  public MatchLabelsNested<A> addNewMatchLabelLike(Label item) {
    return new MatchLabelsNested(-1, item);
  }
  
  public MatchLabelsNested<A> setNewMatchLabelLike(int index,Label item) {
    return new MatchLabelsNested(index, item);
  }
  
  public MatchLabelsNested<A> editMatchLabel(int index) {
    if (matchLabels.size() <= index) throw new RuntimeException("Can't edit matchLabels. Index exceeds size.");
    return setNewMatchLabelLike(index, buildMatchLabel(index));
  }
  
  public MatchLabelsNested<A> editFirstMatchLabel() {
    if (matchLabels.size() == 0) throw new RuntimeException("Can't edit first matchLabels. The list is empty.");
    return setNewMatchLabelLike(0, buildMatchLabel(0));
  }
  
  public MatchLabelsNested<A> editLastMatchLabel() {
    int index = matchLabels.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last matchLabels. The list is empty.");
    return setNewMatchLabelLike(index, buildMatchLabel(index));
  }
  
  public MatchLabelsNested<A> editMatchingMatchLabel(Predicate<LabelBuilder> predicate) {
    int index = -1;
    for (int i=0;i<matchLabels.size();i++) { 
    if (predicate.test(matchLabels.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching matchLabels. No match found.");
    return setNewMatchLabelLike(index, buildMatchLabel(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PersistentVolumeClaimConfigFluent that = (PersistentVolumeClaimConfigFluent) o;
    if (size != that.size) return false;
    if (!java.util.Objects.equals(unit, that.unit)) return false;
    if (!java.util.Objects.equals(storageClass, that.storageClass)) return false;
    if (!java.util.Objects.equals(accessMode, that.accessMode)) return false;
    if (!java.util.Objects.equals(matchLabels, that.matchLabels)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(size,  unit,  storageClass,  accessMode,  matchLabels,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    sb.append("size:"); sb.append(size + ",");
    if (unit != null) { sb.append("unit:"); sb.append(unit + ","); }
    if (storageClass != null) { sb.append("storageClass:"); sb.append(storageClass + ","); }
    if (accessMode != null) { sb.append("accessMode:"); sb.append(accessMode + ","); }
    if (matchLabels != null && !matchLabels.isEmpty()) { sb.append("matchLabels:"); sb.append(matchLabels); }
    sb.append("}");
    return sb.toString();
  }
  public class MatchLabelsNested<N> extends LabelFluent<MatchLabelsNested<N>> implements Nested<N>{
    MatchLabelsNested(int index,Label item) {
      this.index = index;
      this.builder = new LabelBuilder(this, item);
    }
    LabelBuilder builder;
    int index;
    
    public N and() {
      return (N) PersistentVolumeClaimConfigFluent.this.setToMatchLabels(index,builder.build());
    }
    
    public N endMatchLabel() {
      return and();
    }
    
  
  }

}