package io.dekorate.kubernetes.config;

import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class PersistentVolumeClaimVolume{
  public PersistentVolumeClaimVolume() {
  }
  
  public PersistentVolumeClaimVolume(String volumeName,String claimName,Boolean readOnly) {
    this.volumeName = volumeName;
    this.claimName = claimName;
    this.readOnly = readOnly;
  }
  private String volumeName;
  private String claimName;
  private Boolean readOnly;
  
  
  /**
   * The volumeName name.
   * @return The volumeName name.
   */
  public String getVolumeName() {
    return this.volumeName;
  }
  
  
  /**
   * The persistent volumeName claim name.
   * @return The name of the pvcVolume.
   */
  public String getClaimName() {
    return this.claimName;
  }
  
  
  /**
   * Wether the volumeName is read only or not.
   * @return True if read only, False otherwise.
   */
  public Boolean getReadOnly() {
    return this.readOnly;
  }
  
  
  /**
   * Wether the volumeName is read only or not.
   * @return True if read only, False otherwise.
   */
  public boolean isReadOnly() {
    return this.readOnly != null &&  this.readOnly;
  }
  
  public static PersistentVolumeClaimVolumeBuilder newBuilder() {
    return new PersistentVolumeClaimVolumeBuilder();
  }
  
  public static PersistentVolumeClaimVolumeBuilder newBuilderFromDefaults() {
    return new PersistentVolumeClaimVolumeBuilder().withReadOnly(false);
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PersistentVolumeClaimVolume that = (PersistentVolumeClaimVolume) o;
    if (!java.util.Objects.equals(volumeName, that.volumeName)) return false;
    if (!java.util.Objects.equals(claimName, that.claimName)) return false;
    if (!java.util.Objects.equals(readOnly, that.readOnly)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(volumeName,  claimName,  readOnly,  super.hashCode());
  }
  

}