package io.dekorate.kubernetes.config;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PersistentVolumeClaimVolumeFluent<A extends PersistentVolumeClaimVolumeFluent<A>> extends BaseFluent<A>{
  public PersistentVolumeClaimVolumeFluent() {
  }
  
  public PersistentVolumeClaimVolumeFluent(PersistentVolumeClaimVolume instance) {
    this.copyInstance(instance);
  }
  private String volumeName;
  private String claimName;
  private Boolean readOnly;
  
  protected void copyInstance(PersistentVolumeClaimVolume instance) {
    instance = (instance != null ? instance : new PersistentVolumeClaimVolume());
    if (instance != null) {
          this.withVolumeName(instance.getVolumeName());
          this.withClaimName(instance.getClaimName());
          this.withReadOnly(instance.getReadOnly());
        }
  }
  
  public String getVolumeName() {
    return this.volumeName;
  }
  
  public A withVolumeName(String volumeName) {
    this.volumeName = volumeName;
    return (A) this;
  }
  
  public boolean hasVolumeName() {
    return this.volumeName != null;
  }
  
  public String getClaimName() {
    return this.claimName;
  }
  
  public A withClaimName(String claimName) {
    this.claimName = claimName;
    return (A) this;
  }
  
  public boolean hasClaimName() {
    return this.claimName != null;
  }
  
  public Boolean getReadOnly() {
    return this.readOnly;
  }
  
  public A withReadOnly(Boolean readOnly) {
    this.readOnly = readOnly;
    return (A) this;
  }
  
  public boolean hasReadOnly() {
    return this.readOnly != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PersistentVolumeClaimVolumeFluent that = (PersistentVolumeClaimVolumeFluent) o;
    if (!java.util.Objects.equals(volumeName, that.volumeName)) return false;
    if (!java.util.Objects.equals(claimName, that.claimName)) return false;
    if (!java.util.Objects.equals(readOnly, that.readOnly)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(volumeName,  claimName,  readOnly,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (volumeName != null) { sb.append("volumeName:"); sb.append(volumeName + ","); }
    if (claimName != null) { sb.append("claimName:"); sb.append(claimName + ","); }
    if (readOnly != null) { sb.append("readOnly:"); sb.append(readOnly); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withReadOnly() {
    return withReadOnly(true);
  }
  

}