package io.dekorate.kubernetes.config;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import io.dekorate.kubernetes.annotation.Protocol;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class Port{
  public Port() {
  }
  
  public Port(String name,Integer containerPort,Integer hostPort,Integer nodePort,String path,Protocol protocol) {
    this.name = name;
    this.containerPort = containerPort;
    this.hostPort = hostPort;
    this.nodePort = nodePort;
    this.path = path;
    this.protocol = protocol;
  }
  private String name;
  private Integer containerPort;
  private Integer hostPort;
  private Integer nodePort;
  private String path;
  private Protocol protocol;
  
  
  /**
   * The container port name.
   * @return The name.
   */
  public String getName() {
    return this.name;
  }
  
  
  /**
   * The port number. Refers to the container port.
   * @return The port number.
   */
  public Integer getContainerPort() {
    return this.containerPort;
  }
  
  
  /**
   * The host port.
   * When a host port is not specified (or is set to 0) then the container port will be used.
   * @return The host port, or 0 if none specified.
   */
  public Integer getHostPort() {
    return this.hostPort;
  }
  
  
  /**
   * The port number. Refers to the container port.
   * @return The port number.
   */
  public Integer getNodePort() {
    return this.nodePort;
  }
  
  
  /**
   * The application path (refers to web application path).
   * @return The path, defaults to /.
   */
  public String getPath() {
    return this.path;
  }
  
  public Protocol getProtocol() {
    return this.protocol;
  }
  
  public static PortBuilder newBuilder() {
    return new PortBuilder();
  }
  
  public static PortBuilder newBuilderFromDefaults() {
    return new PortBuilder().withHostPort(0).withNodePort(0).withPath("/").withProtocol(io.dekorate.kubernetes.annotation.Protocol.TCP);
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    Port that = (Port) o;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(containerPort, that.containerPort)) return false;
    if (!java.util.Objects.equals(hostPort, that.hostPort)) return false;
    if (!java.util.Objects.equals(nodePort, that.nodePort)) return false;
    if (!java.util.Objects.equals(path, that.path)) return false;
    if (!java.util.Objects.equals(protocol, that.protocol)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(name,  containerPort,  hostPort,  nodePort,  path,  protocol,  super.hashCode());
  }
  

}