package io.dekorate.kubernetes.config;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import io.dekorate.kubernetes.annotation.Protocol;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PortFluent<A extends PortFluent<A>> extends BaseFluent<A>{
  public PortFluent() {
  }
  
  public PortFluent(Port instance) {
    this.copyInstance(instance);
  }
  private String name;
  private Integer containerPort;
  private Integer hostPort;
  private Integer nodePort;
  private String path;
  private Protocol protocol;
  
  protected void copyInstance(Port instance) {
    instance = (instance != null ? instance : new Port());
    if (instance != null) {
          this.withName(instance.getName());
          this.withContainerPort(instance.getContainerPort());
          this.withHostPort(instance.getHostPort());
          this.withNodePort(instance.getNodePort());
          this.withPath(instance.getPath());
          this.withProtocol(instance.getProtocol());
        }
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public Integer getContainerPort() {
    return this.containerPort;
  }
  
  public A withContainerPort(Integer containerPort) {
    this.containerPort = containerPort;
    return (A) this;
  }
  
  public boolean hasContainerPort() {
    return this.containerPort != null;
  }
  
  public Integer getHostPort() {
    return this.hostPort;
  }
  
  public A withHostPort(Integer hostPort) {
    this.hostPort = hostPort;
    return (A) this;
  }
  
  public boolean hasHostPort() {
    return this.hostPort != null;
  }
  
  public Integer getNodePort() {
    return this.nodePort;
  }
  
  public A withNodePort(Integer nodePort) {
    this.nodePort = nodePort;
    return (A) this;
  }
  
  public boolean hasNodePort() {
    return this.nodePort != null;
  }
  
  public String getPath() {
    return this.path;
  }
  
  public A withPath(String path) {
    this.path = path;
    return (A) this;
  }
  
  public boolean hasPath() {
    return this.path != null;
  }
  
  public Protocol getProtocol() {
    return this.protocol;
  }
  
  public A withProtocol(Protocol protocol) {
    this.protocol = protocol;
    return (A) this;
  }
  
  public boolean hasProtocol() {
    return this.protocol != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PortFluent that = (PortFluent) o;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(containerPort, that.containerPort)) return false;
    if (!java.util.Objects.equals(hostPort, that.hostPort)) return false;
    if (!java.util.Objects.equals(nodePort, that.nodePort)) return false;
    if (!java.util.Objects.equals(path, that.path)) return false;
    if (!java.util.Objects.equals(protocol, that.protocol)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(name,  containerPort,  hostPort,  nodePort,  path,  protocol,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (containerPort != null) { sb.append("containerPort:"); sb.append(containerPort + ","); }
    if (hostPort != null) { sb.append("hostPort:"); sb.append(hostPort + ","); }
    if (nodePort != null) { sb.append("nodePort:"); sb.append(nodePort + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (protocol != null) { sb.append("protocol:"); sb.append(protocol); }
    sb.append("}");
    return sb.toString();
  }
  

}