package io.dekorate.kubernetes.config;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
public class Probe{
  public Probe() {
  }
  
  public Probe(String httpActionPath,String execAction,String tcpSocketAction,String grpcAction,Integer initialDelaySeconds,Integer periodSeconds,Integer timeoutSeconds,Integer successThreshold,Integer failureThreshold) {
    this.httpActionPath = httpActionPath;
    this.execAction = execAction;
    this.tcpSocketAction = tcpSocketAction;
    this.grpcAction = grpcAction;
    this.initialDelaySeconds = initialDelaySeconds;
    this.periodSeconds = periodSeconds;
    this.timeoutSeconds = timeoutSeconds;
    this.successThreshold = successThreshold;
    this.failureThreshold = failureThreshold;
  }
  private String httpActionPath;
  private String execAction;
  private String tcpSocketAction;
  private String grpcAction;
  private Integer initialDelaySeconds;
  private Integer periodSeconds;
  private Integer timeoutSeconds;
  private Integer successThreshold;
  private Integer failureThreshold;
  
  
  /**
   * The http path to use for the probe
   * For this to work, the container port also needs to be set
   * Assuming the container port has been set (as per above comment),
   * if execAction or tcpSocketAction are not set, an http probe
   * will be used automatically even if no path is set (which will
   * result in the root path being used)
   */
  public String getHttpActionPath() {
    return this.httpActionPath;
  }
  
  
  /**
   * The command to use for the probe.
   * @return The command.
   */
  public String getExecAction() {
    return this.execAction;
  }
  
  
  /**
   * The tcp socket to use for the probe (the format is port or host:port).
   * Examples:
   * - @Probe(tcpSocketAction="8080"))
   * - @Probe(tcpSocketAction="myhost:8080"))
   * @return The string representation of the socket.
   */
  public String getTcpSocketAction() {
    return this.tcpSocketAction;
  }
  
  
  /**
   * The gRPC port to use for the probe (the format is "port").
   * If the health endpoint is configured on a non-default service, you must also specify the service (the format
   * is "port:service").
   * @return The string representation of the gRPC probe.
   */
  public String getGrpcAction() {
    return this.grpcAction;
  }
  
  
  /**
   * The amount of time to wait in seconds before starting to probe.
   * @return The initial delay.
   */
  public Integer getInitialDelaySeconds() {
    return this.initialDelaySeconds;
  }
  
  
  /**
   * The period in which the action should be called.
   * @return The period.
   */
  public Integer getPeriodSeconds() {
    return this.periodSeconds;
  }
  
  
  /**
   * The amount of time to wait for each action.
   * @return The timeout.
   */
  public Integer getTimeoutSeconds() {
    return this.timeoutSeconds;
  }
  
  
  /**
   * The success threshold to use.
   * @return The threshold.
   */
  public Integer getSuccessThreshold() {
    return this.successThreshold;
  }
  
  
  /**
   * The failure threshold to use.
   * @return The threshold.
   */
  public Integer getFailureThreshold() {
    return this.failureThreshold;
  }
  
  public static ProbeBuilder newBuilder() {
    return new ProbeBuilder();
  }
  
  public static ProbeBuilder newBuilderFromDefaults() {
    return new ProbeBuilder().withInitialDelaySeconds(0).withPeriodSeconds(30).withTimeoutSeconds(10).withSuccessThreshold(1).withFailureThreshold(3);
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    Probe that = (Probe) o;
    if (!java.util.Objects.equals(httpActionPath, that.httpActionPath)) return false;
    if (!java.util.Objects.equals(execAction, that.execAction)) return false;
    if (!java.util.Objects.equals(tcpSocketAction, that.tcpSocketAction)) return false;
    if (!java.util.Objects.equals(grpcAction, that.grpcAction)) return false;
    if (!java.util.Objects.equals(initialDelaySeconds, that.initialDelaySeconds)) return false;
    if (!java.util.Objects.equals(periodSeconds, that.periodSeconds)) return false;
    if (!java.util.Objects.equals(timeoutSeconds, that.timeoutSeconds)) return false;
    if (!java.util.Objects.equals(successThreshold, that.successThreshold)) return false;
    if (!java.util.Objects.equals(failureThreshold, that.failureThreshold)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(httpActionPath,  execAction,  tcpSocketAction,  grpcAction,  initialDelaySeconds,  periodSeconds,  timeoutSeconds,  successThreshold,  failureThreshold,  super.hashCode());
  }
  

}