package io.dekorate.kubernetes.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ProbeBuilder extends ProbeFluent<ProbeBuilder> implements VisitableBuilder<Probe,ProbeBuilder>{
  public ProbeBuilder() {
    this(new Probe());
  }
  
  public ProbeBuilder(ProbeFluent<?> fluent) {
    this(fluent, new Probe());
  }
  
  public ProbeBuilder(ProbeFluent<?> fluent,Probe instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ProbeBuilder(Probe instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ProbeFluent<?> fluent;
  
  public Probe build() {
    Probe buildable = new Probe(fluent.getHttpActionPath(),fluent.getExecAction(),fluent.getTcpSocketAction(),fluent.getGrpcAction(),fluent.getInitialDelaySeconds(),fluent.getPeriodSeconds(),fluent.getTimeoutSeconds(),fluent.getSuccessThreshold(),fluent.getFailureThreshold());
    return buildable;
  }
  

}