package io.dekorate.kubernetes.config;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ProbeFluent<A extends ProbeFluent<A>> extends BaseFluent<A>{
  public ProbeFluent() {
  }
  
  public ProbeFluent(Probe instance) {
    this.copyInstance(instance);
  }
  private String httpActionPath;
  private String execAction;
  private String tcpSocketAction;
  private String grpcAction;
  private Integer initialDelaySeconds;
  private Integer periodSeconds;
  private Integer timeoutSeconds;
  private Integer successThreshold;
  private Integer failureThreshold;
  
  protected void copyInstance(Probe instance) {
    instance = (instance != null ? instance : new Probe());
    if (instance != null) {
          this.withHttpActionPath(instance.getHttpActionPath());
          this.withExecAction(instance.getExecAction());
          this.withTcpSocketAction(instance.getTcpSocketAction());
          this.withGrpcAction(instance.getGrpcAction());
          this.withInitialDelaySeconds(instance.getInitialDelaySeconds());
          this.withPeriodSeconds(instance.getPeriodSeconds());
          this.withTimeoutSeconds(instance.getTimeoutSeconds());
          this.withSuccessThreshold(instance.getSuccessThreshold());
          this.withFailureThreshold(instance.getFailureThreshold());
        }
  }
  
  public String getHttpActionPath() {
    return this.httpActionPath;
  }
  
  public A withHttpActionPath(String httpActionPath) {
    this.httpActionPath = httpActionPath;
    return (A) this;
  }
  
  public boolean hasHttpActionPath() {
    return this.httpActionPath != null;
  }
  
  public String getExecAction() {
    return this.execAction;
  }
  
  public A withExecAction(String execAction) {
    this.execAction = execAction;
    return (A) this;
  }
  
  public boolean hasExecAction() {
    return this.execAction != null;
  }
  
  public String getTcpSocketAction() {
    return this.tcpSocketAction;
  }
  
  public A withTcpSocketAction(String tcpSocketAction) {
    this.tcpSocketAction = tcpSocketAction;
    return (A) this;
  }
  
  public boolean hasTcpSocketAction() {
    return this.tcpSocketAction != null;
  }
  
  public String getGrpcAction() {
    return this.grpcAction;
  }
  
  public A withGrpcAction(String grpcAction) {
    this.grpcAction = grpcAction;
    return (A) this;
  }
  
  public boolean hasGrpcAction() {
    return this.grpcAction != null;
  }
  
  public Integer getInitialDelaySeconds() {
    return this.initialDelaySeconds;
  }
  
  public A withInitialDelaySeconds(Integer initialDelaySeconds) {
    this.initialDelaySeconds = initialDelaySeconds;
    return (A) this;
  }
  
  public boolean hasInitialDelaySeconds() {
    return this.initialDelaySeconds != null;
  }
  
  public Integer getPeriodSeconds() {
    return this.periodSeconds;
  }
  
  public A withPeriodSeconds(Integer periodSeconds) {
    this.periodSeconds = periodSeconds;
    return (A) this;
  }
  
  public boolean hasPeriodSeconds() {
    return this.periodSeconds != null;
  }
  
  public Integer getTimeoutSeconds() {
    return this.timeoutSeconds;
  }
  
  public A withTimeoutSeconds(Integer timeoutSeconds) {
    this.timeoutSeconds = timeoutSeconds;
    return (A) this;
  }
  
  public boolean hasTimeoutSeconds() {
    return this.timeoutSeconds != null;
  }
  
  public Integer getSuccessThreshold() {
    return this.successThreshold;
  }
  
  public A withSuccessThreshold(Integer successThreshold) {
    this.successThreshold = successThreshold;
    return (A) this;
  }
  
  public boolean hasSuccessThreshold() {
    return this.successThreshold != null;
  }
  
  public Integer getFailureThreshold() {
    return this.failureThreshold;
  }
  
  public A withFailureThreshold(Integer failureThreshold) {
    this.failureThreshold = failureThreshold;
    return (A) this;
  }
  
  public boolean hasFailureThreshold() {
    return this.failureThreshold != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ProbeFluent that = (ProbeFluent) o;
    if (!java.util.Objects.equals(httpActionPath, that.httpActionPath)) return false;
    if (!java.util.Objects.equals(execAction, that.execAction)) return false;
    if (!java.util.Objects.equals(tcpSocketAction, that.tcpSocketAction)) return false;
    if (!java.util.Objects.equals(grpcAction, that.grpcAction)) return false;
    if (!java.util.Objects.equals(initialDelaySeconds, that.initialDelaySeconds)) return false;
    if (!java.util.Objects.equals(periodSeconds, that.periodSeconds)) return false;
    if (!java.util.Objects.equals(timeoutSeconds, that.timeoutSeconds)) return false;
    if (!java.util.Objects.equals(successThreshold, that.successThreshold)) return false;
    if (!java.util.Objects.equals(failureThreshold, that.failureThreshold)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(httpActionPath,  execAction,  tcpSocketAction,  grpcAction,  initialDelaySeconds,  periodSeconds,  timeoutSeconds,  successThreshold,  failureThreshold,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (httpActionPath != null) { sb.append("httpActionPath:"); sb.append(httpActionPath + ","); }
    if (execAction != null) { sb.append("execAction:"); sb.append(execAction + ","); }
    if (tcpSocketAction != null) { sb.append("tcpSocketAction:"); sb.append(tcpSocketAction + ","); }
    if (grpcAction != null) { sb.append("grpcAction:"); sb.append(grpcAction + ","); }
    if (initialDelaySeconds != null) { sb.append("initialDelaySeconds:"); sb.append(initialDelaySeconds + ","); }
    if (periodSeconds != null) { sb.append("periodSeconds:"); sb.append(periodSeconds + ","); }
    if (timeoutSeconds != null) { sb.append("timeoutSeconds:"); sb.append(timeoutSeconds + ","); }
    if (successThreshold != null) { sb.append("successThreshold:"); sb.append(successThreshold + ","); }
    if (failureThreshold != null) { sb.append("failureThreshold:"); sb.append(failureThreshold); }
    sb.append("}");
    return sb.toString();
  }
  

}