package io.dekorate.kubernetes.config;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ResourceRequirementsFluent<A extends ResourceRequirementsFluent<A>> extends BaseFluent<A>{
  public ResourceRequirementsFluent() {
  }
  
  public ResourceRequirementsFluent(ResourceRequirements instance) {
    this.copyInstance(instance);
  }
  private String memory;
  private String cpu;
  
  protected void copyInstance(ResourceRequirements instance) {
    instance = (instance != null ? instance : new ResourceRequirements());
    if (instance != null) {
          this.withMemory(instance.getMemory());
          this.withCpu(instance.getCpu());
        }
  }
  
  public String getMemory() {
    return this.memory;
  }
  
  public A withMemory(String memory) {
    this.memory = memory;
    return (A) this;
  }
  
  public boolean hasMemory() {
    return this.memory != null;
  }
  
  public String getCpu() {
    return this.cpu;
  }
  
  public A withCpu(String cpu) {
    this.cpu = cpu;
    return (A) this;
  }
  
  public boolean hasCpu() {
    return this.cpu != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ResourceRequirementsFluent that = (ResourceRequirementsFluent) o;
    if (!java.util.Objects.equals(memory, that.memory)) return false;
    if (!java.util.Objects.equals(cpu, that.cpu)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(memory,  cpu,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (memory != null) { sb.append("memory:"); sb.append(memory + ","); }
    if (cpu != null) { sb.append("cpu:"); sb.append(cpu); }
    sb.append("}");
    return sb.toString();
  }
  

}