package io.dekorate.kubernetes.config;

import java.lang.Object;
import java.lang.String;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class RollingUpdate{
  public RollingUpdate() {
  }
  
  public RollingUpdate(String maxUnavailable,String maxSurge) {
    this.maxUnavailable = maxUnavailable;
    this.maxSurge = maxSurge;
  }
  private String maxUnavailable;
  private String maxSurge;
  
  
  /**
   * Specifies the maximum number of Pods that can be unavailable during the update process.
   */
  public String getMaxUnavailable() {
    return this.maxUnavailable;
  }
  
  
  /**
   * Specifies the maximum number of Pods that can be created over the desired number of Pods.
   */
  public String getMaxSurge() {
    return this.maxSurge;
  }
  
  public static RollingUpdateBuilder newBuilder() {
    return new RollingUpdateBuilder();
  }
  
  public static RollingUpdateBuilder newBuilderFromDefaults() {
    return new RollingUpdateBuilder().withMaxUnavailable("25%").withMaxSurge("25%");
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RollingUpdate that = (RollingUpdate) o;
    if (!java.util.Objects.equals(maxUnavailable, that.maxUnavailable)) return false;
    if (!java.util.Objects.equals(maxSurge, that.maxSurge)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(maxUnavailable,  maxSurge,  super.hashCode());
  }
  

}