package io.dekorate.kubernetes.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SecretVolumeFluent<A extends SecretVolumeFluent<A>> extends BaseFluent<A>{
  public SecretVolumeFluent() {
  }
  
  public SecretVolumeFluent(SecretVolume instance) {
    this.copyInstance(instance);
  }
  private String volumeName;
  private String secretName;
  private Integer defaultMode;
  private Boolean optional;
  private ArrayList<ItemBuilder> items = new ArrayList<ItemBuilder>();
  
  protected void copyInstance(SecretVolume instance) {
    instance = (instance != null ? instance : new SecretVolume());
    if (instance != null) {
          this.withVolumeName(instance.getVolumeName());
          this.withSecretName(instance.getSecretName());
          this.withDefaultMode(instance.getDefaultMode());
          this.withOptional(instance.getOptional());
          this.withItems(instance.getItems());
        }
  }
  
  public String getVolumeName() {
    return this.volumeName;
  }
  
  public A withVolumeName(String volumeName) {
    this.volumeName = volumeName;
    return (A) this;
  }
  
  public boolean hasVolumeName() {
    return this.volumeName != null;
  }
  
  public String getSecretName() {
    return this.secretName;
  }
  
  public A withSecretName(String secretName) {
    this.secretName = secretName;
    return (A) this;
  }
  
  public boolean hasSecretName() {
    return this.secretName != null;
  }
  
  public Integer getDefaultMode() {
    return this.defaultMode;
  }
  
  public A withDefaultMode(Integer defaultMode) {
    this.defaultMode = defaultMode;
    return (A) this;
  }
  
  public boolean hasDefaultMode() {
    return this.defaultMode != null;
  }
  
  public Boolean getOptional() {
    return this.optional;
  }
  
  public A withOptional(Boolean optional) {
    this.optional = optional;
    return (A) this;
  }
  
  public boolean hasOptional() {
    return this.optional != null;
  }
  
  public A withItems(io.dekorate.kubernetes.config.Item... items) {
    if (this.items != null) {
        this.items.clear();
        _visitables.remove("items");
    }
    if (items != null) {
      for (Item item : items) {
        this.addToItems(item);
      }
    }
    return (A) this;
  }
  
  public Item[] buildItems() {
    int size = items != null ? items.size() : 0;;
    Item[] result = new Item[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<Item,ItemBuilder> item : items) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public Item buildItem(int index) {
    return this.items.get(index).build();
  }
  
  public Item buildFirstItem() {
    return this.items.get(0).build();
  }
  
  public Item buildLastItem() {
    return this.items.get(items.size() - 1).build();
  }
  
  public Item buildMatchingItem(Predicate<ItemBuilder> predicate) {
      for (ItemBuilder item : items) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingItem(Predicate<ItemBuilder> predicate) {
      for (ItemBuilder item : items) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToItems(int index,Item item) {
    if (this.items == null) {this.items = new ArrayList<ItemBuilder>();}
    ItemBuilder builder = new ItemBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  
  public A setToItems(int index,Item item) {
    if (this.items == null) {this.items = new ArrayList<ItemBuilder>();}
    ItemBuilder builder = new ItemBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  
  public A addToItems(io.dekorate.kubernetes.config.Item... items) {
    if (this.items == null) {this.items = new ArrayList<ItemBuilder>();}
    for (Item item : items) {ItemBuilder builder = new ItemBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  
  public A addAllToItems(Collection<Item> items) {
    if (this.items == null) {this.items = new ArrayList<ItemBuilder>();}
    for (Item item : items) {ItemBuilder builder = new ItemBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  
  public A removeFromItems(io.dekorate.kubernetes.config.Item... items) {
    if (this.items == null) return (A)this;
    for (Item item : items) {ItemBuilder builder = new ItemBuilder(item);_visitables.get("items").remove(builder); this.items.remove(builder);} return (A)this;
  }
  
  public A removeAllFromItems(Collection<Item> items) {
    if (this.items == null) return (A)this;
    for (Item item : items) {ItemBuilder builder = new ItemBuilder(item);_visitables.get("items").remove(builder); this.items.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromItems(Predicate<ItemBuilder> predicate) {
    if (items == null) return (A) this;
    final Iterator<ItemBuilder> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      ItemBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasItems() {
    return this.items != null && !this.items.isEmpty();
  }
  
  public A addNewItem(String key,String path,Integer mode) {
    return (A)addToItems(new Item(key, path, mode));
  }
  
  public ItemsNested<A> addNewItem() {
    return new ItemsNested(-1, null);
  }
  
  public ItemsNested<A> addNewItemLike(Item item) {
    return new ItemsNested(-1, item);
  }
  
  public ItemsNested<A> setNewItemLike(int index,Item item) {
    return new ItemsNested(index, item);
  }
  
  public ItemsNested<A> editItem(int index) {
    if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
    return setNewItemLike(index, buildItem(index));
  }
  
  public ItemsNested<A> editFirstItem() {
    if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
    return setNewItemLike(0, buildItem(0));
  }
  
  public ItemsNested<A> editLastItem() {
    int index = items.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
    return setNewItemLike(index, buildItem(index));
  }
  
  public ItemsNested<A> editMatchingItem(Predicate<ItemBuilder> predicate) {
    int index = -1;
    for (int i=0;i<items.size();i++) { 
    if (predicate.test(items.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
    return setNewItemLike(index, buildItem(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SecretVolumeFluent that = (SecretVolumeFluent) o;
    if (!java.util.Objects.equals(volumeName, that.volumeName)) return false;
    if (!java.util.Objects.equals(secretName, that.secretName)) return false;
    if (!java.util.Objects.equals(defaultMode, that.defaultMode)) return false;
    if (!java.util.Objects.equals(optional, that.optional)) return false;
    if (!java.util.Objects.equals(items, that.items)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(volumeName,  secretName,  defaultMode,  optional,  items,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (volumeName != null) { sb.append("volumeName:"); sb.append(volumeName + ","); }
    if (secretName != null) { sb.append("secretName:"); sb.append(secretName + ","); }
    if (defaultMode != null) { sb.append("defaultMode:"); sb.append(defaultMode + ","); }
    if (optional != null) { sb.append("optional:"); sb.append(optional + ","); }
    if (items != null && !items.isEmpty()) { sb.append("items:"); sb.append(items); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withOptional() {
    return withOptional(true);
  }
  public class ItemsNested<N> extends ItemFluent<ItemsNested<N>> implements Nested<N>{
    ItemsNested(int index,Item item) {
      this.index = index;
      this.builder = new ItemBuilder(this, item);
    }
    ItemBuilder builder;
    int index;
    
    public N and() {
      return (N) SecretVolumeFluent.this.setToItems(index,builder.build());
    }
    
    public N endItem() {
      return and();
    }
    
  
  }

}