package io.dekorate.option.config;

import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class GeneratorConfig extends Configuration{
  public GeneratorConfig() {
  }
  
  public GeneratorConfig(Project project,Map<ConfigKey,Object> attributes,String inputPath,String outputPath,Boolean verbose,String propertiesProfile,Boolean build,Boolean push,Boolean deploy) {
    super(project, attributes);
    this.inputPath = inputPath;
    this.outputPath = outputPath;
    this.verbose = verbose;
    this.propertiesProfile = propertiesProfile;
    this.build = build;
    this.push = push;
    this.deploy = deploy;
  }
  private String inputPath;
  private String outputPath;
  private Boolean verbose;
  private String propertiesProfile;
  private Boolean build;
  private Boolean push;
  private Boolean deploy;
  
  
  /**
   * The path to input manifests.
   * If the path is specified and the manifests are found, they will be used as input to the generator process.
   * In this case, the instead of generating resources from scratch, the existing will be used and will be decarated
   * according to the annotation configuration.
   * @return The path, or empty string.
   */
  public String getInputPath() {
    return this.inputPath;
  }
  
  
  /**
   * The output path where the generated/decorated manifests will be stored.
   * @return The path, or empty string.
   */
  public String getOutputPath() {
    return this.outputPath;
  }
  
  
  /**
   * Flag to enable verbose logging.
   * @return true if verbose logging is enabled.
   */
  public Boolean getVerbose() {
    return this.verbose;
  }
  
  
  /**
   * Flag to enable verbose logging.
   * @return true if verbose logging is enabled.
   */
  public boolean isVerbose() {
    return this.verbose != null &&  this.verbose;
  }
  
  
  /**
   * The properties profile to use.
   * @reutrn the profile or empty string.
   */
  public String getPropertiesProfile() {
    return this.propertiesProfile;
  }
  
  
  /**
   * Flag to enable build.
   * @return true if build is enabled.
   */
  public Boolean getBuild() {
    return this.build;
  }
  
  
  /**
   * Flag to enable build.
   * @return true if build is enabled.
   */
  public boolean isBuild() {
    return this.build != null &&  this.build;
  }
  
  
  /**
   * Flag to enable push.
   * @return true if push is enabled.
   */
  public Boolean getPush() {
    return this.push;
  }
  
  
  /**
   * Flag to enable push.
   * @return true if push is enabled.
   */
  public boolean isPush() {
    return this.push != null &&  this.push;
  }
  
  
  /**
   * Flag to enable deply.
   * @return true if deply is enabled.
   */
  public Boolean getDeploy() {
    return this.deploy;
  }
  
  
  /**
   * Flag to enable deply.
   * @return true if deply is enabled.
   */
  public boolean isDeploy() {
    return this.deploy != null &&  this.deploy;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GeneratorConfig that = (GeneratorConfig) o;
    if (!java.util.Objects.equals(inputPath, that.inputPath)) return false;
    if (!java.util.Objects.equals(outputPath, that.outputPath)) return false;
    if (!java.util.Objects.equals(verbose, that.verbose)) return false;
    if (!java.util.Objects.equals(propertiesProfile, that.propertiesProfile)) return false;
    if (!java.util.Objects.equals(build, that.build)) return false;
    if (!java.util.Objects.equals(push, that.push)) return false;
    if (!java.util.Objects.equals(deploy, that.deploy)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(inputPath,  outputPath,  verbose,  propertiesProfile,  build,  push,  deploy,  super.hashCode());
  }
  

}