package io.dekorate.option.config;

import java.lang.SuppressWarnings;
import java.lang.Object;
import io.dekorate.kubernetes.config.ConfigurationFluent;
import java.lang.String;
import java.lang.Boolean;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GeneratorConfigFluent<A extends GeneratorConfigFluent<A>> extends ConfigurationFluent<A>{
  public GeneratorConfigFluent() {
  }
  
  public GeneratorConfigFluent(GeneratorConfig instance) {
    this.copyInstance(instance);
  }
  private String inputPath;
  private String outputPath;
  private Boolean verbose;
  private String propertiesProfile;
  private Boolean build;
  private Boolean push;
  private Boolean deploy;
  
  protected void copyInstance(GeneratorConfig instance) {
    instance = (instance != null ? instance : new GeneratorConfig());
    if (instance != null) {
          this.withProject(instance.getProject());
          this.withAttributes(instance.getAttributes());
          this.withInputPath(instance.getInputPath());
          this.withOutputPath(instance.getOutputPath());
          this.withVerbose(instance.getVerbose());
          this.withPropertiesProfile(instance.getPropertiesProfile());
          this.withBuild(instance.getBuild());
          this.withPush(instance.getPush());
          this.withDeploy(instance.getDeploy());
        }
  }
  
  public String getInputPath() {
    return this.inputPath;
  }
  
  public A withInputPath(String inputPath) {
    this.inputPath = inputPath;
    return (A) this;
  }
  
  public boolean hasInputPath() {
    return this.inputPath != null;
  }
  
  public String getOutputPath() {
    return this.outputPath;
  }
  
  public A withOutputPath(String outputPath) {
    this.outputPath = outputPath;
    return (A) this;
  }
  
  public boolean hasOutputPath() {
    return this.outputPath != null;
  }
  
  public Boolean getVerbose() {
    return this.verbose;
  }
  
  public A withVerbose(Boolean verbose) {
    this.verbose = verbose;
    return (A) this;
  }
  
  public boolean hasVerbose() {
    return this.verbose != null;
  }
  
  public String getPropertiesProfile() {
    return this.propertiesProfile;
  }
  
  public A withPropertiesProfile(String propertiesProfile) {
    this.propertiesProfile = propertiesProfile;
    return (A) this;
  }
  
  public boolean hasPropertiesProfile() {
    return this.propertiesProfile != null;
  }
  
  public Boolean getBuild() {
    return this.build;
  }
  
  public A withBuild(Boolean build) {
    this.build = build;
    return (A) this;
  }
  
  public boolean hasBuild() {
    return this.build != null;
  }
  
  public Boolean getPush() {
    return this.push;
  }
  
  public A withPush(Boolean push) {
    this.push = push;
    return (A) this;
  }
  
  public boolean hasPush() {
    return this.push != null;
  }
  
  public Boolean getDeploy() {
    return this.deploy;
  }
  
  public A withDeploy(Boolean deploy) {
    this.deploy = deploy;
    return (A) this;
  }
  
  public boolean hasDeploy() {
    return this.deploy != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GeneratorConfigFluent that = (GeneratorConfigFluent) o;
    if (!java.util.Objects.equals(inputPath, that.inputPath)) return false;
    if (!java.util.Objects.equals(outputPath, that.outputPath)) return false;
    if (!java.util.Objects.equals(verbose, that.verbose)) return false;
    if (!java.util.Objects.equals(propertiesProfile, that.propertiesProfile)) return false;
    if (!java.util.Objects.equals(build, that.build)) return false;
    if (!java.util.Objects.equals(push, that.push)) return false;
    if (!java.util.Objects.equals(deploy, that.deploy)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(inputPath,  outputPath,  verbose,  propertiesProfile,  build,  push,  deploy,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (inputPath != null) { sb.append("inputPath:"); sb.append(inputPath + ","); }
    if (outputPath != null) { sb.append("outputPath:"); sb.append(outputPath + ","); }
    if (verbose != null) { sb.append("verbose:"); sb.append(verbose + ","); }
    if (propertiesProfile != null) { sb.append("propertiesProfile:"); sb.append(propertiesProfile + ","); }
    if (build != null) { sb.append("build:"); sb.append(build + ","); }
    if (push != null) { sb.append("push:"); sb.append(push + ","); }
    if (deploy != null) { sb.append("deploy:"); sb.append(deploy); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withVerbose() {
    return withVerbose(true);
  }
  
  public A withBuild() {
    return withBuild(true);
  }
  
  public A withPush() {
    return withPush(true);
  }
  
  public A withDeploy() {
    return withDeploy(true);
  }
  

}