package io.dekorate.project;

import java.nio.file.Path;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class BuildInfoFluent<A extends BuildInfoFluent<A>> extends BaseFluent<A>{
  public BuildInfoFluent() {
  }
  
  public BuildInfoFluent(BuildInfo instance) {
    this.copyInstance(instance);
  }
  private String name;
  private String version;
  private String packaging;
  private String buildTool;
  private String buildToolVersion;
  private Path outputFile;
  private Path classOutputDir;
  private Path resourceDir;
  
  protected void copyInstance(BuildInfo instance) {
    instance = (instance != null ? instance : new BuildInfo());
    if (instance != null) {
          this.withName(instance.getName());
          this.withVersion(instance.getVersion());
          this.withPackaging(instance.getPackaging());
          this.withBuildTool(instance.getBuildTool());
          this.withBuildToolVersion(instance.getBuildToolVersion());
          this.withOutputFile(instance.getOutputFile());
          this.withClassOutputDir(instance.getClassOutputDir());
          this.withResourceDir(instance.getResourceDir());
        }
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public A withVersion(String version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public String getPackaging() {
    return this.packaging;
  }
  
  public A withPackaging(String packaging) {
    this.packaging = packaging;
    return (A) this;
  }
  
  public boolean hasPackaging() {
    return this.packaging != null;
  }
  
  public String getBuildTool() {
    return this.buildTool;
  }
  
  public A withBuildTool(String buildTool) {
    this.buildTool = buildTool;
    return (A) this;
  }
  
  public boolean hasBuildTool() {
    return this.buildTool != null;
  }
  
  public String getBuildToolVersion() {
    return this.buildToolVersion;
  }
  
  public A withBuildToolVersion(String buildToolVersion) {
    this.buildToolVersion = buildToolVersion;
    return (A) this;
  }
  
  public boolean hasBuildToolVersion() {
    return this.buildToolVersion != null;
  }
  
  public Path getOutputFile() {
    return this.outputFile;
  }
  
  public A withOutputFile(Path outputFile) {
    this.outputFile = outputFile;
    return (A) this;
  }
  
  public boolean hasOutputFile() {
    return this.outputFile != null;
  }
  
  public Path getClassOutputDir() {
    return this.classOutputDir;
  }
  
  public A withClassOutputDir(Path classOutputDir) {
    this.classOutputDir = classOutputDir;
    return (A) this;
  }
  
  public boolean hasClassOutputDir() {
    return this.classOutputDir != null;
  }
  
  public Path getResourceDir() {
    return this.resourceDir;
  }
  
  public A withResourceDir(Path resourceDir) {
    this.resourceDir = resourceDir;
    return (A) this;
  }
  
  public boolean hasResourceDir() {
    return this.resourceDir != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BuildInfoFluent that = (BuildInfoFluent) o;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(packaging, that.packaging)) return false;
    if (!java.util.Objects.equals(buildTool, that.buildTool)) return false;
    if (!java.util.Objects.equals(buildToolVersion, that.buildToolVersion)) return false;
    if (!java.util.Objects.equals(outputFile, that.outputFile)) return false;
    if (!java.util.Objects.equals(classOutputDir, that.classOutputDir)) return false;
    if (!java.util.Objects.equals(resourceDir, that.resourceDir)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(name,  version,  packaging,  buildTool,  buildToolVersion,  outputFile,  classOutputDir,  resourceDir,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (packaging != null) { sb.append("packaging:"); sb.append(packaging + ","); }
    if (buildTool != null) { sb.append("buildTool:"); sb.append(buildTool + ","); }
    if (buildToolVersion != null) { sb.append("buildToolVersion:"); sb.append(buildToolVersion + ","); }
    if (outputFile != null) { sb.append("outputFile:"); sb.append(outputFile + ","); }
    if (classOutputDir != null) { sb.append("classOutputDir:"); sb.append(classOutputDir + ","); }
    if (resourceDir != null) { sb.append("resourceDir:"); sb.append(resourceDir); }
    sb.append("}");
    return sb.toString();
  }
  

}