package io.dekorate.project;

import java.nio.file.Path;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ProjectFluent<A extends ProjectFluent<A>> extends BaseFluent<A>{
  public ProjectFluent() {
  }
  
  public ProjectFluent(Project instance) {
    this.copyInstance(instance);
  }
  private Path root;
  private String dekorateInputDir;
  private String dekorateOutputDir;
  private String dekorateMetaDir;
  private BuildInfoBuilder buildInfo;
  private ScmInfoBuilder scmInfo;
  
  protected void copyInstance(Project instance) {
    instance = (instance != null ? instance : new Project());
    if (instance != null) {
          this.withRoot(instance.getRoot());
          this.withDekorateInputDir(instance.getDekorateInputDir());
          this.withDekorateMetaDir(instance.getDekorateMetaDir());
          this.withDekorateOutputDir(instance.getDekorateOutputDir());
          this.withBuildInfo(instance.getBuildInfo());
          this.withScmInfo(instance.getScmInfo());
        }
  }
  
  public Path getRoot() {
    return this.root;
  }
  
  public A withRoot(Path root) {
    this.root = root;
    return (A) this;
  }
  
  public boolean hasRoot() {
    return this.root != null;
  }
  
  public String getDekorateInputDir() {
    return this.dekorateInputDir;
  }
  
  public A withDekorateInputDir(String dekorateInputDir) {
    this.dekorateInputDir = dekorateInputDir;
    return (A) this;
  }
  
  public boolean hasDekorateInputDir() {
    return this.dekorateInputDir != null;
  }
  
  public String getDekorateOutputDir() {
    return this.dekorateOutputDir;
  }
  
  public A withDekorateOutputDir(String dekorateOutputDir) {
    this.dekorateOutputDir = dekorateOutputDir;
    return (A) this;
  }
  
  public boolean hasDekorateOutputDir() {
    return this.dekorateOutputDir != null;
  }
  
  public String getDekorateMetaDir() {
    return this.dekorateMetaDir;
  }
  
  public A withDekorateMetaDir(String dekorateMetaDir) {
    this.dekorateMetaDir = dekorateMetaDir;
    return (A) this;
  }
  
  public boolean hasDekorateMetaDir() {
    return this.dekorateMetaDir != null;
  }
  
  public BuildInfo buildBuildInfo() {
    return this.buildInfo != null ? this.buildInfo.build() : null;
  }
  
  public A withBuildInfo(BuildInfo buildInfo) {
    this._visitables.remove("buildInfo");
    if (buildInfo != null) {
        this.buildInfo = new BuildInfoBuilder(buildInfo);
        this._visitables.get("buildInfo").add(this.buildInfo);
    } else {
        this.buildInfo = null;
        this._visitables.get("buildInfo").remove(this.buildInfo);
    }
    return (A) this;
  }
  
  public boolean hasBuildInfo() {
    return this.buildInfo != null;
  }
  
  public BuildInfoNested<A> withNewBuildInfo() {
    return new BuildInfoNested(null);
  }
  
  public BuildInfoNested<A> withNewBuildInfoLike(BuildInfo item) {
    return new BuildInfoNested(item);
  }
  
  public BuildInfoNested<A> editBuildInfo() {
    return withNewBuildInfoLike(java.util.Optional.ofNullable(buildBuildInfo()).orElse(null));
  }
  
  public BuildInfoNested<A> editOrNewBuildInfo() {
    return withNewBuildInfoLike(java.util.Optional.ofNullable(buildBuildInfo()).orElse(new BuildInfoBuilder().build()));
  }
  
  public BuildInfoNested<A> editOrNewBuildInfoLike(BuildInfo item) {
    return withNewBuildInfoLike(java.util.Optional.ofNullable(buildBuildInfo()).orElse(item));
  }
  
  public ScmInfo buildScmInfo() {
    return this.scmInfo != null ? this.scmInfo.build() : null;
  }
  
  public A withScmInfo(ScmInfo scmInfo) {
    this._visitables.remove("scmInfo");
    if (scmInfo != null) {
        this.scmInfo = new ScmInfoBuilder(scmInfo);
        this._visitables.get("scmInfo").add(this.scmInfo);
    } else {
        this.scmInfo = null;
        this._visitables.get("scmInfo").remove(this.scmInfo);
    }
    return (A) this;
  }
  
  public boolean hasScmInfo() {
    return this.scmInfo != null;
  }
  
  public ScmInfoNested<A> withNewScmInfo() {
    return new ScmInfoNested(null);
  }
  
  public ScmInfoNested<A> withNewScmInfoLike(ScmInfo item) {
    return new ScmInfoNested(item);
  }
  
  public ScmInfoNested<A> editScmInfo() {
    return withNewScmInfoLike(java.util.Optional.ofNullable(buildScmInfo()).orElse(null));
  }
  
  public ScmInfoNested<A> editOrNewScmInfo() {
    return withNewScmInfoLike(java.util.Optional.ofNullable(buildScmInfo()).orElse(new ScmInfoBuilder().build()));
  }
  
  public ScmInfoNested<A> editOrNewScmInfoLike(ScmInfo item) {
    return withNewScmInfoLike(java.util.Optional.ofNullable(buildScmInfo()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ProjectFluent that = (ProjectFluent) o;
    if (!java.util.Objects.equals(root, that.root)) return false;
    if (!java.util.Objects.equals(dekorateInputDir, that.dekorateInputDir)) return false;
    if (!java.util.Objects.equals(dekorateOutputDir, that.dekorateOutputDir)) return false;
    if (!java.util.Objects.equals(dekorateMetaDir, that.dekorateMetaDir)) return false;
    if (!java.util.Objects.equals(buildInfo, that.buildInfo)) return false;
    if (!java.util.Objects.equals(scmInfo, that.scmInfo)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(root,  dekorateInputDir,  dekorateOutputDir,  dekorateMetaDir,  buildInfo,  scmInfo,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (root != null) { sb.append("root:"); sb.append(root + ","); }
    if (dekorateInputDir != null) { sb.append("dekorateInputDir:"); sb.append(dekorateInputDir + ","); }
    if (dekorateOutputDir != null) { sb.append("dekorateOutputDir:"); sb.append(dekorateOutputDir + ","); }
    if (dekorateMetaDir != null) { sb.append("dekorateMetaDir:"); sb.append(dekorateMetaDir + ","); }
    if (buildInfo != null) { sb.append("buildInfo:"); sb.append(buildInfo + ","); }
    if (scmInfo != null) { sb.append("scmInfo:"); sb.append(scmInfo); }
    sb.append("}");
    return sb.toString();
  }
  public class BuildInfoNested<N> extends BuildInfoFluent<BuildInfoNested<N>> implements Nested<N>{
    BuildInfoNested(BuildInfo item) {
      this.builder = new BuildInfoBuilder(this, item);
    }
    BuildInfoBuilder builder;
    
    public N and() {
      return (N) ProjectFluent.this.withBuildInfo(builder.build());
    }
    
    public N endBuildInfo() {
      return and();
    }
    
  
  }
  public class ScmInfoNested<N> extends ScmInfoFluent<ScmInfoNested<N>> implements Nested<N>{
    ScmInfoNested(ScmInfo item) {
      this.builder = new ScmInfoBuilder(this, item);
    }
    ScmInfoBuilder builder;
    
    public N and() {
      return (N) ProjectFluent.this.withScmInfo(builder.build());
    }
    
    public N endScmInfo() {
      return and();
    }
    
  
  }

}