package io.dekorate.project;

import java.nio.file.Path;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ScmInfoFluent<A extends ScmInfoFluent<A>> extends BaseFluent<A>{
  public ScmInfoFluent() {
  }
  
  public ScmInfoFluent(ScmInfo instance) {
    this.copyInstance(instance);
  }
  private Path root;
  private String branch;
  private String commit;
  private Map<String,String> remote;
  
  protected void copyInstance(ScmInfo instance) {
    instance = (instance != null ? instance : new ScmInfo());
    if (instance != null) {
          this.withRoot(instance.getRoot());
          this.withRemote(instance.getRemote());
          this.withBranch(instance.getBranch());
          this.withCommit(instance.getCommit());
        }
  }
  
  public Path getRoot() {
    return this.root;
  }
  
  public A withRoot(Path root) {
    this.root = root;
    return (A) this;
  }
  
  public boolean hasRoot() {
    return this.root != null;
  }
  
  public String getBranch() {
    return this.branch;
  }
  
  public A withBranch(String branch) {
    this.branch = branch;
    return (A) this;
  }
  
  public boolean hasBranch() {
    return this.branch != null;
  }
  
  public String getCommit() {
    return this.commit;
  }
  
  public A withCommit(String commit) {
    this.commit = commit;
    return (A) this;
  }
  
  public boolean hasCommit() {
    return this.commit != null;
  }
  
  public A addToRemote(String key,String value) {
    if(this.remote == null && key != null && value != null) { this.remote = new LinkedHashMap(); }
    if(key != null && value != null) {this.remote.put(key, value);} return (A)this;
  }
  
  public A addToRemote(Map<String,String> map) {
    if(this.remote == null && map != null) { this.remote = new LinkedHashMap(); }
    if(map != null) { this.remote.putAll(map);} return (A)this;
  }
  
  public A removeFromRemote(String key) {
    if(this.remote == null) { return (A) this; }
    if(key != null && this.remote != null) {this.remote.remove(key);} return (A)this;
  }
  
  public A removeFromRemote(Map<String,String> map) {
    if(this.remote == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.remote != null){this.remote.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getRemote() {
    return this.remote;
  }
  
  public <K,V>A withRemote(Map<String,String> remote) {
    if (remote == null) {
      this.remote = null;
    } else {
      this.remote = new LinkedHashMap(remote);
    }
    return (A) this;
  }
  
  public boolean hasRemote() {
    return this.remote != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ScmInfoFluent that = (ScmInfoFluent) o;
    if (!java.util.Objects.equals(root, that.root)) return false;
    if (!java.util.Objects.equals(branch, that.branch)) return false;
    if (!java.util.Objects.equals(commit, that.commit)) return false;
    if (!java.util.Objects.equals(remote, that.remote)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(root,  branch,  commit,  remote,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (root != null) { sb.append("root:"); sb.append(root + ","); }
    if (branch != null) { sb.append("branch:"); sb.append(branch + ","); }
    if (commit != null) { sb.append("commit:"); sb.append(commit + ","); }
    if (remote != null && !remote.isEmpty()) { sb.append("remote:"); sb.append(remote); }
    sb.append("}");
    return sb.toString();
  }
  

}