/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.knative.config;

import io.dekorate.knative.config.AutoScalerClass;
import io.dekorate.knative.config.AutoScaling;
import io.dekorate.knative.config.AutoscalingMetric;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Objects;

public class AutoScalingFluent<A extends AutoScalingFluent<A>>
extends BaseFluent<A> {
    private AutoScalerClass autoScalerClass;
    private AutoscalingMetric metric;
    private Integer target;
    private Integer containerConcurrency;
    private Integer targetUtilizationPercentage;

    public AutoScalingFluent() {
    }

    public AutoScalingFluent(AutoScaling instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AutoScaling instance) {
        AutoScaling autoScaling = instance = instance != null ? instance : new AutoScaling();
        if (instance != null) {
            this.withAutoScalerClass(instance.getAutoScalerClass());
            this.withMetric(instance.getMetric());
            this.withTarget(instance.getTarget());
            this.withContainerConcurrency(instance.getContainerConcurrency());
            this.withTargetUtilizationPercentage(instance.getTargetUtilizationPercentage());
        }
    }

    public AutoScalerClass getAutoScalerClass() {
        return this.autoScalerClass;
    }

    public A withAutoScalerClass(AutoScalerClass autoScalerClass) {
        this.autoScalerClass = autoScalerClass;
        return (A)((Object)this);
    }

    public boolean hasAutoScalerClass() {
        return this.autoScalerClass != null;
    }

    public AutoscalingMetric getMetric() {
        return this.metric;
    }

    public A withMetric(AutoscalingMetric metric) {
        this.metric = metric;
        return (A)((Object)this);
    }

    public boolean hasMetric() {
        return this.metric != null;
    }

    public Integer getTarget() {
        return this.target;
    }

    public A withTarget(Integer target) {
        this.target = target;
        return (A)((Object)this);
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    public Integer getContainerConcurrency() {
        return this.containerConcurrency;
    }

    public A withContainerConcurrency(Integer containerConcurrency) {
        this.containerConcurrency = containerConcurrency;
        return (A)((Object)this);
    }

    public boolean hasContainerConcurrency() {
        return this.containerConcurrency != null;
    }

    public Integer getTargetUtilizationPercentage() {
        return this.targetUtilizationPercentage;
    }

    public A withTargetUtilizationPercentage(Integer targetUtilizationPercentage) {
        this.targetUtilizationPercentage = targetUtilizationPercentage;
        return (A)((Object)this);
    }

    public boolean hasTargetUtilizationPercentage() {
        return this.targetUtilizationPercentage != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AutoScalingFluent that = (AutoScalingFluent)((Object)o);
        if (!Objects.equals((Object)this.autoScalerClass, (Object)that.autoScalerClass)) {
            return false;
        }
        if (!Objects.equals((Object)this.metric, (Object)that.metric)) {
            return false;
        }
        if (!Objects.equals(this.target, that.target)) {
            return false;
        }
        if (!Objects.equals(this.containerConcurrency, that.containerConcurrency)) {
            return false;
        }
        return Objects.equals(this.targetUtilizationPercentage, that.targetUtilizationPercentage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.autoScalerClass, this.metric, this.target, this.containerConcurrency, this.targetUtilizationPercentage, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.autoScalerClass != null) {
            sb.append("autoScalerClass:");
            sb.append((Object)((Object)this.autoScalerClass) + ",");
        }
        if (this.metric != null) {
            sb.append("metric:");
            sb.append((Object)((Object)this.metric) + ",");
        }
        if (this.target != null) {
            sb.append("target:");
            sb.append(this.target + ",");
        }
        if (this.containerConcurrency != null) {
            sb.append("containerConcurrency:");
            sb.append(this.containerConcurrency + ",");
        }
        if (this.targetUtilizationPercentage != null) {
            sb.append("targetUtilizationPercentage:");
            sb.append(this.targetUtilizationPercentage);
        }
        sb.append("}");
        return sb.toString();
    }
}

