/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.kubernetes.decorator.AddInitContainerDecorator;
import io.dekorate.kubernetes.decorator.AddSidecarDecorator;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.ApplyApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.Quantity;

public class ApplyRequestsMemoryDecorator
extends ApplicationContainerDecorator<ContainerFluent<?>> {
    private static final String MEM = "memory";
    private final String amount;

    public ApplyRequestsMemoryDecorator(String containerName, String amount) {
        super(containerName);
        this.amount = amount;
    }

    public ApplyRequestsMemoryDecorator(String deploymentName, String containerName, String amount) {
        super(deploymentName, containerName);
        this.amount = amount;
    }

    @Override
    public void andThenVisit(ContainerFluent<?> container) {
        ((ContainerFluent.ResourcesNested)container.editOrNewResources().addToRequests(MEM, new Quantity(this.amount))).endResources();
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, ApplyApplicationContainerDecorator.class, AddSidecarDecorator.class, AddInitContainerDecorator.class};
    }
}

