/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.ContainerFluent;
import io.dekorate.kubernetes.config.EditableContainer;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class ContainerBuilder
extends ContainerFluent<ContainerBuilder>
implements VisitableBuilder<Container, ContainerBuilder> {
    ContainerFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerBuilder() {
        this(false);
    }

    public ContainerBuilder(Boolean validationEnabled) {
        this(new Container(), validationEnabled);
    }

    public ContainerBuilder(ContainerFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ContainerBuilder(ContainerFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Container(), validationEnabled);
    }

    public ContainerBuilder(ContainerFluent<?> fluent, Container instance) {
        this(fluent, instance, false);
    }

    public ContainerBuilder(ContainerFluent<?> fluent, Container instance, Boolean validationEnabled) {
        this.fluent = fluent;
        Container container = instance = instance != null ? instance : new Container();
        if (instance != null) {
            fluent.withImage(instance.getImage());
            fluent.withName(instance.getName());
            fluent.withEnvVars(instance.getEnvVars());
            fluent.withWorkingDir(instance.getWorkingDir());
            fluent.withCommand(instance.getCommand());
            fluent.withArguments(instance.getArguments());
            fluent.withPorts(instance.getPorts());
            fluent.withMounts(instance.getMounts());
            fluent.withImagePullPolicy(instance.getImagePullPolicy());
            fluent.withLivenessProbe(instance.getLivenessProbe());
            fluent.withReadinessProbe(instance.getReadinessProbe());
            fluent.withStartupProbe(instance.getStartupProbe());
            fluent.withRequestResources(instance.getRequestResources());
            fluent.withLimitResources(instance.getLimitResources());
        }
        this.validationEnabled = validationEnabled;
    }

    public ContainerBuilder(Container instance) {
        this(instance, (Boolean)false);
    }

    public ContainerBuilder(Container instance, Boolean validationEnabled) {
        this.fluent = this;
        Container container = instance = instance != null ? instance : new Container();
        if (instance != null) {
            this.withImage(instance.getImage());
            this.withName(instance.getName());
            this.withEnvVars(instance.getEnvVars());
            this.withWorkingDir(instance.getWorkingDir());
            this.withCommand(instance.getCommand());
            this.withArguments(instance.getArguments());
            this.withPorts(instance.getPorts());
            this.withMounts(instance.getMounts());
            this.withImagePullPolicy(instance.getImagePullPolicy());
            this.withLivenessProbe(instance.getLivenessProbe());
            this.withReadinessProbe(instance.getReadinessProbe());
            this.withStartupProbe(instance.getStartupProbe());
            this.withRequestResources(instance.getRequestResources());
            this.withLimitResources(instance.getLimitResources());
        }
        this.validationEnabled = validationEnabled;
    }

    public EditableContainer build() {
        EditableContainer buildable = new EditableContainer(this.fluent.getImage(), this.fluent.getName(), this.fluent.buildEnvVars(), this.fluent.getWorkingDir(), this.fluent.getCommand(), this.fluent.getArguments(), this.fluent.buildPorts(), this.fluent.buildMounts(), this.fluent.getImagePullPolicy(), this.fluent.buildLivenessProbe(), this.fluent.buildReadinessProbe(), this.fluent.buildStartupProbe(), this.fluent.buildRequestResources(), this.fluent.buildLimitResources());
        return buildable;
    }
}

