/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.config.EnvFluent;
import io.dekorate.kubernetes.config.Mount;
import io.dekorate.kubernetes.config.MountBuilder;
import io.dekorate.kubernetes.config.MountFluent;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.PortBuilder;
import io.dekorate.kubernetes.config.PortFluent;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ProbeBuilder;
import io.dekorate.kubernetes.config.ProbeFluent;
import io.dekorate.kubernetes.config.ResourceRequirements;
import io.dekorate.kubernetes.config.ResourceRequirementsBuilder;
import io.dekorate.kubernetes.config.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ContainerFluent<A extends ContainerFluent<A>>
extends BaseFluent<A> {
    private String image;
    private String name;
    private ArrayList<EnvBuilder> envVars = new ArrayList();
    private String workingDir;
    private List<String> command = new ArrayList<String>();
    private List<String> arguments = new ArrayList<String>();
    private ArrayList<PortBuilder> ports = new ArrayList();
    private ArrayList<MountBuilder> mounts = new ArrayList();
    private ImagePullPolicy imagePullPolicy;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;
    private ProbeBuilder startupProbe;
    private ResourceRequirementsBuilder requestResources;
    private ResourceRequirementsBuilder limitResources;

    public ContainerFluent() {
    }

    public ContainerFluent(Container instance) {
        Container container = instance = instance != null ? instance : new Container();
        if (instance != null) {
            this.withImage(instance.getImage());
            this.withName(instance.getName());
            this.withEnvVars(instance.getEnvVars());
            this.withWorkingDir(instance.getWorkingDir());
            this.withCommand(instance.getCommand());
            this.withArguments(instance.getArguments());
            this.withPorts(instance.getPorts());
            this.withMounts(instance.getMounts());
            this.withImagePullPolicy(instance.getImagePullPolicy());
            this.withLivenessProbe(instance.getLivenessProbe());
            this.withReadinessProbe(instance.getReadinessProbe());
            this.withStartupProbe(instance.getStartupProbe());
            this.withRequestResources(instance.getRequestResources());
            this.withLimitResources(instance.getLimitResources());
        }
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A withEnvVars(Env ... envVars) {
        if (this.envVars != null) {
            this.envVars.clear();
            this._visitables.remove((Object)"envVars");
        }
        if (envVars != null) {
            for (Env item : envVars) {
                this.addToEnvVars(item);
            }
        }
        return (A)((Object)this);
    }

    public Env[] buildEnvVars() {
        int size = this.envVars != null ? this.envVars.size() : 0;
        Env[] result = new Env[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.envVars) {
            result[index++] = (Env)visitableBuilder.build();
        }
        return result;
    }

    public Env buildEnvVar(int index) {
        return this.envVars.get(index).build();
    }

    public Env buildFirstEnvVar() {
        return this.envVars.get(0).build();
    }

    public Env buildLastEnvVar() {
        return this.envVars.get(this.envVars.size() - 1).build();
    }

    public Env buildMatchingEnvVar(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.envVars) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEnvVar(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.envVars) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToEnvVars(int index, Env item) {
        if (this.envVars == null) {
            this.envVars = new ArrayList();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this.envVars.size()) {
            this._visitables.get((Object)"envVars").add(builder);
            this.envVars.add(builder);
        } else {
            this._visitables.get((Object)"envVars").add(index, builder);
            this.envVars.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEnvVars(int index, Env item) {
        if (this.envVars == null) {
            this.envVars = new ArrayList();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this.envVars.size()) {
            this._visitables.get((Object)"envVars").add(builder);
            this.envVars.add(builder);
        } else {
            this._visitables.get((Object)"envVars").set(index, builder);
            this.envVars.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEnvVars(Env ... items) {
        if (this.envVars == null) {
            this.envVars = new ArrayList();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"envVars").add(builder);
            this.envVars.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToEnvVars(Collection<Env> items) {
        if (this.envVars == null) {
            this.envVars = new ArrayList();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"envVars").add(builder);
            this.envVars.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEnvVars(Env ... items) {
        if (this.envVars == null) {
            return (A)((Object)this);
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"envVars").remove((Object)builder);
            this.envVars.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEnvVars(Collection<Env> items) {
        if (this.envVars == null) {
            return (A)((Object)this);
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"envVars").remove((Object)builder);
            this.envVars.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEnvVars(Predicate<EnvBuilder> predicate) {
        if (this.envVars == null) {
            return (A)((Object)this);
        }
        Iterator<EnvBuilder> each = this.envVars.iterator();
        List visitables = this._visitables.get((Object)"envVars");
        while (each.hasNext()) {
            EnvBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasEnvVars() {
        return this.envVars != null && !this.envVars.isEmpty();
    }

    public EnvVarsNested<A> addNewEnvVar() {
        return new EnvVarsNested(-1, null);
    }

    public EnvVarsNested<A> addNewEnvVarLike(Env item) {
        return new EnvVarsNested(-1, item);
    }

    public EnvVarsNested<A> setNewEnvVarLike(int index, Env item) {
        return new EnvVarsNested(index, item);
    }

    public EnvVarsNested<A> editEnvVar(int index) {
        if (this.envVars.size() <= index) {
            throw new RuntimeException("Can't edit envVars. Index exceeds size.");
        }
        return this.setNewEnvVarLike(index, this.buildEnvVar(index));
    }

    public EnvVarsNested<A> editFirstEnvVar() {
        if (this.envVars.size() == 0) {
            throw new RuntimeException("Can't edit first envVars. The list is empty.");
        }
        return this.setNewEnvVarLike(0, this.buildEnvVar(0));
    }

    public EnvVarsNested<A> editLastEnvVar() {
        int index = this.envVars.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last envVars. The list is empty.");
        }
        return this.setNewEnvVarLike(index, this.buildEnvVar(index));
    }

    public EnvVarsNested<A> editMatchingEnvVar(Predicate<EnvBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.envVars.size(); ++i) {
            if (!predicate.test(this.envVars.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching envVars. No match found.");
        }
        return this.setNewEnvVarLike(index, this.buildEnvVar(index));
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public A withWorkingDir(String workingDir) {
        this.workingDir = workingDir;
        return (A)((Object)this);
    }

    public boolean hasWorkingDir() {
        return this.workingDir != null;
    }

    public A withCommand(String ... command) {
        if (this.command != null) {
            this.command.clear();
            this._visitables.remove((Object)"command");
        }
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (A)((Object)this);
    }

    public String[] getCommand() {
        int size = this.command != null ? this.command.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.command) {
            result[index++] = item;
        }
        return result;
    }

    public A addToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.add(index, item);
        return (A)((Object)this);
    }

    public A setToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.set(index, item);
        return (A)((Object)this);
    }

    public A addToCommand(String ... items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCommand(Collection<String> items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCommand(String ... items) {
        if (this.command == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.command.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCommand(Collection<String> items) {
        if (this.command == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.command.remove(item);
        }
        return (A)((Object)this);
    }

    public boolean hasCommand() {
        return this.command != null && !this.command.isEmpty();
    }

    public A withArguments(String ... arguments) {
        if (this.arguments != null) {
            this.arguments.clear();
            this._visitables.remove((Object)"arguments");
        }
        if (arguments != null) {
            for (String item : arguments) {
                this.addToArguments(item);
            }
        }
        return (A)((Object)this);
    }

    public String[] getArguments() {
        int size = this.arguments != null ? this.arguments.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.arguments) {
            result[index++] = item;
        }
        return result;
    }

    public A addToArguments(int index, String item) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<String>();
        }
        this.arguments.add(index, item);
        return (A)((Object)this);
    }

    public A setToArguments(int index, String item) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<String>();
        }
        this.arguments.set(index, item);
        return (A)((Object)this);
    }

    public A addToArguments(String ... items) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<String>();
        }
        for (String item : items) {
            this.arguments.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToArguments(Collection<String> items) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<String>();
        }
        for (String item : items) {
            this.arguments.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromArguments(String ... items) {
        if (this.arguments == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.arguments.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromArguments(Collection<String> items) {
        if (this.arguments == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.arguments.remove(item);
        }
        return (A)((Object)this);
    }

    public boolean hasArguments() {
        return this.arguments != null && !this.arguments.isEmpty();
    }

    public A withPorts(Port ... ports) {
        if (this.ports != null) {
            this.ports.clear();
            this._visitables.remove((Object)"ports");
        }
        if (ports != null) {
            for (Port item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)((Object)this);
    }

    public Port[] buildPorts() {
        int size = this.ports != null ? this.ports.size() : 0;
        Port[] result = new Port[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.ports) {
            result[index++] = (Port)visitableBuilder.build();
        }
        return result;
    }

    public Port buildPort(int index) {
        return this.ports.get(index).build();
    }

    public Port buildFirstPort() {
        return this.ports.get(0).build();
    }

    public Port buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    public Port buildMatchingPort(Predicate<PortBuilder> predicate) {
        for (PortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPort(Predicate<PortBuilder> predicate) {
        for (PortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToPorts(int index, Port item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        PortBuilder builder = new PortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get((Object)"ports").add(index, builder);
            this.ports.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPorts(int index, Port item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        PortBuilder builder = new PortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get((Object)"ports").set(index, builder);
            this.ports.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPorts(Port ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPorts(Collection<Port> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPorts(Port ... items) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.get((Object)"ports").remove((Object)builder);
            this.ports.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPorts(Collection<Port> items) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.get((Object)"ports").remove((Object)builder);
            this.ports.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPorts(Predicate<PortBuilder> predicate) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        Iterator<PortBuilder> each = this.ports.iterator();
        List visitables = this._visitables.get((Object)"ports");
        while (each.hasNext()) {
            PortBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    public PortsNested<A> addNewPort() {
        return new PortsNested(-1, null);
    }

    public PortsNested<A> addNewPortLike(Port item) {
        return new PortsNested(-1, item);
    }

    public PortsNested<A> setNewPortLike(int index, Port item) {
        return new PortsNested(index, item);
    }

    public PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    public PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editMatchingPort(Predicate<PortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public A withMounts(Mount ... mounts) {
        if (this.mounts != null) {
            this.mounts.clear();
            this._visitables.remove((Object)"mounts");
        }
        if (mounts != null) {
            for (Mount item : mounts) {
                this.addToMounts(item);
            }
        }
        return (A)((Object)this);
    }

    public Mount[] buildMounts() {
        int size = this.mounts != null ? this.mounts.size() : 0;
        Mount[] result = new Mount[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.mounts) {
            result[index++] = (Mount)visitableBuilder.build();
        }
        return result;
    }

    public Mount buildMount(int index) {
        return this.mounts.get(index).build();
    }

    public Mount buildFirstMount() {
        return this.mounts.get(0).build();
    }

    public Mount buildLastMount() {
        return this.mounts.get(this.mounts.size() - 1).build();
    }

    public Mount buildMatchingMount(Predicate<MountBuilder> predicate) {
        for (MountBuilder item : this.mounts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMount(Predicate<MountBuilder> predicate) {
        for (MountBuilder item : this.mounts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToMounts(int index, Mount item) {
        if (this.mounts == null) {
            this.mounts = new ArrayList();
        }
        MountBuilder builder = new MountBuilder(item);
        if (index < 0 || index >= this.mounts.size()) {
            this._visitables.get((Object)"mounts").add(builder);
            this.mounts.add(builder);
        } else {
            this._visitables.get((Object)"mounts").add(index, builder);
            this.mounts.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToMounts(int index, Mount item) {
        if (this.mounts == null) {
            this.mounts = new ArrayList();
        }
        MountBuilder builder = new MountBuilder(item);
        if (index < 0 || index >= this.mounts.size()) {
            this._visitables.get((Object)"mounts").add(builder);
            this.mounts.add(builder);
        } else {
            this._visitables.get((Object)"mounts").set(index, builder);
            this.mounts.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToMounts(Mount ... items) {
        if (this.mounts == null) {
            this.mounts = new ArrayList();
        }
        for (Mount item : items) {
            MountBuilder builder = new MountBuilder(item);
            this._visitables.get((Object)"mounts").add(builder);
            this.mounts.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToMounts(Collection<Mount> items) {
        if (this.mounts == null) {
            this.mounts = new ArrayList();
        }
        for (Mount item : items) {
            MountBuilder builder = new MountBuilder(item);
            this._visitables.get((Object)"mounts").add(builder);
            this.mounts.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromMounts(Mount ... items) {
        if (this.mounts == null) {
            return (A)((Object)this);
        }
        for (Mount item : items) {
            MountBuilder builder = new MountBuilder(item);
            this._visitables.get((Object)"mounts").remove((Object)builder);
            this.mounts.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMounts(Collection<Mount> items) {
        if (this.mounts == null) {
            return (A)((Object)this);
        }
        for (Mount item : items) {
            MountBuilder builder = new MountBuilder(item);
            this._visitables.get((Object)"mounts").remove((Object)builder);
            this.mounts.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromMounts(Predicate<MountBuilder> predicate) {
        if (this.mounts == null) {
            return (A)((Object)this);
        }
        Iterator<MountBuilder> each = this.mounts.iterator();
        List visitables = this._visitables.get((Object)"mounts");
        while (each.hasNext()) {
            MountBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasMounts() {
        return this.mounts != null && !this.mounts.isEmpty();
    }

    public A addNewMount(String name, String path, String subPath, Boolean readOnly) {
        return this.addToMounts(new Mount(name, path, subPath, readOnly));
    }

    public MountsNested<A> addNewMount() {
        return new MountsNested(-1, null);
    }

    public MountsNested<A> addNewMountLike(Mount item) {
        return new MountsNested(-1, item);
    }

    public MountsNested<A> setNewMountLike(int index, Mount item) {
        return new MountsNested(index, item);
    }

    public MountsNested<A> editMount(int index) {
        if (this.mounts.size() <= index) {
            throw new RuntimeException("Can't edit mounts. Index exceeds size.");
        }
        return this.setNewMountLike(index, this.buildMount(index));
    }

    public MountsNested<A> editFirstMount() {
        if (this.mounts.size() == 0) {
            throw new RuntimeException("Can't edit first mounts. The list is empty.");
        }
        return this.setNewMountLike(0, this.buildMount(0));
    }

    public MountsNested<A> editLastMount() {
        int index = this.mounts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last mounts. The list is empty.");
        }
        return this.setNewMountLike(index, this.buildMount(index));
    }

    public MountsNested<A> editMatchingMount(Predicate<MountBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.mounts.size(); ++i) {
            if (!predicate.test(this.mounts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching mounts. No match found.");
        }
        return this.setNewMountLike(index, this.buildMount(index));
    }

    public ImagePullPolicy getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public A withImagePullPolicy(ImagePullPolicy imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return (A)((Object)this);
    }

    public boolean hasImagePullPolicy() {
        return this.imagePullPolicy != null;
    }

    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.get((Object)"livenessProbe").remove((Object)this.livenessProbe);
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.get((Object)"livenessProbe").add(this.livenessProbe);
        } else {
            this.livenessProbe = null;
            this._visitables.get((Object)"livenessProbe").remove((Object)this.livenessProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    public LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNested(null);
    }

    public LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNested(item);
    }

    public LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(null));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(new ProbeBuilder().build()));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(item));
    }

    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.get((Object)"readinessProbe").remove((Object)this.readinessProbe);
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.get((Object)"readinessProbe").add(this.readinessProbe);
        } else {
            this.readinessProbe = null;
            this._visitables.get((Object)"readinessProbe").remove((Object)this.readinessProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    public ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNested(null);
    }

    public ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNested(item);
    }

    public ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(null));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(new ProbeBuilder().build()));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(item));
    }

    public Probe buildStartupProbe() {
        return this.startupProbe != null ? this.startupProbe.build() : null;
    }

    public A withStartupProbe(Probe startupProbe) {
        this._visitables.get((Object)"startupProbe").remove((Object)this.startupProbe);
        if (startupProbe != null) {
            this.startupProbe = new ProbeBuilder(startupProbe);
            this._visitables.get((Object)"startupProbe").add(this.startupProbe);
        } else {
            this.startupProbe = null;
            this._visitables.get((Object)"startupProbe").remove((Object)this.startupProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasStartupProbe() {
        return this.startupProbe != null;
    }

    public StartupProbeNested<A> withNewStartupProbe() {
        return new StartupProbeNested(null);
    }

    public StartupProbeNested<A> withNewStartupProbeLike(Probe item) {
        return new StartupProbeNested(item);
    }

    public StartupProbeNested<A> editStartupProbe() {
        return this.withNewStartupProbeLike(Optional.ofNullable(this.buildStartupProbe()).orElse(null));
    }

    public StartupProbeNested<A> editOrNewStartupProbe() {
        return this.withNewStartupProbeLike(Optional.ofNullable(this.buildStartupProbe()).orElse(new ProbeBuilder().build()));
    }

    public StartupProbeNested<A> editOrNewStartupProbeLike(Probe item) {
        return this.withNewStartupProbeLike(Optional.ofNullable(this.buildStartupProbe()).orElse(item));
    }

    public ResourceRequirements buildRequestResources() {
        return this.requestResources != null ? this.requestResources.build() : null;
    }

    public A withRequestResources(ResourceRequirements requestResources) {
        this._visitables.get((Object)"requestResources").remove((Object)this.requestResources);
        if (requestResources != null) {
            this.requestResources = new ResourceRequirementsBuilder(requestResources);
            this._visitables.get((Object)"requestResources").add(this.requestResources);
        } else {
            this.requestResources = null;
            this._visitables.get((Object)"requestResources").remove((Object)this.requestResources);
        }
        return (A)((Object)this);
    }

    public boolean hasRequestResources() {
        return this.requestResources != null;
    }

    public A withNewRequestResources(String memory, String cpu) {
        return this.withRequestResources(new ResourceRequirements(memory, cpu));
    }

    public RequestResourcesNested<A> withNewRequestResources() {
        return new RequestResourcesNested(null);
    }

    public RequestResourcesNested<A> withNewRequestResourcesLike(ResourceRequirements item) {
        return new RequestResourcesNested(item);
    }

    public RequestResourcesNested<A> editRequestResources() {
        return this.withNewRequestResourcesLike(Optional.ofNullable(this.buildRequestResources()).orElse(null));
    }

    public RequestResourcesNested<A> editOrNewRequestResources() {
        return this.withNewRequestResourcesLike(Optional.ofNullable(this.buildRequestResources()).orElse(new ResourceRequirementsBuilder().build()));
    }

    public RequestResourcesNested<A> editOrNewRequestResourcesLike(ResourceRequirements item) {
        return this.withNewRequestResourcesLike(Optional.ofNullable(this.buildRequestResources()).orElse(item));
    }

    public ResourceRequirements buildLimitResources() {
        return this.limitResources != null ? this.limitResources.build() : null;
    }

    public A withLimitResources(ResourceRequirements limitResources) {
        this._visitables.get((Object)"limitResources").remove((Object)this.limitResources);
        if (limitResources != null) {
            this.limitResources = new ResourceRequirementsBuilder(limitResources);
            this._visitables.get((Object)"limitResources").add(this.limitResources);
        } else {
            this.limitResources = null;
            this._visitables.get((Object)"limitResources").remove((Object)this.limitResources);
        }
        return (A)((Object)this);
    }

    public boolean hasLimitResources() {
        return this.limitResources != null;
    }

    public A withNewLimitResources(String memory, String cpu) {
        return this.withLimitResources(new ResourceRequirements(memory, cpu));
    }

    public LimitResourcesNested<A> withNewLimitResources() {
        return new LimitResourcesNested(null);
    }

    public LimitResourcesNested<A> withNewLimitResourcesLike(ResourceRequirements item) {
        return new LimitResourcesNested(item);
    }

    public LimitResourcesNested<A> editLimitResources() {
        return this.withNewLimitResourcesLike(Optional.ofNullable(this.buildLimitResources()).orElse(null));
    }

    public LimitResourcesNested<A> editOrNewLimitResources() {
        return this.withNewLimitResourcesLike(Optional.ofNullable(this.buildLimitResources()).orElse(new ResourceRequirementsBuilder().build()));
    }

    public LimitResourcesNested<A> editOrNewLimitResourcesLike(ResourceRequirements item) {
        return this.withNewLimitResourcesLike(Optional.ofNullable(this.buildLimitResources()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerFluent that = (ContainerFluent)((Object)o);
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.envVars, that.envVars)) {
            return false;
        }
        if (!Objects.equals(this.workingDir, that.workingDir)) {
            return false;
        }
        if (!Objects.equals(this.command, that.command)) {
            return false;
        }
        if (!Objects.equals(this.arguments, that.arguments)) {
            return false;
        }
        if (!Objects.equals(this.ports, that.ports)) {
            return false;
        }
        if (!Objects.equals(this.mounts, that.mounts)) {
            return false;
        }
        if (!Objects.equals((Object)this.imagePullPolicy, (Object)that.imagePullPolicy)) {
            return false;
        }
        if (!Objects.equals((Object)this.livenessProbe, (Object)that.livenessProbe)) {
            return false;
        }
        if (!Objects.equals((Object)this.readinessProbe, (Object)that.readinessProbe)) {
            return false;
        }
        if (!Objects.equals((Object)this.startupProbe, (Object)that.startupProbe)) {
            return false;
        }
        if (!Objects.equals((Object)this.requestResources, (Object)that.requestResources)) {
            return false;
        }
        return Objects.equals((Object)this.limitResources, (Object)that.limitResources);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.image, this.name, this.envVars, this.workingDir, this.command, this.arguments, this.ports, this.mounts, this.imagePullPolicy, this.livenessProbe, this.readinessProbe, this.startupProbe, this.requestResources, this.limitResources, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.envVars != null) {
            sb.append("envVars:");
            sb.append(this.envVars + ",");
        }
        if (this.workingDir != null) {
            sb.append("workingDir:");
            sb.append(this.workingDir + ",");
        }
        if (this.command != null && !this.command.isEmpty()) {
            sb.append("command:");
            sb.append(this.command + ",");
        }
        if (this.arguments != null && !this.arguments.isEmpty()) {
            sb.append("arguments:");
            sb.append(this.arguments + ",");
        }
        if (this.ports != null) {
            sb.append("ports:");
            sb.append(this.ports + ",");
        }
        if (this.mounts != null) {
            sb.append("mounts:");
            sb.append(this.mounts + ",");
        }
        if (this.imagePullPolicy != null) {
            sb.append("imagePullPolicy:");
            sb.append((Object)((Object)this.imagePullPolicy) + ",");
        }
        if (this.livenessProbe != null) {
            sb.append("livenessProbe:");
            sb.append((Object)((Object)this.livenessProbe) + ",");
        }
        if (this.readinessProbe != null) {
            sb.append("readinessProbe:");
            sb.append((Object)((Object)this.readinessProbe) + ",");
        }
        if (this.startupProbe != null) {
            sb.append("startupProbe:");
            sb.append((Object)((Object)this.startupProbe) + ",");
        }
        if (this.requestResources != null) {
            sb.append("requestResources:");
            sb.append((Object)((Object)this.requestResources) + ",");
        }
        if (this.limitResources != null) {
            sb.append("limitResources:");
            sb.append((Object)this.limitResources);
        }
        sb.append("}");
        return sb.toString();
    }

    public class LimitResourcesNested<N>
    extends ResourceRequirementsFluent<LimitResourcesNested<N>>
    implements Nested<N> {
        ResourceRequirementsBuilder builder;

        LimitResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        public N and() {
            return (N)ContainerFluent.this.withLimitResources(this.builder.build());
        }

        public N endLimitResources() {
            return this.and();
        }
    }

    public class RequestResourcesNested<N>
    extends ResourceRequirementsFluent<RequestResourcesNested<N>>
    implements Nested<N> {
        ResourceRequirementsBuilder builder;

        RequestResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        public N and() {
            return (N)ContainerFluent.this.withRequestResources(this.builder.build());
        }

        public N endRequestResources() {
            return this.and();
        }
    }

    public class StartupProbeNested<N>
    extends ProbeFluent<StartupProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        StartupProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)ContainerFluent.this.withStartupProbe(this.builder.build());
        }

        public N endStartupProbe() {
            return this.and();
        }
    }

    public class ReadinessProbeNested<N>
    extends ProbeFluent<ReadinessProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        ReadinessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)ContainerFluent.this.withReadinessProbe(this.builder.build());
        }

        public N endReadinessProbe() {
            return this.and();
        }
    }

    public class LivenessProbeNested<N>
    extends ProbeFluent<LivenessProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        LivenessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)ContainerFluent.this.withLivenessProbe(this.builder.build());
        }

        public N endLivenessProbe() {
            return this.and();
        }
    }

    public class MountsNested<N>
    extends MountFluent<MountsNested<N>>
    implements Nested<N> {
        MountBuilder builder;
        int index;

        MountsNested(int index, Mount item) {
            this.index = index;
            this.builder = new MountBuilder(this, item);
        }

        public N and() {
            return (N)ContainerFluent.this.setToMounts(this.index, this.builder.build());
        }

        public N endMount() {
            return this.and();
        }
    }

    public class PortsNested<N>
    extends PortFluent<PortsNested<N>>
    implements Nested<N> {
        PortBuilder builder;
        int index;

        PortsNested(int index, Port item) {
            this.index = index;
            this.builder = new PortBuilder(this, item);
        }

        public N and() {
            return (N)ContainerFluent.this.setToPorts(this.index, this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }

    public class EnvVarsNested<N>
    extends EnvFluent<EnvVarsNested<N>>
    implements Nested<N> {
        EnvBuilder builder;
        int index;

        EnvVarsNested(int index, Env item) {
            this.index = index;
            this.builder = new EnvBuilder(this, item);
        }

        public N and() {
            return (N)ContainerFluent.this.setToEnvVars(this.index, this.builder.build());
        }

        public N endEnvVar() {
            return this.and();
        }
    }
}

