/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.config.AzureFileVolumeBuilder;
import java.util.Objects;

public class AzureFileVolume {
    private String volumeName;
    private String shareName;
    private String secretName;
    private Boolean readOnly;

    public AzureFileVolume() {
    }

    public AzureFileVolume(String volumeName, String shareName, String secretName, Boolean readOnly) {
        this.volumeName = volumeName;
        this.shareName = shareName;
        this.secretName = secretName;
        this.readOnly = readOnly;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getShareName() {
        return this.shareName;
    }

    public String getSecretName() {
        return this.secretName;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly != null && this.readOnly != false;
    }

    public static AzureFileVolumeBuilder newBuilder() {
        return new AzureFileVolumeBuilder();
    }

    public static AzureFileVolumeBuilder newBuilderFromDefaults() {
        return (AzureFileVolumeBuilder)((Object)new AzureFileVolumeBuilder().withReadOnly(false));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AzureFileVolume that = (AzureFileVolume)o;
        if (!Objects.equals(this.volumeName, that.volumeName)) {
            return false;
        }
        if (!Objects.equals(this.shareName, that.shareName)) {
            return false;
        }
        if (!Objects.equals(this.secretName, that.secretName)) {
            return false;
        }
        return Objects.equals(this.readOnly, that.readOnly);
    }

    public int hashCode() {
        return Objects.hash(this.volumeName, this.shareName, this.secretName, this.readOnly, super.hashCode());
    }
}

