package io.dekorate.openshift.config;

import io.dekorate.kubernetes.config.RollingUpdate;
import io.dekorate.kubernetes.config.AzureDiskVolume;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolume;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.Mount;
import java.lang.String;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ResourceRequirements;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.annotation.ServiceType;
import io.dekorate.kubernetes.config.EmptyDirVolume;
import io.dekorate.kubernetes.config.Job;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.SecretVolume;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.kubernetes.config.DeploymentStrategy;
import io.dekorate.kubernetes.config.HostAlias;
import java.lang.Integer;
import io.dekorate.project.Project;
import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.config.CronJob;
import java.lang.Object;
import java.util.Map;
import io.dekorate.kubernetes.config.GitRepoVolume;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.kubernetes.config.HostAlias.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class OpenshiftConfig extends BaseConfig{
  public OpenshiftConfig() {
  }
  
  public OpenshiftConfig(Project project,Map<ConfigKey,Object> attributes,String partOf,String name,String version,String deploymentKind,Label[] labels,Annotation[] annotations,Env[] envVars,String workingDir,String[] command,String[] arguments,String serviceAccount,Port[] ports,ServiceType serviceType,PersistentVolumeClaimVolume[] pvcVolumes,SecretVolume[] secretVolumes,ConfigMapVolume[] configMapVolumes,EmptyDirVolume[] emptyDirVolumes,GitRepoVolume[] gitRepoVolumes,AwsElasticBlockStoreVolume[] awsElasticBlockStoreVolumes,AzureDiskVolume[] azureDiskVolumes,AzureFileVolume[] azureFileVolumes,Mount[] mounts,ImagePullPolicy imagePullPolicy,String[] imagePullSecrets,DeploymentStrategy deploymentStrategy,RollingUpdate rollingUpdate,HostAlias[] hostAliases,Probe livenessProbe,Probe readinessProbe,Probe startupProbe,ResourceRequirements requestResources,ResourceRequirements limitResources,Container[] sidecars,Boolean autoDeployEnabled,Job[] jobs,CronJob[] cronJobs,Container[] initContainers,Integer replicas,Route route,Boolean headless) {
    super(project, attributes, partOf, name, version, deploymentKind, labels, annotations, envVars, workingDir, command, arguments, serviceAccount, ports, serviceType, pvcVolumes, secretVolumes, configMapVolumes, emptyDirVolumes, gitRepoVolumes, awsElasticBlockStoreVolumes, azureDiskVolumes, azureFileVolumes, mounts, imagePullPolicy, imagePullSecrets, deploymentStrategy, rollingUpdate, hostAliases, livenessProbe, readinessProbe, startupProbe, requestResources, limitResources, sidecars, autoDeployEnabled, jobs, cronJobs);
    this.initContainers = initContainers != null ? initContainers : new Container[0];
    this.replicas = replicas;
    this.route = route;
    this.headless = headless;
  }
  private Container[] initContainers = new Container[0];
  private Integer replicas;
  private Route route;
  private Boolean headless;
  
  
  /**
   * The init containers.
   * @return the init containers.
   */
  public Container[] getInitContainers() {
    return this.initContainers;
  }
  
  
  /**
   * The number of replicas to use.
   * @return The number of replicas.
   */
  public Integer getReplicas() {
    return this.replicas;
  }
  
  
  /**
   * @return the Route resource configuration.
   */
  public Route getRoute() {
    return this.route;
  }
  
  
  /**
   * Controls whether the generated {@link Service} will be headless.
   * @return true if headless.
   */
  public Boolean getHeadless() {
    return this.headless;
  }
  
  
  /**
   * Controls whether the generated {@link Service} will be headless.
   * @return true if headless.
   */
  public boolean isHeadless() {
    return this.headless != null &&  this.headless;
  }
  
  public static OpenshiftConfigBuilder newOpenshiftConfigBuilder() {
    return new OpenshiftConfigBuilder();
  }
  
  public static OpenshiftConfigBuilder newOpenshiftConfigBuilderFromDefaults() {
    return new OpenshiftConfigBuilder().withDeploymentKind("DeploymentConfig").withReplicas(1).withDeploymentStrategy(io.dekorate.kubernetes.config.DeploymentStrategy.None).withServiceType(io.dekorate.kubernetes.annotation.ServiceType.ClusterIP).withImagePullPolicy(io.dekorate.kubernetes.annotation.ImagePullPolicy.IfNotPresent).withRoute(new Route()).withHeadless(false).withAutoDeployEnabled(false);
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OpenshiftConfig that = (OpenshiftConfig) o;
    if (!java.util.Objects.equals(initContainers, that.initContainers)) return false;
    if (!java.util.Objects.equals(replicas, that.replicas)) return false;
    if (!java.util.Objects.equals(route, that.route)) return false;
    if (!java.util.Objects.equals(headless, that.headless)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(initContainers,  replicas,  route,  headless,  super.hashCode());
  }
  

}