package io.dekorate.option.config;

import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class VcsConfig extends Configuration{
  public VcsConfig() {
  }
  
  public VcsConfig(Project project,Map<ConfigKey,Object> attributes,String remote,Boolean httpsPreferred) {
    super(project, attributes);
    this.remote = remote;
    this.httpsPreferred = httpsPreferred;
  }
  private String remote;
  private Boolean httpsPreferred;
  
  
  /**
   * The remote to use.
   * @return the name of the remote, defaults to 'origin'.
   */
  public String getRemote() {
    return this.remote;
  }
  
  
  /**
   * Flag that specifies that https is preferred.
   * When use vcs url that use 'git+ssh' will be converted to https.
   * @return true, if https is prefered.
   */
  public Boolean getHttpsPreferred() {
    return this.httpsPreferred;
  }
  
  
  /**
   * Flag that specifies that https is preferred.
   * When use vcs url that use 'git+ssh' will be converted to https.
   * @return true, if https is prefered.
   */
  public boolean isHttpsPreferred() {
    return this.httpsPreferred != null &&  this.httpsPreferred;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VcsConfig that = (VcsConfig) o;
    if (!java.util.Objects.equals(remote, that.remote)) return false;
    if (!java.util.Objects.equals(httpsPreferred, that.httpsPreferred)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(remote,  httpsPreferred,  super.hashCode());
  }
  

}