package io.dekorate.prometheus.config;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import java.lang.Object;
import io.dekorate.kubernetes.config.ConfigurationFluent;
import java.lang.String;
import java.lang.Boolean;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ServiceMonitorConfigFluent<A extends ServiceMonitorConfigFluent<A>> extends ConfigurationFluent<A>{
  public ServiceMonitorConfigFluent() {
  }
  
  public ServiceMonitorConfigFluent(ServiceMonitorConfig instance) {
    this.copyInstance(instance);
  }
  private String port;
  private String path;
  private Integer interval;
  private Boolean honorLabels;
  
  protected void copyInstance(ServiceMonitorConfig instance) {
    instance = (instance != null ? instance : new ServiceMonitorConfig());
    if (instance != null) {
          this.withProject(instance.getProject());
          this.withAttributes(instance.getAttributes());
          this.withPort(instance.getPort());
          this.withPath(instance.getPath());
          this.withInterval(instance.getInterval());
          this.withHonorLabels(instance.getHonorLabels());
        }
  }
  
  public String getPort() {
    return this.port;
  }
  
  public A withPort(String port) {
    this.port = port;
    return (A) this;
  }
  
  public boolean hasPort() {
    return this.port != null;
  }
  
  public String getPath() {
    return this.path;
  }
  
  public A withPath(String path) {
    this.path = path;
    return (A) this;
  }
  
  public boolean hasPath() {
    return this.path != null;
  }
  
  public Integer getInterval() {
    return this.interval;
  }
  
  public A withInterval(Integer interval) {
    this.interval = interval;
    return (A) this;
  }
  
  public boolean hasInterval() {
    return this.interval != null;
  }
  
  public Boolean getHonorLabels() {
    return this.honorLabels;
  }
  
  public A withHonorLabels(Boolean honorLabels) {
    this.honorLabels = honorLabels;
    return (A) this;
  }
  
  public boolean hasHonorLabels() {
    return this.honorLabels != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceMonitorConfigFluent that = (ServiceMonitorConfigFluent) o;
    if (!java.util.Objects.equals(port, that.port)) return false;
    if (!java.util.Objects.equals(path, that.path)) return false;
    if (!java.util.Objects.equals(interval, that.interval)) return false;
    if (!java.util.Objects.equals(honorLabels, that.honorLabels)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(port,  path,  interval,  honorLabels,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (interval != null) { sb.append("interval:"); sb.append(interval + ","); }
    if (honorLabels != null) { sb.append("honorLabels:"); sb.append(honorLabels); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withHonorLabels() {
    return withHonorLabels(true);
  }
  

}