/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.BaseFluent;
import io.fabric8.common.Fluent;
import io.fabric8.common.Nested;
import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.BaseKubernetesList;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsBuilder;
import io.fabric8.kubernetes.api.model.EndpointsFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeBuilder;
import io.fabric8.kubernetes.api.model.NodeFluent;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildBuilder;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildFluent;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.Image;
import io.fabric8.openshift.api.model.ImageBuilder;
import io.fabric8.openshift.api.model.ImageFluent;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.OAuthAccessTokenBuilder;
import io.fabric8.openshift.api.model.OAuthAccessTokenFluent;
import io.fabric8.openshift.api.model.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenFluent;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent;
import io.fabric8.openshift.api.model.OAuthClientBuilder;
import io.fabric8.openshift.api.model.OAuthClientFluent;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.openshift.api.model.template.Template;
import io.fabric8.openshift.api.model.template.TemplateBuilder;
import io.fabric8.openshift.api.model.template.TemplateFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseKubernetesListFluent<T extends BaseKubernetesListFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    BaseKubernetesList.ApiVersion apiVersion;
    List<HasMetadata> items = new ArrayList<HasMetadata>();
    List<VisitableBuilder<Build, ?>> buildItems = new ArrayList();
    List<VisitableBuilder<BuildConfig, ?>> buildConfigItems = new ArrayList();
    List<VisitableBuilder<DeploymentConfig, ?>> deploymentConfigItems = new ArrayList();
    List<VisitableBuilder<Image, ?>> imageItems = new ArrayList();
    List<VisitableBuilder<ImageStream, ?>> imageStreamItems = new ArrayList();
    List<VisitableBuilder<OAuthAccessToken, ?>> oAuthAccessTokenItems = new ArrayList();
    List<VisitableBuilder<OAuthAuthorizeToken, ?>> oAuthAuthorizeTokenItems = new ArrayList();
    List<VisitableBuilder<OAuthClient, ?>> oAuthClientItems = new ArrayList();
    List<VisitableBuilder<OAuthClientAuthorization, ?>> oAuthClientAuthorizationItems = new ArrayList();
    List<VisitableBuilder<Route, ?>> routeItems = new ArrayList();
    List<VisitableBuilder<Template, ?>> templateItems = new ArrayList();
    List<VisitableBuilder<Endpoints, ?>> endpointsItems = new ArrayList();
    List<VisitableBuilder<Namespace, ?>> namespaceItems = new ArrayList();
    List<VisitableBuilder<Node, ?>> nodeItems = new ArrayList();
    List<VisitableBuilder<Pod, ?>> podItems = new ArrayList();
    List<VisitableBuilder<ReplicationController, ?>> replicationControllerItems = new ArrayList();
    List<VisitableBuilder<Secret, ?>> secretItems = new ArrayList();
    List<VisitableBuilder<Service, ?>> serviceItems = new ArrayList();
    List<VisitableBuilder<ServiceAccount, ?>> serviceAccountItems = new ArrayList();
    String kind;
    VisitableBuilder<ListMeta, ?> metadata;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public BaseKubernetesList.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(BaseKubernetesList.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    public T addToItems(HasMetadata item) {
        if (item instanceof Build) {
            this.addToBuildItems((Build)item);
        } else if (item instanceof BuildConfig) {
            this.addToBuildConfigItems((BuildConfig)item);
        } else if (item instanceof DeploymentConfig) {
            this.addToDeploymentConfigItems((DeploymentConfig)item);
        } else if (item instanceof Image) {
            this.addToImageItems((Image)item);
        } else if (item instanceof ImageStream) {
            this.addToImageStreamItems((ImageStream)item);
        } else if (item instanceof OAuthAccessToken) {
            this.addToOAuthAccessTokenItems((OAuthAccessToken)item);
        } else if (item instanceof OAuthAuthorizeToken) {
            this.addToOAuthAuthorizeTokenItems((OAuthAuthorizeToken)item);
        } else if (item instanceof OAuthClient) {
            this.addToOAuthClientItems((OAuthClient)item);
        } else if (item instanceof OAuthClientAuthorization) {
            this.addToOAuthClientAuthorizationItems((OAuthClientAuthorization)item);
        } else if (item instanceof Route) {
            this.addToRouteItems((Route)item);
        } else if (item instanceof Template) {
            this.addToTemplateItems((Template)item);
        } else if (item instanceof Endpoints) {
            this.addToEndpointsItems((Endpoints)item);
        } else if (item instanceof Namespace) {
            this.addToNamespaceItems((Namespace)item);
        } else if (item instanceof Node) {
            this.addToNodeItems((Node)item);
        } else if (item instanceof Pod) {
            this.addToPodItems((Pod)item);
        } else if (item instanceof ReplicationController) {
            this.addToReplicationControllerItems((ReplicationController)item);
        } else if (item instanceof Secret) {
            this.addToSecretItems((Secret)item);
        } else if (item instanceof Service) {
            this.addToServiceItems((Service)item);
        } else if (item instanceof ServiceAccount) {
            this.addToServiceAccountItems((ServiceAccount)item);
        }
        return (T)this;
    }

    public List<HasMetadata> getItems() {
        return this.aggregate(this.build(this.buildItems), this.build(this.buildConfigItems), this.build(this.deploymentConfigItems), this.build(this.imageItems), this.build(this.imageStreamItems), this.build(this.oAuthAccessTokenItems), this.build(this.oAuthAuthorizeTokenItems), this.build(this.oAuthClientItems), this.build(this.oAuthClientAuthorizationItems), this.build(this.routeItems), this.build(this.templateItems), this.build(this.endpointsItems), this.build(this.namespaceItems), this.build(this.nodeItems), this.build(this.podItems), this.build(this.replicationControllerItems), this.build(this.secretItems), this.build(this.serviceItems), this.build(this.serviceAccountItems));
    }

    public T withItems(List<HasMetadata> items) {
        this.items.clear();
        if (items != null) {
            for (HasMetadata item : items) {
                this.addToItems(item);
            }
        }
        return (T)this;
    }

    public T addToBuildItems(Build item) {
        if (item != null) {
            BuildBuilder builder = new BuildBuilder(item);
            this._visitables.add(builder);
            this.buildItems.add(builder);
        }
        return (T)this;
    }

    public BuildItemsNested<T> addNewBuildItem() {
        return new BuildItemsNested();
    }

    public T addToBuildConfigItems(BuildConfig item) {
        if (item != null) {
            BuildConfigBuilder builder = new BuildConfigBuilder(item);
            this._visitables.add(builder);
            this.buildConfigItems.add(builder);
        }
        return (T)this;
    }

    public BuildConfigItemsNested<T> addNewBuildConfigItem() {
        return new BuildConfigItemsNested();
    }

    public T addToDeploymentConfigItems(DeploymentConfig item) {
        if (item != null) {
            DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);
            this._visitables.add(builder);
            this.deploymentConfigItems.add(builder);
        }
        return (T)this;
    }

    public DeploymentConfigItemsNested<T> addNewDeploymentConfigItem() {
        return new DeploymentConfigItemsNested();
    }

    public T addToImageItems(Image item) {
        if (item != null) {
            ImageBuilder builder = new ImageBuilder(item);
            this._visitables.add(builder);
            this.imageItems.add(builder);
        }
        return (T)this;
    }

    public ImageItemsNested<T> addNewImageItem() {
        return new ImageItemsNested();
    }

    public T addToImageStreamItems(ImageStream item) {
        if (item != null) {
            ImageStreamBuilder builder = new ImageStreamBuilder(item);
            this._visitables.add(builder);
            this.imageStreamItems.add(builder);
        }
        return (T)this;
    }

    public ImageStreamItemsNested<T> addNewImageStreamItem() {
        return new ImageStreamItemsNested();
    }

    public T addToOAuthAccessTokenItems(OAuthAccessToken item) {
        if (item != null) {
            OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);
            this._visitables.add(builder);
            this.oAuthAccessTokenItems.add(builder);
        }
        return (T)this;
    }

    public OAuthAccessTokenItemsNested<T> addNewOAuthAccessTokenItem() {
        return new OAuthAccessTokenItemsNested();
    }

    public T addToOAuthAuthorizeTokenItems(OAuthAuthorizeToken item) {
        if (item != null) {
            OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);
            this._visitables.add(builder);
            this.oAuthAuthorizeTokenItems.add(builder);
        }
        return (T)this;
    }

    public OAuthAuthorizeTokenItemsNested<T> addNewOAuthAuthorizeTokenItem() {
        return new OAuthAuthorizeTokenItemsNested();
    }

    public T addToOAuthClientItems(OAuthClient item) {
        if (item != null) {
            OAuthClientBuilder builder = new OAuthClientBuilder(item);
            this._visitables.add(builder);
            this.oAuthClientItems.add(builder);
        }
        return (T)this;
    }

    public OAuthClientItemsNested<T> addNewOAuthClientItem() {
        return new OAuthClientItemsNested();
    }

    public T addToOAuthClientAuthorizationItems(OAuthClientAuthorization item) {
        if (item != null) {
            OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);
            this._visitables.add(builder);
            this.oAuthClientAuthorizationItems.add(builder);
        }
        return (T)this;
    }

    public OAuthClientAuthorizationItemsNested<T> addNewOAuthClientAuthorizationItem() {
        return new OAuthClientAuthorizationItemsNested();
    }

    public T addToRouteItems(Route item) {
        if (item != null) {
            RouteBuilder builder = new RouteBuilder(item);
            this._visitables.add(builder);
            this.routeItems.add(builder);
        }
        return (T)this;
    }

    public RouteItemsNested<T> addNewRouteItem() {
        return new RouteItemsNested();
    }

    public T addToTemplateItems(Template item) {
        if (item != null) {
            TemplateBuilder builder = new TemplateBuilder(item);
            this._visitables.add(builder);
            this.templateItems.add(builder);
        }
        return (T)this;
    }

    public TemplateItemsNested<T> addNewTemplateItem() {
        return new TemplateItemsNested();
    }

    public T addToEndpointsItems(Endpoints item) {
        if (item != null) {
            EndpointsBuilder builder = new EndpointsBuilder(item);
            this._visitables.add(builder);
            this.endpointsItems.add(builder);
        }
        return (T)this;
    }

    public EndpointsItemsNested<T> addNewEndpointsItem() {
        return new EndpointsItemsNested();
    }

    public T addToNamespaceItems(Namespace item) {
        if (item != null) {
            NamespaceBuilder builder = new NamespaceBuilder(item);
            this._visitables.add(builder);
            this.namespaceItems.add(builder);
        }
        return (T)this;
    }

    public NamespaceItemsNested<T> addNewNamespaceItem() {
        return new NamespaceItemsNested();
    }

    public T addToNodeItems(Node item) {
        if (item != null) {
            NodeBuilder builder = new NodeBuilder(item);
            this._visitables.add(builder);
            this.nodeItems.add(builder);
        }
        return (T)this;
    }

    public NodeItemsNested<T> addNewNodeItem() {
        return new NodeItemsNested();
    }

    public T addToPodItems(Pod item) {
        if (item != null) {
            PodBuilder builder = new PodBuilder(item);
            this._visitables.add(builder);
            this.podItems.add(builder);
        }
        return (T)this;
    }

    public PodItemsNested<T> addNewPodItem() {
        return new PodItemsNested();
    }

    public T addToReplicationControllerItems(ReplicationController item) {
        if (item != null) {
            ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);
            this._visitables.add(builder);
            this.replicationControllerItems.add(builder);
        }
        return (T)this;
    }

    public ReplicationControllerItemsNested<T> addNewReplicationControllerItem() {
        return new ReplicationControllerItemsNested();
    }

    public T addToSecretItems(Secret item) {
        if (item != null) {
            SecretBuilder builder = new SecretBuilder(item);
            this._visitables.add(builder);
            this.secretItems.add(builder);
        }
        return (T)this;
    }

    public SecretItemsNested<T> addNewSecretItem() {
        return new SecretItemsNested();
    }

    public T addToServiceItems(Service item) {
        if (item != null) {
            ServiceBuilder builder = new ServiceBuilder(item);
            this._visitables.add(builder);
            this.serviceItems.add(builder);
        }
        return (T)this;
    }

    public ServiceItemsNested<T> addNewServiceItem() {
        return new ServiceItemsNested();
    }

    public T addToServiceAccountItems(ServiceAccount item) {
        if (item != null) {
            ServiceAccountBuilder builder = new ServiceAccountBuilder(item);
            this._visitables.add(builder);
            this.serviceAccountItems.add(builder);
        }
        return (T)this;
    }

    public ServiceAccountItemsNested<T> addNewServiceAccountItem() {
        return new ServiceAccountItemsNested();
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    public ListMeta getMetadata() {
        return this.metadata != null ? (ListMeta)this.metadata.build() : null;
    }

    public T withMetadata(ListMeta metadata) {
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public T withNewMetadata(String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public class MetadataNested<N>
    extends ListMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ListMetaBuilder builder = new ListMetaBuilder(this);

        @Override
        public N and() {
            return (N)BaseKubernetesListFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class ServiceAccountItemsNested<N>
    extends ServiceAccountFluent<ServiceAccountItemsNested<N>>
    implements Nested<N> {
        private final ServiceAccountBuilder builder = new ServiceAccountBuilder(this);

        public N endServiceAccountItem() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BaseKubernetesListFluent.this.addToServiceAccountItems(this.builder.build());
        }
    }

    public class ServiceItemsNested<N>
    extends ServiceFluent<ServiceItemsNested<N>>
    implements Nested<N> {
        private final ServiceBuilder builder = new ServiceBuilder(this);

        public N endServiceItem() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BaseKubernetesListFluent.this.addToServiceItems(this.builder.build());
        }
    }

    public class SecretItemsNested<N>
    extends SecretFluent<SecretItemsNested<N>>
    implements Nested<N> {
        private final SecretBuilder builder = new SecretBuilder(this);

        public N endSecretItem() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BaseKubernetesListFluent.this.addToSecretItems(this.builder.build());
        }
    }

    public class ReplicationControllerItemsNested<N>
    extends ReplicationControllerFluent<ReplicationControllerItemsNested<N>>
    implements Nested<N> {
        private final ReplicationControllerBuilder builder = new ReplicationControllerBuilder(this);

        @Override
        public N and() {
            return (N)BaseKubernetesListFluent.this.addToReplicationControllerItems(this.builder.build());
        }

        public N endReplicationControllerItem() {
            return this.and();
        }
    }

    public class PodItemsNested<N>
    extends PodFluent<PodItemsNested<N>>
    implements Nested<N> {
        private final PodBuilder builder = new PodBuilder(this);

        @Override
        public N and() {
            return (N)BaseKubernetesListFluent.this.addToPodItems(this.builder.build());
        }

        public N endPodItem() {
            return this.and();
        }
    }

    public class NodeItemsNested<N>
    extends NodeFluent<NodeItemsNested<N>>
    implements Nested<N> {
        private final NodeBuilder builder = new NodeBuilder(this);

        @Override
        public N and() {
            return (N)BaseKubernetesListFluent.this.addToNodeItems(this.builder.build());
        }

        public N endNodeItem() {
            return this.and();
        }
    }

    public class NamespaceItemsNested<N>
    extends NamespaceFluent<NamespaceItemsNested<N>>
    implements Nested<N> {
        private final NamespaceBuilder builder = new NamespaceBuilder(this);

        @Override
        public N and() {
            return (N)BaseKubernetesListFluent.this.addToNamespaceItems(this.builder.build());
        }

        public N endNamespaceItem() {
            return this.and();
        }
    }

    public class EndpointsItemsNested<N>
    extends EndpointsFluent<EndpointsItemsNested<N>>
    implements Nested<N> {
        private final EndpointsBuilder builder = new EndpointsBuilder(this);

        public N endEndpointsItem() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BaseKubernetesListFluent.this.addToEndpointsItems(this.builder.build());
        }
    }

    public class TemplateItemsNested<N>
    extends TemplateFluent<TemplateItemsNested<N>>
    implements Nested<N> {
        private final TemplateBuilder builder = new TemplateBuilder(this);

        @Override
        public N and() {
            return (N)BaseKubernetesListFluent.this.addToTemplateItems(this.builder.build());
        }

        public N endTemplateItem() {
            return this.and();
        }
    }

    public class RouteItemsNested<N>
    extends RouteFluent<RouteItemsNested<N>>
    implements Nested<N> {
        private final RouteBuilder builder = new RouteBuilder(this);

        @Override
        public N and() {
            return (N)BaseKubernetesListFluent.this.addToRouteItems(this.builder.build());
        }

        public N endRouteItem() {
            return this.and();
        }
    }

    public class OAuthClientAuthorizationItemsNested<N>
    extends OAuthClientAuthorizationFluent<OAuthClientAuthorizationItemsNested<N>>
    implements Nested<N> {
        private final OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(this);

        public N endOAuthClientAuthorizationItem() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BaseKubernetesListFluent.this.addToOAuthClientAuthorizationItems(this.builder.build());
        }
    }

    public class OAuthClientItemsNested<N>
    extends OAuthClientFluent<OAuthClientItemsNested<N>>
    implements Nested<N> {
        private final OAuthClientBuilder builder = new OAuthClientBuilder(this);

        public N endOAuthClientItem() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BaseKubernetesListFluent.this.addToOAuthClientItems(this.builder.build());
        }
    }

    public class OAuthAuthorizeTokenItemsNested<N>
    extends OAuthAuthorizeTokenFluent<OAuthAuthorizeTokenItemsNested<N>>
    implements Nested<N> {
        private final OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(this);

        @Override
        public N and() {
            return (N)BaseKubernetesListFluent.this.addToOAuthAuthorizeTokenItems(this.builder.build());
        }

        public N endOAuthAuthorizeTokenItem() {
            return this.and();
        }
    }

    public class OAuthAccessTokenItemsNested<N>
    extends OAuthAccessTokenFluent<OAuthAccessTokenItemsNested<N>>
    implements Nested<N> {
        private final OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(this);

        @Override
        public N and() {
            return (N)BaseKubernetesListFluent.this.addToOAuthAccessTokenItems(this.builder.build());
        }

        public N endOAuthAccessTokenItem() {
            return this.and();
        }
    }

    public class ImageStreamItemsNested<N>
    extends ImageStreamFluent<ImageStreamItemsNested<N>>
    implements Nested<N> {
        private final ImageStreamBuilder builder = new ImageStreamBuilder(this);

        public N endImageStreamItem() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BaseKubernetesListFluent.this.addToImageStreamItems(this.builder.build());
        }
    }

    public class ImageItemsNested<N>
    extends ImageFluent<ImageItemsNested<N>>
    implements Nested<N> {
        private final ImageBuilder builder = new ImageBuilder(this);

        public N endImageItem() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BaseKubernetesListFluent.this.addToImageItems(this.builder.build());
        }
    }

    public class DeploymentConfigItemsNested<N>
    extends DeploymentConfigFluent<DeploymentConfigItemsNested<N>>
    implements Nested<N> {
        private final DeploymentConfigBuilder builder = new DeploymentConfigBuilder(this);

        @Override
        public N and() {
            return (N)BaseKubernetesListFluent.this.addToDeploymentConfigItems(this.builder.build());
        }

        public N endDeploymentConfigItem() {
            return this.and();
        }
    }

    public class BuildConfigItemsNested<N>
    extends BuildConfigFluent<BuildConfigItemsNested<N>>
    implements Nested<N> {
        private final BuildConfigBuilder builder = new BuildConfigBuilder(this);

        @Override
        public N and() {
            return (N)BaseKubernetesListFluent.this.addToBuildConfigItems(this.builder.build());
        }

        public N endBuildConfigItem() {
            return this.and();
        }
    }

    public class BuildItemsNested<N>
    extends BuildFluent<BuildItemsNested<N>>
    implements Nested<N> {
        private final BuildBuilder builder = new BuildBuilder(this);

        public N endBuildItem() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BaseKubernetesListFluent.this.addToBuildItems(this.builder.build());
        }
    }
}

