/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.BaseFluent;
import io.fabric8.common.Fluent;
import io.fabric8.common.Nested;
import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContainerStateRunning;
import io.fabric8.kubernetes.api.model.ContainerStateRunningBuilder;
import io.fabric8.kubernetes.api.model.ContainerStateRunningFluent;
import io.fabric8.kubernetes.api.model.ContainerStateTerminated;
import io.fabric8.kubernetes.api.model.ContainerStateTerminatedBuilder;
import io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluent;
import io.fabric8.kubernetes.api.model.ContainerStateWaiting;
import io.fabric8.kubernetes.api.model.ContainerStateWaitingBuilder;
import io.fabric8.kubernetes.api.model.ContainerStateWaitingFluent;
import java.util.HashMap;
import java.util.Map;

public class ContainerStateFluent<T extends ContainerStateFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    VisitableBuilder<ContainerStateRunning, ?> running;
    VisitableBuilder<ContainerStateTerminated, ?> termination;
    VisitableBuilder<ContainerStateWaiting, ?> waiting;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ContainerStateRunning getRunning() {
        return this.running != null ? (ContainerStateRunning)this.running.build() : null;
    }

    public T withRunning(ContainerStateRunning running) {
        if (running != null) {
            this.running = new ContainerStateRunningBuilder(running);
            this._visitables.add(this.running);
        }
        return (T)this;
    }

    public RunningNested<T> withNewRunning() {
        return new RunningNested();
    }

    public T withNewRunning(String startedAt) {
        return this.withRunning(new ContainerStateRunning(startedAt));
    }

    public ContainerStateTerminated getTermination() {
        return this.termination != null ? (ContainerStateTerminated)this.termination.build() : null;
    }

    public T withTermination(ContainerStateTerminated termination) {
        if (termination != null) {
            this.termination = new ContainerStateTerminatedBuilder(termination);
            this._visitables.add(this.termination);
        }
        return (T)this;
    }

    public TerminationNested<T> withNewTermination() {
        return new TerminationNested();
    }

    public ContainerStateWaiting getWaiting() {
        return this.waiting != null ? (ContainerStateWaiting)this.waiting.build() : null;
    }

    public T withWaiting(ContainerStateWaiting waiting) {
        if (waiting != null) {
            this.waiting = new ContainerStateWaitingBuilder(waiting);
            this._visitables.add(this.waiting);
        }
        return (T)this;
    }

    public WaitingNested<T> withNewWaiting() {
        return new WaitingNested();
    }

    public T withNewWaiting(String reason) {
        return this.withWaiting(new ContainerStateWaiting(reason));
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public class WaitingNested<N>
    extends ContainerStateWaitingFluent<WaitingNested<N>>
    implements Nested<N> {
        private final ContainerStateWaitingBuilder builder = new ContainerStateWaitingBuilder(this);

        @Override
        public N and() {
            return (N)ContainerStateFluent.this.withWaiting(this.builder.build());
        }

        public N endWaiting() {
            return this.and();
        }
    }

    public class TerminationNested<N>
    extends ContainerStateTerminatedFluent<TerminationNested<N>>
    implements Nested<N> {
        private final ContainerStateTerminatedBuilder builder = new ContainerStateTerminatedBuilder(this);

        public N endTermination() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ContainerStateFluent.this.withTermination(this.builder.build());
        }
    }

    public class RunningNested<N>
    extends ContainerStateRunningFluent<RunningNested<N>>
    implements Nested<N> {
        private final ContainerStateRunningBuilder builder = new ContainerStateRunningBuilder(this);

        public N endRunning() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ContainerStateFluent.this.withRunning(this.builder.build());
        }
    }
}

