/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContainerStateRunning;
import io.fabric8.kubernetes.api.model.ContainerStateRunningFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContainerStateRunningBuilder
extends ContainerStateRunningFluent<ContainerStateRunningBuilder>
implements VisitableBuilder<ContainerStateRunning, ContainerStateRunningBuilder> {
    ContainerStateRunningFluent<?> fluent;

    public ContainerStateRunningBuilder() {
        this(new ContainerStateRunning());
    }

    public ContainerStateRunningBuilder(ContainerStateRunningFluent<?> fluent) {
        this(fluent, new ContainerStateRunning());
    }

    public ContainerStateRunningBuilder(ContainerStateRunningFluent<?> fluent, ContainerStateRunning instance) {
        this.fluent = fluent;
        fluent.withStartedAt(instance.getStartedAt());
    }

    public ContainerStateRunningBuilder(ContainerStateRunning instance) {
        this.fluent = this;
        this.withStartedAt(instance.getStartedAt());
    }

    @Override
    public ContainerStateRunning build() {
        ContainerStateRunning buildable = new ContainerStateRunning(this.fluent.getStartedAt());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

