/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.BaseFluent;
import io.fabric8.common.Fluent;
import io.fabric8.common.Nested;
import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeSpec;
import io.fabric8.kubernetes.api.model.NodeSpecBuilder;
import io.fabric8.kubernetes.api.model.NodeSpecFluent;
import io.fabric8.kubernetes.api.model.NodeStatus;
import io.fabric8.kubernetes.api.model.NodeStatusBuilder;
import io.fabric8.kubernetes.api.model.NodeStatusFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.util.HashMap;
import java.util.Map;

public class NodeFluent<T extends NodeFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    Node.ApiVersion apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<NodeSpec, ?> spec;
    VisitableBuilder<NodeStatus, ?> status;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Node.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(Node.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public NodeSpec getSpec() {
        return this.spec != null ? (NodeSpec)this.spec.build() : null;
    }

    public T withSpec(NodeSpec spec) {
        if (spec != null) {
            this.spec = new NodeSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (T)this;
    }

    public SpecNested<T> withNewSpec() {
        return new SpecNested();
    }

    public T withNewSpec(String externalID, String podCIDR, Boolean unschedulable) {
        return this.withSpec(new NodeSpec(externalID, podCIDR, unschedulable));
    }

    public NodeStatus getStatus() {
        return this.status != null ? (NodeStatus)this.status.build() : null;
    }

    public T withStatus(NodeStatus status) {
        if (status != null) {
            this.status = new NodeStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (T)this;
    }

    public StatusNested<T> withNewStatus() {
        return new StatusNested();
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public class StatusNested<N>
    extends NodeStatusFluent<StatusNested<N>>
    implements Nested<N> {
        private final NodeStatusBuilder builder = new NodeStatusBuilder(this);

        public N endStatus() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)NodeFluent.this.withStatus(this.builder.build());
        }
    }

    public class SpecNested<N>
    extends NodeSpecFluent<SpecNested<N>>
    implements Nested<N> {
        private final NodeSpecBuilder builder = new NodeSpecBuilder(this);

        public N endSpec() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)NodeFluent.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ObjectMetaBuilder builder = new ObjectMetaBuilder(this);

        @Override
        public N and() {
            return (N)NodeFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

