/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.BaseFluent;
import io.fabric8.common.Fluent;
import io.fabric8.common.Nested;
import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.Secret;
import java.util.HashMap;
import java.util.Map;

public class SecretFluent<T extends SecretFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    Secret.ApiVersion apiVersion;
    Map<String, String> data = new HashMap<String, String>();
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    String type;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Secret.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(Secret.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    public T addToData(String key, String value) {
        if (key != null && value != null) {
            this.data.put(key, value);
        }
        return (T)this;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public T withData(Map<String, String> data) {
        this.data.clear();
        if (data != null) {
            this.data.putAll(data);
        }
        return (T)this;
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public String getType() {
        return this.type;
    }

    public T withType(String type) {
        this.type = type;
        return (T)this;
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ObjectMetaBuilder builder = new ObjectMetaBuilder(this);

        public N endMetadata() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)SecretFluent.this.withMetadata(this.builder.build());
        }
    }
}

