/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.util;

import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.util.IntOrString;
import io.fabric8.kubernetes.api.model.util.IntOrStringFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class IntOrStringBuilder
extends IntOrStringFluent<IntOrStringBuilder>
implements VisitableBuilder<IntOrString, IntOrStringBuilder> {
    IntOrStringFluent<?> fluent;

    public IntOrStringBuilder() {
        this(new IntOrString());
    }

    public IntOrStringBuilder(IntOrStringFluent<?> fluent) {
        this(fluent, new IntOrString());
    }

    public IntOrStringBuilder(IntOrStringFluent<?> fluent, IntOrString instance) {
        this.fluent = fluent;
        fluent.withIntVal(instance.getIntVal());
        fluent.withKind(instance.getKind());
        fluent.withStrVal(instance.getStrVal());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }

    public IntOrStringBuilder(IntOrString instance) {
        this.fluent = this;
        this.withIntVal(instance.getIntVal());
        this.withKind(instance.getKind());
        this.withStrVal(instance.getStrVal());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public IntOrString build() {
        IntOrString buildable = new IntOrString(this.fluent.getIntVal(), this.fluent.getKind(), this.fluent.getStrVal(), this.fluent.getAdditionalProperties());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

