/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.common.BaseFluent;
import io.fabric8.common.Fluent;
import io.fabric8.common.Nested;
import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.DeploymentConfigSpecBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DeploymentConfigStatus;
import io.fabric8.openshift.api.model.DeploymentConfigStatusBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigStatusFluent;
import java.util.HashMap;
import java.util.Map;

public class DeploymentConfigFluent<T extends DeploymentConfigFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    DeploymentConfig.ApiVersion apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<DeploymentConfigSpec, ?> spec;
    VisitableBuilder<DeploymentConfigStatus, ?> status;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public DeploymentConfig.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(DeploymentConfig.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public DeploymentConfigSpec getSpec() {
        return this.spec != null ? (DeploymentConfigSpec)this.spec.build() : null;
    }

    public T withSpec(DeploymentConfigSpec spec) {
        if (spec != null) {
            this.spec = new DeploymentConfigSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (T)this;
    }

    public SpecNested<T> withNewSpec() {
        return new SpecNested();
    }

    public DeploymentConfigStatus getStatus() {
        return this.status != null ? (DeploymentConfigStatus)this.status.build() : null;
    }

    public T withStatus(DeploymentConfigStatus status) {
        if (status != null) {
            this.status = new DeploymentConfigStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (T)this;
    }

    public StatusNested<T> withNewStatus() {
        return new StatusNested();
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public class StatusNested<N>
    extends DeploymentConfigStatusFluent<StatusNested<N>>
    implements Nested<N> {
        private final DeploymentConfigStatusBuilder builder = new DeploymentConfigStatusBuilder(this);

        @Override
        public N and() {
            return (N)DeploymentConfigFluent.this.withStatus(this.builder.build());
        }

        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNested<N>
    extends DeploymentConfigSpecFluent<SpecNested<N>>
    implements Nested<N> {
        private final DeploymentConfigSpecBuilder builder = new DeploymentConfigSpecBuilder(this);

        @Override
        public N and() {
            return (N)DeploymentConfigFluent.this.withSpec(this.builder.build());
        }

        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ObjectMetaBuilder builder = new ObjectMetaBuilder(this);

        @Override
        public N and() {
            return (N)DeploymentConfigFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

