/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.common.BaseFluent;
import io.fabric8.common.Fluent;
import io.fabric8.common.Nested;
import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamSpec;
import io.fabric8.openshift.api.model.ImageStreamSpecBuilder;
import io.fabric8.openshift.api.model.ImageStreamSpecFluent;
import io.fabric8.openshift.api.model.ImageStreamStatus;
import io.fabric8.openshift.api.model.ImageStreamStatusBuilder;
import io.fabric8.openshift.api.model.ImageStreamStatusFluent;
import java.util.HashMap;
import java.util.Map;

public class ImageStreamFluent<T extends ImageStreamFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    ImageStream.ApiVersion apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<ImageStreamSpec, ?> spec;
    VisitableBuilder<ImageStreamStatus, ?> status;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ImageStream.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(ImageStream.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public ImageStreamSpec getSpec() {
        return this.spec != null ? (ImageStreamSpec)this.spec.build() : null;
    }

    public T withSpec(ImageStreamSpec spec) {
        if (spec != null) {
            this.spec = new ImageStreamSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (T)this;
    }

    public SpecNested<T> withNewSpec() {
        return new SpecNested();
    }

    public ImageStreamStatus getStatus() {
        return this.status != null ? (ImageStreamStatus)this.status.build() : null;
    }

    public T withStatus(ImageStreamStatus status) {
        if (status != null) {
            this.status = new ImageStreamStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (T)this;
    }

    public StatusNested<T> withNewStatus() {
        return new StatusNested();
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public class StatusNested<N>
    extends ImageStreamStatusFluent<StatusNested<N>>
    implements Nested<N> {
        private final ImageStreamStatusBuilder builder = new ImageStreamStatusBuilder(this);

        @Override
        public N and() {
            return (N)ImageStreamFluent.this.withStatus(this.builder.build());
        }

        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNested<N>
    extends ImageStreamSpecFluent<SpecNested<N>>
    implements Nested<N> {
        private final ImageStreamSpecBuilder builder = new ImageStreamSpecBuilder(this);

        @Override
        public N and() {
            return (N)ImageStreamFluent.this.withSpec(this.builder.build());
        }

        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ObjectMetaBuilder builder = new ObjectMetaBuilder(this);

        public N endMetadata() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ImageStreamFluent.this.withMetadata(this.builder.build());
        }
    }
}

